/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemordemcompraprodutos;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemOrdemCompraProdutos {
    private static Short ANALITICO = 0;
    private static Short NR_ORDEM_COMPRA = 0;
    private static Short IDENTIFICADOR_FORNECEDOR = 1;

    UtilListagemOrdemCompraProdutos() {
    }

    JasperPrint gerarListagemOrdemCompraProdutos(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short tipoRelatorio, Short ordenacao, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarOrdemCompraprodutosAnaliticoSintetico(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarFornecedor, fornecedorInicial, fornecedorFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEmpresa, empresaInicial, empresaFinal, tipoRelatorio, ordenacao);
        return this.gerarJasperPrintOrdemCompraProdutos(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarFornecedor, fornecedorInicial, fornecedorFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEmpresa, empresaInicial, empresaFinal, tipoRelatorio, ordenacao, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarOrdemCompraprodutosAnaliticoSintetico(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short tipoRelatorio, Short ordenacao) {
        if (tipoRelatorio == ANALITICO) {
            return this.pesquisarOrdemCompraprodutosAnalitico(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarFornecedor, fornecedorInicial, fornecedorFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEmpresa, empresaInicial, empresaFinal, ordenacao);
        }
        return this.pesquisarOrdemCompraprodutosSintetico(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarFornecedor, fornecedorInicial, fornecedorFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEmpresa, empresaInicial, empresaFinal, ordenacao);
    }

    private List<HashMap> pesquisarOrdemCompraprodutosAnalitico(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short ordenacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT DISTINCT  i.ordemCompra.identificador                                 AS ID_ORDEM_COMPRA, i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador AS ID_FORNECEDOR, i.ordemCompra.unidadeFatFornecedor.fornecedor.pessoa.nome   AS NOME_FORNECEDOR, i.produto.identificador                                     AS ID_PRODUTO, i.produto.nome                                              AS NOME_PRODUTO, i.ordemCompra.dataEmissao                                   AS DATA_EMISSAO, i.vrProduto                                                 AS VALOR_PRODUTO FROM  ItemOrdemCompra i WHERE (:filtrarDataEmissao <> 1 OR i.ordemCompra.dataEmissao BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND   (:filtrarFornecedor <> 1 OR i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador BETWEEN :fornecedorInicial AND :fornecedorFinal) AND   (:filtrarProduto <> 1 OR i.produto.identificador BETWEEN :produtoInicial AND :produtoFinal) AND   (:filtrarEmpresa <> 1 OR i.ordemCompra.empresa.identificador BETWEEN :empresaInicial AND :empresaFinal) ORDER BY i.produto.identificador, ";
        hql = ordenacao == NR_ORDEM_COMPRA ? (String)hql + "i.ordemCompra.identificador" : (ordenacao == IDENTIFICADOR_FORNECEDOR ? (String)hql + "i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador" : (String)hql + "i.ordemCompra.unidadeFatFornecedor.fornecedor.pessoa.nome");
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarFornecedor", filtrarFornecedor.shortValue());
        q.setLong("fornecedorInicial", fornecedorInicial.longValue());
        q.setLong("fornecedorFinal", fornecedorFinal.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> pesquisarOrdemCompraprodutosSintetico(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short ordenacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT DISTINCT  i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador AS ID_FORNECEDOR, i.ordemCompra.unidadeFatFornecedor.fornecedor.pessoa.nome   AS NOME_FORNECEDOR, i.produto.identificador                                     AS ID_PRODUTO, i.produto.nome                                              AS NOME_PRODUTO, MAX(i.ordemCompra.dataEmissao)                              AS DATA_ULTIMA_COMPRA FROM  ItemOrdemCompra i WHERE (:filtrarDataEmissao <> 1 OR i.ordemCompra.dataEmissao BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND   (:filtrarFornecedor <> 1 OR i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador BETWEEN :fornecedorInicial AND :fornecedorFinal) AND   (:filtrarProduto <> 1 OR i.produto.identificador BETWEEN :produtoInicial AND :produtoFinal) AND   (:filtrarEmpresa <> 1 OR i.ordemCompra.empresa.identificador BETWEEN :empresaInicial AND :empresaFinal) GROUP BY i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador,          i.ordemCompra.unidadeFatFornecedor.fornecedor.pessoa.nome, i.produto.identificador,          i.produto.nome ORDER BY i.produto.identificador, ";
        hql = ordenacao == NR_ORDEM_COMPRA ? (String)hql + "i.ordemCompra.identificador" : (ordenacao == IDENTIFICADOR_FORNECEDOR ? (String)hql + "i.ordemCompra.unidadeFatFornecedor.fornecedor.identificador" : (String)hql + "i.ordemCompra.unidadeFatFornecedor.fornecedor.pessoa.nome");
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarFornecedor", filtrarFornecedor.shortValue());
        q.setLong("fornecedorInicial", fornecedorInicial.longValue());
        q.setLong("fornecedorFinal", fornecedorFinal.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintOrdemCompraProdutos(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarFornecedor, Long fornecedorInicial, Long fornecedorFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short tipoRelatorio, Short ordenacao, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_FORNECEDOR", filtrarFornecedor);
        parametros.put("FORNECEDOR_INICIAL", fornecedorInicial);
        parametros.put("FORNECEDOR_FINAL", fornecedorFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("PRODUTO_INICIAL", produtoInicial);
        parametros.put("PRODUTO_FINAL", produtoFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("TIPO_RELATORIO", tipoRelatorio);
        parametros.put("ORDENACAO", ordenacao);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "suprimentos" + File.separator + "gestaodecompras" + File.separator + "listagens" + File.separator + "listagemordemcompraproduto" + File.separator + "LISTAGEM_ORDEM_COMPRA_PRODUTO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

