/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagempagamentocupom;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilPagamentoCupom {
    JasperPrint gerarListagemPagamentoCupom(Short filtrarDataEmissao, Short filtrarImpressoraFiscal, Date dataEmissaoInicial, Date dataEmissaoFinal, Long impressoraFiscalInicial, Long impressoraFiscalFinal, Short filtrarFormaPagamento, Long formaPagamentoInicial, Long formaPagamentoFinal, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisar(filtrarDataEmissao, filtrarImpressoraFiscal, dataEmissaoInicial, dataEmissaoFinal, impressoraFiscalInicial, impressoraFiscalFinal, filtrarFormaPagamento, formaPagamentoInicial, formaPagamentoFinal, fecho, nodo, parametros);
        return this.gerarJasperPrintPagamentoCupom(filtrarDataEmissao, filtrarImpressoraFiscal, dataEmissaoInicial, dataEmissaoFinal, impressoraFiscalInicial, impressoraFiscalFinal, filtrarFormaPagamento, formaPagamentoInicial, formaPagamentoFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisar(Short filtrarDataEmissao, Short filtrarImpressoraFiscal, Date dataEmissaoInicial, Date dataEmissaoFinal, Long impressoraFiscalInicial, Long impressoraFiscalFinal, Short filtrarFormaPagamento, Long formaPagamentoInicial, Long formaPagamentoFinal, String fecho, Nodo nodo, HashMap parametros) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT pcf.cupom.dataEmissao AS DATA_EMISSAO, pcf.formasPagCupomFiscal.identificador AS ID_FORMA_PAGAMENTO, pcf.formasPagCupomFiscal.descricao AS NOME_FORMA_PAGAMENTO, SUM(pcf.valor) AS VALOR";
        hql = (String)hql + " FROM PagamentoCupomFiscal pcf INNER JOIN pcf.cupom.cupomFiscal cf";
        hql = (String)hql + " WHERE cf.cancelado = 0";
        hql = (String)hql + " AND (:filtrarDataEmissao <> 1 OR pcf.cupom.dataEmissao BETWEEN :dataEmissaoInicial and :dataEmissaoFinal) AND (:filtrarImpressoraFiscal <> 1 OR pcf.cupom.impressoraFiscal.identificador BETWEEN :impressoraFiscalInicial AND :impressoraFiscalFinal) AND (:filtrarFormaPagamento <> 1 OR pcf.formasPagCupomFiscal.identificador BETWEEN :formaPagamentoInicial AND :formaPagamentoFinal) GROUP BY  pcf.cupom.dataEmissao, pcf.formasPagCupomFiscal.identificador, pcf.formasPagCupomFiscal.descricao ORDER BY pcf.cupom.dataEmissao,pcf.formasPagCupomFiscal.descricao ";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarImpressoraFiscal", filtrarImpressoraFiscal.shortValue());
        q.setLong("impressoraFiscalInicial", impressoraFiscalInicial.longValue());
        q.setLong("impressoraFiscalFinal", impressoraFiscalFinal.longValue());
        q.setShort("filtrarFormaPagamento", filtrarFormaPagamento.shortValue());
        q.setLong("formaPagamentoInicial", formaPagamentoInicial.longValue());
        q.setLong("formaPagamentoFinal", formaPagamentoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintPagamentoCupom(Short filtrarDataEmissao, Short filtrarImpressoraFiscal, Date dataEmissaoInicial, Date dataEmissaoFinal, Long impressoraFiscalInicial, Long impressoraFiscalFinal, Short filtrarFormaPagamento, Long formaPagamentoInicial, Long formaPagamentoFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_IMPRESSORA_FISCAL", filtrarImpressoraFiscal);
        parametros.put("IMPRESSORA_FISCAL_INICIAL", impressoraFiscalInicial);
        parametros.put("IMPRESSORA_FISCAL_FINAL", impressoraFiscalFinal);
        parametros.put("FILTRAR_FORMA_PAGAMENTO", filtrarFormaPagamento);
        parametros.put("FORMA_PAGAMENTO_INICIAL", formaPagamentoInicial);
        parametros.put("FORMA_PAGAMENTO_FINAL", formaPagamentoFinal);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "pdv" + File.separator + "listagens" + File.separator + "pagamentocupom" + File.separator + "LISTAGEM_PAGAMENTO_CUPOM.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

