/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagempendenciasprojetos;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemPendenciasProjeto {
    JasperPrint gerarListagemPendenciasProjeto(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal, String fecho, Nodo nodo, HashMap parametros) throws ExceptionService {
        List<HashMap> dados = this.pesquisarPendencias(filtrarDataPrevisaoInicial, dataPrevisaoIniInicial, dataPrevisaoIniFinal, filtrarPessoaAlvo, pessoaAlvoInicial, pessoaAlvoFinal);
        return this.gerarJasperPrintPendenciasProjeto(filtrarDataPrevisaoInicial, dataPrevisaoIniInicial, dataPrevisaoIniFinal, filtrarPessoaAlvo, pessoaAlvoInicial, pessoaAlvoFinal, fecho, nodo, parametros, dados);
    }

    private List<HashMap> pesquisarPendencias(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT                       t.identificador                    AS ID_TAREFA,             t.descricaoTarefa                  AS TAREFA,             t.observacao                       AS OBSERVACAO_TAREFAS,             t.localExecucao                    AS LOCAL_EXECUCAO,             t.subprojetoTarefasStat.descricao  AS TAREFA_STATUS,             p.identificador                    AS ID_PROJETO,             p.descricao                        AS PROJETO,             p.pessoa.identificador             AS ID_PESSOA,             p.pessoa.nome                      AS PESSOA,             p.dataInicial                      AS DATA_INICIAL,             p.dataFinal                        AS DATA_FINAL,             p.observacao                       AS OBSERVACAO_PROJETO FROM        SubprojetoTarefas t INNER JOIN  t.subprojeto s INNER JOIN  s.projeto p WHERE (:filtrarDataPrevisaoInicial <> 1 OR p.dataInicial   BETWEEN :dataPrevisaoIniInicial AND :dataPrevisaoIniFinal) AND   (:filtrarPessoaAlvo          <> 1 OR p.pessoa.identificador BETWEEN :pessoaAlvoInicial AND :pessoaAlvoFinal) ORDER BY p.identificador";
        Query q = s.createQuery(hql);
        q.setShort("filtrarDataPrevisaoInicial", filtrarDataPrevisaoInicial.shortValue());
        q.setDate("dataPrevisaoIniInicial", dataPrevisaoIniInicial);
        q.setDate("dataPrevisaoIniFinal", dataPrevisaoIniFinal);
        q.setShort("filtrarPessoaAlvo", filtrarPessoaAlvo.shortValue());
        q.setLong("pessoaAlvoInicial", pessoaAlvoInicial.longValue());
        q.setLong("pessoaAlvoFinal", pessoaAlvoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintPendenciasProjeto(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados) throws ExceptionService {
        parametros.put("FILTRAR_DATA_PREVISAO_INICIAl", filtrarDataPrevisaoInicial);
        parametros.put("DATA_PREVISAO_INI_INICIAL", dataPrevisaoIniInicial);
        parametros.put("DATA_PREVISAO_INI_FINAL", dataPrevisaoIniFinal);
        parametros.put("FILTRAR_PESSOA_ALVO", filtrarPessoaAlvo);
        parametros.put("PESSOA_ALVO_INICIAL", pessoaAlvoInicial);
        parametros.put("PESSOA_ALVO_FINAL", pessoaAlvoFinal);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "gestaoprojetos" + File.separator + "relatorios" + File.separator + "listagempendenciasprojeto" + File.separator + "LISTAGEM_PENDENCIAS_PROJETO.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

