/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemprojetos;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemProjetos {
    private static final Short ABERTO = 0;
    private static final Short CONCLUIDO = 1;

    JasperPrint gerarListagemProjetos(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal, Short mostrarSubprojetos, Short mostrarTarefas, Short mostrarResponsaveis, Short mostrarAgendamentos, Short status, String fecho, Nodo nodo, HashMap parametros, Short filtrarProjeto, Long projetoInicial, Long projetoFinal, Short mostrarGrafico, Short mostrarProtocolos, Short filtrarStatus, Long statusInicial, Long statusFinal) throws ExceptionService {
        List<HashMap> dados = this.pesquisarProjetos(filtrarDataPrevisaoInicial, dataPrevisaoIniInicial, dataPrevisaoIniFinal, filtrarPessoaAlvo, pessoaAlvoInicial, pessoaAlvoFinal, status, filtrarProjeto, projetoInicial, projetoFinal, mostrarGrafico, filtrarStatus, statusInicial, statusFinal);
        return this.gerarJasperPrintProjetos(filtrarDataPrevisaoInicial, dataPrevisaoIniInicial, dataPrevisaoIniFinal, filtrarPessoaAlvo, pessoaAlvoInicial, pessoaAlvoFinal, mostrarSubprojetos, mostrarTarefas, mostrarResponsaveis, mostrarAgendamentos, fecho, nodo, parametros, dados, filtrarProjeto, projetoInicial, projetoFinal, mostrarGrafico, mostrarProtocolos);
    }

    private List<HashMap> pesquisarProjetos(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal, Short status, Short filtrarProjeto, Long projetoInicial, Long projetoFinal, Short mostrarGrafico, Short filtrarStatus, Long statusInicial, Long statusFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT     distinct              p.identificador                        AS ID_PROJETO,\t\t p.descricao                            AS PROJETO,\t\t e.nome                                 AS PESSOA,              e.identificador                        AS ID_PESSOA,              p.dataInicial                          AS DATA_PREVISAO_INICIAL,              p.dataFinal                            AS DATA_PREVISAO_FINAL,              p.percentualTotal                      AS PERCENTUAL_TOTAL_PROJETO,\t\t s.identificador                        AS ID_SUBPROJETO,\t\t s.descricao                            AS SUBPROJETO,\t\t s.percentualSubprojeto                 AS PERCENTUAL_SUBPROJETO,\t\t s.dataInicial                          AS DATA_INICIAL_SUBPROJETO,\t\t s.dataFinal                            AS DATA_FINAL_SUBPROJETO,              t.identificador                        AS ID_TAREFA,              t.descricaoTarefa                      AS TAREFA,              t.localExecucao                        AS LOCAL_EXECUCAO,              u.descricao                            AS TAREFA_STATUS,              u.percConclusao                        AS TAREFA_PERCENTUAL,              o.nome                                 AS RESPONSAVEL,              a.dataInicial                          AS DATA_AGENDAMENTO_INICIAL,              a.dataFinal                            AS DATA_AGENDAMENTO_FINAL,              t.indice                               AS INDICE,              t.observacao                           AS OBSERVACAO_TAREFA FROM \t Projeto p INNER JOIN   p.pessoa e INNER JOIN\t p.subprojetos s     INNER JOIN   s.subprojetoTarefas t         LEFT JOIN    t.subprojetoTarefasStat u         LEFT JOIN    t.responsaveis r             LEFT JOIN    r.pessoa o         LEFT JOIN    t.temposExecucao a WHERE (:filtrarDataPrevisaoInicial <> 1 OR p.dataInicial   BETWEEN :dataPrevisaoIniInicial AND :dataPrevisaoIniFinal) AND   (:filtrarPessoaAlvo          <> 1 OR e.identificador BETWEEN :pessoaAlvoInicial      AND :pessoaAlvoFinal) AND   (:filtrarProjeto          <> 1 OR p.identificador BETWEEN :projetoInicial      AND :projetoFinal) AND   (:filtrarStatus <> 1 OR u.identificador BETWEEN :statusInicial AND :statusFinal) ";
        if (status.equals(ABERTO)) {
            hql = (String)hql + " AND p.projetoConcluido = 0";
        } else if (status.equals(CONCLUIDO)) {
            hql = (String)hql + " AND p.projetoConcluido = 1";
        }
        hql = (String)hql + " ORDER BY p.identificador,s.indice,s.identificador, t.indice";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataPrevisaoInicial", filtrarDataPrevisaoInicial.shortValue());
        q.setDate("dataPrevisaoIniInicial", dataPrevisaoIniInicial);
        q.setDate("dataPrevisaoIniFinal", dataPrevisaoIniFinal);
        q.setShort("filtrarPessoaAlvo", filtrarPessoaAlvo.shortValue());
        q.setLong("pessoaAlvoInicial", pessoaAlvoInicial.longValue());
        q.setLong("pessoaAlvoFinal", pessoaAlvoFinal.longValue());
        q.setLong("filtrarProjeto", (long)filtrarProjeto.shortValue());
        q.setLong("projetoInicial", projetoInicial.longValue());
        q.setLong("projetoFinal", projetoFinal.longValue());
        q.setShort("filtrarStatus", filtrarStatus.shortValue());
        q.setLong("statusInicial", statusInicial.longValue());
        q.setLong("statusFinal", statusFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List dados = q.list();
        for (HashMap h : dados) {
            Long idTarefa = (Long)h.get("ID_TAREFA");
            List<Map> protocolos = this.getProtocolos(idTarefa);
            h.put("F_PROTOCOLOS", protocolos);
        }
        return dados;
    }

    private List<Map> getProtocolos(Long idTarefa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT DISTINCT  r.nrProtocolo as NR_PROTOCOLO,  r.nrProtocolo          AS NR_PROTOCOLO,  r.dataPrevFinalizacao  AS DATA_PREV_FINALIZACAO,  r.dataFinalizacao      AS DATA_FINALIZACAO,  r.finalizado           AS SOLUCIONADO  FROM Projeto p      INNER JOIN\t p.subprojetos s          INNER JOIN      s.subprojetoTarefas t              LEFT JOIN    t.relacionamentosVinculados rv              LEFT JOIN rv.relPessoaContato r WHERE t.identificador = :idTarefa  and r.nrProtocolo is not null";
        Query q = s.createQuery(query);
        q.setLong("idTarefa", idTarefa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintProjetos(Short filtrarDataPrevisaoInicial, Date dataPrevisaoIniInicial, Date dataPrevisaoIniFinal, Short filtrarPessoaAlvo, Long pessoaAlvoInicial, Long pessoaAlvoFinal, Short mostrarSubprojetos, Short mostrarTarefas, Short mostrarResponsaveis, Short mostrarAgendamentos, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados, Short filtrarProjeto, Long projetoInicial, Long projetoFinal, Short mostrarGrafico, Short mostrarProtocolos) throws ExceptionService {
        parametros.put("FILTRAR_PROJETOS", filtrarProjeto);
        parametros.put("PROJETO_INICIAL", projetoInicial);
        parametros.put("PROJETO_FINAL", projetoFinal);
        parametros.put("FILTRAR_DATA_PREVISAO_INICIAl", filtrarDataPrevisaoInicial);
        parametros.put("DATA_PREVISAO_INI_INICIAL", dataPrevisaoIniInicial);
        parametros.put("DATA_PREVISAO_INI_FINAL", dataPrevisaoIniFinal);
        parametros.put("FILTRAR_PESSOA_ALVO", filtrarPessoaAlvo);
        parametros.put("PESSOA_ALVO_INICIAL", pessoaAlvoInicial);
        parametros.put("PESSOA_ALVO_FINAL", pessoaAlvoFinal);
        parametros.put("MOSTRAR_SUBPROJETOS", mostrarSubprojetos);
        parametros.put("MOSTRAR_TAREFAS", mostrarTarefas);
        parametros.put("MOSTRAR_RESPONSAVEIS", mostrarResponsaveis);
        parametros.put("MOSTRAR_AGENDAMENTOS", mostrarAgendamentos);
        parametros.put("MOSTRAR_GRAFICOS", mostrarGrafico);
        parametros.put("MOSTRAR_PROTOCOLOS", mostrarProtocolos);
        parametros.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "gestaoprojetos" + File.separator + "relatorios" + File.separator + "listagemprojetos" + File.separator + "LISTAGEM_PROJETOS.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

