/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagemtitulosfornecedorliquidado;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityTitulosFornecedorLiquidados {
    JasperPrint gerarListagemTitulosFornecedorLiquidados(Integer filtrarData, Date dataInicial, Date dataFinal, Integer filtrarEmpresa, Empresa empresaInicial, Empresa empresaFinal, Short cheque, Short agenciaValor, Short devolucao, Short faltaPagamento, Short chequeTerceiros, Short borderoCobranca, Short antecipado, Short renegociacao, Short cartaoDebito, Short cartaoCredito, String ordenacao, List<Fornecedor> fornecedores, Integer filtrarPessoa, HashMap parametros) throws ExceptionService {
        Object sql = "  select      distinct      cv.id_conta_valor,       pes.nome \t\t        as contavalor,       g.data_liquidacao,       t.ID_FATURA_CTE,       t.id_titulo,       t.valor \t\t        as valor,       t.id_pessoa,       t.data_emissao,       t.data_vencimento,       t.data_vencimento_base,       sum(B.vr_juros) \t        as vr_juros,       sum(B.vr_desconto) \t        as vr_desconto,      sum(B.vr_atualizacao_monetaria) as vr_atualizacao_monetaria,      sum(B.VALOR) \t\t        AS VALOR_BAIXA,       sum(B.VR_MULTA) \t        as vr_multa,       SUM(B.vr_despesa_cartorio)      as vr_cartorio,       p.nome,np.numero_nota \t        as propria,       nt.numero_nota \t        as terceiro,       cast(r.numero_nfe_se as VARCHAR(30)) as NUMERO_NFSE,      CHAR_LENGTH(r.numero_nfe_se) AS tamanho_nfse,       t.observacao,      sum(b.valor) + sum(b.vr_juros) - sum(b.vr_desconto) + sum(b.vr_multa) as valor_recebido,       datediff(day, g.data_liquidacao, t.data_vencimento) as diasAtrazo,       TI.nome DOC_FINANCEIRO,       gbf.FORMA_PAGAMENTO       from titulo                t inner join baixa_titulo          b on (b.id_titulo               = t.id_titulo) inner join grupo_de_baixa_formas gbf on (b.ID_GRUPO_BAIXA_FORMAS = gbf.id_grupo_de_baixa_formas) inner join grupo_de_baixa        g on (g.id_grupo_de_baixa       = gbf.id_grupo_de_baixa) left  join carteira_cobranca     c on (c.id_carteira_cobranca    = t.id_carteira_cobranca) inner join pessoa                p on (p.id_pessoa               = t.id_pessoa) left  join nota_propria         np on (np.id_nota_propria        = t.id_nota_fiscal_propria) left  join nota_terceiros       nt on (nt.id_nota_terceiros      = t.id_nota_terceiros) left  JOIN tipo_doc_financeiro  tI ON (TI.id_tipo_doc_financeiro = T.id_doc_financeiro) left  join conta_valores        cv on (cv.id_conta_valor         = gbf.id_conta_valor) left  join agencia_valores       a on (cv.id_agencia_valor       = a.id_agencia_valor) left  join pessoa              pes on (pes.id_pessoa             = a.id_pessoa) left  join rps                   r on (r.id_rps\t\t   = t.id_rps) where (:FILTRAR_EMPRESA <>1 OR g.ID_EMPRESA between :ID_EMPRESA_INICIAL AND :ID_EMPRESA_FINAL) AND   ((:FILTRAR_CHEQUE <> 0 and gbf.forma_pagamento = 0)  OR (:FILTRAR_AGENCIA_VALORES<>0 and gbf.forma_pagamento = 1)  OR (:FILTRAR_DEVOLUCAO <>0 and gbf.forma_pagamento = 2) OR (:FILTRAR_FALTA_PAGAMENTO<>0 and gbf.forma_pagamento = 3) OR (:FILTRAR_CHEQUE_TERCEIROS <>0 and gbf.forma_pagamento = 4) OR (:FILTRAR_BORDERO_COBRANCA <>0 and gbf.forma_pagamento = 5) OR (:FILTRAR_ANTECIPADO <>0 and gbf.forma_pagamento = 7) OR (:FILTRAR_RENEGOCIACAO <>0 and gbf.forma_pagamento = 8) OR (:FILTRAR_CARTAO_DEBITO <>0 and gbf.forma_pagamento = 9) OR (:FILTRAR_CARTAO_CREDITO <>0 and gbf.forma_pagamento = 10)) AND (:FILTRAR_DATA <>1 OR g.data_liquidacao between :DATA_INICIAL AND :DATA_FINAL) and t.pag_rec = :PAG_REC and (:FILTRAR_PESSOA <>1 ";
        if (fornecedores.isEmpty()) {
            sql = (String)sql + " )";
        } else {
            sql = (String)sql + " or ";
            Integer count = 1;
            Integer tam = fornecedores.size();
            for (Fornecedor f : fornecedores) {
                sql = (String)sql + " t.id_pessoa = :idpessoa" + count.toString();
                if (count < tam) {
                    sql = (String)sql + " or ";
                }
                count = count + 1;
            }
            sql = (String)sql + ")";
        }
        sql = (String)sql + " group by       cv.id_conta_valor,       pes.nome,       g.data_liquidacao,       t.id_titulo,       t.id_pessoa,       p.nome,       t.data_emissao,       t.data_vencimento,       t.data_vencimento_base,       nt.numero_nota,       np.numero_nota,       t.ID_FATURA_CTE,       t.observacao,       TI.nome,       t.valor,       g.data_liquidacao,       gbf.FORMA_PAGAMENTO,       cast(r.numero_nfe_se as VARCHAR(30)),       CHAR_LENGTH(r.numero_nfe_se) order by       gbf.FORMA_PAGAMENTO,       cv.id_conta_valor,       g.data_liquidacao, " + ordenacao;
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery((String)sql);
        q.setInteger("FILTRAR_EMPRESA", filtrarEmpresa.intValue());
        q.setLong("ID_EMPRESA_INICIAL", empresaInicial.getIdentificador().longValue());
        q.setLong("ID_EMPRESA_FINAL", empresaFinal.getIdentificador().longValue());
        q.setShort("FILTRAR_CHEQUE", cheque.shortValue());
        q.setShort("FILTRAR_AGENCIA_VALORES", agenciaValor.shortValue());
        q.setShort("FILTRAR_DEVOLUCAO", devolucao.shortValue());
        q.setShort("FILTRAR_FALTA_PAGAMENTO", faltaPagamento.shortValue());
        q.setShort("FILTRAR_CHEQUE_TERCEIROS", chequeTerceiros.shortValue());
        q.setShort("FILTRAR_BORDERO_COBRANCA", borderoCobranca.shortValue());
        q.setShort("FILTRAR_ANTECIPADO", antecipado.shortValue());
        q.setShort("FILTRAR_RENEGOCIACAO", renegociacao.shortValue());
        q.setShort("FILTRAR_CARTAO_DEBITO", cartaoDebito.shortValue());
        q.setShort("FILTRAR_CARTAO_CREDITO", cartaoCredito.shortValue());
        q.setInteger("FILTRAR_PESSOA", filtrarPessoa.intValue());
        q.setInteger("FILTRAR_DATA", filtrarData.intValue());
        q.setDate("DATA_INICIAL", dataInicial);
        q.setShort("PAG_REC", (short)0);
        q.setDate("DATA_FINAL", dataFinal);
        if (!fornecedores.isEmpty()) {
            Integer count = 1;
            for (Fornecedor f : fornecedores) {
                q.setLong("idpessoa" + count.toString(), f.getPessoa().getIdentificador().longValue());
                count = count + 1;
            }
        }
        List dados = q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return this.gerarJasperTitulosFornecedorLiquidados(dados, filtrarData, dataInicial, dataFinal, filtrarEmpresa, filtrarPessoa, empresaInicial.getIdentificador(), empresaFinal.getIdentificador(), (short)0, parametros);
    }

    private JasperPrint gerarJasperTitulosFornecedorLiquidados(List<HashMap> dados, Integer filtrarData, Date dataInicial, Date dataFinal, Integer filtrarEmpresa, Integer filtrarPessoa, Long empresaInicial, Long empresaFinal, Short pagamento, HashMap parametros) throws ExceptionService {
        parametros.put("FILTRAR_DATA", filtrarData);
        parametros.put("FILTRAR_PESSOA", filtrarPessoa);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("ID_EMPRESA_INICIAL", empresaInicial);
        parametros.put("ID_EMPRESA_FINAL", empresaFinal);
        parametros.put("PAG_REC", pagamento.intValue());
        parametros.put("HIBERNATE_SESSION", CoreBdUtil.getInstance().getSession());
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "financeiro" + File.separator + "listagemtitulosliquidadosfornecedor" + File.separator + "LISTAGEM_TITULOS_LIQUIDADOS_FORNCEDOR.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        JasperPrint jasper = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
        return jasper;
    }
}

