/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensFinanceiro;

import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeraDetalhamentoSaldoContaValor {
    JasperPrint gerarDetalhamentoSaldoContaValor(CoreRequestContext request) throws ExceptionService {
        Integer tipoRelatorio = (Integer)request.getAttribute("tipoRelatorio");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Integer filtrarContaValores = (Integer)request.getAttribute("filtrarContaValores");
        ContaValores contaValoresInicial = (ContaValores)request.getAttribute("contaInicial");
        ContaValores contaValoresFinal = (ContaValores)request.getAttribute("contaFinal");
        Short filtrarEmpresa = (Short)request.getAttribute("filtrarEmpresa");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short exibirTitulosRecebimento = (Short)request.getAttribute("exibirTitulosRecebimento");
        Short exibirTitulosPagamento = (Short)request.getAttribute("exibirTitulosPagamento");
        Short exibirMovBancarioCredito = (Short)request.getAttribute("exibirMovBancarioCredito");
        Short exibirMovBancarioDebito = (Short)request.getAttribute("exibirMovBancarioDebito");
        Short exibirTransferencias = (Short)request.getAttribute("exibirTransferencias");
        Short exibirTotaisTitPorDia = (Short)request.getAttribute("exibirTotaisTitPorDia");
        Short exibirObservacao = (Short)request.getAttribute("exibirObservacao");
        Short dadosImpresso = (Short)request.getAttribute("dadosImpresso");
        Short imprimirContasInativas = (Short)request.getAttribute("imprimirContasInativas");
        Short impSomContaValCompFluxoCaixa = (Short)request.getAttribute("impSomContaValCompFluxoCaixa");
        Short EXIBIR_COBRANCA_DESCONTADA = (Short)request.getAttribute("EXIBIR_COBRANCA_DESCONTADA");
        List relatorioSintetico = this.getRelatorioSintetico(dataInicial, dataFinal, filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
        List<Object> relatorioLancamentoSintetico = new ArrayList();
        List<Object> relatorioAnalitico = new ArrayList();
        if (tipoRelatorio.equals(0) && exibirTotaisTitPorDia.equals((short)1)) {
            relatorioLancamentoSintetico = this.getLancamentosSintetico(dataInicial, dataFinal, filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa, exibirTotaisTitPorDia, EXIBIR_COBRANCA_DESCONTADA);
        }
        if (tipoRelatorio == 1) {
            relatorioAnalitico = this.getRelatorioAnalitico(dataInicial, dataFinal, filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, exibirTitulosRecebimento, exibirTitulosPagamento, exibirMovBancarioCredito, exibirMovBancarioDebito, exibirTransferencias, imprimirContasInativas, impSomContaValCompFluxoCaixa, EXIBIR_COBRANCA_DESCONTADA);
        }
        HashMap<String, List> dadosRelatoio = new HashMap<String, List>();
        dadosRelatoio.put("relatorioSintetico", relatorioSintetico);
        dadosRelatoio.put("relatorioLancamentoSintetico", relatorioLancamentoSintetico);
        dadosRelatoio.put("relatorioAnalitico", relatorioAnalitico);
        ArrayList<HashMap<String, List>> relatorio = new ArrayList<HashMap<String, List>>();
        relatorio.add(dadosRelatoio);
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("FILTRAR_CONTA_VALOR", filtrarContaValores);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("DADOS_IMPRESSO", dadosImpresso);
        if (empresa != null) {
            parametros.put("EMPRESA", empresa.getPessoa().getNome());
            parametros.put("ID_EMPRESA", empresa.getIdentificador());
        }
        parametros.put("CONTA_INICIAL", contaValoresInicial != null ? Integer.valueOf(contaValoresInicial.getIdentificador().intValue()) : null);
        parametros.put("CONTA_FINAL", contaValoresFinal != null ? Integer.valueOf(contaValoresFinal.getIdentificador().intValue()) : null);
        parametros.put("TIPO_RELATORIO", tipoRelatorio);
        parametros.put("EXIBIR_OBSERVACAO", exibirObservacao);
        parametros.put("EXIBIR_TOTAIS_TIT_DIA", exibirTotaisTitPorDia);
        parametros.put("EXIBIR_COBRANCA_DESCONTADA", EXIBIR_COBRANCA_DESCONTADA);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "financas" + File.separator + "movimentofinanceiro" + File.separator + "relatorios" + File.separator;
        parametros.put("PATH", path);
        CoreRequestContext detalhamentoSaldoAgenciaValor = new CoreRequestContext();
        detalhamentoSaldoAgenciaValor.setAttribute("dados", relatorio);
        detalhamentoSaldoAgenciaValor.setAttribute("path", (String)path + "LISTAGEM_DETALHAMENTO_SALDO_AGENCIA_VALOR.jasper");
        detalhamentoSaldoAgenciaValor.setAttribute("parametros", parametros);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(detalhamentoSaldoAgenciaValor, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List getRelatorioSintetico(Date dataInicial, Date dataFinal, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa) {
        List contas = this.getContas(filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
        List<HashMap> sintetico = this.getRelatorioSitetico(contas, dataInicial, dataFinal);
        return sintetico;
    }

    private List getContas(Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String contas = " SELECT C.ID_CONTA_VALOR AS ID_CONTA,         P.NOME           AS NOME_AGENCIA,        C.NR_CONTA       AS NR_CONTA ,        C.DESCRICAO      AS DESCRICAO,        C.ATIVO          AS ATIVO FROM CONTA_VALORES   C  JOIN AGENCIA_VALORES A ON A.ID_AGENCIA_VALOR = C.ID_AGENCIA_VALOR  JOIN PESSOA          P ON P.ID_PESSOA        = A.ID_PESSOA  WHERE (:FILTRAR_CONTA_VALOR <> 1 OR C.ID_CONTA_VALOR BETWEEN :ID_CONTA_INICIAL AND :ID_CONTA_FINAL)  and (:FILTRAR_EMPRESA <> 1 OR A.ID_EMPRESA = :ID_EMPRESA)  AND (:IMPRIMIR_CONTAS_INATIVAS <> 0 OR c.ATIVO = 1) AND (:IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA <> 1 OR c.IMPRIMIR_SALDO_FLUXO_CAIXA = 1) ORDER BY C.ID_CONTA_VALOR";
        NativeQuery queryContas = s.createSQLQuery(contas);
        queryContas.setInteger("FILTRAR_CONTA_VALOR", filtrarContaValores.intValue());
        queryContas.setInteger("FILTRAR_EMPRESA", (int)filtrarEmpresa.shortValue());
        queryContas.setShort("IMPRIMIR_CONTAS_INATIVAS", imprimirContasInativas.shortValue());
        queryContas.setShort("IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA", impSomContaValCompFluxoCaixa.shortValue());
        if (filtrarContaValores == 1) {
            queryContas.setInteger("ID_CONTA_INICIAL", contaValoresInicial.getIdentificador().intValue());
            queryContas.setInteger("ID_CONTA_FINAL", contaValoresFinal.getIdentificador().intValue());
        } else {
            queryContas.setInteger("ID_CONTA_INICIAL", 0);
            queryContas.setInteger("ID_CONTA_FINAL", 9999999);
        }
        if (filtrarEmpresa == 1) {
            queryContas.setLong("ID_EMPRESA", empresa.getIdentificador().longValue());
        } else {
            queryContas.setLong("ID_EMPRESA", 0L);
        }
        queryContas.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List contasValores = queryContas.list();
        return contasValores;
    }

    private List<HashMap> getRelatorioSitetico(List<HashMap> relatorioSintetico, Date dataInicial, Date dataFinal) {
        for (HashMap conta : relatorioSintetico) {
            conta.putAll(this.getSaldoConta((Integer)conta.get("ID_CONTA"), dataInicial, dataFinal));
        }
        return relatorioSintetico;
    }

    private HashMap getSaldoConta(Integer idContaValor, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String querySaldoAgencia = " SELECT   P.VALOR_SALDO           AS SALDO_ATUAL,  P.SALDO_ANTERIOR        AS SALDO_ANTERIOR,  P.VALOR_DEBITO_MOV      AS DEBITO_MOV,  P.VALOR_CREDITO_MOV     AS CREDITO_MOV,  P.VALOR_DEBITO_TRANSF   AS DEBITO_TRANSF,  P.VALOR_CREDITO_TRANSF  AS CREDITO_TRANSF  FROM SALDO_BANCO_EMISSAO (:ID_CONTA, :DATA_INICIAL, :DATA_FINAL) P ";
        NativeQuery saldos = s.createSQLQuery(querySaldoAgencia);
        saldos.setDate("DATA_INICIAL", dataInicial);
        saldos.setDate("DATA_FINAL", dataFinal);
        saldos.setInteger("ID_CONTA", idContaValor.intValue());
        saldos.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap saldosConta = (HashMap)saldos.uniqueResult();
        return saldosConta;
    }

    private List<HashMap> getRelatorioAnalitico(Date dataInicial, Date dataFinal, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short exibirTitulosRecebimento, Short exibirTitulosPagamento, Short exibirMovBancarioCredito, Short exibirMovBancarioDebito, Short exibirTransferencias, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa, Short EXIBIR_COBRANCA_DESCONTADA) {
        List<HashMap> datasMovimentos = this.getDatasMovimentos(dataInicial, dataFinal, filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
        for (HashMap map : datasMovimentos) {
            List<HashMap> movCredDeb;
            HashMap pagamentosRecebimentos = new HashMap();
            if (exibirTitulosPagamento.equals((short)1) || exibirTitulosRecebimento.equals((short)1)) {
                List<HashMap> pagRec = this.getMovimentosData((Date)map.get("DATA_MOVIMENTO"), filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa, EXIBIR_COBRANCA_DESCONTADA);
                pagamentosRecebimentos = this.getPagamentosRecebimentos(pagRec, exibirTitulosRecebimento, exibirTitulosPagamento);
            }
            HashMap movimentosCreditoDebito = new HashMap();
            if (exibirMovBancarioCredito.equals((short)1) || exibirMovBancarioDebito.equals((short)1)) {
                movCredDeb = this.getMovimBancarios((Date)map.get("DATA_MOVIMENTO"), filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
                movimentosCreditoDebito = this.getMovimentosCreditoDebito(movimentosCreditoDebito, movCredDeb, exibirMovBancarioCredito, exibirMovBancarioDebito);
            }
            if (exibirTransferencias.equals((short)1)) {
                movCredDeb = this.getMovimBancariosTransferencias((Date)map.get("DATA_MOVIMENTO"), filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
                movimentosCreditoDebito = this.getMovimentosCreditoDebitoTransferencias(movimentosCreditoDebito, movCredDeb);
            }
            map.put("PAGAMENTOS", pagamentosRecebimentos.get("PAGAMENTOS"));
            map.put("RECEBIMENTOS", pagamentosRecebimentos.get("RECEBIMENTOS"));
            map.put("MOV_CREDITOS", movimentosCreditoDebito.get("MOV_CREDITO"));
            map.put("MOV_DEBITOS", movimentosCreditoDebito.get("MOV_DEBITO"));
        }
        return datasMovimentos;
    }

    private List<HashMap> getDatasMovimentos(Date dataInicial, Date dataFinal, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String queryDatasMovimentos = "    SELECT DISTINCT M.DATA_LANCAMENTO AS DATA_MOVIMENTO                       FROM MOVIMENTO_BANCARIO M    JOIN  CONTA_VALORES C ON C.ID_CONTA_VALOR         = M.ID_CONTA_VALOR    WHERE                                                                     (:FILTRAR_CONTA_VALORES <> 1 OR  M.ID_CONTA_VALOR  BETWEEN :ID_CONTA_INICIAL AND :ID_CONTA_FINAL)     AND (:FILTRAR_EMPRESA <> 1 OR  M.ID_EMPRESA  = :ID_EMPRESA )     AND  M.DATA_LANCAMENTO BETWEEN :DATA_INICIAL     AND :DATA_FINAL          AND (:IMPRIMIR_CONTAS_INATIVAS <> 0 OR C.ATIVO = 1)    AND (:IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA <> 1 OR c.IMPRIMIR_SALDO_FLUXO_CAIXA = 1)    ORDER BY M.DATA_LANCAMENTO ASC                                        ";
        NativeQuery datasMovimentos = s.createSQLQuery(queryDatasMovimentos);
        datasMovimentos.setDate("DATA_INICIAL", dataInicial);
        datasMovimentos.setDate("DATA_FINAL", dataFinal);
        datasMovimentos.setInteger("FILTRAR_CONTA_VALORES", filtrarContaValores.intValue());
        datasMovimentos.setInteger("FILTRAR_EMPRESA", (int)filtrarEmpresa.shortValue());
        datasMovimentos.setShort("IMPRIMIR_CONTAS_INATIVAS", imprimirContasInativas.shortValue());
        datasMovimentos.setShort("IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA", impSomContaValCompFluxoCaixa.shortValue());
        if (filtrarContaValores == 1) {
            datasMovimentos.setInteger("ID_CONTA_INICIAL", contaValoresInicial.getIdentificador().intValue());
            datasMovimentos.setInteger("ID_CONTA_FINAL", contaValoresFinal.getIdentificador().intValue());
        } else {
            datasMovimentos.setInteger("ID_CONTA_INICIAL", 0);
            datasMovimentos.setInteger("ID_CONTA_FINAL", 9999999);
        }
        if (filtrarEmpresa == 1) {
            datasMovimentos.setLong("ID_EMPRESA", empresa.getIdentificador().longValue());
        } else {
            datasMovimentos.setLong("ID_EMPRESA", 0L);
        }
        datasMovimentos.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List datasComMovimentos = datasMovimentos.list();
        return datasComMovimentos;
    }

    private List<HashMap> getMovimentosData(Date dataMovimento, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa, Short EXIBIR_COBRANCA_DESCONTADA) {
        Session s = CoreBdUtil.getInstance().getSession();
        String queryMovimentos = "  SELECT  TT.PAG_REC                                        AS PAG_REC,  TT.ID_TITULO                                      AS ID_TITULO,   PS.NOME                                           AS NOME_PESSOA,  TT.DATA_VENCIMENTO                                AS DATA_VENCIMENTO,  TT.VALOR                                          AS VALOR_TITULO,  BT.VALOR                                          AS VALOR_PAGO,  BT.VR_JUROS                                       AS VALOR_JUROS,  BT.VR_DESCONTO                                    AS VALOR_DESCONTO,  BT.VR_DESP_BANCARIA_PAGA                          AS VR_DESP_BANC_PAGA,  BT.VR_DESP_BANCARIA_REC                           AS VR_DESP_BANC_RECEBIDA,  BT.VR_MULTA                                       AS VALOR_MULTA, BT.vr_despesa_cartorio                            AS VR_CARTORIO,  BT.total_operacao                                 AS VR_TOTAL_OPERACAO,  TT.observacao                                     AS OBSERVACAO , NP.numero_nota                                    AS NR_NOTA_PROPRIA, NT.numero_nota                                    AS NR_NOTA_TERCEIRO, RPS.numero                                        AS NR_RPS, RPS.numero_nfe_se                                 AS NR_NFE_SE FROM  MOVIMENTO_BANCARIO MB  JOIN GRUPO_DE_BAIXA_FORMAS GBF ON GBF.ID_GRUPO_DE_BAIXA_FORMAS = MB.ID_GRUPO_BAIXA_FORMAS JOIN GRUPO_DE_BAIXA G ON G.ID_GRUPO_DE_BAIXA  = GBF.ID_GRUPO_DE_BAIXA  JOIN  BAIXA_TITULO       BT ON BT.ID_GRUPO_BAIXA_FORMAS = GBF.ID_GRUPO_DE_BAIXA_FORMAS  JOIN  TITULO             TT ON TT.ID_TITULO             = BT.ID_TITULO  INNER JOIN carteira_cobranca CC ON CC.id_carteira_cobranca = TT.id_carteira_cobranca  INNER JOIN situacao_cobranca ST on ST.id_situacao_cobraca = CC.id_situacao_cobranca JOIN  PESSOA             PS ON PS.ID_PESSOA             = TT.ID_PESSOA  JOIN  CONTA_VALORES       C ON C.ID_CONTA_VALOR         = MB.ID_CONTA_VALOR left  join inf_pag_nf_propria inf     on (inf.id_inf_pag_nf_propria    = tt.id_inf_pag_nf_propria)   left  join nota_propria      np       on (np.id_nota_propria           = inf.id_nota_fiscal_propria)   left  join inf_pag_nf_terceiros inft  on (inft.id_inf_pag_nf_terceiros = tt.id_inf_pag_nf_terceiros)   left  join nota_terceiros    nt       on (nt.id_nota_terceiros         = inft.id_nota_fiscal_terceiros) LEFT JOIN RPS           RPS ON RPS.ID_RPS               = TT.ID_RPS WHERE MB.DATA_LANCAMENTO = :DATA_MOVIMENTO  AND   (:FILTRAR_CONTA_VALORES <> 1 OR MB.ID_CONTA_VALOR BETWEEN :ID_CONTA_INICIAL AND :ID_CONTA_FINAL)  AND   (:FILTRAR_EMPRESA <> 1 OR MB.ID_EMPRESA = :ID_EMPRESA)  AND   (:IMPRIMIR_CONTAS_INATIVAS <> 0 OR c.ATIVO = 1)  AND (:IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA <> 1 OR c.IMPRIMIR_SALDO_FLUXO_CAIXA = 1)  AND (:EXIBIR_COBRANCA_DESCONTADA <> 0 OR ST.tipo_cobranca != 1)  GROUP BY PS.NOME,          TT.DATA_VENCIMENTO,           TT.PAG_REC,          TT.VALOR,          TT.ID_TITULO,          BT.VALOR,          BT.VR_JUROS,          BT.VR_DESCONTO,          BT.VR_DESP_BANCARIA_PAGA,          BT.VR_DESP_BANCARIA_REC,          BT.VR_MULTA,          BT.vr_despesa_cartorio,          BT.total_operacao,           TT.observacao ,          NP.numero_nota,          NT.numero_nota,          RPS.numero,          RPS.numero_nfe_se ORDER BY TT.DATA_VENCIMENTO ASC ";
        NativeQuery movimentos = s.createSQLQuery(queryMovimentos);
        movimentos.setDate("DATA_MOVIMENTO", dataMovimento);
        movimentos.setInteger("FILTRAR_CONTA_VALORES", filtrarContaValores.intValue());
        movimentos.setInteger("FILTRAR_EMPRESA", (int)filtrarEmpresa.shortValue());
        movimentos.setShort("IMPRIMIR_CONTAS_INATIVAS", imprimirContasInativas.shortValue());
        movimentos.setShort("IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA", impSomContaValCompFluxoCaixa.shortValue());
        movimentos.setShort("EXIBIR_COBRANCA_DESCONTADA", EXIBIR_COBRANCA_DESCONTADA.shortValue());
        if (filtrarContaValores == 1) {
            movimentos.setInteger("ID_CONTA_INICIAL", contaValoresInicial.getIdentificador().intValue());
            movimentos.setInteger("ID_CONTA_FINAL", contaValoresFinal.getIdentificador().intValue());
        } else {
            movimentos.setInteger("ID_CONTA_INICIAL", 0);
            movimentos.setInteger("ID_CONTA_FINAL", 9999999);
        }
        if (filtrarEmpresa == 1) {
            movimentos.setLong("ID_EMPRESA", empresa.getIdentificador().longValue());
        } else {
            movimentos.setLong("ID_EMPRESA", 0L);
        }
        movimentos.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List titulos = movimentos.list();
        for (HashMap titulo : titulos) {
            titulo.put("SALDO_TITULO", this.getSaldoTitulo((Integer)titulo.get("ID_TITULO"), dataMovimento, (BigDecimal)titulo.get("VALOR_TITULO")));
        }
        return titulos;
    }

    private Double getSaldoTitulo(Integer idTitulo, Date dataMovimento, BigDecimal valorTitulo) {
        String queryBaixasTitulo = " SELECT COALESCE(SUM(B.VALOR), 0) AS TOTAL_BAIXAS FROM BAIXA_TITULO   B JOIN GRUPO_DE_BAIXA_FORMAS GBF ON GBF.ID_GRUPO_DE_BAIXA_FORMAS = B.ID_GRUPO_BAIXA_FORMAS JOIN GRUPO_DE_BAIXA G ON G.ID_GRUPO_DE_BAIXA = GBF.ID_GRUPO_DE_BAIXA WHERE B.ID_TITULO      = :ID_TITULO AND  G.DATA_LIQUIDACAO <= :DATA_MOVIMENTO";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery query = s.createSQLQuery(queryBaixasTitulo);
        query.setDate("DATA_MOVIMENTO", dataMovimento);
        query.setInteger("ID_TITULO", idTitulo.intValue());
        Double saldoTitulo = valorTitulo.doubleValue() - ((BigDecimal)query.uniqueResult()).doubleValue();
        return saldoTitulo;
    }

    private List<HashMap> getMovimBancarios(Date dataMovimento, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String queryMovimentosBancarios = " SELECT  MB.ID_MOVIMENTO_BANCARIO AS ID_MOVIMENTO,  MB.VALOR                 AS VALOR_MOV   ,  MB.HISTORICO             AS HISTORICO   ,  MB.DEB_CRED  FROM MOVIMENTO_BANCARIO MB  LEFT JOIN GRUPO_DE_BAIXA_FORMAS GBF  ON GBF.ID_GRUPO_DE_BAIXA_FORMAS = MB.ID_GRUPO_BAIXA_FORMAS  LEFT JOIN BAIXA_TITULO  BT ON BT.ID_GRUPO_BAIXA_FORMAS = GBF.ID_GRUPO_DE_BAIXA_FORMAS  LEFT JOIN GRUPO_DE_BAIXA G ON GBF.ID_GRUPO_DE_BAIXA = G.ID_GRUPO_DE_BAIXA JOIN  CONTA_VALORES       C ON C.ID_CONTA_VALOR         = MB.ID_CONTA_VALOR WHERE MB.DATA_LANCAMENTO = :DATA_MOVIMENTO  AND   (:FILTRAR_CONTA_VALORES <> 1 OR MB.ID_CONTA_VALOR BETWEEN :ID_CONTA_INICIAL AND :ID_CONTA_FINAL)  AND   (:FILTRAR_EMPRESA <> 1 OR MB.ID_EMPRESA = :ID_EMPRESA)  AND   BT.ID_BAIXA_TITULO IS NULL  AND   MB.ID_TRANSFERENCIA_VALOR IS NULL AND   (:IMPRIMIR_CONTAS_INATIVAS <> 0 OR c.ATIVO = 1) AND   (:IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA <> 1 OR c.IMPRIMIR_SALDO_FLUXO_CAIXA = 1)";
        NativeQuery movimentosBanc = s.createSQLQuery(queryMovimentosBancarios);
        movimentosBanc.setDate("DATA_MOVIMENTO", dataMovimento);
        movimentosBanc.setInteger("FILTRAR_CONTA_VALORES", filtrarContaValores.intValue());
        movimentosBanc.setInteger("FILTRAR_EMPRESA", (int)filtrarEmpresa.shortValue());
        movimentosBanc.setShort("IMPRIMIR_CONTAS_INATIVAS", imprimirContasInativas.shortValue());
        movimentosBanc.setShort("IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA", impSomContaValCompFluxoCaixa.shortValue());
        if (filtrarContaValores == 1) {
            movimentosBanc.setInteger("ID_CONTA_INICIAL", contaValoresInicial.getIdentificador().intValue());
            movimentosBanc.setInteger("ID_CONTA_FINAL", contaValoresFinal.getIdentificador().intValue());
        } else {
            movimentosBanc.setInteger("ID_CONTA_INICIAL", 0);
            movimentosBanc.setInteger("ID_CONTA_FINAL", 9999999);
        }
        if (filtrarEmpresa == 1) {
            movimentosBanc.setLong("ID_EMPRESA", empresa.getIdentificador().longValue());
        } else {
            movimentosBanc.setLong("ID_EMPRESA", 0L);
        }
        movimentosBanc.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return movimentosBanc.list();
    }

    private List<HashMap> getMovimBancariosTransferencias(Date dataMovimento, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String queryMovimentosBancarios = " SELECT  MB.ID_MOVIMENTO_BANCARIO AS ID_MOVIMENTO,  MB.VALOR                 AS VALOR_MOV   ,  MB.HISTORICO             AS HISTORICO   ,  MB.DEB_CRED  FROM MOVIMENTO_BANCARIO MB  LEFT JOIN GRUPO_DE_BAIXA_FORMAS GBF  ON GBF.ID_GRUPO_DE_BAIXA_FORMAS = MB.ID_GRUPO_BAIXA_FORMAS  LEFT JOIN BAIXA_TITULO  BT ON BT.ID_GRUPO_BAIXA_FORMAS = GBF.ID_GRUPO_DE_BAIXA_FORMAS  LEFT JOIN GRUPO_DE_BAIXA G ON GBF.ID_GRUPO_DE_BAIXA = G.ID_GRUPO_DE_BAIXA JOIN  CONTA_VALORES       C ON C.ID_CONTA_VALOR         = MB.ID_CONTA_VALOR WHERE MB.DATA_LANCAMENTO = :DATA_MOVIMENTO  AND   (:FILTRAR_CONTA_VALORES <> 1 OR MB.ID_CONTA_VALOR BETWEEN :ID_CONTA_INICIAL AND :ID_CONTA_FINAL)  AND   (:FILTRAR_EMPRESA <> 1 OR MB.ID_EMPRESA = :ID_EMPRESA)  AND   BT.ID_BAIXA_TITULO IS NULL  AND   MB.ID_TRANSFERENCIA_VALOR IS NOT NULL AND   (:IMPRIMIR_CONTAS_INATIVAS <> 0 OR c.ATIVO = 1) AND   (:IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA <> 1 OR c.IMPRIMIR_SALDO_FLUXO_CAIXA = 1)";
        NativeQuery movimentosBanc = s.createSQLQuery(queryMovimentosBancarios);
        movimentosBanc.setDate("DATA_MOVIMENTO", dataMovimento);
        movimentosBanc.setInteger("FILTRAR_CONTA_VALORES", filtrarContaValores.intValue());
        movimentosBanc.setInteger("FILTRAR_EMPRESA", (int)filtrarEmpresa.shortValue());
        movimentosBanc.setShort("IMPRIMIR_CONTAS_INATIVAS", imprimirContasInativas.shortValue());
        movimentosBanc.setShort("IMP_SOM_CONTA_VAL_COMP_FLUXO_CAIXA", impSomContaValCompFluxoCaixa.shortValue());
        if (filtrarContaValores == 1) {
            movimentosBanc.setInteger("ID_CONTA_INICIAL", contaValoresInicial.getIdentificador().intValue());
            movimentosBanc.setInteger("ID_CONTA_FINAL", contaValoresFinal.getIdentificador().intValue());
        } else {
            movimentosBanc.setInteger("ID_CONTA_INICIAL", 0);
            movimentosBanc.setInteger("ID_CONTA_FINAL", 9999999);
        }
        if (filtrarEmpresa == 1) {
            movimentosBanc.setLong("ID_EMPRESA", empresa.getIdentificador().longValue());
        } else {
            movimentosBanc.setLong("ID_EMPRESA", 0L);
        }
        movimentosBanc.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return movimentosBanc.list();
    }

    private HashMap getPagamentosRecebimentos(List<HashMap> pagRec, Short exibirTitulosRecebimento, Short exibirTitulosPagamento) {
        ArrayList<HashMap> pagamentos = new ArrayList<HashMap>();
        ArrayList<HashMap> recebimentos = new ArrayList<HashMap>();
        for (HashMap map : pagRec) {
            if (map.get("PAG_REC").equals(0) && exibirTitulosPagamento.equals((short)1)) {
                pagamentos.add(map);
                continue;
            }
            if (!map.get("PAG_REC").equals(1) || !exibirTitulosRecebimento.equals((short)1)) continue;
            recebimentos.add(map);
        }
        HashMap<String, ArrayList<HashMap>> pagamentosRecebimentos = new HashMap<String, ArrayList<HashMap>>();
        pagamentosRecebimentos.put("RECEBIMENTOS", recebimentos);
        pagamentosRecebimentos.put("PAGAMENTOS", pagamentos);
        return pagamentosRecebimentos;
    }

    private HashMap getMovimentosCreditoDebito(HashMap movimentosCreditoDebito, List<HashMap> movCredDeb, Short exibirMovBancCredito, Short exibirMovBancDebito) {
        ArrayList<HashMap> creditos = new ArrayList<HashMap>();
        ArrayList<HashMap> debitos = new ArrayList<HashMap>();
        for (HashMap map : movCredDeb) {
            if (map.get("DEB_CRED").equals(1) && exibirMovBancCredito.equals((short)1)) {
                creditos.add(map);
                continue;
            }
            if (!map.get("DEB_CRED").equals(0) || !exibirMovBancDebito.equals((short)1)) continue;
            debitos.add(map);
        }
        movimentosCreditoDebito.put("MOV_CREDITO", creditos);
        movimentosCreditoDebito.put("MOV_DEBITO", debitos);
        return movimentosCreditoDebito;
    }

    private HashMap getMovimentosCreditoDebitoTransferencias(HashMap movimentosCreditoDebito, List<HashMap> movCredDeb) {
        ArrayList<HashMap> creditos = new ArrayList<HashMap>();
        ArrayList<HashMap> debitos = new ArrayList<HashMap>();
        for (HashMap map : movCredDeb) {
            if (map.get("DEB_CRED").equals(1)) {
                creditos.add(map);
                continue;
            }
            if (!map.get("DEB_CRED").equals(0)) continue;
            debitos.add(map);
        }
        List creditosOld = (List)movimentosCreditoDebito.get("MOV_CREDITO");
        if (creditosOld != null && !creditosOld.isEmpty()) {
            creditosOld.addAll(creditos);
            movimentosCreditoDebito.put("MOV_CREDITO", creditosOld);
        } else {
            movimentosCreditoDebito.put("MOV_CREDITO", creditos);
        }
        List debitosOld = (List)movimentosCreditoDebito.get("MOV_DEBITO");
        if (debitosOld != null && !debitosOld.isEmpty()) {
            debitosOld.addAll(debitos);
            movimentosCreditoDebito.put("MOV_DEBITO", debitosOld);
        } else {
            movimentosCreditoDebito.put("MOV_DEBITO", debitosOld);
        }
        return movimentosCreditoDebito;
    }

    private List<HashMap> getLancamentosSintetico(Date dataInicial, Date dataFinal, Integer filtrarContaValores, ContaValores contaValoresInicial, ContaValores contaValoresFinal, Short filtrarEmpresa, Empresa empresa, Short imprimirContasInativas, Short impSomContaValCompFluxoCaixa, Short exibirTotaisTitPorDia, Short EXIBIR_COBRANCA_DESCONTADA) {
        List<HashMap> datasMovimentos = this.getDatasMovimentos(dataInicial, dataFinal, filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa);
        for (HashMap map : datasMovimentos) {
            HashMap pagamentosRecebimentos = new HashMap();
            List<HashMap> pagRec = this.getMovimentosData((Date)map.get("DATA_MOVIMENTO"), filtrarContaValores, contaValoresInicial, contaValoresFinal, filtrarEmpresa, empresa, imprimirContasInativas, impSomContaValCompFluxoCaixa, EXIBIR_COBRANCA_DESCONTADA);
            pagamentosRecebimentos = this.getPagamentosRecebimentosSintetico(pagRec);
            map.put("PAGAMENTOS", (Double)pagamentosRecebimentos.get("PAGAMENTOS"));
            map.put("RECEBIMENTOS", (Double)pagamentosRecebimentos.get("RECEBIMENTOS"));
        }
        return datasMovimentos;
    }

    private HashMap getPagamentosRecebimentosSintetico(List<HashMap> pagRec) {
        Double pagamentos = 0.0;
        Double recebimentos = 0.0;
        for (HashMap map : pagRec) {
            if (map.get("PAG_REC").equals(0)) {
                pagamentos = pagamentos + ((BigDecimal)map.get("VR_TOTAL_OPERACAO")).doubleValue();
                continue;
            }
            if (!map.get("PAG_REC").equals(1)) continue;
            recebimentos = recebimentos + ((BigDecimal)map.get("VR_TOTAL_OPERACAO")).doubleValue();
        }
        HashMap<String, Double> pagamentosRecebimentos = new HashMap<String, Double>();
        pagamentosRecebimentos.put("RECEBIMENTOS", recebimentos);
        pagamentosRecebimentos.put("PAGAMENTOS", pagamentos);
        return pagamentosRecebimentos;
    }
}

