/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensFinanceiro;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.query.NativeQuery;

public class UtilGerarListagemEvolucaoSaldoDevedor {
    JasperPrint gerarListagemEvolucaoSaldoDevedor(Integer filtrarEmpresa, Long idEmpInicial, Long idEmpFinal, Integer filtrarDataVenc, Date dataVencInicial, Date dataVencFinal, Date dataBase, HashMap parametrosRelatorio, Integer filtrarCartCob, Long idCartInicial, Long idCartFinal, Date dataLimite) throws ExceptionService {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataBase);
        ArrayList hash = new ArrayList();
        Double lastValueValorPag = 0.0;
        Double lastValueValorRec = 0.0;
        do {
            g.set(5, g.getActualMaximum(5));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", DateUtil.dateToStr(g.getTime()));
            hash.add(map);
            Double saldoAbertoMesPag = this.getSaldoAbertoMes(g.getTime(), 0, filtrarEmpresa, idEmpInicial, idEmpFinal, filtrarDataVenc, dataVencInicial, dataVencFinal, filtrarCartCob, idCartInicial, idCartFinal);
            map.put("saldoPag", saldoAbertoMesPag);
            if (lastValueValorPag > 0.0) {
                map.put("variacaoPag", (1.0 - lastValueValorPag / saldoAbertoMesPag) * 100.0);
            } else {
                map.put("variacaoPag", 0.0);
            }
            lastValueValorPag = saldoAbertoMesPag;
            if (lastValueValorPag == null) {
                lastValueValorPag = 0.0;
            }
            Double saldoAbertoMesRec = this.getSaldoAbertoMes(g.getTime(), 1, filtrarEmpresa, idEmpInicial, idEmpFinal, filtrarDataVenc, dataVencInicial, dataVencFinal, filtrarCartCob, idCartInicial, idCartFinal);
            map.put("saldoRec", saldoAbertoMesRec);
            if (lastValueValorRec > 0.0) {
                map.put("variacaoRec", (1.0 - lastValueValorRec / saldoAbertoMesRec) * 100.0);
            } else {
                map.put("variacaoRec", 0.0);
            }
            lastValueValorRec = saldoAbertoMesRec;
            if (lastValueValorRec == null) {
                lastValueValorRec = 0.0;
            }
            g.set(5, 1);
            g.set(2, g.get(2) + 1);
        } while (g.getTime().before(dataLimite));
        CoreRequestContext listagemLiberacaoTitulos = new CoreRequestContext();
        listagemLiberacaoTitulos.setAttribute("dados", hash);
        listagemLiberacaoTitulos.setAttribute("path", this.getPathReports());
        listagemLiberacaoTitulos.setAttribute("parametros", parametrosRelatorio);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(listagemLiberacaoTitulos, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private Double getSaldoAbertoMes(Date maxDateMonth, int pagRec, int filtrarEmp, Long idEmpInicial, Long idEmpFinal, int filtrarDataVenc, Date dataVencIn, Date dataVencFinal, int filtrarCartCob, Long idCartCobInicial, Long idCartCobFinal) {
        NativeQuery q = CoreBdUtil.getInstance().getSession().createSQLQuery("select sum(s.valor_saldo) from SALDO_TITULOS_PROC(:TIPO_SALDO,:data_saldo,:data_inicio_emissao,:id_pessoa_in,:id_pessoa_fim,:id_cart_in,:id_cart_fim,:data_venc_inicial,:data_venc_final,:id_emp_inicial,:id_emp_final,:prov_inicial,:prov_final,:data_comp_inicial,:data_comp_final,:pag_rec,:pag_rec,:data_cadastro_inicial,:data_cadastro_final, null)s");
        q.setInteger("TIPO_SALDO", 0);
        q.setDate("data_saldo", maxDateMonth);
        q.setDate("data_inicio_emissao", null);
        q.setParameter("id_pessoa_in", null);
        q.setParameter("id_pessoa_fim", null);
        q.setParameter("data_comp_inicial", null);
        q.setParameter("data_comp_final", null);
        q.setParameter("data_cadastro_inicial", null);
        q.setParameter("data_cadastro_final", null);
        if (filtrarCartCob == 1) {
            q.setLong("id_cart_in", idCartCobInicial.longValue());
            q.setLong("id_cart_fim", idCartCobFinal.longValue());
        } else {
            q.setParameter("id_cart_in", null);
            q.setParameter("id_cart_fim", null);
        }
        q.setInteger("pag_rec", pagRec);
        q.setInteger("pag_rec", pagRec);
        q.setInteger("prov_inicial", 1);
        q.setInteger("prov_final", 1);
        if (filtrarEmp == 1) {
            q.setLong("id_emp_inicial", idEmpInicial.longValue());
            q.setLong("id_emp_final", idEmpFinal.longValue());
        } else {
            q.setParameter("id_emp_inicial", null);
            q.setParameter("id_emp_final", null);
        }
        if (filtrarDataVenc == 1) {
            q.setDate("data_venc_inicial", dataVencIn);
            q.setDate("data_venc_final", dataVencFinal);
        } else {
            q.setParameter("data_venc_inicial", null);
            q.setParameter("data_venc_final", null);
        }
        BigDecimal nr = (BigDecimal)q.uniqueResult();
        if (nr != null) {
            return nr.doubleValue();
        }
        return 0.0;
    }

    private Object getPathReports() {
        return CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "financas" + File.separator + "gestaocontaspagarreceber" + File.separator + "listagemevolucaosaldodevedor" + File.separator + "LISTAGEM_EVOLUCAO_FATOR_DEVEDOR.jasper";
    }
}

