/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagenscontabilidadegerencial;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemLancGerencialPorCentroCusto {
    UtilGerarListagemLancGerencialPorCentroCusto() {
    }

    protected JasperPrint gerarListagemLancGerencialPorCentroCusto(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarPlanoGerencial, String codPlanoGerencialInicial, String codPlanoGerencialFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarCentroCusto, Long idCentroCustoInicial, Long idCentroCustoFinal, Short tipoRelatorio, Short tipoData, Short credorDevedor, Short provRealizado, Short exibirLancamento, Nodo nodo, String fecho, HashMap params) throws ExceptionService {
        ArrayList<HashMap> dados = new ArrayList<HashMap>();
        dados.addAll(this.putDadosLancamentosGerenciais(filtrarData, dataInicial, dataFinal, filtrarPlanoGerencial, codPlanoGerencialInicial, codPlanoGerencialFinal, filtrarCentroCusto, idCentroCustoInicial, idCentroCustoFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, credorDevedor, provRealizado, tipoData));
        this.setarNemeroNotaLancamento(dados);
        this.setarParametros(filtrarData, dataInicial, dataFinal, filtrarPlanoGerencial, codPlanoGerencialInicial, codPlanoGerencialFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarCentroCusto, idCentroCustoInicial, idCentroCustoFinal, tipoRelatorio, tipoData, credorDevedor, provRealizado, exibirLancamento, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaocontabilidadegerencial" + File.separator + "listagens" + File.separator + "listagemlancgerencialcentrocusto" + File.separator + "LISTAGEM_LANC_GERENCIAL_POR_CENTRO_CUSTO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private void setarParametros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarPlanoGerencial, String codigoPlanoGerencialInicial, String codigoPlanoGerencialFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarCentroCusto, Long idCentroCustoInicial, Long idCentroCustoFinal, Short tipoRelatorio, Short tipoData, Short debitoCredito, Short provisaoRealizado, Short exibirLancamento, String fecho, HashMap params) {
        params.put("FILTRAR_DATA", filtrarData);
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FILTRAR_PLANO_GERENCIAL", filtrarPlanoGerencial);
        params.put("COD_PLANO_GERENCIAL_INICIAL", codigoPlanoGerencialInicial);
        params.put("COD_PLANO_GERENCIAL_FINAL", codigoPlanoGerencialFinal);
        params.put("FILTRAR_EMPRESA", filtrarEmpresa);
        params.put("ID_EMPRESA_INICIAL", idEmpresaInicial);
        params.put("ID_EMPRESA_FINAL", idEmpresaFinal);
        params.put("FILTRAR_CENTRO_CUSTO", filtrarCentroCusto);
        params.put("ID_CENTRO_CUSTO_INICIAL", idCentroCustoInicial);
        params.put("ID_CENTRO_CUSTO_FINAL", idCentroCustoFinal);
        params.put("TIPO_RELATORIO", tipoRelatorio);
        params.put("DEBITO_CREDITO", debitoCredito);
        params.put("PROVISIONAMENTO", provisaoRealizado);
        params.put("TIPO_LANCAMENTO", tipoData);
        params.put("EXIBIR_LANCAMENTO", exibirLancamento);
        params.put("FECHO", fecho);
    }

    private List<HashMap> putDadosLancamentosGerenciais(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarPlanoGerencial, String codPlanoGerencialInicial, String codPlanoGerencialFinal, Short filtrarCentroCusto, Long idCentroCustoInicial, Long idCentroCustoFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short credorDevedor, Short provisionadoRealizado, Short tipoData) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select l.valor as VALOR, l.dataCadastro as DATA_LANCAMENTO, c.identificador as ID_CENTRO_CUSTO, c.codigo as CODIGO_CENTRO_CUSTO, c.nome as NOME_CENTRO_CUSTO, pg.identificador as ID_PLANO_GERENCIAL, pg.codigo as CODIGO_PLANO_GERENCIAL, pg.descricao as DESC_PLANO_GERENCIAL, l.identificador as ID_LANC_GERENCIAL, l.dataPrevista as DATA_PREVISTA, l.historico as HISTORICO from LancamentoCtbGerencial l inner join l.centroCusto c inner join l.planoContaGerencial pg WHERE      (:filtrarData           <>1 OR l.dataCadastro between :dataInicial and :dataFinal) AND (:filtrarEmpresa        <>1 OR l.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (:filtrarPlanoGerencial <>1 OR pg.codigo between :codigoPlanoGerencialInicial and :codigoPlanoGerencialFinal) AND (:filtrarCentroCusto    <>1 OR c.identificador between :idCentroCustoInicial and :idCentroCustoFinal) AND (l.tipoLancamento  = :tipoLancamento) AND (l.debCred         = :credorDevedor)";
        if (provisionadoRealizado == 0 || provisionadoRealizado == 1) {
            hql = (String)hql + " AND (l.provRealizado = :provisionadoRealizado )";
        }
        hql = (String)hql + " order by c.identificador, pg.identificador";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarPlanoGerencial", filtrarPlanoGerencial.shortValue());
        q.setString("codigoPlanoGerencialInicial", codPlanoGerencialInicial);
        q.setString("codigoPlanoGerencialFinal", codPlanoGerencialFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpresaFinal", idEmpresaFinal.longValue());
        q.setShort("filtrarCentroCusto", filtrarCentroCusto.shortValue());
        q.setLong("idCentroCustoInicial", idCentroCustoInicial.longValue());
        q.setLong("idCentroCustoFinal", idCentroCustoFinal.longValue());
        q.setShort("credorDevedor", credorDevedor.shortValue());
        q.setShort("tipoLancamento", tipoData.shortValue());
        if (provisionadoRealizado == 0 || provisionadoRealizado == 1) {
            q.setShort("provisionadoRealizado", provisionadoRealizado.shortValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void setarNemeroNotaLancamento(List<HashMap> dados) {
        for (HashMap h : dados) {
            Long idLancamento = (Long)h.get("ID_LANC_GERENCIAL");
            h.put("NR_NOTA_PROPRIA", this.getNumeroNotaPropria(idLancamento));
            h.put("NR_NOTA_TERCEIRO", this.getNumeroNotaTerceiro(idLancamento));
        }
    }

    private Integer getNumeroNotaPropria(Long idLancamento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select distinct t.infPagamentoNfPropria.notaFiscalPropria.numeroNota as nr_nota from Titulo t inner join t.lancCtbGerencial l where l.identificador = :idLancamento ";
        Query q = s.createQuery(hql);
        q.setLong("idLancamento", idLancamento.longValue());
        return (Integer)q.uniqueResult();
    }

    private Integer getNumeroNotaTerceiro(Long idLancamento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select distinct t.infPagamentoNfTerceiros.notaFiscalTerceiros.numeroNota as nr_nota from Titulo t inner join t.lancCtbGerencial l where l.identificador = :idLancamento ";
        Query q = s.createQuery(hql);
        q.setLong("idLancamento", idLancamento.longValue());
        return (Integer)q.uniqueResult();
    }
}

