/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeraBalancoMensal {
    private static Short ordenacao;

    JasperPrint gerarListagemBalancoMensal(Date dataInicial, Date dataFinal, Date dataSaldoInicial, Date dataSaldoFinal, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short filtrarCentroEstoque, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Short filtrarLocalizacao, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal, Short filtrarFabricante, Long idFabricanteInicial, Long idFabricanteFinal, Short filtrarGradeCor, Long idGradeCorInicial, Long idGradeCorFinal, String gradeCor, Long idEmpresa, Short produtosSemMovimentacao, int opcao, Short ordenacao, String fecho, HashMap defaultParams, Short tipoEstoqueCentroEstoque) throws ExceptionService {
        UtilGeraBalancoMensal.ordenacao = ordenacao;
        List<HashMap> dados = this.putDadosMovimentacoes(dataInicial, dataFinal, dataSaldoInicial, dataSaldoFinal, filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarCentroEstoque, idCentroEstoqueInicial, idCentroEstoqueFinal, filtrarLocalizacao, idLocalizacaoInicial, idLocalizacaoFinal, filtrarEspecie, idEspecieInicial, idEspecieFinal, filtrarSubEspecie, idSubEspecieInicial, idSubEspecieFinal, filtrarFabricante, idFabricanteInicial, idFabricanteFinal, filtrarGradeCor, idGradeCorInicial, idGradeCorFinal, idEmpresa, ordenacao, tipoEstoqueCentroEstoque);
        this.ordenarMovimentos(dados);
        if (produtosSemMovimentacao == 1) {
            this.putProdutosSemMovimentacoes(dados, filtrarProduto, idProdutoInicial, idProdutoFinal);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(defaultParams);
        params.put("FECHO", fecho);
        params.put("LEACH_PRODUTO", filtrarProduto);
        params.put("LEACH_ESPECIE", filtrarEspecie);
        params.put("LEACH_SUB_ESPECIE", filtrarSubEspecie);
        params.put("LEACH_LOCALIZACAO", filtrarLocalizacao);
        params.put("LEACH_FABRICANTE", filtrarFabricante);
        params.put("LEACH_GRADE_COR", filtrarGradeCor);
        params.put("LEACH_CENTRO_ESTOQUE", filtrarCentroEstoque);
        params.put("PRODUTOS_SEM_MOVIMENTACAO", produtosSemMovimentacao);
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FECHO", fecho);
        params.put("OPCAO", opcao);
        params.put("PROD_INICIAL", idProdutoInicial);
        params.put("PROD_FINAL", idProdutoFinal);
        params.put("ID_CENTRO_ESTOQUE_INICIAL", idCentroEstoqueInicial);
        params.put("ID_CENTRO_ESTOQUE_FINAL", idCentroEstoqueFinal);
        params.put("LOCAL_INICIAL", idLocalizacaoInicial);
        params.put("LOCAL_FINAL", idLocalizacaoFinal);
        params.put("ESP_INICIAL", idEspecieInicial);
        params.put("ESP_FINAL", idEspecieFinal);
        params.put("SUBESP_INICIAL", idSubEspecieInicial);
        params.put("SUBESP_FINAL", idSubEspecieFinal);
        params.put("FABRICANTE_INICIAL", idFabricanteInicial);
        params.put("FABRICANTE_FINAL", idFabricanteFinal);
        params.put("GRADE_COR_INICIAL", idGradeCorInicial);
        params.put("GRADE_COR_FINAL", idGradeCorFinal);
        params.put("GRADE_COR", gradeCor);
        params.put("ORDENACAO", ordenacao);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "relatorios" + File.separator + "listagens" + File.separator + "LISTAGEM_BALANCO_MENSAL.jasper";
        params.put("PATH", path);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List<SaldoEstoqueGeral> findSaldoUnificadoProduto(Date dataIn, Long idEmpresa, Short filtrarProduto, Long idProdInicial, Long idProdFinal, Short filtrarCentroEstoque, Long idCentroInicial, Long idCentroFinal, Short filtrarLocalizacao, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal, Short filtrarFabricante, Long idFabricanteInicial, Long idFabricanteFinal, Short filtrarGradeCor, Long idGradeCorInicial, Long idGradeCorFinal, Short ordenacao, Short tipoEstoqueCentroEstoque) throws ExceptionService {
        if (dataIn == null) {
            dataIn = new Date();
        }
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)0)) {
            idProdFinal = null;
            idProdInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarGradeCor, (Object)0)) {
            idGradeCorFinal = null;
            idGradeCorInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarCentroEstoque, (Object)0)) {
            idCentroFinal = null;
            idCentroInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarLocalizacao, (Object)0)) {
            idLocalizacaoFinal = null;
            idLocalizacaoInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarFabricante, (Object)0)) {
            idFabricanteFinal = null;
            idFabricanteInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarEspecie, (Object)0)) {
            idEspecieFinal = null;
            idEspecieInicial = null;
        }
        if (ToolMethods.isEquals((Object)filtrarSubEspecie, (Object)0)) {
            idSubEspecieFinal = null;
            idSubEspecieInicial = null;
        }
        ServiceSaldoEstoqueImpl service = (ServiceSaldoEstoqueImpl)Context.get(ServiceSaldoEstoqueImpl.class);
        List saldos = service.findSaldoGradeCentroEstoqueLoteParamAdicLista(dataIn, idProdInicial, idProdFinal, idCentroInicial, idCentroFinal, idGradeCorInicial, idGradeCorFinal, idEmpresa, idEmpresa, null, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idLocalizacaoInicial, idLocalizacaoFinal, idFabricanteInicial, idFabricanteFinal, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_CENTRO_ESTOQUE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.get((Object)tipoEstoqueCentroEstoque), null);
        return saldos;
    }

    private List<HashMap> putDadosMovimentacoes(Date dataInicial, Date dataFinal, Date dataSaldoInicial, Date dataSaldoFinal, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short filtrarCentroEstoque, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Short filtrarLocalizacao, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal, Short filtrarFabricante, Long idFabricanteInicial, Long idFabricanteFinal, Short filtrarGradeCor, Long idGradeCorInicial, Long idGradeCorFinal, Long idEmpresa, Short ordenacao, Short tipoEstoqueCentroEstoque) throws ExceptionService {
        List<SaldoEstoqueGeral> saldosIniciais = this.findSaldoUnificadoProduto(dataSaldoInicial, idEmpresa, filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarCentroEstoque, idCentroEstoqueInicial, idCentroEstoqueFinal, filtrarLocalizacao, idLocalizacaoInicial, idLocalizacaoFinal, filtrarEspecie, idEspecieInicial, idEspecieFinal, filtrarSubEspecie, idSubEspecieInicial, idSubEspecieFinal, filtrarFabricante, idFabricanteInicial, idFabricanteFinal, filtrarGradeCor, idGradeCorInicial, idGradeCorFinal, ordenacao, tipoEstoqueCentroEstoque);
        List<SaldoEstoqueGeral> saldosFinais = this.findSaldoUnificadoProduto(dataSaldoFinal, idEmpresa, filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarCentroEstoque, idCentroEstoqueInicial, idCentroEstoqueFinal, filtrarLocalizacao, idLocalizacaoInicial, idLocalizacaoFinal, filtrarEspecie, idEspecieInicial, idEspecieFinal, filtrarSubEspecie, idSubEspecieInicial, idSubEspecieFinal, filtrarFabricante, idFabricanteInicial, idFabricanteFinal, filtrarGradeCor, idGradeCorInicial, idGradeCorFinal, ordenacao, tipoEstoqueCentroEstoque);
        LinkedList<HashMap> dados = new LinkedList<HashMap>();
        this.mesclar(saldosIniciais, dados, false);
        this.mesclar(saldosFinais, dados, true);
        List<HashMap> movimentacoes = this.getMovimentacoes(dataInicial, dataFinal, idEmpresa, filtrarProduto, idProdutoInicial, idProdutoFinal, tipoEstoqueCentroEstoque);
        this.mesclar(dados, movimentacoes);
        return dados;
    }

    private List<HashMap> getMovimentacoes(Date dataIn, Date dataFim, Long idEmpresa, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short tipoCentroEstPropTerc) throws ExceptionService {
        List<HashMap> lista = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getMovimentacoesEntradaSaidaPorPeriodoAndGradeQuantitativo(dataIn, dataFim, idEmpresa, filtrarProduto, idProdutoInicial, idProdutoFinal, tipoCentroEstPropTerc);
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        Iterator<HashMap> iterator = lista.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap h = o = iterator.next();
            Integer idProduto = (Integer)h.get("ID_PRODUTO");
            BigDecimal quantidadeEntradaDia = (BigDecimal)h.get("QUANTIDADE_ENTRADA");
            BigDecimal quantidadeSaidaDia = (BigDecimal)h.get("QUANTIDADE_SAIDA");
            Date dataSaldo = (Date)h.get("DATA_SALDO");
            Double precoMedio = SaldoEstoqueUtilities.findPrecoMedioPorIdProduto(dataSaldo, idProduto.longValue(), idEmpresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, null, tipoCentroEstPropTerc, null);
            h.put("VALOR_ENTRADA", precoMedio * quantidadeEntradaDia.doubleValue());
            h.put("VALOR_SAIDA", precoMedio * quantidadeSaidaDia.doubleValue());
            h.put("QUANTIDADE_ENTRADA", quantidadeEntradaDia.doubleValue());
            h.put("QUANTIDADE_SAIDA", quantidadeSaidaDia.doubleValue());
            retorno.add(h);
        }
        return retorno;
    }

    private void ordenarMovimentos(List movimentos) {
        Collections.sort(movimentos, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                if (ordenacao.equals(Short.valueOf("1"))) {
                    Integer idProduto1 = (Integer)h1.get("ID_PRODUTO");
                    Integer idProduto2 = (Integer)h2.get("ID_PRODUTO");
                    return idProduto1.compareTo(idProduto2);
                }
                String nomeProduto1 = (String)h1.get("NOME");
                String nomeProduto2 = (String)h2.get("NOME");
                return nomeProduto1.compareTo(nomeProduto2);
            }
        });
    }

    private void putProdutosSemMovimentacoes(List<HashMap> dados, Short filtrarProduto, Long idProdIni, Long idProdFin) {
        Object st = " select p.id_produto as ID_PRODUTO, p.nome as NOME from  grade_cor g  inner join produto_grade pg on pg.id_produto_grade = g.id_produto_grade inner join produto p on p.id_produto = pg.id_produto where not exists      (select gc.id_grade_cor       from saldo_est_proprio ss       inner join grade_cor gc on gc.id_grade_cor = ss.id_grade_cor      where gc.id_grade_cor = g.id_grade_cor)";
        if (filtrarProduto == 1) {
            st = (String)st + " and p.id_produto between :idProdIni and :idProdFin";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery((String)st);
        if (filtrarProduto == 1) {
            q.setLong("idProdIni", idProdIni.longValue());
            q.setLong("idProdFin", idProdFin.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        dados.addAll(lista);
    }

    private void mesclar(List<SaldoEstoqueGeral> saldosIniciais, List<HashMap> dados, boolean isSaldoFinal) {
        for (SaldoEstoqueGeral saldo : saldosIniciais) {
            Double saldoAnt;
            HashMap<String, Object> found = this.findHash(saldo, dados);
            if (found == null) {
                found = new HashMap<String, Object>();
                dados.add(found);
                found.put("ID_CENTRO_ESTOQUE", saldo.getCentroEstoque().getIdentificador());
                found.put("CENTRO_ESTOQUE", saldo.getCentroEstoque().getDescricao());
                found.put("ID_PRODUTO", saldo.getProduto().getIdentificador().intValue());
                found.put("CODIGO_AUXILIAR", saldo.getProduto().getCodigoAuxiliar());
                found.put("NOME", saldo.getProduto().getNome());
                found.put("UNIDADE_MEDIDA", saldo.getProduto().getUnidadeMedida().getSigla());
            }
            if (isSaldoFinal) {
                if (found.get("SALDO_QTD_FINAL") != null) {
                    saldoAnt = (Double)found.get("SALDO_QTD_FINAL");
                    found.put("SALDO_QTD_FINAL", saldoAnt + saldo.getQuantidade());
                } else {
                    found.put("SALDO_QTD_FINAL", saldo.getQuantidade());
                }
                if (found.get("SALDO_VALOR_FINAL") != null) {
                    saldoAnt = (Double)found.get("SALDO_VALOR_FINAL");
                    found.put("SALDO_VALOR_FINAL", saldoAnt + saldo.getValor());
                    continue;
                }
                found.put("SALDO_VALOR_FINAL", saldo.getValor());
                continue;
            }
            if (found.get("SALDO_QTD_INICIAL") != null) {
                saldoAnt = (Double)found.get("SALDO_QTD_INICIAL");
                found.put("SALDO_QTD_INICIAL", saldoAnt + saldo.getQuantidade());
            } else {
                found.put("SALDO_QTD_INICIAL", saldo.getQuantidade());
            }
            if (found.get("SALDO_VALOR_INICIAL") != null) {
                saldoAnt = (Double)found.get("SALDO_VALOR_INICIAL");
                found.put("SALDO_VALOR_INICIAL", saldoAnt + saldo.getValor());
                continue;
            }
            found.put("SALDO_VALOR_INICIAL", saldo.getValor());
        }
    }

    private HashMap findHash(SaldoEstoqueGeral saldo, List<HashMap> dados) {
        for (HashMap dado : dados) {
            Integer idProduto = (Integer)dado.get("ID_PRODUTO");
            Long idCentroEstoque = (Long)dado.get("ID_CENTRO_ESTOQUE");
            if (!idProduto.equals(saldo.getProduto().getIdentificador().intValue()) || !idCentroEstoque.equals(saldo.getCentroEstoque().getIdentificador())) continue;
            return dado;
        }
        return null;
    }

    private void mesclar(List<HashMap> dados, List movimentacoes) {
        for (HashMap h : dados) {
            Integer idProduto = (Integer)h.get("ID_PRODUTO");
            Long idCentroEstoque = (Long)h.get("ID_CENTRO_ESTOQUE");
            for (Object o : movimentacoes) {
                HashMap h2 = (HashMap)o;
                Integer idProduto2 = (Integer)h2.get("ID_PRODUTO");
                Integer idCentroEstoque2 = (Integer)h2.get("ID_CENTRO_ESTOQUE");
                if (!idProduto.equals(idProduto2) || !idCentroEstoque.equals(idCentroEstoque2.longValue())) continue;
                if (h.get("QUANTIDADE_ENTRADA") != null && h2.get("QUANTIDADE_ENTRADA") != null) {
                    Double qtdeEntrada = (Double)h.get("QUANTIDADE_ENTRADA");
                    Double qtdeEntrada2 = (Double)h2.get("QUANTIDADE_ENTRADA");
                    h.put("QUANTIDADE_ENTRADA", qtdeEntrada + qtdeEntrada2);
                } else if (h.get("QUANTIDADE_ENTRADA") == null && h2.get("QUANTIDADE_ENTRADA") != null) {
                    Double qtdeEntrada2 = (Double)h2.get("QUANTIDADE_ENTRADA");
                    h.put("QUANTIDADE_ENTRADA", qtdeEntrada2);
                }
                if (h.get("QUANTIDADE_SAIDA") != null && h2.get("QUANTIDADE_SAIDA") != null) {
                    Double qtdeSaida = (Double)h.get("QUANTIDADE_SAIDA");
                    Double qtdeSaida2 = (Double)h2.get("QUANTIDADE_SAIDA");
                    h.put("QUANTIDADE_SAIDA", qtdeSaida + qtdeSaida2);
                } else if (h.get("QUANTIDADE_SAIDA") == null && h2.get("QUANTIDADE_SAIDA") != null) {
                    Double qtdeSaida2 = (Double)h2.get("QUANTIDADE_SAIDA");
                    h.put("QUANTIDADE_SAIDA", qtdeSaida2);
                }
                if (h.get("VALOR_ENTRADA") != null && h2.get("VALOR_ENTRADA") != null) {
                    Double valorEntrada = (Double)h.get("VALOR_ENTRADA");
                    Double valorEntrada2 = (Double)h2.get("VALOR_ENTRADA");
                    h.put("VALOR_ENTRADA", valorEntrada + valorEntrada2);
                } else if (h.get("VALOR_ENTRADA") == null && h2.get("VALOR_ENTRADA") != null) {
                    Double valorEntrada2 = (Double)h2.get("VALOR_ENTRADA");
                    h.put("VALOR_ENTRADA", valorEntrada2);
                }
                if (h.get("VALOR_SAIDA") != null && h2.get("VALOR_SAIDA") != null) {
                    Double valorSaida = (Double)h.get("VALOR_SAIDA");
                    Double valorSaida2 = (Double)h2.get("VALOR_SAIDA");
                    h.put("VALOR_SAIDA", valorSaida + valorSaida2);
                    continue;
                }
                if (h.get("VALOR_SAIDA") != null || h2.get("VALOR_SAIDA") == null) continue;
                Double valorSaida2 = (Double)h2.get("VALOR_SAIDA");
                h.put("VALOR_SAIDA", valorSaida2);
            }
        }
        for (HashMap h : dados) {
            if (h.get("QUANTIDADE_ENTRADA") == null) {
                h.put("QUANTIDADE_ENTRADA", 0.0);
            }
            if (h.get("QUANTIDADE_SAIDA") == null) {
                h.put("QUANTIDADE_SAIDA", 0.0);
            }
            if (h.get("VALOR_ENTRADA") == null) {
                h.put("VALOR_ENTRADA", 0.0);
            }
            if (h.get("VALOR_SAIDA") != null) continue;
            h.put("VALOR_SAIDA", 0.0);
        }
    }
}

