/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensestoque;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeraEntregaFutura {
    JasperPrint gerarListagemEntregaFutura(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Short tipoNota, String fecho, Long empresa, HashMap defaultParams) throws ExceptionService {
        List dadosPessoa = this.getDadosPessoa(filtrarData, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, empresa, tipoNota);
        List data = this.getEntregaFutura(dadosPessoa, filtrarData, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, empresa, tipoNota);
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.putAll(defaultParams);
        parametros.put("FILTRAR_DATA", filtrarData);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("ID_PRODUTO_INICIAL", produtoInicial);
        parametros.put("ID_PRODUTO_FINAL", produtoFinal);
        parametros.put("FILTRAR_PESSOA", filtrarPessoa);
        parametros.put("ID_PESSOA_INICIAL", pessoaInicial);
        parametros.put("ID_PESSOA_FINAL", pessoaFinal);
        parametros.put("FILTRAR_CENTRO_ESTOQUE", filtrarCentroEstoque);
        parametros.put("ID_CENTRO_ESTOQUE_INICIAL", centroEstoqueInicial);
        parametros.put("ID_CENTRO_ESTOQUE_FINAL", centroEstoqueFinal);
        parametros.put("TIPO_NOTA", tipoNota == 1 ? "Nota Pr\u00f3pria" : "Nota Terceiros");
        parametros.put("FECHO", fecho);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "estoque" + File.separator + "relatorios" + File.separator;
        parametros.put("PATH", path);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", (String)path + "LISTAGEM_ENTREGA_FUTURA.jasper");
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", data);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List getDadosPessoa(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long empresa, Short tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = tipoNota == 0 ? "select distinct pes.id_pessoa as id_pessoa, pes.nome      as nome_pessoa, c.cnpj        as cnpj_pessoa from       item_nota_terceiros       i inner join natureza_operacao       nop on nop.id_natureza_operacao  = i.id_natureza_operacao inner join produto                   p on p.id_produto              = i.id_produto inner join nota_terceiros            n on n.id_nota_terceiros       = i.id_nota_terceiros inner join situacao_documento        s on s.id_situacao_documento   = n.id_situacao_documento inner join unidade_fat_forn          u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn inner join fornecedor                f on f.id_fornecedor           = u.id_fornecedor inner join pessoa                  pes on pes.id_pessoa             = f.id_pessoa inner join complemento               c on c.id_complemento          = pes.id_complemento left  join centro_estoque            e on e.id_centro_estoque       = i.id_centro_estoque inner join estoque_terceiros        et on et.id_item_nota_terceiros = i.id_item_nota_terceiros inner join empresa                  ep on ep.id_emp                 = n.id_empresa where (nop.tipo_estoque = 8) and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null) and s.codigo               <> '02' and s.codigo               <> '03' and ep.id_emp              =  :empresa and (:filtrarProduto       <> 1 OR p.id_produto         between :produtoInicial        AND :produtoFinal) and (:filtrarPessoa        <> 1 OR pes.id_pessoa        between :pessoaInicial         AND :pessoaFinal ) and (:filtrarData          <> 1 OR n.data_entrada_saida between :dataInicial           AND :dataFinal)and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque  between :centroEstoqueInicial  AND :centroEstoqueFinal) " : " select distinct pes.id_pessoa as id_pessoa, pes.nome      as nome_pessoa, co.cnpj       as cnpj_pessoa  from item_nota_propria         i  inner join nota_propria        n on n.id_nota_propria        = i.id_nota_fiscal_propria inner join natureza_operacao nop on nop.id_natureza_operacao = n.id_natureza_operacao  inner join produto             p on p.id_produto             = i.id_produto  inner join situacao_documento  s on s.id_situacao_documento  = n.id_situacao_documento  inner join unidade_fat_cliente u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente  inner join cliente             c on c.id_cliente             = u.id_cliente inner join pessoa            pes on pes.id_pessoa            = c.id_pessoa  inner join complemento        co on co.id_complemento        = pes.id_complemento  left  join centro_estoque      e on e.id_centro_estoque      = i.id_centro_estoque  inner join estoque_terceiros  et on et.id_item_nota_propria  = i.id_item_nota_propria  inner join empresa            ep on ep.id_emp                = n.id_empresa where (nop.tipo_estoque = 10) and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null) and s.codigo               <> '02' and s.codigo               <> '03' and ep.id_emp               = :empresa and (:filtrarProduto       <> 1 OR p.id_produto         between :produtoInicial        AND :produtoFinal) and (:filtrarPessoa        <> 1 OR pes.id_pessoa        between :pessoaInicial         AND :pessoaFinal ) and (:filtrarData          <> 1 OR n.data_entrada_saida between :dataInicial           AND :dataFinal) and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque  between :centroEstoqueInicial  AND :centroEstoqueFinal) ";
        query = (String)query + " order by pes.id_pessoa, pes.nome";
        NativeQuery q = s.createSQLQuery((String)query);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("pessoaInicial", pessoaInicial.longValue());
        q.setLong("pessoaFinal", pessoaFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setLong("empresa", empresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getEntregaFutura(List dadosPessoa, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long empresa, Short tipoNota) {
        for (Object o : dadosPessoa) {
            HashMap pessoa = (HashMap)o;
            Integer idPessoa = (Integer)pessoa.get("ID_PESSOA");
            List notasMae = this.getNotasMaeByPessoa(idPessoa, filtrarData, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, empresa, tipoNota);
            pessoa.put("NOTAS", notasMae);
            for (Object nt : notasMae) {
                HashMap nota = (HashMap)nt;
                Integer idNota = (Integer)nota.get("ID_NOTA");
                List itensNota = this.getItensNotaMae(idNota, filtrarProduto, produtoInicial, produtoFinal, tipoNota, empresa);
                nota.put("ITENS", itensNota);
                for (Object item : itensNota) {
                    HashMap itemMae = (HashMap)item;
                    Integer idItemMae = (Integer)itemMae.get("ID_EST_TERC");
                    List itensRetorno = this.getItensRetorno(idItemMae, tipoNota, empresa);
                    itemMae.put("RETORNOS", itensRetorno);
                }
            }
        }
        return dadosPessoa;
    }

    private List getNotasMaeByPessoa(Integer idPessoa, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long empresa, Short tipoNota) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = tipoNota == 0 ? " select distinct n.id_nota_terceiros           as id_nota, n.serie                       as serie, n.numero_nota                 as numero_nota, n.data_emissao                as data_emissao, n.data_entrada_saida          as data_entrada_saida from item_nota_terceiros       i inner join natureza_operacao nop on nop.id_natureza_operacao  = i.id_natureza_operacao inner join produto             p on p.id_produto              = i.id_produto inner join nota_terceiros      n on n.id_nota_terceiros       = i.id_nota_terceiros inner join situacao_documento  s on s.id_situacao_documento   = n.id_situacao_documento inner join unidade_fat_forn    u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn inner join fornecedor          f on f.id_fornecedor           = u.id_fornecedor inner join pessoa            pes on pes.id_pessoa             = f.id_pessoa inner join complemento         c on c.id_complemento          = pes.id_complemento left  join centro_estoque      e on e.id_centro_estoque       = i.id_centro_estoque inner join estoque_terceiros  et on et.id_item_nota_terceiros = i.id_item_nota_terceiros inner join empresa            ep on ep.id_emp                 = n.id_empresa where nop.tipo_estoque         = 8 and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null) and ep.id_emp                  = :empresa and s.codigo                  <> '02' and s.codigo                  <> '03' and pes.id_pessoa              = :idPessoa and (:filtrarData             <> 1 OR n.data_entrada_saida between :dataInicial          AND :dataFinal) and (:filtrarProduto          <> 1 OR p.id_produto         between :produtoInicial       AND :produtoFinal) and (:filtrarCentroEstoque    <> 1 OR e.id_centro_estoque  between :centroEstoqueInicial AND :centroEstoqueFinal) " : " select distinct n.id_nota_propria                   as id_nota, n.serie                             as serie, n.numero_nota                       as numero_nota, n.data_emissao                      as data_emissao, n.data_entrada_saida                as data_entrada_saida from item_nota_propria               i inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao inner join produto                   p on p.id_produto             = i.id_produto inner join situacao_documento        s on s.id_situacao_documento  = n.id_situacao_documento inner join unidade_fat_cliente       u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente inner join cliente                   c on c.id_cliente             = u.id_cliente inner join pessoa                  pes on pes.id_pessoa            = c.id_pessoa inner join complemento              co on co.id_complemento        = pes.id_complemento left  join centro_estoque            e on e.id_centro_estoque      = i.id_centro_estoque inner join estoque_terceiros        et on et.id_item_nota_propria  = i.id_item_nota_propria inner join empresa                  ep on ep.id_emp                 = n.id_empresa where  nop.tipo_estoque              = 10 and (et.desativa_mov_terceiros       = 0 or et.desativa_mov_terceiros is null) and s.codigo                        <> '02' and s.codigo                        <> '03' and pes.id_pessoa                    = :idPessoa and ep.id_emp                        = :empresa and (:filtrarData                   <> 1 OR n.data_entrada_saida between :dataInicial          AND :dataFinal) and (:filtrarProduto                <> 1 OR p.id_produto         between :produtoInicial       AND :produtoFinal) and (:filtrarCentroEstoque          <> 1 OR e.id_centro_estoque  between :centroEstoqueInicial AND :centroEstoqueFinal) ";
        query = (String)query + "order by n.numero_nota, n.data_emissao";
        NativeQuery q = s.createSQLQuery((String)query);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setLong("empresa", empresa.longValue());
        q.setLong("idPessoa", (long)idPessoa.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensNotaMae(Integer idNota, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short tipoNota, Long empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = tipoNota == 0 ? "select distinct e.id_estoque_terceiros                  as id_est_terc, i.id_item_nota_terceiros                as id_item, p.id_produto                            as id_prod, p.nome                                  as nome_prod, i.quantidade_total                      as qtd_prod, (i.valor_unitario * i.quantidade_total) as valor_total, i.valor_unitario                        as valor_unitario, c.id_centro_estoque                     as id_centro_estoque from item_nota_terceiros                 i inner join natureza_operacao           nop on nop.id_natureza_operacao = i.id_natureza_operacao inner join produto                       p on p.id_produto             = i.id_produto inner join nota_terceiros                n on n.id_nota_terceiros      = i.id_nota_terceiros inner join estoque_terceiros             e on e.id_item_nota_terceiros = i.id_item_nota_terceiros left  join centro_estoque                c on c.id_centro_estoque      = i.id_centro_estoque inner join empresa                      ep on ep.id_emp                = n.id_empresa where (:filtrarProduto                  <> 1 OR p.id_produto between :produtoInicial and :produtoFinal) and (e.desativa_mov_terceiros            = 0 OR e.desativa_mov_terceiros is null) and n.id_nota_terceiros                  = :idNota and ep.id_emp                            = :empresa and nop.tipo_estoque                     = 8 " : "select distinct e.id_estoque_terceiros                  as id_est_terc, i.id_item_nota_propria                  as id_item, p.id_produto                            as id_prod, p.nome                                  as nome_prod, i.quantidade_total                      as qtd_prod, (i.valor_unitario * i.quantidade_total) as valor_total, i.valor_unitario                        as valor_unitario, c.id_centro_estoque                     as id_centro_estoque from item_nota_propria                   i inner join nota_propria                  n on n.id_nota_propria        = i.id_nota_fiscal_propria inner join natureza_operacao           nop on nop.id_natureza_operacao = n.id_natureza_operacao inner join produto                       p on p.id_produto             = i.id_produto inner join estoque_terceiros             e on e.id_item_nota_propria   = i.id_item_nota_propria left  join centro_estoque                c on c.id_centro_estoque      = i.id_centro_estoque inner join empresa                      ep on ep.id_emp                = n.id_empresa where (:filtrarProduto                  <> 1 OR p.id_produto between :produtoInicial and :produtoFinal) and (e.desativa_mov_terceiros            = 0 or e.desativa_mov_terceiros is null) and ep.id_emp                            = :empresa and n.id_nota_propria                    = :idNota and nop.tipo_estoque                     = 10 ";
        query = (String)query + "order by p.id_produto, p.nome";
        NativeQuery q = s.createSQLQuery((String)query);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setInteger("idNota", idNota.intValue());
        q.setLong("empresa", empresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensRetorno(Integer idItemMae, Short tipoNota, Long empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = tipoNota == 0 ? "select distinct e.id_estoque_terceiros                  as id_est_terc, i.quantidade_total                      as quantidade_retorno, (i.valor_unitario * i.quantidade_total) as valor_total_retorno, nt.data_emissao                         as data_emissao_retorno, nt.data_entrada_saida                   as data_entrada_saida_retorno, i.valor_unitario                        as valor_unitario_retorno, nt.serie                                as serie_nota_retorno, nt.numero_nota                          as numero_nota_retorno FROM item_nota_terceiros                 i  INNER JOIN nota_terceiros               nt ON nt.id_nota_terceiros     = i.id_nota_terceiros       INNER JOIN natureza_operacao           nop ON nop.id_natureza_operacao = i.id_natureza_operacao    INNER JOIN situacao_documento            s ON s.id_situacao_documento  = nt.id_situacao_documento  INNER JOIN estoque_terceiros             e on e.id_item_nota_terceiros = i.id_item_nota_terceiros  inner join empresa                      ep on ep.id_emp                = nt.id_empresa WHERE (nop.tipo_estoque                  = 9) and (e.desativa_mov_terceiros            = 0 or e.desativa_mov_terceiros is null) AND e.id_estoque_terc_mae                = :idEstTer and ep.id_emp                            = :empresa AND s.codigo                            <> '02' AND s.codigo                            <> '03' order by nt.numero_nota, nt.data_emissao " : " SELECT e.id_estoque_terceiros                 as id_est_terc, i.quantidade_total                     as quantidade_retorno, (i.valor_unitario * i.quantidade_total) as valor_total_retorno, np.data_emissao                        as data_emissao_retorno, np.data_entrada_saida                  as data_entrada_saida_retorno, i.valor_unitario                       as valor_unitario_retorno, np.serie                               as serie_nota_retorno, np.numero_nota                         as numero_nota_retorno FROM item_nota_propria                  i INNER JOIN nota_propria                np ON np.id_nota_propria       = i.id_nota_fiscal_propria INNER JOIN natureza_operacao          nop ON nop.id_natureza_operacao = np.id_natureza_operacao INNER JOIN situacao_documento           s ON s.id_situacao_documento  = np.id_situacao_documento INNER JOIN estoque_terceiros            e on e.id_item_nota_propria   = i.id_item_nota_propria inner join empresa                     ep on ep.id_emp                = np.id_empresa WHERE nop.tipo_estoque                  = 11 and (e.desativa_mov_terceiros           = 0 or e.desativa_mov_terceiros is null) AND e.id_estoque_terc_mae               = :idEstTer AND s.codigo                           <> '02' AND s.codigo                           <> '03' and ep.id_emp                           = :empresa order by np.numero_nota, np.data_emissao ";
        NativeQuery q = s.createSQLQuery(query);
        q.setInteger("idEstTer", idItemMae.intValue());
        q.setLong("empresa", empresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

