/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGeraLivroModelo3 {
    UtilGeraLivroModelo3() {
    }

    public JasperPrint gerarLivroModelo3(CoreRequestContext r) throws ExceptionService {
        Short filtrarData = (Short)r.getAttribute("filtrarData");
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Short filtrarProduto = (Short)r.getAttribute("filtrarProduto");
        Long idProdutoInicial = (Long)r.getAttribute("produtoInicial");
        Long idProdutoFinal = (Long)r.getAttribute("produtoFinal");
        Short filtrarCentroEstoque = (Short)r.getAttribute("filtrarCentroEstoque");
        Object[] centroEstoque = (Object[])r.getAttribute("centroEstoque");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Short tipoEstoque = (Short)r.getAttribute("tipoEstoque");
        Long tipoMovimento = (Long)r.getAttribute("tipoMovimento");
        Integer numInicialPagina = (Integer)r.getAttribute("numInicialPagina");
        Boolean exibirProdutosSemMovimentos = (Boolean)r.getAttribute("exibirProdutosSemMovimentos");
        Short movimentacao = (Short)r.getAttribute("movimentacao");
        GradeCor gradeCor = (GradeCor)r.getAttribute("gradeCor");
        Short exibirValoresMonetariosNotaFiscalTerceirosPropria = (Short)r.getAttribute("exibirValoresMonetariosNotaFiscalTerceirosPropria");
        Short exibirValoresMonetariosComunicadoProducao = (Short)r.getAttribute("exibirValoresMonetariosComunicadoProducao");
        Short exibirValoresMonetariosRequiscao = (Short)r.getAttribute("exibirValoresMonetariosRequiscao");
        ArrayList livroModelo3 = new ArrayList();
        livroModelo3.addAll(this.pesquisaMovNFTerceiros(filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarData, dataInicial, dataFinal, empresa.getIdentificador(), tipoEstoque, filtrarCentroEstoque, centroEstoque, tipoMovimento, gradeCor, movimentacao));
        livroModelo3.addAll(this.pesquisaMovNFPropria(filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarData, dataInicial, dataFinal, empresa.getIdentificador(), tipoEstoque, filtrarCentroEstoque, centroEstoque, tipoMovimento, gradeCor, movimentacao));
        if (tipoEstoque == 0) {
            livroModelo3.addAll(this.pesquisaMovImpSaldos(filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarData, dataInicial, dataFinal, empresa.getIdentificador(), filtrarCentroEstoque, centroEstoque, gradeCor));
            livroModelo3.addAll(this.pesquisaMovComProducao(filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarData, dataInicial, dataFinal, empresa.getIdentificador(), filtrarCentroEstoque, centroEstoque, gradeCor));
            livroModelo3.addAll(this.pesquisaMovRequisicao(filtrarProduto, idProdutoInicial, idProdutoFinal, filtrarData, dataInicial, dataFinal, empresa.getIdentificador(), filtrarCentroEstoque, centroEstoque, gradeCor));
        }
        if (filtrarData == 0) {
            dataInicial = DateUtil.strToDate("11/11/1111");
            dataFinal = DateUtil.strToDate("31/12/9999");
        }
        this.processaMovimentos(livroModelo3, dataInicial, tipoEstoque, filtrarProduto, idProdutoInicial, idProdutoFinal, empresa, dataFinal, tipoMovimento, exibirProdutosSemMovimentos, filtrarCentroEstoque, centroEstoque, movimentacao, gradeCor);
        HashMap<String, Comparable<Short>> parametros = new HashMap<String, Comparable<Short>>();
        parametros.put("FILTRAR_DATA", filtrarData);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("PRODUTO_INICIAL", idProdutoInicial);
        parametros.put("PRODUTO_FINAL", idProdutoFinal);
        parametros.put("TIPO_ESTOQUE", tipoEstoque);
        parametros.put("NUM_INICIAL_PAGINA", numInicialPagina);
        parametros.put("EXIBIR_VALORES_MONETARIOS_NOTA_FISCAL_TERCEIROS_PROPRIA", exibirValoresMonetariosNotaFiscalTerceirosPropria);
        parametros.put("EXIBIR_VALORES_MONETARIOS_COMUNICADO_PRODUCAO", exibirValoresMonetariosComunicadoProducao);
        parametros.put("EXIBIR_VALORES_MONETARIOS_REQUISICAO", exibirValoresMonetariosRequiscao);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "suprimentos" + File.separator + "gestaoestoque" + File.separator + "listagens" + File.separator + "livromodelo3" + File.separator + "BEANS_LISTAGEM_LIVRO_MODELO_3.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", livroModelo3);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private Collection pesquisaMovNFTerceiros(Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarData, Date dataInicial, Date dataFinal, Long idEmpresa, Short tipoEstoque, Short filtrarCentroEstoque, Object[] centroEstoque, Long tipoMovimento, GradeCor gradeCor, Short movimentacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "";
        hql = " SELECT pr.identificador                                  AS ID_PRO, e.identificador                                     AS ID_EMP, pe.nome                                             AS CAMPO1, c.cnpj                                              AS CAMPO2, c.inscEst                                           AS CAMPO3, pr.nome                                             AS CAMPO5, u.sigla                                             AS CAMPO6, n.codigo                                            AS CAMPO7, 'NF'                                                AS CAMPO9, nt.serie                                            AS CAMPO10, CAST(nt.numeroNota as int)                          AS CAMPO11, nt.dataEntrada                                      AS CAMPO12, p.codigo                                            AS CAMPO13, cf.codigo                                           AS CAMPO14, 0                                                   AS CAMPO15, CAST(cf.cfopIndustrializacao AS int)                AS CAMPO16, sum(gp.quantidade * i.fatorConversao)               AS CAMPO17, (CASE WHEN :movimentacao = 0 THEN sum(CAST(gp.quantidade As double) * CAST(gp.valorCusto As double)) ELSE sum(gp.quantidade * i.valorUnitario) END) AS CAMPO18, sum(item.vrIpiComercio + item.vrIpiIndustria)       AS CAMPO19, i.naturezaOperacao.tipoEstoque                      AS tipoEstoque, i.naturezaOperacao.tipoMovimento.identificador      AS tipoMovimento FROM ItemNotaTerceiros                              i";
        if (tipoEstoque != 0) {
            hql = (String)hql + " INNER JOIN i.grade                gg  Inner Join gg.estoqueTerceiros et";
        }
        hql = (String)hql + " INNER JOIN i.notaFiscalTerceiros                       nt INNER JOIN i.grade                                  gp INNER JOIN nt.empresa                               e INNER JOIN e.pessoa                                 pe INNER JOIN pe.complemento                           c INNER JOIN i.produto                                pr INNER JOIN pr.unidadeMedida                         u INNER JOIN pr.ncm                                   n INNER JOIN i.itemNotaLivroFiscal                    item INNER JOIN item.cfop                                cf INNER JOIN i.centroEstoque                          cenEst LEFT JOIN i.planoContaDeb                           p WHERE (:filtrarData <> 1 OR nt.dataEntrada BETWEEN :dataInicial AND :dataFinal) AND (pr.tipoIemSped.codigo = '00' OR  pr.tipoIemSped.codigo = '01' OR  pr.tipoIemSped.codigo = '02' OR  pr.tipoIemSped.codigo = '03' OR  pr.tipoIemSped.codigo = '04' OR  pr.tipoIemSped.codigo = '05' OR  pr.tipoIemSped.codigo = '06' OR  pr.tipoIemSped.codigo = '10') AND (:filtrarCentroEstoque <> 1 or cenEst.identificador in (:centroEstoque))  AND (:filtrarProduto <> 1 OR pr.identificador BETWEEN :produtoInicial AND :produtoFinal) AND e.identificador = :idEmpresa ";
        if (gradeCor != null) {
            hql = (String)hql + " AND gp.gradeCor = :gradeCor ";
        }
        hql = tipoEstoque == 0 ? (String)hql + " AND gp.movimentacaoFisica = 1" : (tipoEstoque == 1 ? (String)hql + " AND (i.naturezaOperacao.tipoEstoque = 2 OR i.naturezaOperacao.tipoEstoque = 4)  AND (et.desativaMovTerceiros is null or et.desativaMovTerceiros = 0)  AND (et.naturezaOperacao.tipoMovimento.identificador = :idTipoMovimento)" : (String)hql + " AND (i.naturezaOperacao.tipoEstoque = 6 OR i.naturezaOperacao.tipoEstoque = 1 OR i.naturezaOperacao.tipoEstoque = 5)  AND (et.desativaMovTerceiros is null or et.desativaMovTerceiros = 0)  AND (et.naturezaOperacao.tipoMovimento.identificador = :idTipoMovimento)");
        hql = (String)hql + " group by pr.identificador, e.identificador, pe.nome, c.cnpj, c.inscEst, pr.nome, u.sigla, n.codigo, 'NF', nt.serie, nt.numeroNota, nt.dataEntrada, p.codigo, cf.codigo, 2, cf.cfopIndustrializacao, i.vrProduto, item.vrIpiComercio, item.vrIpiIndustria, i.naturezaOperacao.tipoEstoque, i.naturezaOperacao.tipoMovimento.identificador";
        Query q = s.createQuery((String)hql);
        q.setShort("movimentacao", movimentacao.shortValue());
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setParameterList("centroEstoque", centroEstoque);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (tipoEstoque != 0) {
            q.setLong("idTipoMovimento", tipoMovimento.longValue());
        }
        if (gradeCor != null) {
            q.setEntity("gradeCor", (Object)gradeCor);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List movimentosTerceiros = this.processaCampo16(q.list());
        return movimentosTerceiros;
    }

    private Collection pesquisaMovImpSaldos(Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarData, Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarCentroEstoque, Object[] centroEstoque, GradeCor gradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT item.produto.identificador      AS ID_PRO, i.empresa.identificador                             AS ID_EMP, i.empresa.pessoa.nome                               AS CAMPO1, i.empresa.pessoa.complemento.cnpj                   AS CAMPO2, i.empresa.pessoa.complemento.inscEst                AS CAMPO3, item.produto.nome                                   AS CAMPO5, item.produto.unidadeMedida.sigla                    AS CAMPO6, item.produto.ncm.codigo                             AS CAMPO7, 'IMP'                                               AS CAMPO9, CAST(i.identificador AS int)                        AS CAMPO11, i.dataEntradaSaida                                  AS CAMPO12, item.produto.planoConta.codigo                      AS CAMPO13, CAST(sum(0) as int)                                 AS CAMPO15, 3                                                   AS CAMPO16, item.quantidadeTotal                                AS CAMPO17, sum(cast(grade.valorUnitario as double ) * cast(grade.quantidade as double))     AS CAMPO18, CAST(sum(0) AS double)                                   AS CAMPO19 FROM ItemImplantaSaldo                              item INNER JOIN item.implantacaoSaldos                   i INNER JOIN item.centroEstoque                       cenEst INNER JOIN item.gradeItem                           grade WHERE (:filtrarData        <> 1 OR i.dataEntradaSaida   BETWEEN :dataInicial            AND :dataFinal) AND (:filtrarCentroEstoque <> 1 or cenEst.identificador in (:centroEstoque))  AND (item.produto.tipoIemSped.codigo = '00' OR  item.produto.tipoIemSped.codigo = '01' OR  item.produto.tipoIemSped.codigo = '02' OR  item.produto.tipoIemSped.codigo = '03' OR  item.produto.tipoIemSped.codigo = '04' OR  item.produto.tipoIemSped.codigo = '05' OR  item.produto.tipoIemSped.codigo = '06' OR  item.produto.tipoIemSped.codigo = '10') AND (:filtrarProduto <> 1 OR item.produto.identificador BETWEEN :produtoInicial AND :produtoFinal) AND i.empresa.identificador = :idEmpresa ";
        if (gradeCor != null) {
            hql = (String)hql + " AND grade.gradeCor = :gradeCor ";
        }
        hql = (String)hql + " GROUP BY item.produto.identificador, i.empresa.identificador, i.empresa.pessoa.nome, i.empresa.pessoa.complemento.cnpj, i.empresa.pessoa.complemento.inscEst, item.produto.nome, item.produto.unidadeMedida.sigla, item.produto.ncm.codigo, 'IMP', CAST(i.identificador AS int), i.dataEntradaSaida, item.produto.planoConta.codigo, 3, item.quantidadeTotal, grade.valorUnitario";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setParameterList("centroEstoque", centroEstoque);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (gradeCor != null) {
            q.setEntity("gradeCor", (Object)gradeCor);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection pesquisaMovComProducao(Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarData, Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarCentroEstoque, Object[] centroEstoque, GradeCor gradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT c.empresa.identificador         AS ID_EMP, item.produto.identificador                          AS ID_PRO,   c.empresa.pessoa.nome                               AS CAMPO1,   c.empresa.pessoa.complemento.cnpj                   AS CAMPO2,   c.empresa.pessoa.complemento.inscEst                AS CAMPO3,   item.produto.nome                                   AS CAMPO5,   item.produto.unidadeMedida.sigla                    AS CAMPO6,   item.produto.ncm.codigo                             AS CAMPO7,   'CP'                                                AS CAMPO9,   CAST(c.identificador AS int)                        AS CAMPO11,  c.dataEntradaSaida                                  AS CAMPO12,  cast (sum(0) as int)                                AS CAMPO15,  1                                                   AS CAMPO16,  sum(item.quantidadeTotal)                           AS CAMPO17,  sum(grade.valorUnitario)                            AS CAMPO18,  cast (sum(0) as double)                             AS CAMPO19   FROM ItemComunicadoProducao                         item  INNER JOIN item.comunicadoProducao                  c  INNER JOIN item.centroEstoque                       cenEst INNER JOIN item.gradeItemComunicadoProducao         grade WHERE (:filtrarData        <> 1 OR c.dataEntradaSaida   BETWEEN :dataInicial            AND :dataFinal) AND (:filtrarCentroEstoque <> 1 or cenEst.identificador in (:centroEstoque))  AND (item.produto.tipoIemSped.codigo = '00' OR  item.produto.tipoIemSped.codigo = '01' OR  item.produto.tipoIemSped.codigo = '02' OR  item.produto.tipoIemSped.codigo = '03' OR  item.produto.tipoIemSped.codigo = '04' OR  item.produto.tipoIemSped.codigo = '05' OR  item.produto.tipoIemSped.codigo = '06' OR  item.produto.tipoIemSped.codigo = '10') AND (:filtrarProduto <> 1 OR item.produto.identificador BETWEEN :produtoInicial AND :produtoFinal) AND c.empresa.identificador = :idEmpresa ";
        if (gradeCor != null) {
            hql = (String)hql + " AND grade.gradeCor = :gradeCor ";
        }
        hql = (String)hql + " GROUP BY   c.empresa.identificador, item.produto.identificador, c.empresa.pessoa.nome, c.empresa.pessoa.complemento.cnpj, c.empresa.pessoa.complemento.inscEst, item.produto.nome, item.produto.unidadeMedida.sigla, item.produto.ncm.codigo, 'CP', c.identificador, c.dataEntradaSaida, 1";
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setParameterList("centroEstoque", centroEstoque);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (gradeCor != null) {
            q.setEntity("gradeCor", (Object)gradeCor);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection pesquisaMovNFPropria(Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarData, Date dataInicial, Date dataFinal, Long idEmpresa, Short tipoEstoque, Short filtrarCentroEstoque, Object[] centroEstoque, Long tipoMovimento, GradeCor gradeCor, Short movimentacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " SELECT pr.identificador                          AS ID_PRO,  e.identificador                                     AS ID_EMP, pe.nome                                             AS CAMPO1, c.cnpj                                              AS CAMPO2, c.inscEst                                           AS CAMPO3, pr.nome                                             AS CAMPO5, u.sigla                                             AS CAMPO6, nc.codigo                                           AS CAMPO7, 'NF'                                                AS CAMPO9, np.serie                                            AS CAMPO10, CAST(np.numeroNota AS int)                          AS CAMPO11, np.dataEmissaoNota                                  AS CAMPO12, pl.codigo                                           AS CAMPO13, cf.codigo                                           AS CAMPO14, CAST(cf.cfopDevolucaoVenda AS int)                  AS CFOP_DEV, CAST(nat.entradaSaida AS int)                       AS CAMPO15, 1                                                   AS CAMPO16, sum(gp.quantidade * i.fatorConversao)               AS CAMPO17, (CASE WHEN :movimentacao = 0 THEN sum(gp.quantidade * gp.valorCusto) ELSE sum(gp.quantidade * i.valorUnitario) END) AS CAMPO18,  sum(item.vrIpiComercio + item.vrIpiIndustria)       AS CAMPO19, nat.tipoEstoque                                     AS tipoEstoque, nat.tipoMovimento.identificador                     AS tipoMovimento, i.identificador   FROM ItemNotaFiscalPropria                          i";
        if (tipoEstoque != 0) {
            hql = (String)hql + " INNER JOIN i.gradesNotaFiscalPropria gfp Inner Join gfp.estoqueTerceiros                      et ";
        }
        hql = (String)hql + " INNER JOIN i.notaFiscalPropria                         np INNER JOIN i.gradesNotaFiscalPropria                gp INNER JOIN i.produto                                pr INNER JOIN np.empresa                               e INNER JOIN e.pessoa                                 pe INNER JOIN pe.complemento                           c INNER JOIN pr.unidadeMedida                         u INNER JOIN pr.ncm                                   nc INNER JOIN i.itemNotaLivroFiscal                    item INNER JOIN item.cfop                                cf INNER JOIN np.naturezaOperacao                      nat INNER JOIN i.centroEstoque                          cenEst LEFT JOIN i.planoContaCred                          pl WHERE (:filtrarData <> 1 OR np.dataEmissaoNota BETWEEN :dataInicial AND :dataFinal)  AND np.status <> 101  AND (pr.tipoIemSped.codigo = '00' OR  pr.tipoIemSped.codigo = '01' OR  pr.tipoIemSped.codigo = '02' OR  pr.tipoIemSped.codigo = '03' OR  pr.tipoIemSped.codigo = '04' OR  pr.tipoIemSped.codigo = '05' OR  pr.tipoIemSped.codigo = '06' OR  pr.tipoIemSped.codigo = '10') AND (:filtrarProduto       <> 1 OR pr.identificador     BETWEEN :produtoInicial         AND :produtoFinal)  AND (:filtrarCentroEstoque <> 1 OR cenEst.identificador in (:centroEstoque))  AND e.identificador = :idEmpresa ";
        if (gradeCor != null) {
            hql = (String)hql + " AND gp.gradeCor = :gradeCor ";
        }
        hql = tipoEstoque == 0 ? (String)hql + " AND gp.movimentacaoFisica = 1 " : (tipoEstoque == 1 ? (String)hql + " AND (np.naturezaOperacao.tipoEstoque = 2 OR np.naturezaOperacao.tipoEstoque = 4)  AND (et.desativaMovTerceiros is null or et.desativaMovTerceiros = 0)  AND (et.naturezaOperacao.tipoMovimento.identificador = :idTipoMovimento)" : (String)hql + " AND (np.naturezaOperacao.tipoEstoque = 6 OR np.naturezaOperacao.tipoEstoque = 1 OR np.naturezaOperacao.tipoEstoque = 5)  AND (et.desativaMovTerceiros is null or et.desativaMovTerceiros = 0)  AND (et.naturezaOperacao.tipoMovimento.identificador = :idTipoMovimento)");
        hql = (String)hql + " group by  pr.identificador, e.identificador, pe.nome, c.cnpj, c.inscEst, pr.nome, u.sigla, nc.codigo, 'NF', np.serie, np.numeroNota, np.dataEmissaoNota, pl.codigo, cf.codigo, cf.cfopDevolucaoVenda,   nat.entradaSaida, 1, i.vrProduto, item.vrIpiComercio, item.vrIpiIndustria, nat.tipoEstoque, nat.tipoMovimento.identificador, i.identificador";
        Query q = s.createQuery((String)hql);
        q.setShort("movimentacao", movimentacao.shortValue());
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setParameterList("centroEstoque", centroEstoque);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (tipoEstoque != 0) {
            q.setLong("idTipoMovimento", tipoMovimento.longValue());
        }
        if (gradeCor != null) {
            q.setEntity("gradeCor", (Object)gradeCor);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List data = q.list();
        this.trocaFatEntradaEntrada(data);
        return data;
    }

    private Collection pesquisaMovRequisicao(Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarData, Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarCentroEstoque, Object[] centroEstoque, GradeCor gradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select item.produto.identificador      AS ID_PRO,   r.empresa.identificador                             AS ID_EMP,   r.empresa.pessoa.nome                               AS CAMPO1,   r.empresa.pessoa.complemento.cnpj                   AS CAMPO2,   r.empresa.pessoa.complemento.inscEst                AS CAMPO3,   item.produto.nome                                   AS CAMPO5,   item.produto.unidadeMedida.sigla                    AS CAMPO6,   item.produto.ncm.codigo                             AS CAMPO7,   'REQ'                                               AS CAMPO9,   CAST(r.identificador AS int)                        AS CAMPO11,  r.dataRequisicao                                    AS CAMPO12,  item.produto.planoConta.codigo                      AS CAMPO13,  1                                                   AS CAMPO15,  1                                                   AS CAMPO16,  item.quantidadeTotal                                AS CAMPO17,  cast(0 AS double)                                   AS CAMPO19   from ItemRequisicao                                        item  inner join item.requisicao                                    r  INNER JOIN item.centroEstoque                                cenEst INNER JOIN item.gradeItemRequisicao                          grade where (:filtrarData <> 1 OR r.dataRequisicao BETWEEN :dataInicial AND :dataFinal) AND (item.produto.tipoIemSped.codigo = '00' OR  item.produto.tipoIemSped.codigo  = '01' OR  item.produto.tipoIemSped.codigo  = '02' OR  item.produto.tipoIemSped.codigo  = '03' OR  item.produto.tipoIemSped.codigo  = '04' OR  item.produto.tipoIemSped.codigo  = '05' OR  item.produto.tipoIemSped.codigo  = '06' OR  item.produto.tipoIemSped.codigo  = '10') AND (:filtrarProduto       <> 1 OR item.produto.identificador BETWEEN :produtoInicial         AND :produtoFinal) AND (:filtrarCentroEstoque <> 1 OR cenEst.identificador       in (:centroEstoque))  AND r.empresa.identificador = :idEmpresa ";
        if (gradeCor != null) {
            hql = (String)hql + " AND grade.gradeCor = :gradeCor ";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setParameterList("centroEstoque", centroEstoque);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (gradeCor != null) {
            q.setEntity("gradeCor", (Object)gradeCor);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void processaMovimentos(List livroModelo3, Date dataInicial, Short tipoEstoque, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Empresa empresa, Date dataFinal, Long tipoMovimento, Boolean exibirProdutosSemMovimentos, Short filtrarCentroEstoque, Object[] centroEstoque, Short movimentacao, GradeCor gradeCor) throws ExceptionService {
        this.getListaOrdenada(livroModelo3);
        Date dataSaldoInicial = DateUtil.previousDays(dataInicial, 1);
        List<SaldoEstoqueGeralBasico> saldosAnteriores = new ArrayList<SaldoEstoqueGeralBasico>();
        if (tipoEstoque == 0) {
            Produto produtoInicial = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOProduto(), idProdutoInicial);
            Produto produtoFinal = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOProduto(), idProdutoFinal);
            saldosAnteriores = this.findSaldoProdutoLivroModelo3(produtoInicial, produtoFinal, dataSaldoInicial, empresa, filtrarCentroEstoque, centroEstoque, gradeCor);
        }
        if (movimentacao == 0) {
            this.processarMovimentosValorCusto(livroModelo3, saldosAnteriores, tipoEstoque, dataSaldoInicial, tipoMovimento);
        } else {
            this.processarMovimentosValorNota(livroModelo3, saldosAnteriores, tipoEstoque, dataSaldoInicial, tipoMovimento);
        }
        if (exibirProdutosSemMovimentos.booleanValue()) {
            ArrayList<Produto> produtosSemMovimentos = new ArrayList<Produto>();
            List produtos = filtrarProduto.equals((short)1) ? this.getProdutos(idProdutoInicial, idProdutoFinal) : (List)CoreService.simpleFindAll(CoreDAOFactory.getInstance().getDAOProduto());
            Boolean isEquals = false;
            for (Object p : produtos) {
                Produto produto = (Produto)p;
                for (Object o : livroModelo3) {
                    HashMap map = (HashMap)o;
                    Long idProd = (Long)map.get("ID_PRO");
                    if (!produto.getIdentificador().equals(idProd)) continue;
                    isEquals = true;
                }
                if (!isEquals.booleanValue() && this.produtoIsValid(produto)) {
                    produtosSemMovimentos.add(produto);
                }
                isEquals = false;
            }
            Date dataSaldoAnterior = DateUtil.previousDays(dataInicial, 1);
            for (Object e : produtosSemMovimentos) {
                Serializable campo8;
                Produto produto = (Produto)e;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("ID_PRO", produto.getIdentificador());
                map.put("CAMPO1", empresa.getPessoa().getNome());
                map.put("CAMPO2", empresa.getPessoa().getComplemento().getCnpj());
                map.put("CAMPO3", empresa.getPessoa().getComplemento().getInscEst());
                map.put("CAMPO5", produto.getNome());
                if (produto.getUnidadeMedida() != null) {
                    map.put("CAMPO6", produto.getUnidadeMedida().getSigla());
                } else {
                    map.put("CAMPO6", "");
                }
                if (produto.getNcm() != null) {
                    map.put("CAMPO7", produto.getNcm().getCodigo());
                } else {
                    map.put("CAMPO7", "");
                }
                if (tipoEstoque == 0) {
                    campo8 = this.findSaldoProdutoLivroModelo3(produto, dataSaldoAnterior, empresa, filtrarCentroEstoque, centroEstoque, gradeCor);
                    System.out.println("Id. Produto: " + produto.getIdentificador());
                    if (campo8 != null) {
                        map.put("CAMPO8", ((HashMap)campo8).get("CAMPO8") != null ? (Double)((HashMap)campo8).get("CAMPO8") : 0.0);
                    } else {
                        map.put("CAMPO8", 0.0);
                    }
                } else {
                    campo8 = CoreDAOFactory.getInstance().getDAOSaldoEstoqueTerceiros().findaSaldoTerceirosAnteriorByProduto(tipoEstoque == 1 ? 2 : 6, dataSaldoAnterior, empresa.getIdentificador(), tipoMovimento, produto.getIdentificador());
                    map.put("CAMPO8", campo8 != null ? (Double)campo8 : 0.0);
                }
                if ((campo8 = (Double)map.get("CAMPO8")) == null || !((Double)campo8 > 0.0)) continue;
                livroModelo3.add(map);
            }
        }
    }

    private Collection getListaOrdenada(List movimentos) {
        if (movimentos != null) {
            Collections.sort(movimentos, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap hash = (HashMap)o1;
                    HashMap hash2 = (HashMap)o2;
                    Long idProuduto1 = (Long)hash.get("ID_PRO");
                    Long idProuduto2 = (Long)hash2.get("ID_PRO");
                    Date data1 = (Date)hash.get("CAMPO12");
                    Date data2 = (Date)hash2.get("CAMPO12");
                    Integer entSai1 = (Integer)hash.get("CAMPO15");
                    Integer entSai2 = (Integer)hash2.get("CAMPO15");
                    if (idProuduto1.equals(idProuduto2)) {
                        if (data1.equals(data2)) {
                            return entSai1.compareTo(entSai2);
                        }
                        return data1.compareTo(data2);
                    }
                    return idProuduto1.compareTo(idProuduto2);
                }
            });
            return movimentos;
        }
        return null;
    }

    private List processaCampo16(List movimentosTerceiros) {
        for (Object o : movimentosTerceiros) {
            HashMap map = (HashMap)o;
            Integer campo16 = (Integer)map.get("CAMPO16");
            if (campo16 != null) {
                campo16 = campo16 == 1 ? 2 : 3;
                map.put("CAMPO16", campo16);
                continue;
            }
            campo16 = 3;
            map.put("CAMPO16", campo16);
        }
        return movimentosTerceiros;
    }

    private List getProdutos(Long idProdutoInicial, Long idProdutoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select p  from Produto p where p.identificador between :produtoInicial and :produtoFinal");
        q.setLong("produtoInicial", idProdutoInicial.longValue());
        q.setLong("produtoFinal", idProdutoFinal.longValue());
        return q.list();
    }

    private boolean produtoIsValid(Produto produto) {
        String codigoItemSped;
        List<String> codigosAceitos = Arrays.asList("00", "01", "02", "03", "04", "05", "06", "10");
        return codigosAceitos.contains(codigoItemSped = produto.getTipoIemSped().getCodigo());
    }

    private void trocaFatEntradaEntrada(List data) {
        for (Object o : data) {
            HashMap h = (HashMap)o;
            Integer entSai = (Integer)h.get("CAMPO15");
            if (entSai != 2) continue;
            h.put("CAMPO15", 0);
        }
    }

    private void processarMovimentosValorCusto(List livroModelo3, List<SaldoEstoqueGeralBasico> saldosAnteriores, Short tipoEstoque, Date dataSaldoInicial, Long tipoMovimento) {
        Double saldoQtdAnterior = 0.0;
        Double saldoVlrAnterior = 0.0;
        Long idProduto = null;
        for (Object o : livroModelo3) {
            Double valorMovimentacao;
            Double qtdParcial;
            HashMap map = (HashMap)o;
            if (idProduto == null || idProduto.longValue() != ((Long)map.get("ID_PRO")).longValue()) {
                idProduto = (Long)map.get("ID_PRO");
                saldoQtdAnterior = 0.0;
                saldoVlrAnterior = 0.0;
                if (tipoEstoque == 0) {
                    for (SaldoEstoqueGeralBasico s : saldosAnteriores) {
                        if (!s.getIdProduto().equals(idProduto)) continue;
                        map.put("CAMPO8", s.getQuantidade());
                        saldoQtdAnterior = s.getQuantidade();
                        saldoVlrAnterior = (Double)map.get("CAMPO18");
                        break;
                    }
                } else {
                    saldoQtdAnterior = CoreDAOFactory.getInstance().getDAOSaldoEstoqueTerceiros().findaSaldoTerceirosAnteriorByProduto(tipoEstoque == 1 ? 2 : 6, dataSaldoInicial, (Long)map.get("ID_EMP"), tipoMovimento, (Long)map.get("ID_PRO"));
                    map.put("CAMPO8", saldoQtdAnterior);
                }
            }
            saldoQtdAnterior = saldoQtdAnterior == null ? 0.0 : saldoQtdAnterior;
            saldoVlrAnterior = saldoVlrAnterior == null ? 0.0 : saldoVlrAnterior;
            if ((Integer)map.get("CAMPO15") == 1) {
                qtdParcial = (Double)map.get("CAMPO17");
                qtdParcial = qtdParcial == null ? 0.0 : qtdParcial;
                valorMovimentacao = (Double)map.get("CAMPO18");
                valorMovimentacao = valorMovimentacao == null ? 0.0 : valorMovimentacao;
                if (tipoEstoque == 0 || tipoEstoque == 1) {
                    valorMovimentacao = saldoVlrAnterior / saldoQtdAnterior * qtdParcial;
                    saldoVlrAnterior = saldoVlrAnterior - valorMovimentacao;
                    saldoQtdAnterior = saldoQtdAnterior - qtdParcial;
                } else if (tipoEstoque == 2) {
                    valorMovimentacao = saldoVlrAnterior / saldoQtdAnterior * qtdParcial;
                    saldoVlrAnterior = saldoVlrAnterior + valorMovimentacao;
                    saldoQtdAnterior = saldoQtdAnterior + qtdParcial;
                }
                map.put("CAMPO20", saldoQtdAnterior);
                map.put("CAMPO18", valorMovimentacao);
                continue;
            }
            qtdParcial = (Double)map.get("CAMPO17");
            qtdParcial = qtdParcial == null ? 0.0 : qtdParcial;
            valorMovimentacao = (Double)map.get("CAMPO18");
            valorMovimentacao = valorMovimentacao == null ? 0.0 : valorMovimentacao;
            if (tipoEstoque == 0 || tipoEstoque == 1) {
                saldoQtdAnterior = saldoQtdAnterior + qtdParcial;
                saldoVlrAnterior = saldoVlrAnterior + valorMovimentacao;
            } else if (tipoEstoque == 2) {
                saldoQtdAnterior = saldoQtdAnterior - qtdParcial;
                saldoVlrAnterior = saldoVlrAnterior - valorMovimentacao;
            }
            map.put("CAMPO20", saldoQtdAnterior);
            map.put("CAMPO18", valorMovimentacao);
        }
    }

    private void processarMovimentosValorNota(List livroModelo3, List<SaldoEstoqueGeralBasico> saldosAnteriores, Short tipoEstoque, Date dataSaldoInicial, Long tipoMovimento) {
        Double saldoQtdAnterior = 0.0;
        Double saldoVlrAnterior = 0.0;
        Long idProduto = null;
        for (Object o : livroModelo3) {
            Double valorMovimentacao;
            Double qtdParcial;
            HashMap map = (HashMap)o;
            if (idProduto == null || idProduto.longValue() != ((Long)map.get("ID_PRO")).longValue()) {
                idProduto = (Long)map.get("ID_PRO");
                saldoQtdAnterior = 0.0;
                saldoVlrAnterior = 0.0;
                if (tipoEstoque == 0) {
                    for (SaldoEstoqueGeralBasico s : saldosAnteriores) {
                        if (!s.getIdProduto().equals(idProduto)) continue;
                        map.put("CAMPO8", s.getQuantidade());
                        saldoQtdAnterior = s.getQuantidade();
                        saldoVlrAnterior = (Double)map.get("CAMPO18");
                        break;
                    }
                } else {
                    saldoQtdAnterior = CoreDAOFactory.getInstance().getDAOSaldoEstoqueTerceiros().findaSaldoTerceirosAnteriorByProduto(tipoEstoque == 1 ? 2 : 6, dataSaldoInicial, (Long)map.get("ID_EMP"), tipoMovimento, (Long)map.get("ID_PRO"));
                    map.put("CAMPO8", saldoQtdAnterior);
                }
            }
            saldoQtdAnterior = saldoQtdAnterior == null ? 0.0 : saldoQtdAnterior;
            saldoVlrAnterior = saldoVlrAnterior == null ? 0.0 : saldoVlrAnterior;
            if ((Integer)map.get("CAMPO15") == 1) {
                qtdParcial = (Double)map.get("CAMPO17");
                qtdParcial = qtdParcial == null ? 0.0 : qtdParcial;
                valorMovimentacao = (Double)map.get("CAMPO18");
                valorMovimentacao = valorMovimentacao == null ? 0.0 : valorMovimentacao;
                if (!((String)map.get("CAMPO9")).equals("NF")) {
                    valorMovimentacao = saldoVlrAnterior / saldoQtdAnterior * qtdParcial;
                }
                if (tipoEstoque == 0 || tipoEstoque == 1) {
                    saldoVlrAnterior = saldoVlrAnterior - valorMovimentacao;
                    saldoQtdAnterior = saldoQtdAnterior - qtdParcial;
                } else if (tipoEstoque == 2) {
                    saldoVlrAnterior = saldoVlrAnterior + valorMovimentacao;
                    saldoQtdAnterior = saldoQtdAnterior + qtdParcial;
                }
                map.put("CAMPO20", saldoQtdAnterior);
                map.put("CAMPO18", valorMovimentacao);
                continue;
            }
            qtdParcial = (Double)map.get("CAMPO17");
            qtdParcial = qtdParcial == null ? 0.0 : qtdParcial;
            valorMovimentacao = (Double)map.get("CAMPO18");
            valorMovimentacao = valorMovimentacao == null ? 0.0 : valorMovimentacao;
            if (tipoEstoque == 0 || tipoEstoque == 1) {
                saldoQtdAnterior = saldoQtdAnterior + qtdParcial;
                saldoVlrAnterior = saldoVlrAnterior + valorMovimentacao;
            } else if (tipoEstoque == 2) {
                saldoQtdAnterior = saldoQtdAnterior - qtdParcial;
                saldoVlrAnterior = saldoVlrAnterior - valorMovimentacao;
            }
            map.put("CAMPO20", saldoQtdAnterior);
            map.put("CAMPO18", valorMovimentacao);
        }
    }

    private HashMap findSaldoProdutoLivroModelo3(Produto produto, Date dataIn, Empresa empresa, Short filtrarCentroEstoque, Object[] centroEstoque, GradeCor gradeCor) throws ExceptionService {
        if (dataIn == null) {
            dataIn = new Date();
        }
        HashMap<String, Double> h = new HashMap<String, Double>();
        Long idCentroInicial = 0L;
        Long idCentroFinal = 9999999L;
        Object lista = null;
        Double valorMedio = 0.0;
        Double quantidade = 0.0;
        if (filtrarCentroEstoque.equals((short)1)) {
            for (Object object : centroEstoque) {
                Long idCentroEstoque = (Long)object;
                CentroEstoque centroEst = (CentroEstoque)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCentroEstoque(), idCentroEstoque);
                SaldoEstoqueGeralBasico s = SaldoEstoqueUtilities.findSaldoGradeCorCentroEstoqueBasico(produto, gradeCor, dataIn, centroEst, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
                if (s == null) continue;
                valorMedio = valorMedio + s.getValorMedio();
                quantidade = quantidade + s.getQuantidade();
            }
            h.put("CAMPO8", quantidade);
            h.put("CAMPO18", valorMedio);
        } else {
            List<SaldoEstoqueGeralBasico> saldos = SaldoEstoqueUtilities.findSaldoGradeCorCentroEstoqueListaBasico(produto, produto, gradeCor, gradeCor, dataIn, null, null, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
            if (saldos != null) {
                Double qtde = 0.0;
                Double valor = 0.0;
                for (SaldoEstoqueGeralBasico s : saldos) {
                    qtde = qtde + s.getQuantidade();
                    valor = valor + s.getValorMedio();
                }
                h.put("CAMPO8", qtde);
                h.put("CAMPO18", valor);
            }
        }
        return h;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoLivroModelo3(Produto produtoInicial, Produto produtoFinal, Date dataIn, Empresa empresa, Short filtrarCentroEstoque, Object[] centroEstoque, GradeCor gradeCor) throws ExceptionService {
        if (dataIn == null) {
            dataIn = new Date();
        }
        Long idCentroInicial = 0L;
        Long idCentroFinal = 9999999L;
        Object lista = null;
        ArrayList<SaldoEstoqueGeralBasico> todosSaldos = new ArrayList<SaldoEstoqueGeralBasico>();
        if (filtrarCentroEstoque.equals((short)1)) {
            for (Object object : centroEstoque) {
                Long idCentroEstoque = (Long)object;
                CentroEstoque centroEst = (CentroEstoque)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCentroEstoque(), idCentroEstoque);
                SaldoEstoqueGeralBasico s = SaldoEstoqueUtilities.findSaldoGradeCorCentroEstoqueBasico(produtoInicial, gradeCor, dataIn, centroEst, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
                if (s == null) continue;
                boolean achou = false;
                for (Object e : todosSaldos) {
                    SaldoEstoqueGeralBasico ss = (SaldoEstoqueGeralBasico)e;
                    if (!ss.getIdProduto().equals(s.getIdProduto())) continue;
                    ss.setQuantidade(Double.valueOf(ss.getQuantidade() + s.getQuantidade()));
                    achou = true;
                }
                if (achou) continue;
                todosSaldos.add(s);
            }
            return todosSaldos;
        }
        List<SaldoEstoqueGeralBasico> saldos = SaldoEstoqueUtilities.findSaldoGradeCorCentroEstoqueListaBasico(produtoInicial, produtoFinal, gradeCor, gradeCor, dataIn, null, null, empresa, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        if (saldos != null) {
            todosSaldos.addAll(saldos);
            return todosSaldos;
        }
        return new ArrayList<SaldoEstoqueGeralBasico>();
    }
}

