/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensestoque;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeraRazaoAnaliticaEstoqueTerceiros {
    public JasperPrint gerarListagemRazaoAnaliticoEstoqueTerceiros(CoreRequestContext r) throws ExceptionService {
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "estoque" + File.separator + "relatorios" + File.separator;
        Long idTipoMovimento = (Long)r.getAttribute("idTipoMovimento");
        String descricaoTipoMovimento = (String)r.getAttribute("descricaoTipoMovimento");
        Short filtrarPessoa = (Short)r.getAttribute("filtrarPessoa");
        Long pessoaInicial = (Long)r.getAttribute("pessoaInicial");
        Long pessoaFinal = (Long)r.getAttribute("pessoaFinal");
        Long idEmp = (Long)r.getAttribute("idEmp");
        Short filtrarProduto = (Short)r.getAttribute("filtrarProduto");
        Long produtoInicial = (Long)r.getAttribute("produtoInicial");
        Long produtoFinal = (Long)r.getAttribute("produtoFinal");
        Short filtrarCentroEstoque = (Short)r.getAttribute("filtrarCentroEstoque");
        Long centroEstoqueInicial = (Long)r.getAttribute("centroEstoqueInicial");
        Long centroEstoqueFinal = (Long)r.getAttribute("centroEstoqueFinal");
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Short tipoEstoque = (Short)r.getAttribute("tipoEstoque");
        HashMap parametros = (HashMap)r.getAttribute("defaultParams");
        parametros.put("ID_TIPO_MOVIMENTO", idTipoMovimento);
        parametros.put("DESCRICAO_TIPO_MOVIMENTO", descricaoTipoMovimento);
        parametros.put("FILTRAR_PESSOA", filtrarPessoa);
        parametros.put("PESSOA_INICIAL", pessoaInicial);
        parametros.put("PESSOA_FINAL", pessoaFinal);
        parametros.put("FILTRAR_PRODUTO", filtrarProduto);
        parametros.put("PRODUTO_INICIAL", produtoInicial);
        parametros.put("PRODUTO_FINAL", produtoFinal);
        parametros.put("FILTRAR_CENTRO_ESTOQUE", filtrarCentroEstoque);
        parametros.put("CENTRO_ESTOQUE_INICIAL", centroEstoqueInicial);
        parametros.put("CENTRO_ESTOQUE_FINAL", centroEstoqueFinal);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("TIPO_ESTOQUE", tipoEstoque);
        parametros.put("PATH", path);
        Object jasperPrint = null;
        List razaoTercCompleto = null;
        if (tipoEstoque == 2) {
            fornecedores = this.findFornecedoresTipoEstoque((short)4, dataInicial, dataFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            razaoTercCompleto = this.findNotasTipoEstoque((short)2, (short)4, fornecedores, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
        } else if (tipoEstoque == 11) {
            fornecedores = this.findFornecedoresTipoEstoque((short)10, dataInicial, dataFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            razaoTercCompleto = this.findNotasTipoEstoque((short)11, (short)10, fornecedores, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
        } else if (tipoEstoque == 9) {
            fornecedores = this.findFornecedoresTipoEstoque((short)8, dataInicial, dataFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            razaoTercCompleto = this.findNotasTipoEstoque((short)9, (short)8, fornecedores, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
        } else if (tipoEstoque == 6) {
            fornecedores = this.findFornecedoresTipoEstoque6(dataInicial, dataFinal, filtrarPessoa, pessoaInicial, pessoaFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            razaoTercCompleto = this.findNotasTipoEstoque6(fornecedores, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
        }
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", (String)path + "RAZAO_ANALITICO_TERCEIROS.jasper");
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", razaoTercCompleto);
        jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List findFornecedoresTipoEstoque(short tipoEstoque, Date dataInicial, Date dataFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select  distinct              pes.id_pessoa      as id_pessoa  ,              pes.nome           as nome_pessoa,              c.cnpj             as cnpj_pessoa         from item_nota_terceiros       i  inner join grade_item_nota_terceiros g on g.id_item_nota_terceiros = i.id_item_nota_terceiros inner join natureza_operacao       nop on nop.id_natureza_operacao  = i.id_natureza_operacao  inner join produto                   p on p.id_produto              = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros       = i.id_nota_terceiros  inner join situacao_documento        s on s.id_situacao_documento   = n.id_situacao_documento  inner join unidade_fat_forn          u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn  inner join fornecedor                f on f.id_fornecedor           = u.id_fornecedor  inner join pessoa                  pes on pes.id_pessoa             = f.id_pessoa  inner join complemento               c on c.id_complemento          = pes.id_complemento  left  join centro_estoque            e on e.id_centro_estoque       = i.id_centro_estoque  inner join estoque_terceiros        et on et.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  inner join empresa                  ep on ep.id_emp                 = n.id_empresa  where      nop.tipo_estoque        =   :tipo_estoque   and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'  and s.codigo               <> '03'  and ep.id_emp             = :idEmp         and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)  and (:filtrarPessoa        <> 1 OR pes.id_pessoa       between :pessoaInicial  AND :pessoaFinal )  and n.data_entrada_saida                               between :dataInicial    AND :dataFinal  and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)  and nop.id_tipo_movimento = :tipoMovimento   ";
        String query2 = " select   distinct                pes.id_pessoa      as id_pessoa  ,                pes.nome           as nome_pessoa,                co.cnpj            as cnpj_pessoa         from item_nota_propria         i   inner join grade_item_nota_propria   g on g.id_item_nota_fiscal_propria = i.id_item_nota_propria inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao   inner join produto                   p on p.id_produto             = i.id_produto   inner join situacao_documento        s on s.id_situacao_documento  = n.id_situacao_documento   inner join unidade_fat_cliente       u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente   inner join cliente                   c on c.id_cliente             = u.id_cliente  inner join pessoa                  pes on pes.id_pessoa            = c.id_pessoa   inner join complemento              co on co.id_complemento        = pes.id_complemento   left  join centro_estoque            e on e.id_centro_estoque      = i.id_centro_estoque   inner join estoque_terceiros        et on et.id_grade_item_nota_propria  = g.id_grade_item_nota_propria   inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      nop.tipo_estoque =   :tipo_estoque  and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'   and s.codigo               <> '03'   and ep.id_emp             = :idEmp         and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial        AND :produtoFinal)  and (:filtrarPessoa        <> 1 OR pes.id_pessoa       between :pessoaInicial         AND :pessoaFinal )  and n.data_emissao                                     between :dataInicial           AND :dataFinal   and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)   and nop.id_tipo_movimento = :tipoMovimento  ";
        String query3 = " select  id_pessoa,  nome_pessoa,  cnpj_pessoa  from ( " + query1 + "union" + query2 + ")  order by id_pessoa, nome_pessoa ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setShort("tipo_estoque", tipoEstoque);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("pessoaInicial", pessoaInicial.longValue());
        q.setLong("pessoaFinal", pessoaFinal.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List findNotasTipoEstoque(Short tipoEstoqueOrigem, Short tipoEstoque, List fornecedores, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        for (Object o : fornecedores) {
            HashMap fornecedor = (HashMap)o;
            Integer idFornecedor = (Integer)fornecedor.get("ID_PESSOA");
            List notas = this.getNotasByFornecedorTipoEstoque(tipoEstoque, idFornecedor, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            fornecedor.put("NOTAS", notas);
            List notasFornecedor = (List)fornecedor.get("NOTAS");
            for (Object nt : notasFornecedor) {
                HashMap notaTerc = (HashMap)nt;
                Integer idNota = (Integer)notaTerc.get("ID_NOTA");
                List itensNotaTer = this.getItensNotaTerceirosTipoEstoque(tipoEstoque, idNota, filtrarProduto, produtoInicial, produtoFinal, idEmp, idTipoMovimento);
                notaTerc.put("ITENS", itensNotaTer);
                List itensNota = (List)notaTerc.get("ITENS");
                for (Object item : itensNota) {
                    HashMap itemTer = (HashMap)item;
                    Integer idEstTer = (Integer)itemTer.get("ID_EST_TERC");
                    List itensRetorno = this.getItensNotaTerceirosRetornoTipoEstoque2(tipoEstoqueOrigem, idEstTer, idEmp);
                    itemTer.put("RETORNOS", itensRetorno);
                }
            }
        }
        return fornecedores;
    }

    private List getNotasByFornecedorTipoEstoque(Short tipoEstoque, Integer idFornecedor, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select  distinct              n.id_nota_terceiros  as id_nota           ,              n.serie              as serie             ,              n.numero_nota        as numero_nota       ,              n.data_emissao       as data_emissao      ,              n.data_entrada_saida as data_entrada_saida         from item_nota_terceiros       i  inner join grade_item_nota_terceiros g on g.id_item_nota_terceiros = i.id_item_nota_terceiros inner join natureza_operacao       nop on nop.id_natureza_operacao  = i.id_natureza_operacao  inner join produto                   p on p.id_produto              = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros       = i.id_nota_terceiros  inner join situacao_documento        s on s.id_situacao_documento   = n.id_situacao_documento  inner join unidade_fat_forn          u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn  inner join fornecedor                f on f.id_fornecedor           = u.id_fornecedor  inner join pessoa                  pes on pes.id_pessoa             = f.id_pessoa  inner join complemento               c on c.id_complemento          = pes.id_complemento  left  join centro_estoque            e on e.id_centro_estoque       = i.id_centro_estoque  inner join estoque_terceiros        et on et.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  inner join empresa                  ep on ep.id_emp                 = n.id_empresa  where      nop.tipo_estoque        =   :tipo_estoque   and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'  and s.codigo               <> '03'  and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)  and pes.id_pessoa           = :idFornecedor  and ep.id_emp             = :idEmp         and n.data_entrada_saida                               between :dataInicial    AND :dataFinal  and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)  and nop.id_tipo_movimento = :tipoMovimento    ";
        String query2 = " select   distinct               n.id_nota_propria    as id_nota           ,                n.serie              as serie             ,                n.numero_nota        as numero_nota       ,                n.data_emissao       as data_emissao      ,                n.data_entrada_saida as data_entrada_saida           from item_nota_propria         i   inner join grade_item_nota_propria    g on g.id_item_nota_fiscal_propria = i.id_item_nota_propria  inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao    inner join produto                   p on p.id_produto             = i.id_produto    inner join situacao_documento        s on s.id_situacao_documento  = n.id_situacao_documento    inner join unidade_fat_cliente       u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente   inner join cliente                   c on c.id_cliente             = u.id_cliente       inner join pessoa                  pes on pes.id_pessoa            = c.id_pessoa    inner join complemento              co on co.id_complemento        = pes.id_complemento    left  join centro_estoque            e on e.id_centro_estoque      = i.id_centro_estoque    inner join estoque_terceiros        et on et.id_grade_item_nota_propria  = g.id_grade_item_nota_propria    inner join empresa                  ep on ep.id_emp                 = n.id_empresa   where    nop.tipo_estoque = :tipo_estoque    and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)   and s.codigo               <> '02'    and s.codigo               <> '03'    and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)    and pes.id_pessoa           = :idFornecedor   and ep.id_emp                = :idEmp          and n.data_emissao                                     between :dataInicial    AND :dataFinal    and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)    and nop.id_tipo_movimento = :tipoMovimento  ";
        String query3 = " select   id_nota           ,   serie             ,   numero_nota       ,   data_emissao      ,   data_entrada_saida    from ( " + query1 + " union " + query2 + " )  order by numero_nota, data_emissao ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setShort("tipo_estoque", tipoEstoque.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idFornecedor", idFornecedor.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensNotaTerceirosTipoEstoque(Short tipoEstoque, Integer idNota, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select        distinct      e.id_estoque_terceiros                  as id_est_terc,            i.id_item_nota_terceiros                as id_item,                g.id_grade_item_nota_terceiros          as id_grade_item,          p.id_produto                            as id_prod,                p.nome                                  as nome_prod,              e.quantidade * i.FATOR_CONVERSAO        as qtd_prod,               CAST((e.quantidade * i.FATOR_CONVERSAO) AS NUMERIC(15,6)) * CAST((i.valor_unitario / i.FATOR_CONVERSAO) AS NUMERIC(15,6)) AS VALOR_TOTAL,     i.valor_unitario  / i.FATOR_CONVERSAO                        as valor_unitario,         c.id_centro_estoque                     as id_centro_estoque,      lf.lote_fabricacao                      as lote_fabricacao          from item_nota_terceiros      i  inner join grade_item_nota_terceiros g on g.id_item_nota_terceiros = i.id_item_nota_terceiros left join lote_fabricacao lf on lf.id_lote_fabricacao = g.id_lote_fabricacao inner join natureza_operacao       nop on nop.id_natureza_operacao = i.id_natureza_operacao  inner join produto                   p on p.id_produto             = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros      = i.id_nota_terceiros  inner join estoque_terceiros         e on e.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  left  join centro_estoque            c on c.id_centro_estoque      = i.id_centro_estoque  inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      (:filtrarProduto   <> 1 OR p.id_produto between :produtoInicial and :produtoFinal)  and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  and n.id_nota_terceiros       = :idNota  and ep.id_emp                 = :idEmp         and nop.tipo_estoque          = :tipo_estoque  and nop.id_tipo_movimento     = :tipoMovimento  ";
        String query2 = " select  distinct      e.id_estoque_terceiros                  as id_est_terc,            i.id_item_nota_propria                  as id_item,                g.id_grade_item_nota_propria            as id_grade_item,          p.id_produto                            as id_prod,                p.nome                                  as nome_prod,              e.quantidade                            as qtd_prod,               (i.valor_unitario * e.quantidade)       as valor_total,            i.valor_unitario                        as valor_unitario,         c.id_centro_estoque                     as id_centro_estoque,       lf.lote_fabricacao                      as lote_fabricacao          from item_nota_propria        i  inner join grade_item_nota_propria   g on g.id_item_nota_fiscal_propria = i.id_item_nota_propria left  join lote_fabricacao lf on lf.id_lote_fabricacao = g.id_lote_fabricacao inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao  inner join produto                   p on p.id_produto             = i.id_produto  inner join estoque_terceiros         e on e.id_grade_item_nota_propria   = g.id_grade_item_nota_propria    left  join centro_estoque            c on c.id_centro_estoque      = i.id_centro_estoque  inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      (:filtrarProduto   <> 1 OR p.id_produto between :produtoInicial and :produtoFinal)  and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  and ep.id_emp                 = :idEmp   and n.id_nota_propria         = :idNota  and nop.tipo_estoque          = :tipo_estoque   and nop.id_tipo_movimento     = :tipoMovimento   ";
        String query3 = " select     id_est_terc,      id_item,          id_grade_item,    id_prod,          nome_prod,        qtd_prod,         valor_total,      valor_unitario,   id_centro_estoque, lote_fabricacao  from ( " + query1 + " union " + query2 + " )  order by id_prod, nome_prod ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setShort("tipo_estoque", tipoEstoque.shortValue());
        q.setInteger("idNota", idNota.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensNotaTerceirosRetornoTipoEstoque2(Short tipoEstoqueOrigem, Integer idEstTer, Long idEmp) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(" SELECT       e.id_estoque_terceiros                  as id_est_terc,                       e.quantidade                            as quantidade_retorno,                (ilv.vr_total)       as valor_total_retorno,               np.data_emissao                         as data_emissao_retorno,              np.data_entrada_saida                   as data_entrada_saida_retorno,        i.valor_unitario                        as valor_unitario_retorno,            np.serie                                as serie_nota_retorno,                np.numero_nota                          as numero_nota_retorno                 FROM grade_item_nota_propria   g   INNER JOIN item_nota_propria         i ON g.id_item_nota_fiscal_propria = i.id_item_nota_propria INNER JOIN nota_propria             np ON np.id_nota_propria       = i.id_nota_fiscal_propria  INNER JOIN item_nota_livro_fiscal  ilv ON ilv.ID_ITEM_NOTA_FISCAL_PROPRIA = i.id_item_nota_propria  INNER JOIN natureza_operacao       nop ON nop.id_natureza_operacao = np.id_natureza_operacao     INNER JOIN situacao_documento        s ON s.id_situacao_documento  = np.id_situacao_documento   INNER JOIN estoque_terceiros         e on e.id_grade_item_nota_propria   = g.id_grade_item_nota_propria   inner join empresa                  ep on ep.id_emp                = np.id_empresa  WHERE       nop.tipo_estoque      = :tipo_estoque_origem           and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  AND e.id_estoque_terc_mae = :idEstTer     AND s.codigo             <> '02'          AND s.codigo             <> '03'          and ep.id_emp             = :idEmp        order by np.numero_nota, np.data_emissao ");
        q.setInteger("idEstTer", idEstTer.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setShort("tipo_estoque_origem", tipoEstoqueOrigem.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List a = q.list();
        s = CoreBdUtil.getInstance().getSession();
        q = s.createSQLQuery(" SELECT       e.id_estoque_terceiros                  as id_est_terc,                       e.quantidade * i.fator_conversao        as quantidade_retorno,                (ilv.vr_total)       as valor_total_retorno,               np.data_emissao                         as data_emissao_retorno,              np.data_entrada_saida                   as data_entrada_saida_retorno,        i.valor_unitario                        as valor_unitario_retorno,            np.serie                                as serie_nota_retorno,                np.numero_nota                          as numero_nota_retorno                 FROM  grade_item_nota_terceiros g   INNER JOIN item_nota_terceiros        i   ON g.id_item_nota_terceiros = i.id_item_nota_terceiros INNER JOIN nota_terceiros             np  ON np.id_nota_terceiros       = i.id_nota_terceiros  INNER JOIN item_nota_livro_fiscal  ilv    ON ilv.ID_ITEM_NOTA_TERCEIROS = i.id_item_nota_terceiros  INNER JOIN natureza_operacao          nop ON nop.id_natureza_operacao = i.id_natureza_operacao     INNER JOIN situacao_documento         s   ON s.id_situacao_documento  = np.id_situacao_documento   INNER JOIN estoque_terceiros          e   ON e.ID_GRADE_ITEM_NOTA_TERCEIROS   = g.ID_GRADE_ITEM_NOTA_TERCEIROS   inner join empresa                    ep  ON ep.id_emp                = np.id_empresa  WHERE       nop.tipo_estoque      = :tipo_estoque_origem           and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  AND e.id_estoque_terc_mae = :idEstTer     AND s.codigo             <> '02'          AND s.codigo             <> '03'          and ep.id_emp             = :idEmp        order by np.numero_nota, np.data_emissao ");
        q.setInteger("idEstTer", idEstTer.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setShort("tipo_estoque_origem", tipoEstoqueOrigem.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        a.addAll(q.list());
        return a;
    }

    private List findFornecedoresTipoEstoque6(Date dataInicial, Date dataFinal, Short filtrarPessoa, Long pessoaInicial, Long pessoaFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select  distinct              pes.id_pessoa      as id_pessoa  ,              pes.nome           as nome_pessoa,              c.cnpj             as cnpj_pessoa         from item_nota_terceiros       i  inner join grade_item_nota_Terceiros g on g.id_item_nota_terceiros  = i.id_item_nota_terceiros inner join natureza_operacao       nop on nop.id_natureza_operacao  = i.id_natureza_operacao  inner join produto                   p on p.id_produto              = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros       = i.id_nota_terceiros  inner join situacao_documento        s on s.id_situacao_documento   = n.id_situacao_documento  inner join unidade_fat_forn          u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn  inner join fornecedor                f on f.id_fornecedor           = u.id_fornecedor  inner join pessoa                  pes on pes.id_pessoa             = f.id_pessoa  inner join complemento               c on c.id_complemento          = pes.id_complemento  left  join centro_estoque            e on e.id_centro_estoque       = i.id_centro_estoque  inner join estoque_terceiros        et on et.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  inner join empresa                  ep on ep.id_emp                 = n.id_empresa  where  (nop.tipo_estoque =   1 or nop.tipo_estoque = 5)  and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'  and s.codigo               <> '03'  and ep.id_emp             = :idEmp         and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)  and (:filtrarPessoa        <> 1 OR pes.id_pessoa       between :pessoaInicial  AND :pessoaFinal )  and n.data_entrada_saida                               between :dataInicial    AND :dataFinal  and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)  and nop.id_tipo_movimento = :tipoMovimento  ";
        String query2 = " select   distinct                pes.id_pessoa      as id_pessoa  ,                pes.nome           as nome_pessoa,                co.cnpj            as cnpj_pessoa         from item_nota_propria         i   inner join grade_item_nota_propria   g on g.id_item_nota_fiscal_propria = i.id_item_nota_propria  inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao   inner join produto                   p on p.id_produto             = i.id_produto   inner join situacao_documento        s on s.id_situacao_documento  = n.id_situacao_documento   inner join unidade_fat_cliente       u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente   inner join cliente                   c on c.id_cliente             = u.id_cliente  inner join pessoa                  pes on pes.id_pessoa            = c.id_pessoa   inner join complemento              co on co.id_complemento        = pes.id_complemento   left  join centro_estoque            e on e.id_centro_estoque      = i.id_centro_estoque   inner join estoque_terceiros        et on et.id_grade_item_nota_propria  = g.id_grade_item_nota_propria   inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      (nop.tipo_estoque =   1 or nop.tipo_estoque = 5)  and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'   and s.codigo               <> '03'   and ep.id_emp             = :idEmp         and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial        AND :produtoFinal)  and (:filtrarPessoa        <> 1 OR pes.id_pessoa       between :pessoaInicial         AND :pessoaFinal )  and n.data_emissao                                     between :dataInicial           AND :dataFinal   and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)   and nop.id_tipo_movimento = :tipoMovimento  ";
        String query3 = " select  id_pessoa,  nome_pessoa,  cnpj_pessoa  from ( " + query1 + "union" + query2 + ")  order by id_pessoa, nome_pessoa ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setLong("idEmp", idEmp.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("pessoaInicial", pessoaInicial.longValue());
        q.setLong("pessoaFinal", pessoaFinal.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List findNotasTipoEstoque6(List fornecedores, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        for (Object o : fornecedores) {
            HashMap fornecedor = (HashMap)o;
            Integer idFornecedor = (Integer)fornecedor.get("ID_PESSOA");
            List notas = this.getNotasByFornecedorTipoEstoque6(idFornecedor, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, idEmp, idTipoMovimento);
            fornecedor.put("NOTAS", notas);
            List notasFornecedor = (List)fornecedor.get("NOTAS");
            for (Object nt : notasFornecedor) {
                HashMap notaTerc = (HashMap)nt;
                Integer idNota = (Integer)notaTerc.get("ID_NOTA");
                List itensNotaTer = this.getItensNotaTerceirosTipoEstoque6(idNota, filtrarProduto, produtoInicial, produtoFinal, idEmp, idTipoMovimento);
                notaTerc.put("ITENS", itensNotaTer);
                List itensNota = (List)notaTerc.get("ITENS");
                for (Object item : itensNota) {
                    HashMap itemTer = (HashMap)item;
                    Integer idEstTer = (Integer)itemTer.get("ID_EST_TERC");
                    Integer idGradeItem = (Integer)itemTer.get("ID_GRADE_ITEM");
                    List itensRetorno = this.getItensNotaTerceirosRetornoTipoEstoque6(idEstTer, idEmp);
                    itemTer.put("RETORNOS", itensRetorno);
                }
            }
        }
        return fornecedores;
    }

    private List getNotasByFornecedorTipoEstoque6(Integer idFornecedor, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select  distinct              n.id_nota_terceiros  as id_nota           ,              n.serie              as serie             ,              n.numero_nota        as numero_nota       ,              n.data_emissao       as data_emissao      ,              n.data_entrada_saida as data_entrada_saida         from item_nota_terceiros       i  inner join grade_item_nota_terceiros g on g.id_item_nota_terceiros  = i.id_item_nota_terceiros inner join natureza_operacao       nop on nop.id_natureza_operacao  = i.id_natureza_operacao  inner join produto                   p on p.id_produto              = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros       = i.id_nota_terceiros  inner join situacao_documento        s on s.id_situacao_documento   = n.id_situacao_documento  inner join unidade_fat_forn          u on n.id_unidade_fat_forn     = u.id_unidade_fat_forn  inner join fornecedor                f on f.id_fornecedor           = u.id_fornecedor  inner join pessoa                  pes on pes.id_pessoa             = f.id_pessoa  inner join complemento               c on c.id_complemento          = pes.id_complemento  left  join centro_estoque            e on e.id_centro_estoque       = i.id_centro_estoque  inner join estoque_terceiros        et on et.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  inner join empresa                  ep on ep.id_emp                 = n.id_empresa  where  (nop.tipo_estoque = 1 or nop.tipo_estoque = 5)  and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)  and s.codigo               <> '02'  and s.codigo               <> '03'  and ep.id_emp             = :idEmp         and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)  and pes.id_pessoa           = :idFornecedor  and n.data_entrada_saida                               between :dataInicial    AND :dataFinal  and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)  and nop.id_tipo_movimento = :tipoMovimento  ";
        String query2 = " select   distinct               n.id_nota_propria    as id_nota           ,                n.serie              as serie             ,                n.numero_nota        as numero_nota       ,                n.data_emissao       as data_emissao      ,                n.data_entrada_saida as data_entrada_saida           from item_nota_propria         i    inner join grade_item_nota_propria   g on g.id_item_nota_fiscal_propria = i.id_item_nota_propria  inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao    inner join produto                   p on p.id_produto             = i.id_produto    inner join situacao_documento        s on s.id_situacao_documento  = n.id_situacao_documento    inner join unidade_fat_cliente       u on n.id_unidade_fat_cliente = u.id_unidade_fat_cliente   inner join cliente                   c on c.id_cliente             = u.id_cliente       inner join pessoa                  pes on pes.id_pessoa            = c.id_pessoa    inner join complemento              co on co.id_complemento        = pes.id_complemento    left  join centro_estoque            e on e.id_centro_estoque      = i.id_centro_estoque    inner join estoque_terceiros        et on et.id_grade_item_nota_propria  = g.id_grade_item_nota_propria   inner join empresa                  ep on ep.id_emp                 = n.id_empresa   where    (nop.tipo_estoque = 1 or nop.tipo_estoque = 5)    and (et.desativa_mov_terceiros = 0 or et.desativa_mov_terceiros is null)   and s.codigo               <> '02'     and s.codigo               <> '03'     and (:filtrarProduto       <> 1 OR p.id_produto        between :produtoInicial AND :produtoFinal)    and pes.id_pessoa           = :idFornecedor    and ep.id_emp               = :idEmp   and n.data_emissao                                     between :dataInicial    AND :dataFinal    and (:filtrarCentroEstoque <> 1 OR e.id_centro_estoque between :centroEstoqueInicial  AND :centroEstoqueFinal)    and nop.id_tipo_movimento = :tipoMovimento  ";
        String query3 = " select   id_nota           ,   serie             ,   numero_nota       ,   data_emissao      ,   data_entrada_saida    from ( " + query1 + " union " + query2 + " )  order by numero_nota, data_emissao ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setLong("idEmp", idEmp.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idFornecedor", idFornecedor.intValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("centroEstoqueInicial", centroEstoqueInicial.longValue());
        q.setLong("centroEstoqueFinal", centroEstoqueFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensNotaTerceirosTipoEstoque6(Integer idNota, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Long idEmp, Long idTipoMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = " select  distinct      e.id_estoque_terceiros                  as id_est_terc,            i.id_item_nota_terceiros                as id_item,                g.id_grade_item_nota_terceiros          as id_grade_item,          p.id_produto                            as id_prod,                p.nome                                  as nome_prod,              e.quantidade * i.fator_conversao        as qtd_prod,               (i.valor_unitario * e.quantidade)       as valor_total,            i.valor_unitario                        as valor_unitario,         c.id_centro_estoque                     as id_centro_estoque,       lf.lote_fabricacao                      as lote_fabricacao          from item_nota_terceiros      i  inner join grade_item_nota_terceiros g on g.id_item_nota_terceiros  = i.id_item_nota_terceiros left  join lote_fabricacao lf on lf.id_lote_fabricacao = g.id_lote_fabricacao inner join natureza_operacao       nop on nop.id_natureza_operacao = i.id_natureza_operacao  inner join produto                   p on p.id_produto             = i.id_produto  inner join nota_terceiros            n on n.id_nota_terceiros      = i.id_nota_terceiros  inner join estoque_terceiros         e on e.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros  left  join centro_estoque            c on c.id_centro_estoque      = i.id_centro_estoque  inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      (:filtrarProduto   <> 1 OR p.id_produto between :produtoInicial and :produtoFinal)  and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  and n.id_nota_terceiros = :idNota  and ep.id_emp             = :idEmp         and (nop.tipo_estoque = 1 or nop.tipo_estoque = 5)   and nop.id_tipo_movimento = :tipoMovimento  ";
        String query2 = " select  distinct      e.id_estoque_terceiros                  as id_est_terc,            i.id_item_nota_propria                  as id_item,                g.id_grade_item_nota_propria            as id_grade_item,          p.id_produto                            as id_prod,                p.nome                                  as nome_prod,              e.quantidade                            as qtd_prod,               (i.valor_unitario * e.quantidade)       as valor_total,            i.valor_unitario                        as valor_unitario,         c.id_centro_estoque                     as id_centro_estoque,       lf.lote_fabricacao                      as lote_fabricacao          from item_nota_propria        i  inner join grade_item_nota_propria   g on g.id_item_nota_fiscal_propria   = i.id_item_nota_propria left  join lote_fabricacao lf on lf.id_lote_fabricacao = g.id_lote_fabricacao inner join nota_propria              n on n.id_nota_propria        = i.id_nota_fiscal_propria  inner join natureza_operacao       nop on nop.id_natureza_operacao = n.id_natureza_operacao  inner join produto                   p on p.id_produto             = i.id_produto  inner join estoque_terceiros         e on e.id_grade_item_nota_propria   = g.id_grade_item_nota_propria    left  join centro_estoque            c on c.id_centro_estoque      = i.id_centro_estoque  inner join empresa                  ep on ep.id_emp                = n.id_empresa  where      (:filtrarProduto   <> 1 OR p.id_produto between :produtoInicial and :produtoFinal)  and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  and ep.id_emp             = :idEmp   and n.id_nota_propria = :idNota      and (nop.tipo_estoque = 1 or nop.tipo_estoque = 5)   and nop.id_tipo_movimento = :tipoMovimento  ";
        String query3 = " select      id_est_terc,       id_item,           id_grade_item,     id_prod,           nome_prod,         qtd_prod,          valor_total,       valor_unitario,    id_centro_estoque,  lote_fabricacao  from ( " + query1 + " union " + query2 + " )  order by id_prod, nome_prod ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setInteger("idNota", idNota.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setLong("tipoMovimento", idTipoMovimento.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getItensNotaTerceirosRetornoTipoEstoque6(Integer idEstTer, Long idEmp) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query1 = "select  e.quantidade                            as quantidade_retorno,           (ilv.vr_total)                          as valor_total_retorno,          np.data_emissao                         as data_emissao_retorno,         np.data_entrada_saida                   as data_entrada_saida_retorno,   i.valor_unitario                        as valor_unitario_retorno,       np.serie                                as serie_nota_retorno,           np.numero_nota                          as numero_nota_retorno FROM grade_item_nota_propria  g inner join estoque_terceiros  e   on e.id_grade_item_nota_propria = g.id_grade_item_nota_propria inner join item_nota_propria  i   on i.id_item_nota_propria = g.id_item_nota_fiscal_propria INNER JOIN item_nota_livro_fiscal  ilv ON ilv.ID_ITEM_NOTA_FISCAL_PROPRIA = i.id_item_nota_propria  inner join nota_propria       np  on np.id_nota_propria = i.id_nota_fiscal_propria inner join natureza_operacao  nop on nop.id_natureza_operacao = np.id_natureza_operacao inner join situacao_documento s   on s.id_situacao_documento = np.id_situacao_documento inner join empresa            ep  on ep.id_emp = np.id_empresa WHERE   (nop.tipo_estoque = 6)   AND (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  AND e.id_estoque_terc_mae = :idEstTer   AND ep.id_emp             = :idEmp AND s.codigo             <> '02'        AND s.codigo             <> '03'";
        String query2 = " select       e.quantidade  * i.fator_conversao       as quantidade_retorno,              (i.valor_unitario * e.quantidade)        as valor_total_retorno,              nt.data_emissao                         as data_emissao_retorno,             nt.data_entrada_saida                   as data_entrada_saida_retorno,       i.valor_unitario                        as valor_unitario_retorno,           nt.serie                                as serie_nota_retorno,               nt.numero_nota                          as numero_nota_retorno               FROM grade_item_nota_terceiros g INNER join item_nota_terceiros i    on i.id_item_nota_terceiros = g.id_item_nota_terceiros      INNER JOIN nota_terceiros           nt ON nt.id_nota_terceiros     = i.id_nota_terceiros        INNER JOIN item_nota_livro_fiscal  ilv    ON ilv.ID_ITEM_NOTA_TERCEIROS = i.id_item_nota_terceiros  INNER JOIN natureza_operacao       nop ON nop.id_natureza_operacao = i.id_natureza_operacao     INNER JOIN situacao_documento        s ON s.id_situacao_documento  = nt.id_situacao_documento   INNER JOIN estoque_terceiros         e on e.id_grade_item_nota_terceiros = g.id_grade_item_nota_terceiros   inner join empresa                  ep on ep.id_emp                = nt.id_empresa  WHERE       (nop.tipo_estoque = 6)   and (e.desativa_mov_terceiros = 0 or e.desativa_mov_terceiros is null)  AND e.id_estoque_terc_mae = :idEstTer      and ep.id_emp             = :idEmp         AND s.codigo             <> '02'           AND s.codigo             <> '03'          ";
        String query3 = " select                 quantidade_retorno,          valor_total_retorno,         data_emissao_retorno,        data_entrada_saida_retorno,  valor_unitario_retorno,      serie_nota_retorno,          numero_nota_retorno          from ( " + query1 + " union all " + query2 + " )  order by numero_nota_retorno, data_emissao_retorno ";
        NativeQuery q = s.createSQLQuery(query3);
        q.setInteger("idEstTer", idEstTer.intValue());
        q.setLong("idEmp", idEmp.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

