/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemRequisicoesCentroCusto {
    JasperPrint gerarRelatorio(CoreRequestContext r) throws ExceptionService {
        Short filtrarData = (Short)r.getAttribute("FILTRAR_DATA");
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        Short filtrarCentroCusto = (Short)r.getAttribute("FILTRAR_CENTRO_CUSTO");
        Long centroCustoInicial = (Long)r.getAttribute("ID_CENTRO_CUSTO_INICIAL");
        Long centroCustoFinal = (Long)r.getAttribute("ID_CENTRO_CUSTO_FINAL");
        Short filtrarCentroEstoque = (Short)r.getAttribute("FILTRAR_CENTRO_ESTOQUE");
        Long centroEstoqueInicial = (Long)r.getAttribute("ID_CENTRO_ESTOQUE_INICIAL");
        Long centroEstoqueFinal = (Long)r.getAttribute("ID_CENTRO_ESTOQUE_FINAL");
        Short filtrarEspecie = (Short)r.getAttribute("FILTRAR_ESPECIE");
        Long especieInicial = (Long)r.getAttribute("ID_ESPECIE_INICIAL");
        Long especieFinal = (Long)r.getAttribute("ID_ESPECIE_FINAL");
        Short filtrarSubespecie = (Short)r.getAttribute("FILTRAR_SUBESPECIE");
        Long subespecieInicial = (Long)r.getAttribute("ID_SUBESPECIE_INICIAL");
        Long subespecieFinal = (Long)r.getAttribute("ID_SUBESPECIE_FINAL");
        Short filtrarFabricante = (Short)r.getAttribute("FILTRAR_FABRICANTE");
        Long fabricanteInicial = (Long)r.getAttribute("ID_FABRICANTE_INICIAL");
        Long fabricanteFinal = (Long)r.getAttribute("ID_FABRICANTE_FINAL");
        Short filtrarLocalizacao = (Short)r.getAttribute("FILTRAR_LOCALIZACAO");
        Long localizacaoInicial = (Long)r.getAttribute("ID_LOCALIZACAO_INICIAL");
        Long localizacaoFinal = (Long)r.getAttribute("ID_LOCALIZACAO_FINAL");
        Short filtrarProduto = (Short)r.getAttribute("FILTRAR_PRODUTO");
        Long produtoInicial = (Long)r.getAttribute("ID_PRODUTO_INICIAL");
        Long produtoFinal = (Long)r.getAttribute("ID_PRODUTO_FINAL");
        Nodo nodo = (Nodo)r.getAttribute("NODO");
        Empresa empresa = (Empresa)r.getAttribute("EMPRESA");
        Short calcPrecoMedio = (Short)r.getAttribute("CALC_PRECO_MEDIO");
        Short calcUltCusto = (Short)r.getAttribute("CALC_ULT_PRECO_CUSTO");
        Short tipoCentroEstPropTerc = (Short)r.getAttribute("tipoCentroEstoque");
        List saidas = this.getSaidas(filtrarData, dataInicial, dataFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal, filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, filtrarEspecie, especieInicial, especieFinal, filtrarSubespecie, subespecieInicial, subespecieFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarFabricante, fabricanteInicial, fabricanteFinal, filtrarLocalizacao, localizacaoInicial, localizacaoFinal);
        List saldosMedios = this.getSaldos(new Date(), filtrarCentroEstoque, centroEstoqueInicial, centroEstoqueFinal, filtrarEspecie, especieInicial, especieFinal, filtrarSubespecie, subespecieInicial, subespecieFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarFabricante, fabricanteInicial, fabricanteFinal, filtrarLocalizacao, localizacaoInicial, localizacaoFinal, empresa, tipoCentroEstPropTerc);
        if (calcPrecoMedio == 1) {
            this.mergePrecosMedios(saidas, saldosMedios);
        }
        if (calcUltCusto == 1) {
            this.mergeUltimoPreco(saidas, empresa);
        }
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.putAll(r.toHashMap());
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "suprimentos" + File.separator + "gestaoestoque" + File.separator + "listagens" + File.separator + "requisicoescentrocusto" + File.separator;
        parametros.put("PATH", path);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", (String)path + "LISTAGEM_REQUISICOES_CENTRO_CUSTOS.jasper");
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", saidas);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List getSaidas(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarSubespecie, Long subespecieInicial, Long subespecieFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarLocalizacao, Long localizacaoInicial, Long localizacaoFinal) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(ItemRequisicao.class);
        c.createAlias("produto", "p");
        c.createAlias("p.especie", "e");
        c.createAlias("p.localizacao", "l");
        c.createAlias("p.fabricante", "f");
        c.createAlias("p.subEspecie", "s");
        c.createAlias("centroCusto", "cc");
        c.createAlias("centroEstoque", "ce");
        c.createAlias("requisicao", "r");
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.alias((Projection)Projections.property((String)"p.identificador"), (String)"ID_PRODUTO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"p.codigoAuxiliar"), (String)"CODIGO_AUXILIAR"));
        projections.add(Projections.alias((Projection)Projections.property((String)"p.nome"), (String)"PRODUTO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"cc.identificador"), (String)"ID_CENTRO_CUSTO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"cc.codigo"), (String)"CODIGO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"cc.nome"), (String)"CENTRO_CUSTO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"quantidadeTotal"), (String)"QUANTIDADE"));
        projections.add(Projections.alias((Projection)Projections.property((String)"r.dataRequisicao"), (String)"DATA_REQUISICAO"));
        projections.add(Projections.alias((Projection)Projections.property((String)"r.identificador"), (String)"ID_REQUISICAO"));
        c.setProjection((Projection)projections);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        c.addOrder(Order.asc((String)"cc.codigo"));
        if (filtrarData == 1) {
            c.add(Restrictions.between((String)"r.dataRequisicao", (Object)dataInicial, (Object)dataFinal));
        }
        if (filtrarCentroCusto == 1) {
            c.add(Restrictions.between((String)"cc.identificador", (Object)centroCustoInicial, (Object)centroCustoFinal));
        }
        if (filtrarCentroEstoque == 1) {
            c.add(Restrictions.between((String)"ce.identificador", (Object)centroEstoqueInicial, (Object)centroEstoqueFinal));
        }
        if (filtrarEspecie == 1) {
            c.add(Restrictions.between((String)"e.identificador", (Object)especieInicial, (Object)especieFinal));
        }
        if (filtrarSubespecie == 1) {
            c.add(Restrictions.between((String)"s.identificador", (Object)subespecieInicial, (Object)subespecieFinal));
        }
        if (filtrarProduto == 1) {
            c.add(Restrictions.between((String)"p.identificador", (Object)produtoInicial, (Object)produtoFinal));
        }
        if (filtrarLocalizacao == 1) {
            c.add(Restrictions.between((String)"l.identificador", (Object)localizacaoInicial, (Object)localizacaoFinal));
        }
        if (filtrarFabricante == 1) {
            c.add(Restrictions.between((String)"f.identificador", (Object)fabricanteInicial, (Object)fabricanteFinal));
        }
        return c.list();
    }

    private List getSaldos(Date dataPosicao, Short filtrarCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarSubespecie, Long subespecieInicial, Long subespecieFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarLocalizacao, Long localizacaoInicial, Long localizacaoFinal, Empresa empresa, Short tipoCentroEstPropTerc) {
        if (filtrarCentroEstoque == null || filtrarCentroEstoque != 1) {
            centroEstoqueFinal = null;
            centroEstoqueInicial = null;
        }
        if (filtrarEspecie == null || filtrarEspecie != 1) {
            especieFinal = null;
            especieInicial = null;
        }
        if (filtrarSubespecie == null || filtrarSubespecie != 1) {
            subespecieFinal = null;
            subespecieInicial = null;
        }
        if (filtrarFabricante == null || filtrarFabricante != 1) {
            fabricanteFinal = null;
            fabricanteInicial = null;
        }
        if (filtrarProduto == null || filtrarProduto != 1) {
            produtoFinal = null;
            produtoInicial = null;
        }
        if (filtrarLocalizacao == null || filtrarLocalizacao != 1) {
            localizacaoFinal = null;
            localizacaoInicial = null;
        }
        List saldos = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getSaldoProdutoPorGradePorQtdeMaxMinRessuprimento(dataPosicao, produtoInicial, produtoFinal, especieInicial, especieFinal, subespecieInicial, subespecieFinal, centroEstoqueInicial, centroEstoqueFinal, fabricanteInicial, fabricanteFinal, localizacaoInicial, localizacaoFinal, 0, 99, (short)2, empresa.getIdentificador(), 2, 1, 3, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstPropTerc, null);
        List hashProdutos = this.convertSaldosToHash(saldos);
        return hashProdutos;
    }

    private void mergePrecosMedios(List<HashMap> saidas, List<HashMap> saldosMedios) {
        block0: for (HashMap h : saidas) {
            Long idProduto = (Long)h.get("ID_PRODUTO");
            for (HashMap h1 : saldosMedios) {
                Long idProduto1 = (Long)h1.get("ID_PRODUTO");
                if (!ToolMethods.isEquals((Object)idProduto, (Object)idProduto1)) continue;
                Double ob = (Double)h1.get("VLR_PRECO_MEDIO");
                Double quantidade = (Double)h.get("QUANTIDADE");
                h.put("VLR_PRECO_MEDIO", ob);
                h.put("VLR_TOT_PRECO_MEDIO", quantidade * ob);
                continue block0;
            }
        }
    }

    private void mergeUltimoPreco(List<HashMap> saidas, Empresa emp) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        HashMap<Long, Double> cache = new HashMap<Long, Double>();
        for (HashMap h : saidas) {
            Long idProduto = (Long)h.get("ID_PRODUTO");
            Double value = (Double)cache.get(idProduto);
            if (value == null) {
                CompEstoque compEstoque = (CompEstoque)Context.get(CompEstoque.class);
                value = compEstoque.getUltimoCusto(idProduto, emp.getIdentificador());
                cache.put(idProduto, value);
            }
            if (value == null) {
                value = 0.0;
            }
            Double quantidade = (Double)h.get("QUANTIDADE");
            h.put("VLR_ULT_PR_COMPRA", value);
            h.put("VLR_TOT_ULT_PR_COMPRA", quantidade * value);
        }
    }

    private List convertSaldosToHash(List<SaldoEstoqueGeral> saldos) {
        ArrayList lista = new ArrayList();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                Produto produto = s.getGradeCor().getProdutoGrade().getProduto();
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("SALDO_QTD", s.getQuantidade());
                h.put("SALDO_VALOR", s.getValor());
                h.put("VLR_PRECO_MEDIO", s.getValorMedio());
                h.put("GRADE", s.getGradeCor().getCor().getNome());
                h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador());
                h.put("ID_PRODUTO", produto.getIdentificador());
                h.put("CODIGO_AUXILIAR", produto.getCodigoAuxiliar());
                h.put("PRODUTO", produto.getNome());
                h.put("QTD_MAX", produto.getQtdMax());
                h.put("QTD_MIN", produto.getQtdMin());
                h.put("PTO_RESSUPRIMENTO", produto.getPontoRessupEstoque());
                h.put("UNIDADE_MEDIDA", produto.getUnidadeMedida().getSigla());
                h.put("ESPECIE", produto.getEspecie().getNome());
                h.put("SUB_ESPECIE", produto.getSubEspecie().getNome());
                lista.add(h);
            }
        }
        return lista;
    }
}

