/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemDocFiscaisPorPeriodo {
    private static final String[] SITUACOES = new String[]{"02", "03", "04"};

    UtilGerarListagemDocFiscaisPorPeriodo() {
    }

    protected JasperPrint gerarListagemDocFiscaisPorPer\u00edodo(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarTransportador, Long transportadorIncial, Long transportadorFinal, Short filtrarModeloDocFiscal, ModeloDocFiscal modeloDocFiscal, Short tipoDocumento, Short imprimirRps, Short compoeFluxoVenda, Short imprimirNotasServico, Nodo nodo, String fecho, HashMap params) throws ExceptionService {
        List<HashMap> dados = tipoDocumento == 0 ? this.gerarDadosEntrada(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarModeloDocFiscal, modeloDocFiscal, filtrarTransportador, transportadorIncial, transportadorFinal, imprimirNotasServico, compoeFluxoVenda) : this.gerarDadosSaida(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarModeloDocFiscal, modeloDocFiscal, filtrarTransportador, transportadorIncial, transportadorFinal, imprimirNotasServico, imprimirRps, compoeFluxoVenda);
        this.setarParametros(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, tipoDocumento, imprimirRps, compoeFluxoVenda, imprimirNotasServico, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "listagens" + File.separator + "listagemdocumentosfiscaisporperiodo" + File.separator + "LISTAGEM_DOC_FISCAIS_POR_PERIODO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List<HashMap> gerarDadosEntrada(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarModeloDocFiscal, ModeloDocFiscal modeloDocFiscal, Short filtrarTransportador, Long transportadorIncial, Long transportadorFinal, Short imprimirNotasServico, Short compoeFluxoVenda) {
        List<HashMap> dados = this.gerarDadosNotaTerceiros(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarModeloDocFiscal, modeloDocFiscal, filtrarTransportador, transportadorIncial, transportadorFinal, imprimirNotasServico);
        dados.addAll(this.gerarDadosNotaPropria(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarTransportador, transportadorIncial, transportadorFinal, filtrarModeloDocFiscal, modeloDocFiscal, imprimirNotasServico, compoeFluxoVenda, (short)2));
        return dados;
    }

    private List<HashMap> gerarDadosSaida(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarModeloDocFiscal, ModeloDocFiscal modeloDocFiscal, Short filtrarTransportador, Long transportadorIncial, Long transportadorFinal, Short imprimirNotasServico, Short imprimirRps, Short compoeFluxoVenda) {
        List<HashMap> dados = this.gerarDadosNotaPropria(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, filtrarTransportador, transportadorIncial, transportadorFinal, filtrarModeloDocFiscal, modeloDocFiscal, imprimirNotasServico, compoeFluxoVenda, (short)1);
        if (imprimirRps == 1) {
            dados.addAll(this.gerarDadosSaidaRPS(filtrarData, dataInicial, dataFinal, filtrarSerie, serie, filtrarPessoa, idPessoaInicial, idPessoaFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal));
        }
        return dados;
    }

    private List<HashMap> gerarDadosNotaTerceiros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarModeloDocFiscal, ModeloDocFiscal modeloDocFiscal, Short filtrarTransportador, Long transportadorIncial, Long transportadorFinal, Short imprimirNotasServico) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select distinct n.dataEmissao as DATA_EMISSAO, n.dataEntrada as DATA_ENTRADA_SAIDA, n.numeroNota as NUMERO_NOTA, n.serie as SERIE, n.unidadeFatFornecedor.fornecedor.identificador as ID_FORNECEDOR_CLIENTE,  n.unidadeFatFornecedor.pessoa.nome as NOME_FORNECEDOR_CLIENTE,  n.valoresNfTerceiros.valorTotal as VALOR_TOTAL, n.modeloDocFiscal.codigo as COD_MOD_DOC_FISCAL, n.empresa.pessoa.nomeFantasia as NOME_EMPRESA, SD.codigo as F_CODIGO_SITUACAO, c.cnpj as CPF_CNPJ  from NotaFiscalTerceiros n     Inner Join n.situacaoDocumento SD     Inner Join n.itemNotaTerceiros IT     INNER JOIN n.unidadeFatFornecedor uf          INNER JOIN uf.pessoa p              LEFT JOIN p.complemento c WHERE      (:filtrarData          <> 1 OR (n.dataEntrada  BETWEEN :dataInicial            AND :dataFinal)) AND (:filtrarSerie         <> 1 or (n.serie = :serie)) AND (:filtrarPessoa        <> 1 or(n.unidadeFatFornecedor.pessoa.identificador BETWEEN :idPessoaInicial and :idPessoaFinal)) AND (:filtrarEmpresa       <> 1 or(n.empresa.identificador BETWEEN :idEmpresaInicial and :idEmpresaFinal)) AND (:filtrarModDocFiscal  <> 1 or(n.modeloDocFiscal.identificador = :idModDocFiscal)) AND (:imprimirNotasServico <> 0 or(n.modeloDocFiscal.codigo  <> :codModeloServico)) and (:filtrarTransportador <>1 or (n.transportador.identificador between :transportadorIncial and :transportadorFinal)) and IT.naturezaOperacao.entradaSaida = :entrada  order by n.dataEntrada, n.numeroNota";
        Query q = s.createQuery(hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarSerie", filtrarSerie.shortValue());
        q.setString("serie", serie);
        q.setShort("filtrarModDocFiscal", filtrarModeloDocFiscal.shortValue());
        if (modeloDocFiscal != null) {
            q.setLong("idModDocFiscal", modeloDocFiscal.getIdentificador().longValue());
        } else {
            q.setLong("idModDocFiscal", 999999L);
        }
        q.setShort("filtrarTransportador", filtrarTransportador.shortValue());
        q.setLong("transportadorIncial", transportadorIncial.longValue());
        q.setLong("transportadorFinal", transportadorFinal.longValue());
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("idPessoaInicial", idPessoaInicial.longValue());
        q.setLong("idPessoaFinal", idPessoaFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpresaFinal", idEmpresaFinal.longValue());
        q.setShort("imprimirNotasServico", imprimirNotasServico.shortValue());
        q.setString("codModeloServico", "99");
        q.setShort("entrada", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> gerarDadosNotaPropria(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short filtrarTransportador, Long transportadorIncial, Long transportadorFinal, Short filtrarModeloDocFiscal, ModeloDocFiscal modeloDocFiscal, Short imprimirNotasServico, Short compoeFluxoVenda, Short tipoFaturamento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select distinct n.dataEmissaoNota as DATA_EMISSAO, n.dataEntradaSaida as DATA_ENTRADA_SAIDA, n.numeroNota as NUMERO_NOTA, n.serie as SERIE, n.unidadeFatCliente.cliente.identificador as ID_FORNECEDOR_CLIENTE,  n.unidadeFatCliente.pessoa.nome as NOME_FORNECEDOR_CLIENTE,  n.valoresNfPropria.valorTotal as VALOR_TOTAL, n.empresa.pessoa.nomeFantasia as NOME_EMPRESA, n.status as STATUS, SD.codigo as F_CODIGO_SITUACAO, c.cnpj as CPF_CNPJ  from NotaFiscalPropria n inner join n.itensNotaPropria i inner join n.situacaoDocumento SD      INNER JOIN n.unidadeFatCliente uc          INNER JOIN uc.pessoa p              LEFT join p.complemento c WHERE      (:filtrarData          <> 1 OR (n.dataEmissaoNota  BETWEEN :dataInicial            AND :dataFinal)) AND (:filtrarSerie         <> 1 or (n.serie = :serie)) AND (:filtrarPessoa        <> 1 or(n.unidadeFatCliente.pessoa.identificador BETWEEN :idPessoaInicial and :idPessoaFinal)) AND (:filtrarEmpresa       <> 1 or(n.empresa.identificador BETWEEN :idEmpresaInicial and :idEmpresaFinal)) AND (:filtrarModDocFiscal  <> 1 or(n.modeloDocFiscal.identificador = :idModDocFiscal)) AND (:imprimirNotasServico <> 0 or(n.modeloDocFiscal.codigo  <> :codModeloServico)) AND (:compoeFluxoVenda     <> 1 or (i.modeloFiscal.compoeFluxoVenda = :compoeFluxoVenda)) and (:filtrarTransportador <> 1 or (n.dadosTransNfPropria.transportador.identificador between :transportadorIncial and :transportadorFinal))\n AND (n.naturezaOperacao.entradaSaida = :tipoFaturamento) order by n.numeroNota, n.dataEmissaoNota";
        Query q = s.createQuery(hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarSerie", filtrarSerie.shortValue());
        q.setString("serie", serie);
        q.setShort("filtrarModDocFiscal", filtrarModeloDocFiscal.shortValue());
        if (modeloDocFiscal != null) {
            q.setLong("idModDocFiscal", modeloDocFiscal.getIdentificador().longValue());
        } else {
            q.setLong("idModDocFiscal", 999999L);
        }
        q.setShort("filtrarTransportador", filtrarTransportador.shortValue());
        q.setLong("transportadorIncial", transportadorIncial.longValue());
        q.setLong("transportadorFinal", transportadorFinal.longValue());
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("idPessoaInicial", idPessoaInicial.longValue());
        q.setLong("idPessoaFinal", idPessoaFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", idEmpresaInicial == null ? 0L : idEmpresaInicial);
        q.setLong("idEmpresaFinal", idEmpresaFinal == null ? 999L : idEmpresaFinal);
        q.setShort("imprimirNotasServico", imprimirNotasServico.shortValue());
        q.setString("codModeloServico", "99");
        q.setShort("compoeFluxoVenda", compoeFluxoVenda.shortValue());
        q.setShort("tipoFaturamento", tipoFaturamento.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> gerarDadosSaidaRPS(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select distinct n.dataEmissao as DATA_EMISSAO, n.dataEmissao as DATA_ENTRADA_SAIDA, CAST(n.numero AS int) as NUMERO_NOTA, n.serie as SERIE, n.unidadeTomPrestRPS.tomadorPrestadorRPS.identificador as ID_FORNECEDOR_CLIENTE,  n.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.nome as NOME_FORNECEDOR_CLIENTE,  n.valorServico as VALOR_TOTAL, n.empresa.pessoa.nomeFantasia as NOME_EMPRESA, n.status as STATUS,  c.cnpj as CPF_CNPJ  from Rps n inner join n.situacaoDocumento SD      Inner join n.unidadeTomPrestRPS ut          INNER JOIN ut.tomadorPrestadorRPS tp             INNER JOIN tp.pessoa p                  LEFT JOIN p.complemento c WHERE     (:filtrarData           <> 1 OR (n.dataEmissao  BETWEEN :dataInicial            AND :dataFinal)) AND (:filtrarSerie         <> 1 or (n.serie = :serie)) AND (:filtrarPessoa        <> 1 or(n.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.identificador BETWEEN :idPessoaInicial and :idPessoaFinal)) AND (:filtrarEmpresa       <> 1 or(n.empresa.identificador BETWEEN :idEmpresaInicial and :idEmpresaFinal)) AND (SD.codigo not in (:situacoes)) order by n.numero, n.dataEmissao";
        Query q = s.createQuery(hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarSerie", filtrarSerie.shortValue());
        q.setString("serie", serie);
        q.setShort("filtrarPessoa", filtrarPessoa.shortValue());
        q.setLong("idPessoaInicial", idPessoaInicial.longValue());
        q.setLong("idPessoaFinal", idPessoaFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpresaFinal", idEmpresaFinal.longValue());
        q.setParameterList("situacoes", (Object[])SITUACOES);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void setarParametros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Short filtrarPessoa, Long idPessoaInicial, Long idPessoaFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short tipoDocumento, Short imprimirRps, Short compoeFluxoVenda, Short imprimirNotasServico, String fecho, HashMap params) {
        params.put("FILTRAR_DATA", filtrarData);
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FILTRAR_SERIE", filtrarSerie);
        params.put("SERIE", serie);
        params.put("FILTRAR_PESSOA", filtrarPessoa);
        params.put("ID_PESSOA_INICIAL", idPessoaInicial);
        params.put("ID_PESSOA_FINAL", idPessoaFinal);
        params.put("FILTRAR_EMPRESA", filtrarEmpresa);
        params.put("ID_EMPRESA_INICIAL", idEmpresaInicial);
        params.put("ID_EMPRESA_FINAL", idEmpresaFinal);
        params.put("TIPO_DOCUMENTO", tipoDocumento);
        params.put("COMPOE_FLUXO_VENDA", compoeFluxoVenda);
        params.put("IMPRIMIR_RPS", imprimirRps);
        params.put("IMPRIMIR_NOTAS_SERVICO", imprimirNotasServico);
        params.put("FECHO", fecho);
    }
}

