/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemEntradaSaidaUFPorGI {
    private static final Short SAIDA = 1;

    UtilGerarListagemEntradaSaidaUFPorGI() {
    }

    public JasperPrint gerarListagemEntradaSaidaUfPorGI(Short filtrarData, Date dataInicial, Date dataFinal, Short tipo, Long idUF, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short exibirNotas, Short exibirCte, Short exibirCupons, Short quebrarCFOP, Short quebrarCST, Short quebrarCidade, Nodo nodo, String fecho, HashMap params, Short naoExibirUFEmitente) throws ExceptionService {
        ArrayList dados = new ArrayList();
        if (tipo.equals(SAIDA)) {
            if (exibirNotas.equals((short)1)) {
                dados.addAll(UtilGerarListagemEntradaSaidaUFPorGI.gerarDadosNotaPropriaSaida(filtrarData, dataInicial, dataFinal, idUF, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, quebrarCidade, quebrarCFOP, quebrarCST, naoExibirUFEmitente));
            }
            if (exibirCte.equals((short)1)) {
                dados.addAll(UtilGerarListagemEntradaSaidaUFPorGI.gerarDadosCTeSaida(filtrarData, dataInicial, dataFinal, idUF, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, quebrarCidade, quebrarCFOP, quebrarCST, naoExibirUFEmitente));
            }
            if (exibirCupons.equals((short)1)) {
                dados.addAll(UtilGerarListagemEntradaSaidaUFPorGI.gerarDadosCupomFiscal(filtrarData, dataInicial, dataFinal, idUF, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, quebrarCidade, quebrarCFOP, quebrarCST));
            }
        } else {
            dados.addAll(this.gerarDadosNotaTerceirosEntrada(filtrarData, dataInicial, dataFinal, idUF, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, quebrarCidade, quebrarCFOP, quebrarCST, naoExibirUFEmitente));
            dados.addAll(UtilGerarListagemEntradaSaidaUFPorGI.gerarDadosNotaPropriaEntrada(filtrarData, dataInicial, dataFinal, idUF, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, quebrarCidade, quebrarCFOP, quebrarCST, naoExibirUFEmitente));
        }
        UtilGerarListagemEntradaSaidaUFPorGI.setarParametros(filtrarData, dataInicial, dataFinal, filtrarEmpresa, idEmpresaInicial, idEmpresaFinal, idUF, tipo, exibirNotas, exibirCte, quebrarCST, quebrarCFOP, quebrarCidade, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "listagens" + File.separator + "listagementradasaidaufporgi" + File.separator + "LISTAGEM_ENTRADA_SAIDA_UF_POR_GI.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", this.getEventosOrdenados(dados));
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private static Collection gerarDadosNotaPropriaSaida(Short filtrarData, Date dataInicial, Date dataFinal, Long idUF, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarCidade, Short quebrarCFOP, Short quebrarCST, Short naoExibirUFEmitente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select  l.valorTotal as VALOR_CONTABIL, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsSemAprov as VALOR_ICMS_SEM_APROV, l.valorIcmsIsento as VALOR_ICMS_ISENTO, l.valorIcmsOutros as VALOR_ICMS_OUTROS, l.valorIcms as VALOR_ICMS, l.valorIcmsSt as VALOR_ICMS_ST, l.valorBCIcmsSt as BC_ICMS_ST, l.cfop.codigo as CFOP, l.incidenciaIcms.codigo as CODIGO_INC_ICMS, l.incidenciaIcms.descricao as DESCRICAO_INC_ICMS, l.cidade.descricao as CIDADE,  l.cidade.identificador as ID_CIDADE,  l.cidade.uf.sigla  as UF,  l.cidade.uf.identificador  as ID_UF,  n.unidadeFatCliente.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL, n.numeroNota as NUMERO_NOTA from NotaFiscalPropria n inner join n.livrosFiscais l WHERE      (:filtrarData         <>1 OR l.dataLivro between :dataInicial and :dataFinal) AND (:filtrarEmpresa      <>1 OR l.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (l.cidade.uf.identificador between :idUfInicial and :idUfFinal) AND l.cancelado = :naoCancelado AND l.entradaSaidaNaturezaOp = 1";
        if (naoExibirUFEmitente.equals((short)1)) {
            hql = (String)hql + " AND n.unidadeFatCliente.pessoa.endereco.cidade.uf <> n.empresa.pessoa.endereco.cidade.uf";
        }
        hql = (String)hql + " ORDER BY l.cidade.uf.identificador";
        if (quebrarCidade == 1) {
            hql = (String)hql + ", l.cidade.identificador";
        }
        if (quebrarCFOP == 1) {
            hql = (String)hql + ", l.cfop.codigo";
        }
        if (quebrarCST == 1) {
            hql = (String)hql + ", l.incidenciaIcms.codigo";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", empresaInicial.longValue());
        q.setLong("idEmpresaFinal", empresaFinal.longValue());
        if (idUF != null) {
            q.setLong("idUfInicial", idUF.longValue());
            q.setLong("idUfFinal", idUF.longValue());
        } else {
            q.setLong("idUfInicial", 0L);
            q.setLong("idUfFinal", 999999L);
        }
        q.setShort("naoCancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static Collection gerarDadosCTeSaida(Short filtrarData, Date dataInicial, Date dataFinal, Long idUF, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarCidade, Short quebrarCFOP, Short quebrarCST, Short naoExibirUFEmitente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select  l.valorTotal as VALOR_CONTABIL, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsSemAprov as VALOR_ICMS_SEM_APROV, l.valorIcmsIsento as VALOR_ICMS_ISENTO, l.valorIcmsOutros as VALOR_ICMS_OUTROS, l.valorIcms as VALOR_ICMS, l.valorIcmsSt as VALOR_ICMS_ST, l.valorBCIcmsSt as BC_ICMS_ST, l.cfop.codigo as CFOP, l.incidenciaIcms.codigo as CODIGO_INC_ICMS, l.incidenciaIcms.descricao as DESCRICAO_INC_ICMS, n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.descricao as CIDADE,  n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.identificador as ID_CIDADE,  n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.uf.sigla  as UF,  n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.uf.identificador  as ID_UF,  n.remetenteDestinatario.pessoaRemetente.inscricaoEstadual as INSCRICAO_ESTADUAL from Cte n inner join n.livrosFiscais l WHERE      (:filtrarData         <>1 OR n.dataEmissao between :dataInicial and :dataFinal) AND (:filtrarEmpresa      <>1 OR n.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.uf.identificador between :idUfInicial and :idUfFinal) AND (n.situacaoDocumento.codigo <> :cancelado AND n.situacaoDocumento.codigo <> :canceladoExtemporaneo)";
        if (naoExibirUFEmitente.equals((short)1)) {
            hql = (String)hql + " AND n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.uf <> n.empresa.pessoa.endereco.cidade.uf ";
        }
        hql = (String)hql + " ORDER BY n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.uf.identificador";
        if (quebrarCidade == 1) {
            hql = (String)hql + ", n.remetenteDestinatario.pessoaRemetente.pessoaTransporte.pessoa.endereco.cidade.identificador";
        }
        if (quebrarCFOP == 1) {
            hql = (String)hql + ", l.cfop.codigo";
        }
        if (quebrarCST == 1) {
            hql = (String)hql + ", l.incidenciaIcms.codigo";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", empresaInicial.longValue());
        q.setLong("idEmpresaFinal", empresaFinal.longValue());
        if (idUF != null) {
            q.setLong("idUfInicial", idUF.longValue());
            q.setLong("idUfFinal", idUF.longValue());
        } else {
            q.setLong("idUfInicial", 0L);
            q.setLong("idUfFinal", 999999L);
        }
        q.setString("cancelado", "02");
        q.setString("canceladoExtemporaneo", "03");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static Collection gerarDadosCupomFiscal(Short filtrarData, Date dataInicial, Date dataFinal, Long idUF, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarCidade, Short quebrarCFOP, Short quebrarCST) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select  l.valorTotal as VALOR_CONTABIL, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsSemAprov as VALOR_ICMS_SEM_APROV, l.valorIcmsIsento as VALOR_ICMS_ISENTO, l.valorIcmsOutros as VALOR_ICMS_OUTROS, l.valorIcms as VALOR_ICMS, l.valorIcmsSt as VALOR_ICMS_ST, l.valorBCIcmsSt as BC_ICMS_ST, l.cfop.codigo as CFOP, l.incidenciaIcms.codigo as CODIGO_INC_ICMS, l.incidenciaIcms.descricao as DESCRICAO_INC_ICMS, l.cidade.descricao as CIDADE,  l.cidade.identificador as ID_CIDADE,  l.cidade.uf.sigla  as UF,  l.cidade.uf.identificador  as ID_UF,  n.empresa.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL from ReducaoZ n inner join n.livrosFiscais l WHERE      (:filtrarData         <>1 OR l.dataLivro between :dataInicial and :dataFinal) AND (:filtrarEmpresa      <>1 OR l.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (l.cidade.uf.identificador between :idUfInicial and :idUfFinal) AND (l.cancelado = :naoCancelado) ORDER BY l.empresa.pessoa.endereco.cidade.uf.identificador";
        if (quebrarCidade == 1) {
            hql = (String)hql + ", l.cidade.identificador";
        }
        if (quebrarCFOP == 1) {
            hql = (String)hql + ", l.cfop.codigo";
        }
        if (quebrarCST == 1) {
            hql = (String)hql + ", l.incidenciaIcms.codigo";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", empresaInicial.longValue());
        q.setLong("idEmpresaFinal", empresaFinal.longValue());
        if (idUF != null) {
            q.setLong("idUfInicial", idUF.longValue());
            q.setLong("idUfFinal", idUF.longValue());
        } else {
            q.setLong("idUfInicial", 0L);
            q.setLong("idUfFinal", 999999L);
        }
        q.setShort("naoCancelado", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static Collection gerarDadosNotaPropriaEntrada(Short filtrarData, Date dataInicial, Date dataFinal, Long idUF, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short quebrarCidade, Short quebrarCFOP, Short quebrarCST, Short naoExibirUFEmitente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select  l.valorTotal as VALOR_CONTABIL, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsSemAprov as VALOR_ICMS_SEM_APROV, l.valorIcmsIsento as VALOR_ICMS_ISENTO, l.valorIcmsOutros as VALOR_ICMS_OUTROS, l.valorIcms as VALOR_ICMS, l.valorIcmsSt as VALOR_ICMS_ST, l.valorBCIcmsSt as BC_ICMS_ST, l.cfop.codigo as CFOP, l.incidenciaIcms.codigo as CODIGO_INC_ICMS, l.incidenciaIcms.descricao as DESCRICAO_INC_ICMS, l.cidade.descricao as CIDADE,  l.cidade.identificador as ID_CIDADE,  l.cidade.uf.sigla  as UF,  l.cidade.uf.identificador  as ID_UF,  n.unidadeFatCliente.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL from NotaFiscalPropria n inner join n.livrosFiscais l WHERE      (:filtrarData         <>1 OR l.dataLivro between :dataInicial and :dataFinal) AND (:filtrarEmpresa      <>1 OR l.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (l.cidade.uf.identificador between :idUfInicial and :idUfFinal) AND (n.situacaoDocumento.codigo <> :cancelado AND n.situacaoDocumento.codigo <> :canceladoExtemporaneo) AND (n.naturezaOperacao.entradaSaida = 0 OR n.naturezaOperacao.entradaSaida = 2)";
        if (naoExibirUFEmitente.equals((short)1)) {
            hql = (String)hql + " AND n.unidadeFatCliente.pessoa.endereco.cidade.uf <> n.empresa.pessoa.endereco.cidade.uf";
        }
        hql = (String)hql + " ORDER BY l.cidade.uf.identificador";
        if (quebrarCidade == 1) {
            hql = (String)hql + ", l.cidade.identificador";
        }
        if (quebrarCFOP == 1) {
            hql = (String)hql + ", l.cfop.codigo";
        }
        if (quebrarCST == 1) {
            hql = (String)hql + ", l.incidenciaIcms.codigo";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", empresaInicial.longValue());
        q.setLong("idEmpresaFinal", empresaFinal.longValue());
        if (idUF != null) {
            q.setLong("idUfInicial", idUF.longValue());
            q.setLong("idUfFinal", idUF.longValue());
        } else {
            q.setLong("idUfInicial", 0L);
            q.setLong("idUfFinal", 999999L);
        }
        q.setString("cancelado", "02");
        q.setString("canceladoExtemporaneo", "03");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection gerarDadosNotaTerceirosEntrada(Short filtrarData, Date dataInicial, Date dataFinal, Long idUF, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Short quebrarCidade, Short quebrarCFOP, Short quebrarCST, Short naoExibirUFEmitente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select  l.valorTotal as VALOR_CONTABIL, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsSemAprov as VALOR_ICMS_SEM_APROV, l.valorIcmsIsento as VALOR_ICMS_ISENTO, l.valorIcmsOutros as VALOR_ICMS_OUTROS, l.valorIcms as VALOR_ICMS, l.valorIcmsSt as VALOR_ICMS_ST, l.valorBCIcmsSt as BC_ICMS_ST, l.cfop.codigo as CFOP, l.incidenciaIcms.codigo as CODIGO_INC_ICMS, l.incidenciaIcms.descricao as DESCRICAO_INC_ICMS, l.cidade.descricao as CIDADE,  l.cidade.identificador as ID_CIDADE,  l.cidade.uf.sigla  as UF,  l.cidade.uf.identificador  as ID_UF,  n.unidadeFatFornecedor.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL from NotaFiscalTerceiros n inner join n.livrosFiscais l WHERE      (:filtrarData         <>1 OR l.dataLivro between :dataInicial and :dataFinal) AND (:filtrarEmpresa      <>1 OR l.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal) AND (l.cidade.uf.identificador between :idUfInicial and :idUfFinal) AND (n.situacaoDocumento.codigo <> :cancelado AND n.situacaoDocumento.codigo <> :canceladoExtemporaneo) AND (l.entradaSaidaNaturezaOp = 0 OR l.entradaSaidaNaturezaOp = 2)";
        if (naoExibirUFEmitente.equals((short)1)) {
            hql = (String)hql + " AND l.cidade.uf <> n.empresa.pessoa.endereco.cidade.uf";
        }
        hql = (String)hql + " ORDER BY l.cidade.uf.identificador";
        if (quebrarCidade == 1) {
            hql = (String)hql + ", l.cidade.identificador";
        }
        if (quebrarCFOP == 1) {
            hql = (String)hql + ", l.cfop.codigo";
        }
        if (quebrarCST == 1) {
            hql = (String)hql + ", l.incidenciaIcms.codigo";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresaInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpresaFinal", idEmpresaFinal.longValue());
        if (idUF != null) {
            q.setLong("idUfInicial", idUF.longValue());
            q.setLong("idUfFinal", idUF.longValue());
        } else {
            q.setLong("idUfInicial", 0L);
            q.setLong("idUfFinal", 999999L);
        }
        q.setString("cancelado", "02");
        q.setString("canceladoExtemporaneo", "03");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static void setarParametros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarEmpresa, Long idEmpresaInicial, Long idEmpresaFinal, Long idUF, Short tipo, Short exibirNotas, Short exibirCte, Short quebrarCST, Short quebrarCFOP, Short quebrarCidade, String fecho, HashMap params) {
        params.put("FILTRAR_DATA", filtrarData);
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FILTRAR_EMPRESA", filtrarEmpresa);
        params.put("EMPRESA_INICIAL", idEmpresaInicial);
        params.put("EMPRESA_FINAL", idEmpresaFinal);
        params.put("UF_INICIAL", idUF);
        params.put("UF_FINAL", idUF);
        params.put("FECHO", fecho);
        params.put("TIPO_RELATORIO", tipo);
        params.put("EXIBIR_NOTAS", exibirNotas);
        params.put("EXIBIR_CTE", exibirCte);
        params.put("QUEBRAR_CST", quebrarCST);
        params.put("QUEBRAR_CFOP", quebrarCFOP);
        params.put("QUEBRAR_CIDADE", quebrarCidade);
    }

    private Object getDados(List dados) {
        if (dados != null) {
            for (Object o : dados) {
                HashMap h = (HashMap)o;
                if (h.get("INSCRICAO_ESTADUAL") != null) continue;
                h.put("INSCRICAO_ESTADUAL", "ISENTO");
            }
        }
        return dados;
    }

    private List getEventosOrdenados(List lista) {
        if (lista != null) {
            this.getDados(lista);
            Collections.sort(lista, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap item1 = (HashMap)o1;
                    HashMap item2 = (HashMap)o2;
                    if (item1.get("ID_UF") != null && item2.get("ID_UF") != null) {
                        Long vlr1 = (long)((Long)item1.get("ID_UF"));
                        Long vlr2 = (long)((Long)item2.get("ID_UF"));
                        return vlr1.compareTo(vlr2);
                    }
                    return 0;
                }
            });
            return lista;
        }
        return null;
    }
}

