/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemMovCfop {
    UtilGerarListagemMovCfop() {
    }

    JasperPrint gerarListagemMovCFOP(Short tipoRelatorio, Short filtrarData, Date dataIn, Date dataFim, Short filtrarOpcoesCfop, Short cfopDevolVenda, Short cfopDevolCompra, Short cfopIndustria, Short cfopReceitaVEnda, Short filtrarCfop, Cfop cfop, Short filtrarEmpresa, Long empInicial, Long empFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarNaturezaOperacao, Long naturezaOperacaoInicial, Long naturezaOperacaoFinal, Short filtrarClassificacaoCliente, ClassificacaoClientes classificacaoCliente, Nodo nodo, HashMap params) throws ExceptionService {
        LinkedList movimentos = new LinkedList();
        if (tipoRelatorio == 0 || tipoRelatorio == 2) {
            movimentos.addAll(this.getNFTerceiros(filtrarData, dataIn, dataFim, filtrarOpcoesCfop, cfopDevolCompra, cfopDevolVenda, cfopIndustria, cfopReceitaVEnda, filtrarCfop, cfop, filtrarEmpresa, empInicial, empFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarNaturezaOperacao, naturezaOperacaoInicial, naturezaOperacaoFinal, filtrarClassificacaoCliente, classificacaoCliente));
            movimentos.addAll(this.getNFProprias(filtrarData, dataIn, dataFim, filtrarOpcoesCfop, cfopDevolCompra, cfopDevolVenda, cfopIndustria, cfopReceitaVEnda, filtrarCfop, cfop, filtrarEmpresa, empInicial, empFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarNaturezaOperacao, naturezaOperacaoInicial, naturezaOperacaoFinal, (short)2, filtrarClassificacaoCliente, classificacaoCliente));
        }
        if (tipoRelatorio == 1 || tipoRelatorio == 2) {
            movimentos.addAll(this.getNFProprias(filtrarData, dataIn, dataFim, filtrarOpcoesCfop, cfopDevolCompra, cfopDevolVenda, cfopIndustria, cfopReceitaVEnda, filtrarCfop, cfop, filtrarEmpresa, empInicial, empFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarNaturezaOperacao, naturezaOperacaoInicial, naturezaOperacaoFinal, (short)1, filtrarClassificacaoCliente, classificacaoCliente));
        }
        this.ordenarMovimentos(movimentos);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo).setAttribute("isPaisagem", true), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "listagens" + File.separator + "listagemmovimentoscfop" + File.separator + "LISTAGEM_MOVIMENTOS_CFOP.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", movimentos);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private Collection getNFTerceiros(Short filtrarData, Date dataIn, Date dataFim, Short filtrarOpcoesCfop, Short cfopDevolCompra, Short cfopDevolVenda, Short cfopIndustria, Short cfopReceitaVEnda, Short filtrarCfop, Cfop cfop, Short filtrarEmpresa, Long empInicial, Long empFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarNaturezaOperacao, Long naturezaOperacaoInicial, Long naturezaOperacaoFinal, Short filtrarClassificacaoCliente, ClassificacaoClientes classificacaoCliente) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select n.numeroNota as                 NUMERO_NOTA,n.serie as                           SERIE,n.dataEntrada as                     DATA_MOVIMENTO,f.identificador as                   ID_PARCEIRO,ps.nome as                           NOME,cl.cnpj as                           CNPJ,p.identificador as                   ID_PRODUTO,p.nome as                            PRODUTO,i.quantidadeTotal as                 QUANTIDADE_TOTAL_PRODUTOS,p.codigoAuxiliar as                  CODIGO_AUXILIAR,c.codigo as                          CODIGO_CFOP,c.descricao as                       CFOP,c.cfopDevolucaoVenda as              CFOP_DEVOL_VENDA,c.cfopDevolucaoCompra as             CFOP_DEVOL_COMPRA,c.cfopReceitaVenda AS                CFOP_RECEITA_VENDA,c.cfopIndustrializacao as            CFOP_INDUSTRIALIZACAO,sum(il.valorTotal) as                VALOR_TOTAL,sum(il.vrIcms) as                    VALOR_ICMS,sum(i.vrProduto + i.vrServico) as    VALOR_PROD_SERVICO from NotaFiscalTerceiros            n inner join n.unidadeFatFornecedor   u inner join u.fornecedor             f inner join f.pessoa                 ps inner join ps.complemento           cl inner join n.empresa                e inner join n.itemNotaTerceiros      i inner join i.produto                p inner join i.itemNotaLivroFiscal    il inner join il.cfop                  c inner join i.naturezaOperacao       no where (:filtrarData<>1 or n.dataEntrada between :dataIn and :dataFim) and (:filtrarOpcoesCfop <> 1 or (c.cfopDevolucaoCompra=:cfopDevolCompra or c.cfopDevolucaoVenda=:cfopDevolVenda or c.cfopReceitaVenda=:cfopReceitaVEnda or c.cfopIndustrializacao=:cfopIndustria)) and (:filtrarEmpresa <> 1 or e.identificador between :empInicial and :empFinal) and (:filtrarCfop <> 1 or c.identificador = :idCfop) and (:filtrarProduto <> 1 or p.identificador between :produtoInicial and :produtoFinal) and (:filtrarNaturezaOperacao <> 1 or no.identificador between :naturezaOperacaoInicial and :naturezaOperacaoFinal) and (:filtrarClassificacaoCliente <> 1 or n.classificacaoPessoas = :classificacaoCliente) group by n.numeroNota , n.serie , n.dataEntrada , f.identificador, ps.nome, cl.cnpj, p.identificador , p.nome , i.quantidadeTotal , p.codigoAuxiliar , c.codigo , c.descricao,  c.descricao, c.cfopDevolucaoVenda, c.cfopDevolucaoCompra , c.cfopReceitaVenda , c.cfopIndustrializacao order by c.codigo, n.dataEntrada ");
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("filtrarOpcoesCfop", filtrarOpcoesCfop.shortValue());
        q.setShort("cfopDevolCompra", cfopDevolCompra == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopDevolVenda", cfopDevolVenda == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopReceitaVEnda", cfopReceitaVEnda == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopIndustria", cfopIndustria == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        if (filtrarEmpresa != null && filtrarEmpresa == 1) {
            q.setLong("empInicial", empInicial.longValue());
            q.setLong("empFinal", empFinal.longValue());
        } else {
            q.setLong("empInicial", 0L);
            q.setLong("empFinal", 0L);
        }
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        if (filtrarProduto != null && filtrarProduto == 1) {
            q.setLong("produtoInicial", produtoInicial.longValue());
            q.setLong("produtoFinal", produtoFinal.longValue());
        } else {
            q.setLong("produtoInicial", 0L);
            q.setLong("produtoFinal", 0L);
        }
        q.setShort("filtrarNaturezaOperacao", filtrarNaturezaOperacao.shortValue());
        if (filtrarNaturezaOperacao != null && filtrarNaturezaOperacao == 1) {
            q.setLong("naturezaOperacaoInicial", naturezaOperacaoInicial.longValue());
            q.setLong("naturezaOperacaoFinal", naturezaOperacaoFinal.longValue());
        } else {
            q.setLong("naturezaOperacaoInicial", 0L);
            q.setLong("naturezaOperacaoFinal", 0L);
        }
        q.setShort("filtrarCfop", filtrarCfop.shortValue());
        if (filtrarCfop != null && filtrarCfop == 1) {
            q.setLong("idCfop", cfop.getIdentificador().longValue());
        } else {
            q.setLong("idCfop", 0L);
        }
        q.setShort("filtrarClassificacaoCliente", filtrarClassificacaoCliente.shortValue());
        q.setParameter("classificacaoCliente", (Object)classificacaoCliente);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection getNFProprias(Short filtrarData, Date dataIn, Date dataFim, Short filtrarOpcoesCfop, Short cfopDevolCompra, Short cfopDevolVenda, Short cfopIndustria, Short cfopReceitaVEnda, Short filtrarCfop, Cfop cfop, Short filtrarEmpresa, Long empInicial, Long empFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarNaturezaOperacao, Long naturezaOperacaoInicial, Long naturezaOperacaoFinal, short tipoNaturezaOperacao, Short filtrarClassificacaoCliente, ClassificacaoClientes classificacaoCliente) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select n.numeroNota                as NUMERO_NOTA,n.serie                          as SERIE,n.dataEmissaoNota                as DATA_MOVIMENTO,f.identificador                  as ID_PARCEIRO,ps.nome                          as NOME,cl.cnpj                          as CNPJ,p.identificador                  as ID_PRODUTO,p.nome                           as PRODUTO,i.quantidadeTotal                as QUANTIDADE_TOTAL_PRODUTOS,p.codigoAuxiliar                 as CODIGO_AUXILIAR,c.codigo                         as CODIGO_CFOP,c.descricao                      as CFOP,c.cfopDevolucaoVenda             as CFOP_DEVOL_VENDA,c.cfopDevolucaoCompra            as CFOP_DEVOL_COMPRA,c.cfopReceitaVenda               AS CFOP_RECEITA_VENDA,c.cfopIndustrializacao           as CFOP_INDUSTRIALIZACAO,sum(il.valorTotal)               as VALOR_TOTAL,sum(il.vrIcms)                   as VALOR_ICMS,sum(i.vrProduto + i.vrServico)   as VALOR_PROD_SERVICO from NotaFiscalPropria              n inner join n.naturezaOperacao       no inner join n.unidadeFatCliente      u inner join u.cliente                f inner join f.pessoa                 ps inner join ps.complemento           cl inner join n.empresa                e inner join n.itensNotaPropria       i inner join i.produto                p inner join i.itemNotaLivroFiscal    il inner join il.cfop                  c where   (:filtrarData<>1 or n.dataEmissaoNota between :dataIn and :dataFim) and (:filtrarOpcoesCfop <> 1 or (c.cfopDevolucaoCompra=:cfopDevolCompra or c.cfopDevolucaoVenda=:cfopDevolVenda or c.cfopReceitaVenda=:cfopReceitaVEnda or c.cfopIndustrializacao=:cfopIndustria)) and (:filtrarEmpresa<>1 or e.identificador between :empInicial and :empFinal) and (:filtrarCfop<>1 or c.identificador = :idCfop) and (:filtrarProduto <> 1 or p.identificador between :produtoInicial and :produtoFinal) and (:filtrarNaturezaOperacao <> 1 or no.identificador between :naturezaOperacaoInicial and :naturezaOperacaoFinal) and (:filtrarClassificacaoCliente <> 1 or n.classificacaoCliente = :classificacaoCliente) and no.entradaSaida = :entradaSaida and (n.situacaoDocumento.codigo <> :cod1 and n.situacaoDocumento.codigo <> :cod2 and n.situacaoDocumento.codigo <> :cod3) group by n.numeroNota , n.serie , n.dataEmissaoNota , f.identificador, ps.nome, cl.cnpj, p.identificador , p.nome , i.quantidadeTotal , p.codigoAuxiliar , c.codigo , c.descricao,  c.descricao, c.cfopDevolucaoVenda, c.cfopDevolucaoCompra , c.cfopReceitaVenda , c.cfopIndustrializacao order by c.codigo, n.dataEmissaoNota");
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("filtrarOpcoesCfop", filtrarOpcoesCfop.shortValue());
        q.setShort("cfopDevolCompra", cfopDevolCompra == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopDevolVenda", cfopDevolVenda == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopReceitaVEnda", cfopReceitaVEnda == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("cfopIndustria", cfopIndustria == 1 ? (short)1 : Short.valueOf("-1"));
        q.setShort("entradaSaida", tipoNaturezaOperacao);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        if (filtrarEmpresa != null && filtrarEmpresa == 1) {
            q.setLong("empInicial", empInicial.longValue());
            q.setLong("empFinal", empFinal.longValue());
        } else {
            q.setLong("empInicial", 0L);
            q.setLong("empFinal", 0L);
        }
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        if (filtrarProduto != null && filtrarProduto == 1) {
            q.setLong("produtoInicial", produtoInicial.longValue());
            q.setLong("produtoFinal", produtoFinal.longValue());
        } else {
            q.setLong("produtoInicial", 0L);
            q.setLong("produtoFinal", 0L);
        }
        q.setShort("filtrarNaturezaOperacao", filtrarNaturezaOperacao.shortValue());
        if (filtrarNaturezaOperacao != null && filtrarNaturezaOperacao == 1) {
            q.setLong("naturezaOperacaoInicial", naturezaOperacaoInicial.longValue());
            q.setLong("naturezaOperacaoFinal", naturezaOperacaoFinal.longValue());
        } else {
            q.setLong("naturezaOperacaoInicial", 0L);
            q.setLong("naturezaOperacaoFinal", 0L);
        }
        q.setShort("filtrarCfop", filtrarCfop.shortValue());
        if (filtrarCfop != null && filtrarCfop == 1) {
            q.setLong("idCfop", cfop.getIdentificador().longValue());
        } else {
            q.setLong("idCfop", 0L);
        }
        q.setShort("filtrarClassificacaoCliente", filtrarClassificacaoCliente.shortValue());
        q.setParameter("classificacaoCliente", (Object)classificacaoCliente);
        q.setString("cod1", "02");
        q.setString("cod2", "03");
        q.setString("cod3", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void ordenarMovimentos(LinkedList movimentos) {
        Collections.sort(movimentos, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                String codCFOP1 = (String)h1.get("CODIGO_CFOP");
                String codCFOP2 = (String)h2.get("CODIGO_CFOP");
                return codCFOP1.compareTo(codCFOP2);
            }
        });
    }
}

