/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGerarListagemRelacaoNcmFaturadosDIPJ {
    protected JasperPrint gerarListagemRelacaoNCMFaturadosDIPJ(List ncm, List cfop, Date dataIn, Date dataFim, Empresa empresa, Integer tipoRelatorio, Nodo nodo, String fecho, HashMap params) throws ExceptionService {
        ArrayList dados = new ArrayList();
        dados.addAll(this.putDadosNotas(ncm, cfop, dataIn, dataFim, empresa));
        this.setarParametros(dataIn, dataFim, empresa, tipoRelatorio, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "listagens" + File.separator + "listagemrelacaoncmfaturadosdipj" + File.separator + "LISTAGEM_RELACAO_NCM_FATURADOS_DIPJ.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List putDadosNotas(List ncm, List cfop, Date dataIn, Date dataFim, Empresa empresa) {
        HashMap h;
        int i;
        Session s = CoreBdUtil.getInstance().getSession();
        Object st = "select il.valorTotal as VALOR_CONTABIL, il.vrIcmsTributado as VR_BC_ICMS, il.vrIcms as VR_ICMS, il.vrIcmsSemAprov as VR_ICMS_SA, il.vrIcmsOutros as VR_ICMS_OUTROS, il.vrIcmsIsento as VR_ICMS_ISENTO, il.vrBcCalculoIcmsSt as VR_BC_ICMS_ST, il.vrIcmsSt as VR_ICMS_ST, n.serie as SERIE, n.numeroNota as NUMERO_NOTA, il.cfop.codigo as CODIGO_CFOP, i.produto.ncm.codigo as CODIGO_NCM, i.produto.ncm.descricao as DESCRICAO_NCM, n.dataEmissaoNota as DATA_ENTRADA_SAIDA   from NotaFiscalPropria n inner join n.situacaoDocumento s inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal il where n.dataEmissaoNota between :dataIn and :dataFim and (s.codigo= :cod1 or s.codigo=:cod2 or s.codigo =:cod3 or s.codigo=:cod4 or s.codigo=:cod5) and n.empresa = :empresa";
        if (!cfop.isEmpty()) {
            st = (String)st + " and (";
            i = 1;
            for (Object o : cfop) {
                h = (HashMap)o;
                st = (String)st + " replace(il.cfop.codigo,'.','') between " + String.valueOf(h.get("CFOP_INICIAL")) + " and " + String.valueOf(h.get("CFOP_FINAL"));
                if (i < cfop.size()) {
                    st = (String)st + " or ";
                }
                ++i;
            }
            st = (String)st + ")";
        }
        if (!ncm.isEmpty()) {
            st = (String)st + " and (";
            i = 1;
            for (Object o : ncm) {
                h = (HashMap)o;
                st = (String)st + " i.produto.ncm.codigo between " + String.valueOf(h.get("NCM_INICIAL")) + " and " + String.valueOf(h.get("NCM_FINAL"));
                if (i < ncm.size()) {
                    st = (String)st + " or ";
                }
                ++i;
            }
            st = (String)st + ")";
        }
        st = (String)st + " order by i.produto.ncm.codigo,il.cfop.codigo,n.dataEmissaoNota";
        Query q = s.createQuery((String)st);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setString("cod1", "00");
        q.setString("cod2", "01");
        q.setString("cod3", "06");
        q.setString("cod4", "07");
        q.setString("cod5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void setarParametros(Date dataInicial, Date dataFinal, Empresa empresa, Integer tipoRelatorio, String fecho, HashMap params) {
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("ID_EMPRESA_INICIAL", empresa.getIdentificador());
        params.put("ID_EMPRESA_FINAL", empresa.getIdentificador());
        params.put("TIPO_RELATORIO", tipoRelatorio);
        params.put("FECHO", fecho);
    }
}

