/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarLivroFiscalEntrada {
    UtilGerarLivroFiscalEntrada() {
    }

    protected JasperPrint gerarLivroFiscalEntrada(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta, Integer folha, Short imprimirNomePessoa, Short imprimirResumoCfop, Short imprimirResumoUF, Short imprimirStCusto, Nodo nodo, String fecho, HashMap params) throws ExceptionService {
        ArrayList<HashMap> dados = new ArrayList<HashMap>();
        dados.addAll(this.putDadosEntradaNotasTerceiros(dataInicial, dataFinal, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPessoa, idPessoa, filtrarPlanoConta, idPlanoConta));
        dados.addAll(this.putDadosEntradaNotasProprias(dataInicial, dataFinal, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPessoa, idPessoa, filtrarPlanoConta, idPlanoConta));
        this.processarDados(dados);
        if (imprimirResumoCfop.equals((short)1)) {
            this.gerarDadosResumoCFOP(dados, params);
        }
        if (imprimirResumoUF.equals((short)1)) {
            this.gerarDadosResumoUF(dados, params);
        }
        this.setarParametros(dataInicial, dataFinal, idEmpresa, folha, imprimirNomePessoa, imprimirResumoCfop, imprimirResumoUF, imprimirStCusto, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "livrosfiscais" + File.separator + "livrofiscalentrada" + File.separator + "LIVRO_FISCAL_ENTRADA.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private void ordenarPorCfop(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                Long cfop1 = (Long)h1.get("ID_CFOP");
                Long cfop2 = (Long)h2.get("ID_CFOP");
                return cfop1.compareTo(cfop2);
            }
        });
    }

    private void processarDados(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                Integer tipo1 = (Integer)h1.get("TIPO");
                Integer tipo2 = (Integer)h2.get("TIPO");
                if (tipo1 == 2 && tipo2 == 2) {
                    Date data1 = (Date)h1.get("DATA_EMISSAO");
                    Date data2 = (Date)h2.get("DATA_EMISSAO");
                    return data1.compareTo(data2);
                }
                if (tipo1 == 3 && tipo2 == 3) {
                    Date data1 = (Date)h1.get("DATA_ENTRADA_SAIDA");
                    Date data2 = (Date)h2.get("DATA_ENTRADA_SAIDA");
                    return data1.compareTo(data2);
                }
                if (tipo1 == 2 && tipo2 == 3) {
                    Date data1 = (Date)h1.get("DATA_EMISSAO");
                    Date data2 = (Date)h2.get("DATA_ENTRADA_SAIDA");
                    return data1.compareTo(data2);
                }
                Date data1 = (Date)h1.get("DATA_ENTRADA_SAIDA");
                Date data2 = (Date)h2.get("DATA_EMISSAO");
                return data1.compareTo(data2);
            }
        });
    }

    private Collection<? extends HashMap> putDadosEntradaNotasTerceiros(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO, l.identificador as ID_LIVRO, n.identificador as ID_NOTA, n.numeroNota as NUMERO_NOTA, 3 as TIPO, n.serie as SERIE, n.dataEntrada as DATA_ENTRADA_SAIDA, n.dataEmissao as DATA_EMISSAO, n.unidadeFatFornecedor.fornecedor.identificador as ID_FORNECEDOR, n.unidadeFatFornecedor.fornecedor.pessoa.nome as NOME_PESSOA, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as CNPJ_FORNECEDOR, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL, l.uf.sigla as SIGLA, l.valorTotal as VALOR_TOTAL, pc.reduzida as REDUZIDA, l.cfop.identificador as ID_CFOP, l.cfop.codigo as CODIGO_CFOP, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsIsento    as VALOR_ICMS_ISENTO, l.valorIcmsOutros + l.valorFCPSt as VALOR_ICMS_OUTROS, l.aliquotaIcms as ALIQUOTA_ICMS, l.valorIcms as VALOR_ICMS, l.valorIpiTributado as VALOR_IPI_TRIBUTADO, l.valorIpiIsento as VALOR_IPI_ISENTO, l.valorIpiOutros as VALOR_IPI_OUTROS, (l.valorIpiIndustria  + l.valorIpiComercio) as IMPOSTO_CREDITADO, l.valorIpiObservacao as VALOR_IPI_OBSERVACAO, l.valorBCIcmsSt as VALOR_BC_ICMS_ST, l.valorIcmsSt as VALOR_ICMS_ST, l.vrBCCustoICMSST as VALOR_BC_ICMS_ST_CUSTO, l.vrCustoICMSST as VALOR_ICMS_ST_CUSTO, l.valorIpiIndustria as VALOR_IPI_INDUSTRIA, n.situacaoDocumento.codigo as CODIGO_SIT_DOC, n.modeloDocFiscal.codigo as CODIGO_MOD_DOC from NotaFiscalTerceiros n inner join n.livrosFiscais l left  join l.planoConta pc  where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa and (l.entradaSaidaNaturezaOp = :op1 OR l.entradaSaidaNaturezaOp = :op2) and (l.cancelado = :nao)";
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarModDocFiscal == 1) {
            hql = (String)hql + " and n.modeloDocFiscal.identificador = :idModeloDocFiscal";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        if (filtrarPessoa == 1) {
            hql = (String)hql + " and  n.unidadeFatFornecedor.fornecedor.pessoa.identificador = :idPessoa";
        }
        hql = (String)hql + " ORDER BY l.dataLivro, n.numeroNota";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("op1", (short)0);
        q.setShort("op2", (short)2);
        q.setShort("nao", (short)0);
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarModDocFiscal == 1) {
            q.setLong("idModeloDocFiscal", idModeloDocFiscal.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        if (filtrarPessoa == 1) {
            q.setLong("idPessoa", idPessoa.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection<? extends HashMap> putDadosEntradaNotasProprias(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO, l.identificador as ID_LIVRO, n.identificador as ID_NOTA, n.numeroNota as NUMERO_PROPRIA, 2 as TIPO, n.serie as SERIE_PROPRIA, n.dataEntradaSaida as DATA_ENTRADA_SAIDA, n.dataEmissaoNota as DATA_EMISSAO, n.unidadeFatCliente.cliente.identificador as ID_CLIENTE, n.unidadeFatCliente.cliente.pessoa.nome as NOME_PESSOA, n.unidadeFatCliente.cliente.pessoa.complemento.cnpj as CNPJ_FORNECEDOR, n.unidadeFatCliente.cliente.pessoa.complemento.inscEst as INSCRICAO_ESTADUAL, l.uf.sigla as SIGLA, l.valorTotal as VALOR_TOTAL, pc.reduzida as REDUZIDA, l.cfop.identificador as ID_CFOP, l.cfop.codigo as CODIGO_CFOP, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsIsento    as VALOR_ICMS_ISENTO, l.valorIcmsOutros + l.valorFCPSt   as VALOR_ICMS_OUTROS, l.aliquotaIcms as ALIQUOTA_ICMS, l.valorIcms as VALOR_ICMS, l.valorIpiTributado as VALOR_IPI_TRIBUTADO, l.valorIpiIsento as VALOR_IPI_ISENTO, l.valorIpiOutros as VALOR_IPI_OUTROS, (l.valorIpiIndustria  + l.valorIpiComercio) as IMPOSTO_CREDITADO, l.valorIpiObservacao as VALOR_IPI_OBSERVACAO, l.valorBCIcmsSt as VALOR_BC_ICMS_ST, l.valorIcmsSt as VALOR_ICMS_ST, l.vrBCCustoICMSST as VALOR_BC_ICMS_ST_CUSTO, l.vrCustoICMSST as VALOR_ICMS_ST_CUSTO, l.valorIpiIndustria as VALOR_IPI_INDUSTRIA, n.situacaoDocumento.codigo as CODIGO_SIT_DOC, n.modeloDocFiscal.codigo as CODIGO_MOD_DOC from NotaFiscalPropria n inner join n.livrosFiscais l left  join l.planoConta pc  where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa and (l.entradaSaidaNaturezaOp = :op1) and (l.cancelado is null or l.cancelado = :naoCancelado)";
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarModDocFiscal == 1) {
            hql = (String)hql + " and n.modeloDocFiscal.identificador = :idModeloDocFiscal";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        if (filtrarPessoa == 1) {
            hql = (String)hql + " and  n.unidadeFatCliente.cliente.pessoa.identificador = :idPessoa";
        }
        hql = (String)hql + " ORDER BY l.dataLivro, n.numeroNota";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("op1", (short)2);
        q.setShort("naoCancelado", (short)0);
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarModDocFiscal == 1) {
            q.setLong("idModeloDocFiscal", idModeloDocFiscal.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        if (filtrarPessoa == 1) {
            q.setLong("idPessoa", idPessoa.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void setarParametros(Date dataInicial, Date dataFinal, Long idEmpresa, Integer folha, Short imprimirNomeCliente, Short imprimirResumoCfop, Short imprimirResumoUf, Short imprimirStCusto, String fecho, HashMap params) {
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FOLHA", folha);
        params.put("ID_EMPRESA", idEmpresa);
        params.put("IMPRIMIR_NOME_PESSOA", imprimirNomeCliente);
        params.put("IMPRIMIR_RESUMO_CFOP", imprimirResumoCfop);
        params.put("IMPRIMIR_RESUMO_UF", imprimirResumoUf);
        params.put("IMPRIMIR_ICMS_ST_CUSTO", imprimirStCusto);
        params.put("FECHO", fecho);
    }

    private void gerarDadosResumoCFOP(List<HashMap> dados, HashMap params) {
        HashMap hashCfop = new HashMap();
        for (HashMap h : dados) {
            String cfop = (String)h.get("CODIGO_CFOP");
            if (hashCfop.containsKey(cfop)) {
                HashMap hh = (HashMap)hashCfop.get(cfop);
                hh.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL") + (Double)hh.get("VALOR_TOTAL"));
                hh.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO") + (Double)hh.get("VALOR_ICMS_TRIBUTADO"));
                hh.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO") + (Double)hh.get("VALOR_ICMS_ISENTO"));
                hh.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS") + (Double)hh.get("VALOR_ICMS_OUTROS"));
                hh.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS") + (Double)hh.get("VALOR_ICMS"));
                hh.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO") + (Double)hh.get("VALOR_IPI_TRIBUTADO"));
                hh.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO") + (Double)hh.get("VALOR_IPI_ISENTO"));
                hh.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS") + (Double)hh.get("VALOR_IPI_OUTROS"));
                hh.put("IMPOSTO_CREDITADO", (Double)h.get("IMPOSTO_CREDITADO") + (Double)hh.get("IMPOSTO_CREDITADO"));
                hh.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO") + (Double)hh.get("VALOR_IPI_OBSERVACAO"));
                hh.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA") + (Double)hh.get("VALOR_IPI_INDUSTRIA"));
                hh.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST") + (Double)hh.get("VALOR_BC_ICMS_ST"));
                hh.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST") + (Double)hh.get("VALOR_ICMS_ST"));
                continue;
            }
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("ID_CFOP", (Long)h.get("ID_CFOP"));
            newHash.put("CODIGO_CFOP", (String)h.get("CODIGO_CFOP"));
            newHash.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL"));
            newHash.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO"));
            newHash.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO"));
            newHash.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS"));
            newHash.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS"));
            newHash.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO"));
            newHash.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO"));
            newHash.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS"));
            newHash.put("IMPOSTO_CREDITADO", (Double)h.get("IMPOSTO_CREDITADO"));
            newHash.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO"));
            newHash.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA"));
            newHash.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST"));
            newHash.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST"));
            hashCfop.put(cfop, newHash);
        }
        ArrayList<HashMap> dadosCFOP = new ArrayList<HashMap>();
        Set chaves = hashCfop.keySet();
        for (Object ob : chaves) {
            String chave = (String)ob;
            HashMap h = (HashMap)hashCfop.get(chave);
            dadosCFOP.add(h);
        }
        this.ordenarPorCfop(dadosCFOP);
        params.put("DADOS_CFOP", dadosCFOP);
    }

    private void gerarDadosResumoUF(List<HashMap> dados, HashMap params) {
        HashMap hashUF = new HashMap();
        for (HashMap h : dados) {
            String uf = (String)h.get("SIGLA");
            if (hashUF.containsKey(uf)) {
                HashMap hh = (HashMap)hashUF.get(uf);
                hh.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL") + (Double)hh.get("VALOR_TOTAL"));
                hh.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO") + (Double)hh.get("VALOR_ICMS_TRIBUTADO"));
                hh.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO") + (Double)hh.get("VALOR_ICMS_ISENTO"));
                hh.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS") + (Double)hh.get("VALOR_ICMS_OUTROS"));
                hh.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS") + (Double)hh.get("VALOR_ICMS"));
                hh.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO") + (Double)hh.get("VALOR_IPI_TRIBUTADO"));
                hh.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO") + (Double)hh.get("VALOR_IPI_ISENTO"));
                hh.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS") + (Double)hh.get("VALOR_IPI_OUTROS"));
                hh.put("IMPOSTO_CREDITADO", (Double)h.get("IMPOSTO_CREDITADO") + (Double)hh.get("IMPOSTO_CREDITADO"));
                hh.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO") + (Double)hh.get("VALOR_IPI_OBSERVACAO"));
                hh.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA") + (Double)hh.get("VALOR_IPI_INDUSTRIA"));
                hh.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST") + (Double)hh.get("VALOR_BC_ICMS_ST"));
                hh.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST") + (Double)hh.get("VALOR_ICMS_ST"));
                continue;
            }
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("SIGLA", (String)h.get("SIGLA"));
            newHash.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL"));
            newHash.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO"));
            newHash.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO"));
            newHash.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS"));
            newHash.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS"));
            newHash.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO"));
            newHash.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO"));
            newHash.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS"));
            newHash.put("IMPOSTO_CREDITADO", (Double)h.get("IMPOSTO_CREDITADO"));
            newHash.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO"));
            newHash.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA"));
            newHash.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST"));
            newHash.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST"));
            hashUF.put(uf, newHash);
        }
        ArrayList<HashMap> dadosUF = new ArrayList<HashMap>();
        Set chaves = hashUF.keySet();
        for (Object ob : chaves) {
            String chave = (String)ob;
            HashMap h = (HashMap)hashUF.get(chave);
            dadosUF.add(h);
        }
        params.put("DADOS_UF", dadosUF);
    }
}

