/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensfiscais;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoCTe;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarLivroFiscalSaida {
    UtilGerarLivroFiscalSaida() {
    }

    protected JasperPrint gerarLivroFiscalSaida(Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta, Short filtrarNotasProprias, Short filtrarCuponsFiscais, Short filtrarCtes, Short filtrarNFCe, Integer folha, Short imprimirNomeCLiente, Short imprimirResumoCfop, Short imprimirResumoUF, Nodo nodo, String fecho, HashMap params) throws ExceptionService {
        ArrayList<HashMap> dados = new ArrayList<HashMap>();
        if (filtrarNotasProprias == 1) {
            dados.addAll(this.putDadosSaidaNotasProprias(dataInicial, dataFinal, filtrarSerie, serie, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPessoa, idPessoa, filtrarPlanoConta, idPlanoConta));
        }
        if (filtrarCuponsFiscais == 1) {
            dados.addAll(this.putDadosSaidaCuponsFiscais(dataInicial, dataFinal, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPlanoConta, idPlanoConta));
        }
        if (filtrarCtes == 1) {
            dados.addAll(this.putDadosSaidaCTEs(dataInicial, dataFinal, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPlanoConta, idPlanoConta, filtrarPessoa, idPessoa));
        }
        if (filtrarNFCe == 1) {
            dados.addAll(this.putDadosSaidaNFCe(dataInicial, dataFinal, filtrarSerie, serie, idEmpresa, filtrarUF, idUF, filtrarModDocFiscal, idModeloDocFiscal, filtrarIncidenciaIcms, idIncidenciaIcms, filtrarIncidenciaIpi, idIncidenciaIpi, filtrarCfop, idCfop, filtrarPessoa, idPessoa, filtrarPlanoConta, idPlanoConta));
        }
        this.processarDados(dados);
        this.findInutilizacoes(dataInicial, dataFinal, idEmpresa, dados);
        if (imprimirResumoCfop.equals((short)1)) {
            this.gerarDadosResumoCFOP(dados, params);
        }
        if (imprimirResumoUF.equals((short)1)) {
            this.gerarDadosResumoUF(dados, params);
        }
        this.setarParametros(dataInicial, dataFinal, idEmpresa, folha, imprimirNomeCLiente, imprimirResumoCfop, imprimirResumoUF, fecho, params);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "controladoria" + File.separator + "gestaotributos" + File.separator + "livrosfiscais" + File.separator + "livrofiscalsaida" + File.separator + "LIVRO_FISCAL_SAIDA.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private void ordenarPorCfop(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                Long cfop1 = (Long)h1.get("ID_CFOP");
                Long cfop2 = (Long)h2.get("ID_CFOP");
                return cfop1.compareTo(cfop2);
            }
        });
    }

    private void processarDados(List<HashMap> dados) {
        Collections.sort(dados, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                Date data1 = (Date)h1.get("DATA_EMISSAO");
                Date data2 = (Date)h2.get("DATA_EMISSAO");
                if ((data1 = DateUtil.dataSemHora(data1)).equals(data2 = DateUtil.dataSemHora(data2))) {
                    Long nrCte1 = (Long)h1.get("NUMERO_CTE");
                    Long nrCte2 = (Long)h1.get("NUMERO_CTE");
                    if (nrCte1 != null && nrCte2 != null) {
                        return nrCte1.compareTo(nrCte2);
                    }
                    Integer nrNota1 = (Integer)h1.get("NUMERO_NOTA");
                    Integer nrNota2 = (Integer)h1.get("NUMERO_NOTA");
                    if (nrNota1 != null && nrNota2 != null) {
                        return nrNota1.compareTo(nrNota2);
                    }
                    Long nrNFCE1 = (Long)h1.get("NUMERO_NFCE");
                    Long nrNFCE2 = (Long)h1.get("NUMERO_NFCE");
                    if (nrNFCE1 != null && nrNFCE2 != null) {
                        return nrNFCE1.compareTo(nrNFCE2);
                    }
                }
                return data1.compareTo(data2);
            }
        });
    }

    private Collection<? extends HashMap> putDadosSaidaNotasProprias(Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO, n.numeroNota as NUMERO_NOTA, l.identificador as ID_LIVRO_FISCAL, n.serie as SERIE, n.dataEmissaoNota as DATA_EMISSAO, n.unidadeFatCliente.cliente.identificador as ID_CLIENTE, n.unidadeFatCliente.cliente.pessoa.nome as NOME_CLIENTE, n.unidadeFatCliente.cliente.pessoa.complemento.cnpj as CNPJ_CLIENTE,  l.uf.sigla as SIGLA, l.valorTotal as VALOR_TOTAL, pc.reduzida as REDUZIDA, l.cfop.identificador as ID_CFOP, l.cfop.codigo as CODIGO_CFOP, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsIsento    as VALOR_ICMS_ISENTO, (l.valorIcmsOutros) as VALOR_ICMS_OUTROS, l.aliquotaIcms as ALIQUOTA_ICMS, l.valorIcms as VALOR_ICMS, l.valorIpiTributado as VALOR_IPI_TRIBUTADO, l.valorIpiIsento as VALOR_IPI_ISENTO, l.valorIpiOutros as VALOR_IPI_OUTROS, (l.valorIpiIndustria  + l.valorIpiComercio) as VALOR_IPI_COMERCIO, l.valorIpiObservacao as VALOR_IPI_OBSERVACAO, l.valorBCIcmsSt as VALOR_BC_ICMS_ST, l.valorIcmsSt as VALOR_ICMS_ST, l.valorIpiIndustria as VALOR_IPI_INDUSTRIA, n.situacaoDocumento.codigo as COD_SIT_DOC, n.modeloDocFiscal.codigo as CODIGO_MOD_DOC, l.cancelado as CANCELADO, l.entradaSaidaNaturezaOp as ENTRADA_SAIDA_NATUREZA_OP, n.status as STATUS from NotaFiscalPropria n inner join n.livrosFiscais l left  join l.planoConta pc  where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa and (l.entradaSaidaNaturezaOp = :op1 OR l.entradaSaidaNaturezaOp = :op2)";
        if (filtrarSerie == 1) {
            hql = (String)hql + " and n.serie = :serie";
        }
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarModDocFiscal == 1) {
            hql = (String)hql + " and n.modeloDocFiscal.identificador = :idModeloDocFiscal";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        if (filtrarPessoa == 1) {
            hql = (String)hql + " and  n.unidadeFatCliente.cliente.pessoa.identificador = :idPessoa";
        }
        hql = (String)hql + " ORDER BY n.numeroNota, l.dataLivro";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("op1", (short)2);
        q.setShort("op2", (short)1);
        if (filtrarSerie == 1) {
            q.setString("serie", serie);
        }
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarModDocFiscal == 1) {
            q.setLong("idModeloDocFiscal", idModeloDocFiscal.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        if (filtrarPessoa == 1) {
            q.setLong("idPessoa", idPessoa.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection<? extends HashMap> putDadosSaidaCuponsFiscais(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPlanoConta, Long idPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO, n.contadorCRZ as CONTADOR_CRZ, n.valorVendaBruta as VALOR_VENDA_BRUTA, l.identificador as ID_LIVRO_FISCAL, n.dataEmissao as DATA_EMISSAO, l.uf.sigla as SIGLA, l.valorTotal as VALOR_TOTAL, pc.reduzida as REDUZIDA, l.cfop.identificador as ID_CFOP, l.cfop.codigo as CODIGO_CFOP, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsIsento    as VALOR_ICMS_ISENTO, (l.valorIcmsOutros) as VALOR_ICMS_OUTROS, l.aliquotaIcms as ALIQUOTA_ICMS, l.valorIcms as VALOR_ICMS, l.valorIpiTributado as VALOR_IPI_TRIBUTADO, l.valorIpiIsento as VALOR_IPI_ISENTO, l.valorIpiOutros as VALOR_IPI_OUTROS, (l.valorIpiIndustria  + l.valorIpiComercio) as VALOR_IPI_COMERCIO, l.valorIpiObservacao as VALOR_IPI_OBSERVACAO, l.valorBCIcmsSt as VALOR_BC_ICMS_ST, l.valorIcmsSt as VALOR_ICMS_ST, l.valorIpiIndustria as VALOR_IPI_INDUSTRIA, l.cancelado as CANCELADO, l.entradaSaidaNaturezaOp as ENTRADA_SAIDA_NATUREZA_OP from ReducaoZ n inner join n.livrosFiscais l left  join l.planoConta pc  where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa and (l.entradaSaidaNaturezaOp = :op1 OR l.entradaSaidaNaturezaOp = :op2)";
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        hql = (String)hql + " ORDER BY n.contadorCRZ, l.dataLivro";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("op1", (short)2);
        q.setShort("op2", (short)1);
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection<? extends HashMap> putDadosSaidaCTEs(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPlanoConta, Long idPlanoConta, Short filtrarPessoa, Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO, n.numero as NUMERO_CTE, n.serie as SERIE, l.identificador as ID_LIVRO_FISCAL, n.dataEmissao as DATA_EMISSAO, l.uf.sigla as SIGLA, n.clienteTomador.cliente.identificador as ID_CLIENTE, n.clienteTomador.cliente.pessoa.nome as NOME_CLIENTE, n.clienteTomador.cliente.pessoa.complemento.cnpj as CNPJ_CLIENTE,  l.valorTotal as VALOR_TOTAL, pc.reduzida as REDUZIDA, c.identificador as ID_CFOP, c.codigo as CODIGO_CFOP, l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO, l.valorIcmsIsento    as VALOR_ICMS_ISENTO, (l.valorIcmsOutros) as VALOR_ICMS_OUTROS, l.aliquotaIcms as ALIQUOTA_ICMS, l.valorIcms as VALOR_ICMS, l.valorIpiTributado as VALOR_IPI_TRIBUTADO, l.valorIpiIsento as VALOR_IPI_ISENTO, l.valorIpiOutros as VALOR_IPI_OUTROS, (l.valorIpiIndustria  + l.valorIpiComercio) as VALOR_IPI_COMERCIO, l.valorIpiObservacao as VALOR_IPI_OBSERVACAO, l.valorBCIcmsSt as VALOR_BC_ICMS_ST, l.valorIcmsSt as VALOR_ICMS_ST, l.valorIpiIndustria as VALOR_IPI_INDUSTRIA, l.cancelado as CANCELADO, l.entradaSaidaNaturezaOp as ENTRADA_SAIDA_NATUREZA_OP, n.cteInfo.status as STATUS from Cte n inner join n.livrosFiscais l inner join n.clienteTomador t inner join t.cliente c inner join c.pessoa p left  join l.planoConta pc  left  join l.cfop c where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa";
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarPessoa == 1) {
            hql = (String)hql + " and p.identificador = :idPessoa";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        hql = (String)hql + " ORDER BY l.dataLivro, n.numero";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarPessoa == 1) {
            q.setLong("idPessoa", idPessoa.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void setarParametros(Date dataInicial, Date dataFinal, Long idEmpresa, Integer folha, Short imprimirNomeCliente, Short imprimirResumoCfop, Short imprimirResumoUf, String fecho, HashMap params) {
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("FOLHA", folha);
        params.put("DATA_INICIAL", dataInicial);
        params.put("DATA_FINAL", dataFinal);
        params.put("ID_EMPRESA", idEmpresa);
        params.put("IMPRIMIR_NOME_CLIENTE", imprimirNomeCliente);
        params.put("IMPRIMIR_RESUMO_CFOP", imprimirResumoCfop);
        params.put("IMPRIMIR_RESUMO_UF", imprimirResumoUf);
        params.put("FECHO", fecho);
    }

    private Collection<? extends HashMap> putDadosSaidaNFCe(Date dataInicial, Date dataFinal, Short filtrarSerie, String serie, Long idEmpresa, Short filtrarUF, Long idUF, Short filtrarModDocFiscal, Long idModeloDocFiscal, Short filtrarIncidenciaIcms, Long idIncidenciaIcms, Short filtrarIncidenciaIpi, Long idIncidenciaIpi, Short filtrarCfop, Long idCfop, Short filtrarPessoa, Long idPessoa, Short filtrarPlanoConta, Long idPlanoConta) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  l.dataLivro as DATA_LIVRO,  n.numero as NUMERO_NFCE,  l.identificador as ID_LIVRO_FISCAL,  n.serie as SERIE,  n.dataEmissao as DATA_EMISSAO,  cl.identificador as ID_CLIENTE,  ps.nome as NOME_CLIENTE,  com.cnpj as CNPJ_CLIENTE,  l.valorTotal as VALOR_TOTAL,  pc.reduzida as REDUZIDA,  l.valorIcmsTributado as VALOR_ICMS_TRIBUTADO,  l.valorIcmsIsento    as VALOR_ICMS_ISENTO,  (l.valorIcmsOutros) as VALOR_ICMS_OUTROS,  l.aliquotaIcms as ALIQUOTA_ICMS,  l.valorIcms as VALOR_ICMS,  l.valorIpiTributado as VALOR_IPI_TRIBUTADO,  l.valorIpiIsento as VALOR_IPI_ISENTO,  l.valorIpiOutros as VALOR_IPI_OUTROS,  (l.valorIpiIndustria  + l.valorIpiComercio) as VALOR_IPI_COMERCIO,  l.valorIpiObservacao as VALOR_IPI_OBSERVACAO,  l.valorBCIcmsSt as VALOR_BC_ICMS_ST,  l.valorIcmsSt as VALOR_ICMS_ST,  l.valorIpiIndustria as VALOR_IPI_INDUSTRIA,  n.situacaoDocumento.codigo as COD_SIT_DOC,  n.modeloDocFiscal.codigo as CODIGO_MOD_DOC,  l.cancelado as CANCELADO,   l.entradaSaidaNaturezaOp as ENTRADA_SAIDA_NATUREZA_OP,  cast(n.status as short) as STATUS, l.cfop.identificador as ID_CFOP,  l.cfop.codigo as CODIGO_CFOP,  uf.sigla as SIGLA from NFCe n  LEFT JOIN n.unidadeFatCliente ufc  LEFT JOIN ufc.cliente cl  LEFT JOIN cl.pessoa ps  LEFT JOIN ps.complemento com inner join n.livrosFiscais l  left  join l.planoConta pc  LEFT JOIN l.uf uf where     l.dataLivro between :dataInicial and :dataFinal and l.empresa.identificador = :idEmpresa and (l.entradaSaidaNaturezaOp = :op1 )";
        if (filtrarSerie == 1) {
            hql = (String)hql + " and n.serie = :serie";
        }
        if (filtrarUF == 1) {
            hql = (String)hql + " and l.uf.identificador = :idUf";
        }
        if (filtrarModDocFiscal == 1) {
            hql = (String)hql + " and n.modeloDocFiscal.identificador = :idModeloDocFiscal";
        }
        if (filtrarIncidenciaIcms == 1) {
            hql = (String)hql + " and l.incidenciaIcms.identificador = :idIncidenciaIcms";
        }
        if (filtrarIncidenciaIpi == 1) {
            hql = (String)hql + " and l.incidenciaIpi.identificador = :idIncidenciaIpi";
        }
        if (filtrarCfop == 1) {
            hql = (String)hql + " and l.cfop.identificador = :idCfop";
        }
        if (filtrarPlanoConta == 1) {
            hql = (String)hql + " and l.planoConta.identificador = :idPlanoConta";
        }
        if (filtrarPessoa == 1) {
            hql = (String)hql + " and  n.unidadeFatCliente.cliente.pessoa.identificador = :idPessoa";
        }
        hql = (String)hql + " ORDER BY n.numero, l.dataLivro";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("op1", (short)1);
        if (filtrarSerie == 1) {
            q.setString("serie", serie);
        }
        if (filtrarUF == 1) {
            q.setLong("idUf", idUF.longValue());
        }
        if (filtrarModDocFiscal == 1) {
            q.setLong("idModeloDocFiscal", idModeloDocFiscal.longValue());
        }
        if (filtrarIncidenciaIcms == 1) {
            q.setLong("idIncidenciaIcms", idIncidenciaIcms.longValue());
        }
        if (filtrarIncidenciaIpi == 1) {
            q.setLong("idIncidenciaIpi", idIncidenciaIpi.longValue());
        }
        if (filtrarCfop == 1) {
            q.setLong("idCfop", idCfop.longValue());
        }
        if (filtrarPlanoConta == 1) {
            q.setLong("idPlanoConta", idPlanoConta.longValue());
        }
        if (filtrarPessoa == 1) {
            q.setLong("idPessoa", idPessoa.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public void findInutilizacoes(Date dataInicial, Date dataFinal, Long idEmpresa, List dados) {
        List inutilizacoes = this.findInutilizacoesNFe(dataInicial, dataFinal, idEmpresa);
        inutilizacoes.addAll(this.findInutilizacoesCTe(dataInicial, dataFinal, idEmpresa));
        for (Object o : inutilizacoes) {
            InutilizacaoNumeracaoNFe in;
            if (o instanceof InutilizacaoNumeracaoNFe) {
                in = (InutilizacaoNumeracaoNFe)o;
                for (int i = in.getNumeroInicial().intValue(); i <= in.getNumeroFinal(); ++i) {
                    HashMap<String, Object> h = new HashMap<String, Object>();
                    h.put("NUMERO_NOTA", i);
                    h.put("SERIE", in.getSerie());
                    h.put("CODIGO_MOD_DOC", in.getModeloDocFiscal().getCodigo());
                    h.put("CODIGO_SIT_DOC", "05");
                    h.put("TIPO_NF", in.getNfce() != null ? 1 : 0);
                    dados.add(h);
                }
                continue;
            }
            in = (InutilizacaoNumeracaoCTe)o;
            for (long i = in.getNumeroInicial().longValue(); i <= in.getNumeroFinal(); ++i) {
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("NUMERO_CTE", i);
                h.put("SERIE", in.getSerie().toString());
                h.put("CODIGO_MOD_DOC", in.getModeloDocFiscal().getCodigo());
                h.put("CODIGO_SIT_DOC", "05");
                dados.add(h);
            }
        }
    }

    private List findInutilizacoesNFe(Date dataInicial, Date dataFinal, Long idEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from InutilizacaoNumeracaoNFe i where i.periodo between :dataIn and :dataFim and i.empresa.identificador = :idEmpresa and i.status IN(:status) order by i.serie, i.numeroInicial";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setParameter("status", (Object)EnumConstNFeStatus.getStatusInutilizadaString());
        return q.list();
    }

    private Collection findInutilizacoesCTe(Date dataInicial, Date dataFinal, Long idEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from InutilizacaoNumeracaoCTe i where i.periodo between :dataIn and :dataFim and i.empresa.identificador = :idEmpresa and i.status IN(:status)";
        Query q = s.createQuery(hql);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setParameter("status", (Object)EnumConstNFeStatus.getStatusInutilizadaString());
        return q.list();
    }

    private void gerarDadosResumoCFOP(List<HashMap> dados, HashMap params) {
        HashMap hashCfop = new HashMap();
        for (HashMap h : dados) {
            Short cancelado = (Short)h.get("CANCELADO");
            String cfop = (String)h.get("CODIGO_CFOP");
            Short entradaSaida = (Short)h.get("ENTRADA_SAIDA_NATUREZA_OP");
            if (cancelado == null || !cancelado.equals((short)0) || entradaSaida == null || !entradaSaida.equals((short)1)) continue;
            if (hashCfop.containsKey(cfop)) {
                HashMap hh = (HashMap)hashCfop.get(cfop);
                hh.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL") + (Double)hh.get("VALOR_TOTAL"));
                hh.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO") + (Double)hh.get("VALOR_ICMS_TRIBUTADO"));
                hh.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO") + (Double)hh.get("VALOR_ICMS_ISENTO"));
                hh.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS") + (Double)hh.get("VALOR_ICMS_OUTROS"));
                hh.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS") + (Double)hh.get("VALOR_ICMS"));
                hh.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO") + (Double)hh.get("VALOR_IPI_TRIBUTADO"));
                hh.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO") + (Double)hh.get("VALOR_IPI_ISENTO"));
                hh.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS") + (Double)hh.get("VALOR_IPI_OUTROS"));
                hh.put("VALOR_IPI_COMERCIO", (Double)h.get("VALOR_IPI_COMERCIO") + (Double)hh.get("VALOR_IPI_COMERCIO"));
                hh.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO") + (Double)hh.get("VALOR_IPI_OBSERVACAO"));
                hh.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA") + (Double)hh.get("VALOR_IPI_INDUSTRIA"));
                hh.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST") + (Double)hh.get("VALOR_BC_ICMS_ST"));
                hh.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST") + (Double)hh.get("VALOR_ICMS_ST"));
                continue;
            }
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("ID_CFOP", (Long)h.get("ID_CFOP"));
            newHash.put("CODIGO_CFOP", (String)h.get("CODIGO_CFOP"));
            newHash.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL"));
            newHash.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO"));
            newHash.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO"));
            newHash.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS"));
            newHash.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS"));
            newHash.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO"));
            newHash.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO"));
            newHash.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS"));
            newHash.put("VALOR_IPI_COMERCIO", (Double)h.get("VALOR_IPI_COMERCIO"));
            newHash.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO"));
            newHash.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA"));
            newHash.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST"));
            newHash.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST"));
            hashCfop.put(cfop, newHash);
        }
        ArrayList<HashMap> dadosCFOP = new ArrayList<HashMap>();
        Set chaves = hashCfop.keySet();
        for (Object ob : chaves) {
            String chave = (String)ob;
            HashMap h = (HashMap)hashCfop.get(chave);
            dadosCFOP.add(h);
        }
        this.ordenarPorCfop(dadosCFOP);
        params.put("DADOS_CFOP", dadosCFOP);
    }

    private void gerarDadosResumoUF(List<HashMap> dados, HashMap params) {
        HashMap hashUF = new HashMap();
        for (HashMap h : dados) {
            Short cancelado = (Short)h.get("CANCELADO");
            String uf = (String)h.get("SIGLA");
            Short entradaSaida = (Short)h.get("ENTRADA_SAIDA_NATUREZA_OP");
            if (cancelado == null || !cancelado.equals((short)0) || entradaSaida == null || !entradaSaida.equals((short)1)) continue;
            if (hashUF.containsKey(uf)) {
                HashMap hh = (HashMap)hashUF.get(uf);
                hh.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL") + (Double)hh.get("VALOR_TOTAL"));
                hh.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO") + (Double)hh.get("VALOR_ICMS_TRIBUTADO"));
                hh.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO") + (Double)hh.get("VALOR_ICMS_ISENTO"));
                hh.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS") + (Double)hh.get("VALOR_ICMS_OUTROS"));
                hh.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS") + (Double)hh.get("VALOR_ICMS"));
                hh.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO") + (Double)hh.get("VALOR_IPI_TRIBUTADO"));
                hh.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO") + (Double)hh.get("VALOR_IPI_ISENTO"));
                hh.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS") + (Double)hh.get("VALOR_IPI_OUTROS"));
                hh.put("VALOR_IPI_COMERCIO", (Double)h.get("VALOR_IPI_COMERCIO") + (Double)hh.get("VALOR_IPI_COMERCIO"));
                hh.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO") + (Double)hh.get("VALOR_IPI_OBSERVACAO"));
                hh.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA") + (Double)hh.get("VALOR_IPI_INDUSTRIA"));
                hh.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST") + (Double)hh.get("VALOR_BC_ICMS_ST"));
                hh.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST") + (Double)hh.get("VALOR_ICMS_ST"));
                continue;
            }
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("SIGLA", (String)h.get("SIGLA"));
            newHash.put("VALOR_TOTAL", (Double)h.get("VALOR_TOTAL"));
            newHash.put("VALOR_ICMS_TRIBUTADO", (Double)h.get("VALOR_ICMS_TRIBUTADO"));
            newHash.put("VALOR_ICMS_ISENTO", (Double)h.get("VALOR_ICMS_ISENTO"));
            newHash.put("VALOR_ICMS_OUTROS", (Double)h.get("VALOR_ICMS_OUTROS"));
            newHash.put("VALOR_ICMS", (Double)h.get("VALOR_ICMS"));
            newHash.put("VALOR_IPI_TRIBUTADO", (Double)h.get("VALOR_IPI_TRIBUTADO"));
            newHash.put("VALOR_IPI_ISENTO", (Double)h.get("VALOR_IPI_ISENTO"));
            newHash.put("VALOR_IPI_OUTROS", (Double)h.get("VALOR_IPI_OUTROS"));
            newHash.put("VALOR_IPI_COMERCIO", (Double)h.get("VALOR_IPI_COMERCIO"));
            newHash.put("VALOR_IPI_OBSERVACAO", (Double)h.get("VALOR_IPI_OBSERVACAO"));
            newHash.put("VALOR_IPI_INDUSTRIA", (Double)h.get("VALOR_IPI_INDUSTRIA"));
            newHash.put("VALOR_BC_ICMS_ST", (Double)h.get("VALOR_BC_ICMS_ST"));
            newHash.put("VALOR_ICMS_ST", (Double)h.get("VALOR_ICMS_ST"));
            hashUF.put(uf, newHash);
        }
        ArrayList<HashMap> dadosUF = new ArrayList<HashMap>();
        Set chaves = hashUF.keySet();
        for (Object ob : chaves) {
            String chave = (String)ob;
            HashMap h = (HashMap)hashUF.get(chave);
            dadosUF.add(h);
        }
        params.put("DADOS_UF", dadosUF);
    }
}

