/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensnfese;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemRps {
    private static final Short FATURADOS = 0;
    private static final Short CANCELADOS = 1;
    private static final Short DATA_EMISSAO = 0;
    private static final Short NUMERO_RPS = 1;
    private static final Short NUMERO_NFSE = 2;
    private static final Short ID_TOMADOR = 3;
    private static final Short NOME_TOMADOR = 4;

    UtilGerarListagemRps() {
    }

    JasperPrint gerarListagemRps(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short status, Short ordenacao, Short quebrarTomador, String fecho, Nodo nodo, HashMap parametros, Short mostrarObservacao) throws ExceptionService {
        List<HashMap> dados = this.pesquisarRps(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarTomadorServico, tomadorServicoInicial, tomadorServicoFinal, filtrarEmpresa, empresaInicial, empresaFinal, status, ordenacao);
        return this.gerarJasperPrintRps(filtrarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarTomadorServico, tomadorServicoInicial, tomadorServicoFinal, filtrarEmpresa, empresaInicial, empresaFinal, status, quebrarTomador, fecho, nodo, parametros, dados, mostrarObservacao);
    }

    private List<HashMap> pesquisarRps(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short status, Short ordenacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT r.numeroNFse AS NUMERO_NFSE, r.serie AS SERIE, r.dataEmissao AS DATA_EMISSAO, r.unidadeTomPrestRPS.tomadorPrestadorRPS.identificador AS ID_TOMADOR_SERVICO, r.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.nome AS NOME_TOMADOR_SERVICO, r.aliquotaIss AS ALIQUOTA_ISS, r.valorIssRetido AS VALOR_ISS_RETIDO, r.aliquotaIr AS ALIQUOTA_IRRF, r.valorIr AS VALOR_IRRF, r.valorLiquidoNfse AS VALOR_LIQUIDO_NFSE, r.valorServico AS VALOR_SERVICO, r.aliquotaInss AS ALIQUOTA_INSS, r.valorInss    AS VALOR_INSS, r.observacao   AS F_OBSERVACAO FROM Rps r WHERE (:filtrarDataEmissao <> 1 OR CAST(r.dataEmissao AS date) BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal) AND (:filtrarTomadorServico <> 1 OR r.unidadeTomPrestRPS.tomadorPrestadorRPS.identificador BETWEEN :tomadorServicoInicial AND :tomadorServicoFinal) AND (:filtrarEmpresa <> 1 OR r.empresa.identificador BETWEEN :empresaInicial AND :empresaFinal)";
        if (status == FATURADOS) {
            hql = (String)hql + " AND r.numeroNFse IS NOT NULL and r.status = :status";
        } else if (status == CANCELADOS) {
            hql = (String)hql + " AND r.status = :status";
        }
        if (ordenacao == DATA_EMISSAO) {
            hql = (String)hql + " ORDER BY dataEmissao";
        } else if (ordenacao == NUMERO_RPS) {
            hql = (String)hql + " ORDER BY c.numero";
        } else if (ordenacao == NUMERO_NFSE) {
            hql = (String)hql + " ORDER BY r.numeroNFse";
        } else if (ordenacao == ID_TOMADOR) {
            hql = (String)hql + " ORDER BY r.unidadeTomPrestRPS.tomadorPrestadorRPS.identificador";
        } else if (ordenacao == NOME_TOMADOR) {
            hql = (String)hql + " ORDER BY r.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.nome";
        }
        Query q = s.createQuery((String)hql);
        q.setShort("filtrarDataEmissao", filtrarDataEmissao.shortValue());
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("filtrarTomadorServico", filtrarTomadorServico.shortValue());
        q.setLong("tomadorServicoInicial", tomadorServicoInicial.longValue());
        q.setLong("tomadorServicoFinal", tomadorServicoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        if (status == CANCELADOS) {
            q.setShort("status", (short)2);
        }
        if (status == FATURADOS) {
            q.setShort("status", (short)1);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private JasperPrint gerarJasperPrintRps(Short filtrarDataEmissao, Date dataEmissaoInicial, Date dataEmissaoFinal, Short filtrarTomadorServico, Long tomadorServicoInicial, Long tomadorServicoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short status, Short quebrarTomador, String fecho, Nodo nodo, HashMap parametros, List<HashMap> dados, Short mostrarObservacao) throws ExceptionService {
        parametros.put("FILTRAR_DATA_EMISSAO", filtrarDataEmissao);
        parametros.put("DATA_EMISSAO_INICIAL", dataEmissaoInicial);
        parametros.put("DATA_EMISSAO_FINAL", dataEmissaoFinal);
        parametros.put("FILTRAR_TOMADOR_SERVICO", filtrarTomadorServico);
        parametros.put("TOMADOR_SERVICO_INICIAL", tomadorServicoInicial);
        parametros.put("TOMADOR_SERVICO_FINAL", tomadorServicoFinal);
        parametros.put("FILTRAR_EMPRESA", filtrarEmpresa);
        parametros.put("EMPRESA_INICIAL", empresaInicial);
        parametros.put("EMPRESA_FINAL", empresaFinal);
        parametros.put("STATUS", status);
        parametros.put("QUEBRAR_TOMADOR", quebrarTomador);
        parametros.put("FECHO", fecho);
        parametros.put("P_MOSTRAR_OBSERVACAO", mostrarObservacao);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("isPaisagem", false).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "mercado" + File.separator + "gestaonfese" + File.separator + "listagens" + File.separator + "rps" + File.separator + "LISTAGEM_RPS.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

