/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagenspatrimonio;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeraListagemBensAtivosOuInativos {
    public JasperPrint gerarListagemBensAtivosOuInativos(CoreRequestContext r) throws ExceptionService {
        Date dataInicial = (Date)r.getAttribute("dataInicialPeriodo");
        Date dataFinal = (Date)r.getAttribute("dataFinalPeriodo");
        Short filtrarTipoDepreciacao = (Short)r.getAttribute("filtrarTipoDepreciacao");
        Integer idTipoDep = (Integer)r.getAttribute("idTipoDep");
        HashMap defaultParams = (HashMap)r.getAttribute("defaultParams");
        Short filtrarBem = (Short)r.getAttribute("filtrarBem");
        Long bemInicial = (Long)r.getAttribute("bemInicial");
        Long bemFinal = (Long)r.getAttribute("bemFinal");
        Short filtrarCentroCusto = (Short)r.getAttribute("filtrarCentroCusto");
        Long centroCustoInicial = (Long)r.getAttribute("centroCustoInicial");
        Long centroCustoFinal = (Long)r.getAttribute("centroCustoFinal");
        Short filtrarCtbDepreciacao = (Short)r.getAttribute("filtrarCtbDepreciacao");
        Long ctbDepreciacaoInicial = (Long)r.getAttribute("ctbDepreciacaoInicial");
        Long ctbDepreciacaoFinal = (Long)r.getAttribute("ctbDepreciacaoFinal");
        Short filtrarCtbDespesas = (Short)r.getAttribute("filtrarCtbDespesas");
        Long ctbDespesasInicial = (Long)r.getAttribute("ctbDespesasInicial");
        Long ctbDespesasFinal = (Long)r.getAttribute("ctbDespesasFinal");
        Short filtrarDataAquisicao = (Short)r.getAttribute("filtrarDataAquisicao");
        Date dataAquisicaoInicial = (Date)r.getAttribute("dataAquisicaoInicial");
        Date dataAquisicaoFinal = (Date)r.getAttribute("dataAquisicaoFinal");
        Short filtrarDataImobilizacao = (Short)r.getAttribute("filtrarDataImobilizacao");
        Date dataImobilizacaoFinal = (Date)r.getAttribute("dataImobilizacaoFinal");
        Date dataImobilizacaoInicial = (Date)r.getAttribute("dataImobilizacaoInicial");
        Short filtrarValor = (Short)r.getAttribute("filtrarValor");
        Double valorInicial = (Double)r.getAttribute("valorInicial");
        Double valorFinal = (Double)r.getAttribute("valorFinal");
        Short filtrarTaxa = (Short)r.getAttribute("filtrarTaxa");
        Double taxaInicial = (Double)r.getAttribute("taxaInicial");
        Double taxaFinal = (Double)r.getAttribute("taxaFinal");
        List dados = this.getDadosBens(dataInicial, dataFinal, filtrarTipoDepreciacao, idTipoDep, filtrarBem, bemInicial, bemFinal, filtrarDataAquisicao, dataAquisicaoInicial, dataAquisicaoFinal, filtrarDataImobilizacao, dataImobilizacaoFinal, dataImobilizacaoInicial, filtrarValor, valorInicial, valorFinal, filtrarTaxa, taxaInicial, taxaFinal, filtrarCtbDepreciacao, ctbDepreciacaoInicial, ctbDepreciacaoFinal, filtrarCtbDespesas, ctbDespesasInicial, ctbDespesasFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal);
        List relatorio = this.getRelatorioCompleto(dados, dataFinal);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "controladoria" + File.separator + "gestaoDoPatrimonio" + File.separator + "listagens" + File.separator + "BENS_ATIVOS_OU_INATIVOS.jasper";
        defaultParams.put("FILTRAR_DEPRECIACAO", filtrarTipoDepreciacao);
        defaultParams.put("ID_TIPO_DEPRECIACAO", (Integer)r.getAttribute("idTipoDep"));
        defaultParams.put("DESC_TIPO_DEPRECIACAO", (String)r.getAttribute("descTipoDep"));
        defaultParams.put("DATA_INICIAL", (Date)r.getAttribute("dataInicialPeriodo"));
        defaultParams.put("DATA_FINAL", (Date)r.getAttribute("dataFinalPeriodo"));
        defaultParams.put("FILTRAR_BEM", (Short)r.getAttribute("filtrarBem"));
        defaultParams.put("BEM_INICIAL", (Long)r.getAttribute("bemInicial"));
        defaultParams.put("BEM_FINAL", (Long)r.getAttribute("bemFinal"));
        defaultParams.put("FILTRAR_CENTRO_CUSTO", (Short)r.getAttribute("filtrarCentroCusto"));
        defaultParams.put("CENTRO_CUSTO_INICIAL", (Long)r.getAttribute("centroCustoInicial"));
        defaultParams.put("CENTRO_CUSTO_FINAL", (Long)r.getAttribute("centroCustoFinal"));
        defaultParams.put("FILTRAR_PC_CONTABIL", (Short)r.getAttribute("filtrarCtbDespesas"));
        defaultParams.put("PC_CONTABIL_INICIAL", (Long)r.getAttribute("ctbDespesasInicial"));
        defaultParams.put("PC_CONTABIL_FINAL", (Long)r.getAttribute("ctbDespesasFinal"));
        defaultParams.put("FILTRAR_PC_DEPRECIACAO", (Short)r.getAttribute("filtrarCtbDepreciacao"));
        defaultParams.put("PC_DEPRECIACAO_INICIAL", (Long)r.getAttribute("ctbDepreciacaoInicial"));
        defaultParams.put("PC_DEPRECIACAO_FINAL", (Long)r.getAttribute("ctbDepreciacaoFinal"));
        defaultParams.put("FILTRAR_DATA_AQUISICAO", (Short)r.getAttribute("filtrarDataAquisicao"));
        defaultParams.put("DATA_AQUISICAO_INICIAL", (Date)r.getAttribute("dataAquisicaoInicial"));
        defaultParams.put("DATA_AQUISICAO_FINAL", (Date)r.getAttribute("dataAquisicaoFinal"));
        defaultParams.put("FILTRAR_DATA_IMOBILIZACAO", (Short)r.getAttribute("filtrarDataImobilizacao"));
        defaultParams.put("DATA_IMOBILIZACAO_INICIAL", (Date)r.getAttribute("dataImobilizacaoFinal"));
        defaultParams.put("DATA_IMOBILIZACAO_FINAL", (Date)r.getAttribute("dataImobilizacaoInicial"));
        defaultParams.put("FILTRAR_VALOR", (Short)r.getAttribute("filtrarValor"));
        defaultParams.put("VALOR_INICIAL", (Double)r.getAttribute("valorInicial"));
        defaultParams.put("VALOR_FINAL", (Double)r.getAttribute("valorFinal"));
        defaultParams.put("FILTRAR_TAXA", (Short)r.getAttribute("filtrarTaxa"));
        defaultParams.put("TAXA_INICIAL", (Double)r.getAttribute("taxaInicial"));
        defaultParams.put("TAXA_FINAL", (Double)r.getAttribute("taxaFinal"));
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("path", path);
        request.setAttribute("parametros", defaultParams);
        request.setAttribute("dados", relatorio);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(request, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List getDadosBens(Date dataPeriodoInicial, Date dataPeriodoFinal, Short filtrarTipoDepreciacao, Integer idTipoDep, Short filtrarBem, Long bemInicial, Long bemFinal, Short filtrarDataAquisicao, Date dataAquisicaoInicial, Date dataAquisicaoFinal, Short filtrarDataImobilizacao, Date dataImobilizacaoFinal, Date dataImobilizacaoInicial, Short filtrarValor, Double valorInicial, Double valorFinal, Short filtrarTaxa, Double taxaInicial, Double taxaFinal, Short filtrarCtbDepreciacao, Long ctbDepreciacaoInicial, Long ctbDepreciacaoFinal, Short filtrarCtbDespesas, Long ctbDespesasInicial, Long ctbDespesasFinal, Short filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = " select distinct bem.identificador                          as ID_BEM,            bem.codigo                                 as CODIGO_BEM,        bem.descricao                              as DESCRICAO_BEM,     bem.dataCompra                             as DATA_AQUISICAO,    bem.valorCompra                            as VR_AQUISICAO,      depBem.valorDepreciacao                    as DEPRECIACAO_MES,   pcDep.codigo                               as PC_DEP,            pcAcel.codigo                              as PC_DEP_ACEL,       pcDesp.codigo                              as PC_DESP,           tpBem.taxaAnualDepreciacao                 as TAXA_DEP_ANUAL,    bemTipDep.dataInicial                      as DATA_IMOBILIZACAO  from ItemCiapDepreciacaoBaixaBem          item       left  join item.depreciacaoCiap           dep        left  join item.depreciacaoBem            depBem     left  join item.bem                       bem     left  join bem.centroCusto                centro left  join bem.bensTipoDepreciacao        bemTipDep     left  join bemTipDep.tipoDepreciacao       tipoDep    left  join bem.tipoBem                     tpBem      left  join tipoDep.planoContaBemDepr       pecBem     left  join pecBem.planoContaDepreciacao    pcDep      left  join pecBem.planoContaDeprAcelerada  pcAcel     left  join pecBem.planoContaDespesa        pcDesp     where  (:filtrarTipoDepreciacao <> 1 or tipoDep.identificador = :idTipoDep ) and (dep.periodo between :dataInicialPeriodo and :dataFinalPeriodo)  and (pecBem.tipoBem = tpBem)";
        if (filtrarBem == 1) {
            query = (String)query + "and bem.identificador between :bemInicial and :bemFinal ";
        }
        if (filtrarCentroCusto == 1) {
            query = (String)query + "and centro.identificador between :centroCustoInicial and :centroCustoFinal ";
        }
        if (filtrarDataAquisicao == 1) {
            query = (String)query + "and bem.dataCompra between :dataAquisicaoInicial and :dataAquisicaoFinal ";
        }
        if (filtrarDataImobilizacao == 1) {
            query = (String)query + "and bemTipDep.dataInicial between :dataImobilizacaoInicial and :dataImobilizacaoFinal ";
        }
        if (filtrarTaxa == 1) {
            query = (String)query + "and tpBem.taxaAnualDepreciacao between :taxaInicial and :taxaFinal ";
        }
        if (filtrarValor == 1) {
            query = (String)query + "and bemTipDep.valor between :valorInicial and :valorFinal ";
        }
        if (filtrarCtbDespesas == 1) {
            query = (String)query + "and pcDesp.identificador between :ctbDespesasInicial and :ctbDespesasFinal ";
        }
        if (filtrarCtbDepreciacao == 1) {
            query = (String)query + "and pcDep.identificador between :ctbDepreciacaoInicial and :ctbDepreciacaoFinal ";
        }
        Query q = s.createQuery((String)query);
        q.setShort("filtrarTipoDepreciacao", filtrarTipoDepreciacao.shortValue());
        q.setInteger("idTipoDep", idTipoDep.intValue());
        q.setDate("dataInicialPeriodo", dataPeriodoInicial);
        q.setDate("dataFinalPeriodo", dataPeriodoFinal);
        if (filtrarBem == 1) {
            q.setLong("bemInicial", bemInicial.longValue());
            q.setLong("bemFinal", bemFinal.longValue());
        }
        if (filtrarCentroCusto == 1) {
            q.setLong("centroCustoInicial", centroCustoInicial.longValue());
            q.setLong("centroCustoFinal", centroCustoFinal.longValue());
        }
        if (filtrarCtbDespesas == 1) {
            q.setLong("ctbDespesasInicial", ctbDespesasInicial.longValue());
            q.setLong("ctbDespesasFinal", ctbDespesasFinal.longValue());
        }
        if (filtrarCtbDepreciacao == 1) {
            q.setLong("ctbDepreciacaoInicial", ctbDepreciacaoInicial.longValue());
            q.setLong("ctbDepreciacaoFinal", ctbDepreciacaoFinal.longValue());
        }
        if (filtrarDataAquisicao == 1) {
            q.setDate("dataAquisicaoInicial", dataAquisicaoInicial);
            q.setDate("dataAquisicaoFinal", dataAquisicaoFinal);
        }
        if (filtrarDataImobilizacao == 1) {
            q.setDate("dataImobilizacaoInicial", dataImobilizacaoInicial);
            q.setDate("dataImobilizacaoFinal", dataImobilizacaoFinal);
        }
        if (filtrarTaxa == 1) {
            q.setDouble("taxaInicial", taxaInicial.doubleValue());
            q.setDouble("taxaFinal", taxaFinal.doubleValue());
        }
        if (filtrarValor == 1) {
            q.setDouble("valorInicial", valorInicial.doubleValue());
            q.setDouble("valorFinal", valorFinal.doubleValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getRelatorioCompleto(List dados, Date dataPeriodoFinal) {
        for (Object o : dados) {
            HashMap map = (HashMap)o;
            Long idBem = (Long)map.get("ID_BEM");
            Double depAcumulada = this.getDepAcumulada(idBem, dataPeriodoFinal);
            if (depAcumulada != null) {
                map.put("DEP_ACUMULADA", depAcumulada);
            } else {
                map.put("DEP_ACUMULADA", 0.0);
            }
            depAcumulada = (Double)map.get("DEP_ACUMULADA");
            Double vrAquisivcao = (Double)map.get("VR_AQUISICAO");
            Double vrResidual = vrAquisivcao - depAcumulada;
            map.put("VR_RESIDUAL", vrResidual);
        }
        return dados;
    }

    private Double getDepAcumulada(Long idBem, Date dataPeriodoFinal) {
        return CoreDAOFactory.getInstance().getDAOBem().getDepreciacaoAcumulada(idBem, dataPeriodoFinal);
    }
}

