/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensrh;

import com.touchcomp.basementor.model.vo.Ano13oSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.listagensrh.UtilGerarListagemValoresLiquidosPorBanco;
import mentorcore.service.impl.listagensrh.UtilListagemControlePonto;
import mentorcore.service.impl.listagensrh.UtilListagemMediaDecimoTerceiro;
import mentorcore.service.impl.listagensrh.UtilListagemRotinasPeriodicas;
import mentorcore.service.impl.listagensrh.UtillistagemConferenciaDirf;
import mentorcore.service.impl.listagensrh.UtillistagemInformativoRendimento;
import mentorcore.service.impl.rh.ImpressaoRequerimentoSeguroDesempregoUtilities;
import mentorcore.service.impl.rh.UtilListagemImpressaoExamePeriodico;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceListagensRH
extends CoreService {
    public static final String GERAR_LISTAGEM_VALORES_LIQUIDOS_POR_BANCO = "gerarListagemValoresLiquidosPorBanco";
    public static final String GERAR_LISTAGEM_CONTROLE_PONTO = "gerarListagemControlePonto";
    public static final String IMPRIMIR_CONTROLE_EXAME_PERIODICO = "impressaoControleExamePeriodico";
    public static final String IMPRIMIR_REQUERIMENTO_SEGURO_DESEMPREGO = "imprimirRequerimentoSeguroDesemprego";
    public static final String IMPRIMIR_RELATORIO_MEDIA_DEC_SALARIO = "imprimirRelatorioMediaDecSalario";
    public static final String IMPRIMIR_CONFERENCIA_FOLHA_DIRF = "imprimirConferenciaFolhaDirf";
    public static final String IMPRIMIR_INFORMATIVO_RENDIMENTO = "imprimirInformativoRendimento";
    public static final String IMPRIMIR_CONFERENCIA_DIRF_SIGLA = "conferenciaDirfSigla";
    public static final String IMPRIMIR_ROTINAS_PERIODICAS = "imprimirListagemRotinasPeriodicas";

    public JasperPrint gerarListagemValoresLiquidosPorBanco(CoreRequestContext r) throws ExceptionService {
        Date periodoInicial = (Date)r.getAttribute("periodoInicial");
        Date periodoFinal = (Date)r.getAttribute("periodoFinal");
        Boolean filtrarConta = (Boolean)r.getAttribute("filtrarConta");
        Long tipoPagamento = (Long)r.getAttribute("tipoPagamento");
        Long bancoInicial = (Long)r.getAttribute("bancoInicial");
        Long bancoFinal = (Long)r.getAttribute("bancoFinal");
        Boolean filtrarCentroCusto = (Boolean)r.getAttribute("filtrarCentroCusto");
        Long centroCustoInicial = (Long)r.getAttribute("centroCustoInicial");
        Long centroCustoFinal = (Long)r.getAttribute("centroCustoFinal");
        Short gerarFinanceiro = (Short)r.getAttribute("gerarFinanceiro");
        TipoCalculo tipoCalculo = (TipoCalculo)r.getAttribute("tipoCalculo");
        HashMap params = (HashMap)r.getAttribute("params");
        Long idEmpresa = (Long)r.getAttribute("idEmpresa");
        JasperPrint jasperPrint = new UtilGerarListagemValoresLiquidosPorBanco().gerarListagemValoresLiquidosPorBanco(periodoInicial, periodoFinal, filtrarConta, bancoInicial, bancoFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal, tipoCalculo, params, idEmpresa, tipoPagamento, gerarFinanceiro);
        return jasperPrint;
    }

    public List gerarListagemControlePonto(CoreRequestContext request) throws ExceptionService, ParseException {
        List ret = new ArrayList();
        HashMap params = (HashMap)request.getAttribute("params");
        Short folhaPorColaborador = (Short)request.getAttribute("folhaPorColaborador");
        Long idColaborador = (Long)request.getAttribute("idColaborador");
        ret = new UtilListagemControlePonto().gerarListagemControlePonto(params, folhaPorColaborador, idColaborador);
        return ret;
    }

    public Object impressaoControleExamePeriodico(CoreRequestContext request) throws ExceptionService {
        Date periodo = (Date)request.getAttribute("periodo");
        ExamePeriodo exame = (ExamePeriodo)request.getAttribute("exame");
        Integer ordenacao = (Integer)request.getAttribute("ordenacao");
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        return new UtilListagemImpressaoExamePeriodico().impressaoControleExamePeriodico(parametros, exame, periodo, ordenacao);
    }

    public Object imprimirRequerimentoSeguroDesemprego(CoreRequestContext request) throws ExceptionService {
        Recisao rescisao = (Recisao)request.getAttribute("recisao");
        HashMap hash = (HashMap)request.getAttribute("hash");
        return new ImpressaoRequerimentoSeguroDesempregoUtilities().gerarRequerimentoSeguro(rescisao, hash);
    }

    public Object imprimirRelatorioMediaDecSalario(CoreRequestContext request) throws ExceptionService {
        Ano13oSalario vo = (Ano13oSalario)request.getAttribute("ano13");
        HashMap params = (HashMap)request.getAttribute("params");
        return new UtilListagemMediaDecimoTerceiro().gerarListagemMediaPagamentoDec(vo, params);
    }

    public Object imprimirConferenciaFolhaDirf(CoreRequestContext request) throws ExceptionService {
        Long anoBase = (Long)request.getAttribute("anoBase");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        Colaborador idColaborador = (Colaborador)request.getAttribute("idColaborador");
        String ordenacao = (String)request.getAttribute("ordenacao");
        Short mostrarRecisao = (Short)request.getAttribute("mostrarRecisao");
        return new UtillistagemConferenciaDirf().findMovimentoFolhaDirf(anoBase, empresa, empresaRh, parametros, idColaborador, ordenacao, mostrarRecisao);
    }

    public Object imprimirInformativoRendimento(CoreRequestContext request) throws ExceptionService {
        Date dataCadastro = (Date)request.getAttribute("dataCadastro");
        Long anoBase = (Long)request.getAttribute("anoBase");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        String pessoaResponsavel = (String)request.getAttribute("pessoaResponsavel");
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        Colaborador idColaborador = (Colaborador)request.getAttribute("idColaborador");
        String ordenacao = (String)request.getAttribute("ordenacao");
        Short mostrarRecisao = (Short)request.getAttribute("mostrarRecisao");
        Double valorParticipacaoLucro = (Double)request.getAttribute("valorParticipacaoLucro");
        return new UtillistagemInformativoRendimento().findInformativoRendimento(dataCadastro, anoBase, empresa, empresaRh, pessoaResponsavel, parametros, idColaborador, ordenacao, mostrarRecisao, valorParticipacaoLucro);
    }

    public Object conferenciaDirfSigla(CoreRequestContext request) throws ExceptionService {
        Long anoBase = (Long)request.getAttribute("anoBase");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        return new UtillistagemConferenciaDirf().conferenciaDirfProSigla(anoBase, empresa, empresaRh, parametros);
    }

    public Object imprimirListagemRotinasPeriodicas(CoreRequestContext request) throws ExceptionService {
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Integer filtro = (Integer)request.getAttribute("filtro");
        String ordenacao = (String)request.getAttribute("ordenacao");
        HashMap parametros = (HashMap)request.getAttribute("parametros");
        Short quebrarRotina = (Short)request.getAttribute("quebrarRotina");
        Short filtarRotina = (Short)request.getAttribute("filtarRotina");
        Long idRotina = (Long)request.getAttribute("idRotina");
        Short filtrarColaborador = (Short)request.getAttribute("filtrarColaborador");
        Long idPessoaColaborador = (Long)request.getAttribute("idPessoaColaborador");
        return new UtilListagemRotinasPeriodicas().imprimirRotinasPeriodicas(dataInicio, dataFinal, filtro, parametros, ordenacao, quebrarRotina, filtarRotina, idRotina, filtrarColaborador, idPessoaColaborador);
    }
}

