/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensrh;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilGerarListagemValoresLiquidosPorBanco {
    UtilGerarListagemValoresLiquidosPorBanco() {
    }

    JasperPrint gerarListagemValoresLiquidosPorBanco(Date periodoInicial, Date periodoFinal, Boolean filtrarBanco, Long bancoInicial, Long bancoFinal, Boolean filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, TipoCalculo tipoCalculo, HashMap params, Long idEmpresa, Long agrupamento, Short gerarFinanceiro) throws ExceptionService {
        List<HashMap> valoresLiquidosPorBanco = new ArrayList();
        valoresLiquidosPorBanco = tipoCalculo.getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue()) ? this.getValoresFeriasPorBanco(periodoInicial, periodoFinal, filtrarBanco, bancoInicial, bancoFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal, idEmpresa) : (tipoCalculo.getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()) ? this.getValoresRecisaoPorBanco(periodoInicial, periodoFinal, filtrarBanco, bancoInicial, bancoFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal, idEmpresa) : this.getValoresMovimentoFolhaPorBanco(periodoInicial, periodoFinal, filtrarBanco, bancoInicial, bancoFinal, filtrarCentroCusto, centroCustoInicial, centroCustoFinal, tipoCalculo, idEmpresa, agrupamento, gerarFinanceiro));
        ArrayList<HashMap> remove = new ArrayList<HashMap>();
        for (HashMap h : valoresLiquidosPorBanco) {
            for (HashMap h1 : valoresLiquidosPorBanco) {
                if (h == h1 || !((Colaborador)h.get("colaborador")).equals((Object)((Colaborador)h1.get("colaborador"))) || !((Double)h.get("valor")).equals((Double)h1.get("valor"))) continue;
                if ((Short)h.get("ativo") == 0 && !remove.contains(h)) {
                    remove.add(h);
                }
                if ((Short)h1.get("ativo") != 0 || remove.contains(h1)) continue;
                remove.add(h1);
            }
        }
        if (!remove.isEmpty()) {
            valoresLiquidosPorBanco.removeAll(remove);
        }
        for (HashMap hashMap : valoresLiquidosPorBanco) {
            if (hashMap.get("numBanco") == null) {
                hashMap.put("numBanco", "000");
                hashMap.put("nomeBanco", "Colaboradores nao pagos em Banco");
                continue;
            }
            if (hashMap.get("pagoComCheque") == null || (Short)hashMap.get("pagoComCheque") != 1) continue;
            hashMap.put("numBanco", "000");
            hashMap.put("nomeBanco", "Colaboradores nao pagos em Banco");
        }
        params.put("periodoInicial", periodoInicial);
        params.put("periodoFinal", periodoFinal);
        params.put("filtrarBanco", filtrarBanco);
        params.put("bancoInicial", bancoInicial);
        params.put("bancoFinal", bancoFinal);
        params.put("MOVIMENTACAO", tipoCalculo.getDescricao().toUpperCase());
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "valoreliquidosporbanco" + File.separator + "LISTAGEM_VALORES_LIQUIDOS_POR_BANCO.jasper";
        this.sortList(valoresLiquidosPorBanco);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", valoresLiquidosPorBanco);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List getValoresFeriasPorBanco(Date periodoInicial, Date periodoFinal, Boolean filtrarBanco, Long bancoInicial, Long bancoFinal, Boolean filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, Long idEmpresa) {
        Object hql = " select      col                   as colaborador,  \tcol.numeroRegistro    as numeroRegistro,  \tcol.pessoa.nome       as nomeColaborador,      c.cnpj                as cpfColaborador,      conta.agencia         as agencia,      conta.dvAgencia       as dvAgencia,      conta.contaCorrente   as conta,      conta.dvContaCorrente as dvConta,  \tf.vrLiquidoFerias     as valor,  \tbanco.nrBanco         as numBanco,  \tbanco.nomeBanco       as nomeBanco,     conta.ativo           as ativo  from FeriasColaborador  \t     f  join f.periodoAqFeriasColab      aqColab  join aqColab.colaborador \t     col  join f.periodoFerias pf join pf.empresa                  e left join col.centroCusto cc  join col.pessoa                  ps  join ps.complemento              c left join ps.contaSalarioColaborador conta  left join conta.instituicaoValor      banco  where f.dataPagamento between :periodoInicial and :periodoFinal  and conta.preferencial = :preferencial and e.identificador = :idEmpresa";
        if (filtrarBanco.booleanValue()) {
            hql = (String)hql + " and banco.identificador between :bancoInicial   and :bancoFinal ";
        }
        if (filtrarCentroCusto.booleanValue()) {
            hql = (String)hql + " and cc.identificador between :centroCustoInicial   and :centroCustoFinal ";
        }
        hql = (String)hql + " order by banco.nrBanco ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setShort("preferencial", EnumConstantsMentorSimNao.SIM.getValue());
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        if (filtrarBanco.booleanValue()) {
            q.setLong("bancoInicial", bancoInicial.longValue());
            q.setLong("bancoFinal", bancoFinal.longValue());
        }
        if (filtrarCentroCusto.booleanValue()) {
            q.setLong("centroCustoInicial", centroCustoInicial.longValue());
            q.setLong("centroCustoFinal", centroCustoFinal.longValue());
        }
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valoresFerias = q.list();
        return valoresFerias;
    }

    private List getValoresRecisaoPorBanco(Date periodoInicial, Date periodoFinal, Boolean filtrarBanco, Long bancoInicial, Long bancoFinal, Boolean filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, Long idEmpresa) {
        Object hql = " select      col                   as colaborador,  \tcol.numeroRegistro    as numeroRegistro,  \tcol.pessoa.nome       as nomeColaborador,      c.cnpj                as cpfColaborador,      conta.agencia         as agencia,      conta.dvAgencia       as dvAgencia,      conta.contaCorrente   as conta,      conta.dvContaCorrente as dvConta,  \tr.vlrLiquido          as valor,  \tbanco.nrBanco         as numBanco,  \tbanco.nomeBanco       as nomeBanco,     conta.ativo           as ativo  from Recisao  \t     \t     r  join r.empresa                   e join r.colaborador \t             col  left join col.centroCusto        cc  join col.pessoa                  ps  join ps.complemento              c left join ps.contaSalarioColaborador conta  left join conta.instituicaoValor      banco  where r.dataAfastamento between :periodoInicial and :periodoFinal  and conta.preferencial = :preferencial and e.identificador = :idEmpresa";
        if (filtrarBanco.booleanValue()) {
            hql = (String)hql + " and banco.identificador between :bancoInicial   and :bancoFinal ";
        }
        if (filtrarCentroCusto.booleanValue()) {
            hql = (String)hql + " and cc.identificador between :centroCustoInicial   and :centroCustoFinal ";
        }
        hql = (String)hql + " order by banco.nrBanco ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setShort("preferencial", EnumConstantsMentorSimNao.SIM.getValue());
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        if (filtrarBanco.booleanValue()) {
            q.setLong("bancoInicial", bancoInicial.longValue());
            q.setLong("bancoFinal", bancoFinal.longValue());
        }
        if (filtrarCentroCusto.booleanValue()) {
            q.setLong("centroCustoInicial", centroCustoInicial.longValue());
            q.setLong("centroCustoFinal", centroCustoFinal.longValue());
        }
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valoresRecisoes = q.list();
        return valoresRecisoes;
    }

    private List getValoresMovimentoFolhaPorBanco(Date periodoInicial, Date periodoFinal, Boolean filtrarBanco, Long bancoInicial, Long bancoFinal, Boolean filtrarCentroCusto, Long centroCustoInicial, Long centroCustoFinal, TipoCalculo tipoCalculo, Long idEmpresa, Long agrupamento, Short gerarFinanceiro) {
        Object hql = " select      col                   as colaborador,  \tcol.numeroRegistro    as numeroRegistro,  \tcol.pessoa.nome       as nomeColaborador,      c.cnpj                as cpfColaborador,     conta.agencia         as agencia,     conta.dvAgencia       as dvAgencia,     conta.contaCorrente   as conta,     conta.dvContaCorrente as dvConta, \tmov.vrSalarioLiquido  as valor,  \tbanco.nrBanco         as numBanco,  \tbanco.nomeBanco       as nomeBanco,      conta.ativo           as ativo  from MovimentoFolha                   mov  join mov.colaborador                  col  left join col.centroCusto             cc  join col.pessoa                       ps  join ps.complemento                   c left join ps.contaSalarioColaborador conta  left join conta.instituicaoValor      banco  join mov.aberturaPeriodo              ab  join ab.tipoCalculo                   tc  where ab.dataInicio >= :periodoInicial  and ab.dataFinal    <= :periodoFinal  and tc.tipoFolha     = :tipoFolha  and mov.empresa.identificador = :idEmpresa  and (:gerarFinanceiro = 1 or col.gerarFinanceiro = :sim) and  (:tipoPagamento = 0 or mov.aberturaPeriodo.tipoPagamentoFolha.identificador = :tipoPagamento )  and conta.preferencial = :preferencial";
        if (filtrarBanco.booleanValue()) {
            hql = (String)hql + " and banco.identificador between :bancoInicial and :bancoFinal ";
        }
        if (filtrarCentroCusto.booleanValue()) {
            hql = (String)hql + " and cc.identificador between :centroCustoInicial   and :centroCustoFinal ";
        }
        hql = (String)hql + " order by banco.nrBanco ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setShort("preferencial", EnumConstantsMentorSimNao.SIM.getValue());
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        q.setShort("gerarFinanceiro", gerarFinanceiro.shortValue());
        q.setShort("sim", (short)1);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setLong("tipoPagamento", agrupamento.longValue());
        if (filtrarBanco.booleanValue()) {
            q.setLong("bancoInicial", bancoInicial.longValue());
            q.setLong("bancoFinal", bancoFinal.longValue());
        }
        if (filtrarCentroCusto.booleanValue()) {
            q.setLong("centroCustoInicial", centroCustoInicial.longValue());
            q.setLong("centroCustoFinal", centroCustoFinal.longValue());
        }
        q.setShort("tipoFolha", tipoCalculo.getTipoFolha().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valoresMovimentoFolha = q.list();
        return valoresMovimentoFolha;
    }

    private void sortList(List<HashMap> valoresLiquidosPorBanco) {
        if (valoresLiquidosPorBanco != null) {
            Collections.sort(valoresLiquidosPorBanco, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap hash = (HashMap)o1;
                    HashMap hash2 = (HashMap)o2;
                    String banco1 = (String)hash.get("numBanco");
                    String banco2 = (String)hash2.get("numBanco");
                    String colaborador1 = (String)hash.get("nomeColaborador");
                    String colaborador2 = (String)hash2.get("nomeColaborador");
                    if (banco1.equals(banco2)) {
                        return colaborador1.compareTo(colaborador2);
                    }
                    return banco1.compareTo(banco2);
                }
            });
        }
    }
}

