/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.listagensrh;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtillistagemInformativoRendimento {
    public Object findInformativoRendimento(Date dataCadastro, Long anoBase, Empresa empresa, EmpresaRh empresaRh, String pessoaResponsavel, HashMap parametros, Colaborador colaborador, String ordenacao, Short mostrarRecisao, Double valorParticipacaoLucro) throws ExceptionService {
        List ret = this.getListaGeral(anoBase, empresa, ordenacao, colaborador);
        int contador = 0;
        for (Object obj : ret) {
            HashMap hash = (HashMap)obj;
            System.err.println(" FOLHA NUMERO: " + ++contador);
            Short nrDep = (Short)hash.get("DEPENDENTES");
            Long l = (Long)hash.get("ID_MOV");
            Long idColaboradorPesquisa = (Long)hash.get("ID_COLABORADOR");
            Double d = ContatoFormatUtil.arrredondarNumero(nrDep.doubleValue() * 189.59, 2);
            hash.put("DEPENDENTES", d);
            hash.put("PENSAO_ALIMENTICIA", this.getVlrPensao(l));
            hash.put("BC_IRRF", this.getRendimentosTributaveis(l));
            hash.put("IRRF", this.getValorIRRF(l));
            this.getBcIrrfDec(idColaboradorPesquisa, anoBase, hash, empresa);
        }
        ArrayList<Object> aux = new ArrayList<Object>();
        for (Object object : ret) {
            HashMap hash = (HashMap)object;
            boolean bl = false;
            for (Object e : aux) {
                HashMap newHash = (HashMap)e;
                if (!newHash.get("MES").equals(hash.get("MES")) || !newHash.get("ID_COLABORADOR").equals(hash.get("ID_COLABORADOR"))) continue;
                Double valorInss = (Double)hash.get("INSS");
                Double valorInssAux = (Double)newHash.get("INSS");
                Double bcIrrf = (Double)hash.get("BC_IRRF");
                Double bcIrrfAux = (Double)newHash.get("BC_IRRF");
                Double irrf = (Double)hash.get("IRRF");
                Double irrfAux = (Double)newHash.get("IRRF");
                newHash.put("INSS", ContatoFormatUtil.arrredondarNumero(valorInss + valorInssAux, 2));
                newHash.put("BC_IRRF", ContatoFormatUtil.arrredondarNumero(bcIrrf + bcIrrfAux, 2));
                newHash.put("IRRF", ContatoFormatUtil.arrredondarNumero(irrf + irrfAux, 2));
                bl = true;
                break;
            }
            if (bl) continue;
            aux.add(hash);
        }
        ArrayList aux2 = new ArrayList();
        HashMap<Object, Object> auxiliar = new HashMap<Object, Object>();
        for (Object e : aux) {
            HashMap hash = (HashMap)e;
            if (auxiliar != null && !auxiliar.isEmpty()) {
                if (!hash.get("NR_REGISTRO").equals(auxiliar.get("NR_REGISTRO"))) continue;
                auxiliar.put("BC_IRRF", (Double)auxiliar.get("BC_IRRF") + (Double)hash.get("BC_IRRF"));
                auxiliar.put("INSS", (Double)auxiliar.get("INSS") + (Double)hash.get("INSS"));
                auxiliar.put("IRRF", (Double)auxiliar.get("IRRF") + (Double)hash.get("IRRF"));
                auxiliar.put("PENSAO_ALIMENTICIA", (Double)auxiliar.get("PENSAO_ALIMENTICIA") + (Double)hash.get("PENSAO_ALIMENTICIA"));
                auxiliar.put("DEPENDENTES", (Double)auxiliar.get("DEPENDENTES") + (Double)hash.get("DEPENDENTES"));
                continue;
            }
            auxiliar.put("NR_REGISTRO", (String)hash.get("NR_REGISTRO"));
            auxiliar.put("CPF_COLABORADOR", (String)hash.get("CNPJ_COLABORADOR"));
            auxiliar.put("NOME_COLABORADOR", (String)hash.get("NOME"));
            auxiliar.put("BC_IRRF", (Double)hash.get("BC_IRRF"));
            auxiliar.put("INSS", (Double)hash.get("INSS"));
            auxiliar.put("IRRF", (Double)hash.get("IRRF"));
            auxiliar.put("PENSAO_ALIMENTICIA", (Double)hash.get("PENSAO_ALIMENTICIA"));
            auxiliar.put("DEPENDENTES", (Double)hash.get("DEPENDENTES"));
            auxiliar.put("BC_IRRF_DEC", (Double)hash.get("BC_IRRF_DEC"));
            auxiliar.put("INSS_DEC", (Double)hash.get("INSS_DEC"));
            auxiliar.put("PENSAO_DEC", (Double)hash.get("PENSAO_DEC"));
            auxiliar.put("DEPENDENTES_DEC", (Double)hash.get("DEPENDENTES_DEC"));
            auxiliar.put("IRRF_DEC", (Double)hash.get("IRRF_DEC"));
            Date date = ToolDate.intToDate((Integer)(new Date().getYear() + 1900), (Integer)2, (Integer)ToolDate.getLastDayOnMonth((int)(new Date().getYear() + 1900), (int)2));
            auxiliar.put("DATA", date);
            auxiliar.put("ANO_BASE", anoBase);
            auxiliar.put("EMPRESA", empresaRh.getEmpresa().getPessoa().getNome());
            auxiliar.put("CNPJ_EMPRESA", empresaRh.getEmpresa().getPessoa().getComplemento().getCnpj());
            auxiliar.put("PESSOA_RESPONSAVEL", pessoaResponsavel);
            List<HashMap> valores = this.conferenciaDirfProSigla(anoBase, empresa, empresaRh, parametros, (String)hash.get("CNPJ_COLABORADOR"));
            for (HashMap h : valores) {
                String sigla = (String)h.get("SIGLA");
                auxiliar.put("VALOR_TOTAL_" + sigla, (Double)h.get("VALOR_TOTAL"));
                auxiliar.put("DESCRICAO_" + sigla, (String)h.get("DESCRICAO_DE_PARA"));
                auxiliar.put("F_NOME_CONVENIO_" + sigla, (String)h.get("F_NOME_CONVENIO"));
                auxiliar.put("F_CNPJ_CONVENIO_" + sigla, (String)h.get("F_CNPJ_CONVENIO"));
            }
        }
        auxiliar.put("VALOR_PARTICIPACAO_LUCROS", valorParticipacaoLucro);
        aux2.add(auxiliar);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "dirf" + File.separator + "informativorendimento" + File.separator + "LISTAGEM_INFORMATIVO_RENDIMENTO.jasper";
        CoreRequestContext coreRequestContext = new CoreRequestContext();
        coreRequestContext.setAttribute("path", path);
        coreRequestContext.setAttribute("parametros", parametros);
        coreRequestContext.setAttribute("dados", aux2);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(coreRequestContext, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List ordernarLista(List aux) {
        if (aux != null) {
            Collections.sort(aux, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap hash1 = (HashMap)o1;
                    HashMap hash2 = (HashMap)o2;
                    String cnpj1 = (String)hash1.get("CNPJ_COLABORADOR");
                    String cnpj2 = (String)hash2.get("CNPJ_COLABORADOR");
                    Long mes1 = (Long)hash1.get("ID_MOV");
                    Long mes2 = (Long)hash2.get("ID_MOV");
                    if (cnpj1.equalsIgnoreCase(cnpj2)) {
                        return mes1.compareTo(mes2);
                    }
                    return cnpj1.compareTo(cnpj2);
                }
            });
            return aux;
        }
        return aux;
    }

    private Double getVlrPensao(Long idMov) {
        String hql = " select coalesce(sum(item.valor),0) from ItemMovimentoFolha item  where   exists (select dePara.identificador         from DeParaTipoEventoDirf dePara          where          dePara.evento = item.eventoColaborador.tipoCalculoEvento.evento          and          dePara.tipoEventoDirf.codigo = :codigoPensao)  and  item.movimentoFolha.identificador = :idMov ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setString("codigoPensao", "RTPA").setLong("idMov", idMov.longValue()).uniqueResult();
    }

    private void getBcIrrfDec(Long idColaborador, Long anoBase, HashMap hash, Empresa empresa) {
        String hql = "  select  coalesce(sum(mov.nrDepIrrf),0) as DEPENDENTES,  coalesce(sum(mov.bcInss13Sal),0) as BC_IRRF, coalesce(sum(mov.vrIrrf13Sal),0) as IRRF, coalesce(sum(mov.vrInss13Sal),0) as INSS,  mov.colaborador.numeroRegistro as NR_REGISTRO, mov.colaborador.pessoa.nome as NOME, mov.colaborador.dataAdmissao as DATA_ADMISSAO, mov.colaborador.dataDemissao as DATA_DEMISSAO, mov.colaborador.pessoa.complemento.cnpj as CNPJ_COLABORADOR from MovimentoFolha mov  where  extract(year from mov.aberturaPeriodo.dataPagamento)  = :anoBase and  mov.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and  mov.colaborador.identificador = :identificador  and  mov.bcInss13Sal > :zero  and  (mov.aberturaPeriodo.tipoCalculo.tipoFolha = 0 or mov.aberturaPeriodo.tipoCalculo.tipoFolha = 2 or mov.aberturaPeriodo.tipoCalculo.tipoFolha = 8 or mov.aberturaPeriodo.tipoCalculo.tipoFolha = 6) group by   mov.colaborador.numeroRegistro , mov.colaborador.pessoa.nome , mov.colaborador.dataAdmissao , mov.colaborador.dataDemissao , mov.colaborador.pessoa.complemento.cnpj  ";
        HashMap ret = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).setLong("identificador", idColaborador.longValue()).setDouble("zero", 0.0).setInteger("anoBase", anoBase.intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (ret != null) {
            Double depDec = ((Long)ret.get("DEPENDENTES")).doubleValue();
            if (depDec != null) {
                depDec = depDec * 189.59;
            }
            hash.put("DEPENDENTES_DEC", depDec);
            hash.put("BC_IRRF_DEC", new Double((Double)ret.get("BC_IRRF")) - new Double((Double)ret.get("INSS")) - new Double((Double)ret.get("IRRF")));
            hash.put("INSS_DEC", ret.get("INSS"));
            hash.put("IRRF_DEC", ret.get("IRRF"));
            hash.put("PENSAO_DEC", this.getVlrPensaoDec(anoBase.intValue(), idColaborador, empresa));
        } else {
            hash.put("DEPENDENTES_DEC", 0.0);
            hash.put("BC_IRRF_DEC", 0.0);
            hash.put("INSS_DEC", 0.0);
            hash.put("IRRF_DEC", 0.0);
            hash.put("PENSAO_DEC", 0.0);
        }
    }

    private Double getVlrPensaoDec(Integer anoBase, Long identificador, Empresa empresa) {
        String hql = " select coalesce(sum(item.valor),0) from ItemMovimentoFolha item  where   exists (select dePara.identificador         from DeParaTipoEventoDirf dePara          where          dePara.evento = item.eventoColaborador.tipoCalculoEvento.evento          and          dePara.tipoEventoDirf.codigo = :codigoPensao)  and  item.movimentoFolha.colaborador.identificador = :identificador  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataPagamento) = :anoBase  and  (item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro  or  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :addDecimoTerceiro ) and  item.movimentoFolha.empresa.empresaDados.grupoEmpresa = :grupoEmpresa ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("identificador", identificador.longValue()).setInteger("anoBase", anoBase.intValue()).setString("codigoPensao", "RTPA").setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setShort("addDecimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue().shortValue()).setParameter("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).uniqueResult();
    }

    private List getListaGeral(Long anoBase, Empresa empresa, String ordenacao, Colaborador colaborador) {
        String hql = " select  mov.colaborador.identificador as ID_COLABORADOR, mov.nrDepIrrf as DEPENDENTES,  mov.identificador as ID_MOV,  (mov.vrInssSalario + mov.vrInssFerias ) as INSS,  extract(month from mov.aberturaPeriodo.dataInicio) as MES, mov.colaborador.numeroRegistro as NR_REGISTRO, mov.colaborador.pessoa.nome as NOME, mov.colaborador.dataAdmissao as DATA_ADMISSAO, mov.colaborador.dataDemissao as DATA_DEMISSAO, mov.colaborador.pessoa.complemento.cnpj as CNPJ_COLABORADOR, extract(month from mov.aberturaPeriodo.dataPagamento) as MES_PAGAMENTO  from MovimentoFolha mov  where  extract(year from mov.aberturaPeriodo.dataPagamento)  = :anoBase  and  ( mov.colaborador.pessoa.complemento.cnpj = :cpf)  and  (mov.aberturaPeriodo.tipoCalculo.tipoFolha = :adiantamentoSalario or mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento or mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaComplementar or mov.aberturaPeriodo.tipoCalculo.tipoFolha = :rescisaoComplementar) " + ordenacao;
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("anoBase", anoBase.intValue()).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setParameter("adiantamentoSalario", (Object)EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_SALARIO.getValue()).setParameter("folhaComplementar", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue()).setParameter("rescisaoComplementar", (Object)EnumConstTipoCalculoEvento.CALCULO_RECISAO_COMPLEMENTAR.getValue()).setParameter("cpf", (Object)ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj())).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private Double getRendimentosTributaveis(Long idMov) throws ExceptionService {
        Double valorAnt;
        Double valorAnt2;
        Short tipoEvento;
        HashMap h;
        Double desconto;
        Double provento;
        Session s = CoreBdUtil.getInstance().getSession();
        Date dataPagamento = null;
        MovimentoFolha mov = (MovimentoFolha)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOMovimentoFolha(), "identificador", idMov, 0);
        String hql = " select sum(i.valor) as VALOR,  i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO, i.movimentoFolha.aberturaPeriodo.dataPagamento as DATA_PAGAMENTO from ItemMovimentoFolha i where      i.movimentoFolha.statusFolha.codigo != :recisao and  i.movimentoFolha = :mov  and i.movimentoFolha.colaborador.pessoa.complemento.cnpj          = :cpf  and i.itemFeriasFolha = null  and (i.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha != :decTerceiro and      i.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha != :adiantDecTerceiro and       i.eventoColaborador.tipoCalculoEvento.tipoCalculo.tipoFolha != :decTerceiro and       i.eventoColaborador.tipoCalculoEvento.tipoCalculo.tipoFolha != :adiantDecTerceiro) and (exists        (         from DeParaTipoEventoDirf d        where d.tipoEventoDirf.identificador = :tipoEventoDirf and i.eventoColaborador.tipoCalculoEvento.evento = d.evento))  group by i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento, i.movimentoFolha.aberturaPeriodo.dataPagamento";
        Query q = s.createQuery(hql);
        q.setParameter("mov", (Object)mov);
        q.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
        q.setShort("decTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue());
        q.setShort("adiantDecTerceiro", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue().shortValue());
        q.setParameter("tipoEventoDirf", (Object)1L);
        q.setParameter("recisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        HashMap<Date, Double> hash = new HashMap<Date, Double>();
        if (lista != null && !lista.isEmpty()) {
            provento = 0.0;
            desconto = 0.0;
            for (Object ob : lista) {
                h = (HashMap)ob;
                dataPagamento = (Date)h.get("DATA_PAGAMENTO");
                if (hash.get(dataPagamento) == null) {
                    hash.put(dataPagamento, 0.0);
                }
                if ((tipoEvento = (Short)h.get("TIPO_EVENTO")).equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                    provento = (Double)h.get("VALOR");
                    valorAnt2 = (Double)hash.get(dataPagamento);
                    hash.put(dataPagamento, valorAnt2 + provento);
                    continue;
                }
                desconto = (Double)h.get("VALOR");
                valorAnt2 = (Double)hash.get(dataPagamento);
                hash.put(dataPagamento, valorAnt2 - desconto);
            }
        }
        if (mov.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            s = CoreBdUtil.getInstance().getSession();
            hql = " select i.itemFeriasFolha.itemFerias.valor as VALOR,  i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO, i.itemFeriasFolha.itemFerias.ferias.dataPagamento as DATA_PAGAMENTO from ItemMovimentoFolha i where  (i.movimentoFolha.empresa= :empresa and i.movimentoFolha.colaborador.pessoa.complemento.cnpj  = :cpf  and i.itemFeriasFolha.itemFerias.ferias.dataPagamento between :dataInicial and :dataFinal) and (exists            (         from DeParaTipoEventoDirf d        where d.tipoEventoDirf.identificador = :tipoEventoDirf and i.eventoColaborador.tipoCalculoEvento.evento = d.evento))  group by i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento,i.itemFeriasFolha.itemFerias.ferias.dataPagamento ,  i.itemFeriasFolha.itemFerias.valor ";
            q = s.createQuery(hql);
            q.setDate("dataInicial", DateUtil.getDateFirstMonthDay(mov.getAberturaPeriodo().getDataPagamento()));
            q.setDate("dataFinal", DateUtil.getDateLastMonthDay(mov.getAberturaPeriodo().getDataPagamento()));
            q.setEntity("empresa", (Object)mov.getEmpresa());
            q.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
            q.setParameter("tipoEventoDirf", (Object)1L);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            lista = q.list();
            if (lista != null && !lista.isEmpty()) {
                provento = 0.0;
                desconto = 0.0;
                for (Object ob : lista) {
                    h = (HashMap)ob;
                    dataPagamento = (Date)h.get("DATA_PAGAMENTO");
                    if (hash.get(dataPagamento) == null) {
                        hash.put(dataPagamento, 0.0);
                    }
                    if ((tipoEvento = (Short)h.get("TIPO_EVENTO")).equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                        provento = (Double)h.get("VALOR");
                        valorAnt2 = (Double)hash.get(dataPagamento);
                        hash.put(dataPagamento, valorAnt2 + provento);
                        continue;
                    }
                    desconto = (Double)h.get("VALOR");
                    valorAnt2 = (Double)hash.get(dataPagamento);
                    hash.put(dataPagamento, valorAnt2 - desconto);
                }
            }
            hql = " select sum(i.valor) as VALOR,  i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO, i.recisao.dataPagamento as DATA_PAGAMENTO from ItemMovimentoRescisao i where   i.itemOrigem.movimentoFolha = :mov  and i.recisao.empresa                                      = :empresa and i.recisao.colaborador.pessoa.complemento.cnpj          = :cpf  and (       i.eventoColaborador.tipoCalculoEvento.tipoCalculo.tipoFolha != :decTerceiro and       i.eventoColaborador.tipoCalculoEvento.tipoCalculo.tipoFolha != :adiantDecTerceiro) and (exists            (        from DeParaTipoEventoDirf d        where d.tipoEventoDirf.identificador = :tipoEventoDirf and i.eventoColaborador.tipoCalculoEvento.evento = d.evento))  group by i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento, i.recisao.dataPagamento";
            Query q1 = s.createQuery(hql);
            q1.setParameter("mov", (Object)mov);
            q1.setEntity("empresa", (Object)mov.getEmpresa());
            q1.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
            q1.setShort("decTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue());
            q1.setShort("adiantDecTerceiro", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue().shortValue());
            q1.setParameter("tipoEventoDirf", (Object)1L);
            q1.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            lista = q1.list();
            if (lista != null && !lista.isEmpty()) {
                Double provento2 = 0.0;
                Double desconto2 = 0.0;
                for (Object ob : lista) {
                    Short tipoEvento2;
                    HashMap h2 = (HashMap)ob;
                    dataPagamento = (Date)h2.get("DATA_PAGAMENTO");
                    if (hash.get(dataPagamento) == null) {
                        hash.put(dataPagamento, 0.0);
                    }
                    if ((tipoEvento2 = (Short)h2.get("TIPO_EVENTO")).equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                        provento2 = (Double)h2.get("VALOR");
                        valorAnt = (Double)hash.get(dataPagamento);
                        hash.put(dataPagamento, valorAnt + provento2);
                        continue;
                    }
                    desconto2 = (Double)h2.get("VALOR");
                    valorAnt = (Double)hash.get(dataPagamento);
                    hash.put(dataPagamento, valorAnt - desconto2);
                }
            }
        }
        HashMap<Integer, Double> newHash = new HashMap<Integer, Double>();
        Set chaves = hash.keySet();
        int mes = 0;
        for (Object o : chaves) {
            Date dataPag = (Date)o;
            Double valor = (Double)hash.get(dataPag);
            mes = DateUtil.monthFromDate(dataPag);
            if (newHash.get(mes) != null) {
                valorAnt = (Double)newHash.get(mes);
                newHash.put(mes, valorAnt + valor);
                continue;
            }
            newHash.put(mes, valor);
        }
        return (Double)newHash.get(mes) != null ? (Double)newHash.get(mes) : 0.0;
    }

    private Object getValorIRRF(Long idMov) throws ExceptionService {
        Double valorAnt;
        Date dataPagamento = null;
        MovimentoFolha mov = (MovimentoFolha)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOMovimentoFolha(), "identificador", idMov, 0);
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(m.vrIrrfSalario) as VR_IRRF, sum(m.vrIrrf13Sal) as VR_IRRF_13SAL, m.aberturaPeriodo.dataPagamento as DATA_PAGAMENTO from MovimentoFolha m  where  m.statusFolha.codigo != :recisao  and m = :mov and m.colaborador.pessoa.complemento.cnpj          = :cpf group by m.aberturaPeriodo.dataPagamento ";
        Query q = s.createQuery(hql);
        q.setParameter("mov", (Object)mov);
        q.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
        q.setShort("recisao", EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        HashMap<Object, Double> hash = new HashMap<Object, Double>();
        if (lista != null && !lista.isEmpty()) {
            Double valor = 0.0;
            for (Object ob : lista) {
                HashMap h = (HashMap)ob;
                dataPagamento = (Date)h.get("DATA_PAGAMENTO");
                if (hash.get(dataPagamento) == null) {
                    hash.put(dataPagamento, 0.0);
                }
                valor = (Double)h.get("VR_IRRF");
                Double valorAnt2 = (Double)hash.get(dataPagamento);
                hash.put(dataPagamento, valorAnt2 + valor);
                if (hash.get("13SAL") == null) {
                    hash.put("13SAL", 0.0);
                }
                Double valor13Sal = (Double)h.get("VR_IRRF_13SAL");
                valorAnt2 = (Double)hash.get("13SAL");
                hash.put("13SAL", valorAnt2 + valor13Sal);
            }
        }
        if (mov.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            lista = null;
            hql = " select sum(f.vrIrrfFerias) as VR_IRRF,  f.dataPagamento as DATA_PAGAMENTO  from FeriasColaborador f  where  f.periodoAqFeriasColab.colaborador.pessoa.complemento.cnpj = :cpf  and  f.dataPagamento between :dataInicial and :dataFinal  and  f.periodoFerias.empresa = :empresa  group by  f.dataPagamento ";
            Query q1 = s.createQuery(hql);
            q1.setDate("dataInicial", DateUtil.getDateFirstMonthDay(mov.getAberturaPeriodo().getDataPagamento()));
            q1.setDate("dataFinal", DateUtil.getDateLastMonthDay(mov.getAberturaPeriodo().getDataPagamento()));
            q1.setEntity("empresa", (Object)mov.getEmpresa());
            q1.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
            q1.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            lista = q1.list();
            if (lista != null && !lista.isEmpty()) {
                Double valor = 0.0;
                for (Object ob : lista) {
                    HashMap h = (HashMap)ob;
                    dataPagamento = (Date)h.get("DATA_PAGAMENTO");
                    if (hash.get(dataPagamento) == null) {
                        hash.put(dataPagamento, 0.0);
                    }
                    valor = (Double)h.get("VR_IRRF");
                    Double valorAnt3 = (Double)hash.get(dataPagamento);
                    hash.put(dataPagamento, valorAnt3 + valor);
                }
            }
            lista = null;
            hql = " select sum(r.vrlIrrf + r.vlrIrrfFerias) as VR_IRRF ,  sum(r.vlrIrrf13) as VR_IRRF_13SAL,  r.dataPagamento as DATA_PAGAMENTO from Recisao r  where  r.colaborador.pessoa.complemento.cnpj = :cpf  and  r.dataPagamento between :dataInicial and :dataFinal  and  r.empresa = :empresa  group by  r.dataPagamento";
            Query q2 = s.createQuery(hql);
            q2.setDate("dataInicial", mov.getAberturaPeriodo().getDataInicio());
            q2.setDate("dataFinal", mov.getAberturaPeriodo().getDataFinal());
            q2.setEntity("empresa", (Object)mov.getEmpresa());
            q2.setString("cpf", mov.getColaborador().getPessoa().getComplemento().getCnpj());
            q2.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            lista = q2.list();
            if (lista != null && !lista.isEmpty()) {
                Double valor = 0.0;
                for (Object ob : lista) {
                    HashMap h = (HashMap)ob;
                    dataPagamento = (Date)h.get("DATA_PAGAMENTO");
                    if (hash.get(dataPagamento) == null) {
                        hash.put(dataPagamento, 0.0);
                    }
                    valor = (Double)h.get("VR_IRRF");
                    valorAnt = (Double)hash.get(dataPagamento);
                    hash.put(dataPagamento, valorAnt + valor);
                    if (hash.get("13SAL") == null) {
                        hash.put("13SAL", 0.0);
                    }
                    Double valor13Sal = (Double)h.get("VR_IRRF_13SAL");
                    valorAnt = (Double)hash.get("13SAL");
                    hash.put("13SAL", valorAnt + valor13Sal);
                }
            }
        }
        HashMap<Integer, Double> newHash = new HashMap<Integer, Double>();
        Set chaves = hash.keySet();
        int mes = 0;
        for (Object o : chaves) {
            if (!(o instanceof Date)) continue;
            Date dataPag = (Date)o;
            Double valor = (Double)hash.get(dataPag);
            mes = DateUtil.monthFromDate(dataPag);
            if (newHash.get(mes) != null) {
                valorAnt = (Double)newHash.get(mes);
                newHash.put(mes, valorAnt + valor);
                continue;
            }
            newHash.put(mes, valor);
        }
        return (Double)newHash.get(mes) != null ? (Double)newHash.get(mes) : 0.0;
    }

    public List<HashMap> conferenciaDirfProSigla(Long anoBase, Empresa empresa, EmpresaRh empresaRh, HashMap parametros, String cpf) throws ExceptionService {
        String hql = "select  te.codigo as SIGLA,  te.descricao as DESCRICAO_DE_PARA, i.valor as VALOR_EVENTO, i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO, pcps.nome   AS F_NOME_CONVENIO, pcs.cnpj    AS F_CNPJ_CONVENIO  from MovimentoFolha m inner join m.colaborador c inner join m.aberturaPeriodo a inner join m.itensMovimentoFolha i inner join i.eventoColaborador ec inner join ec.tipoCalculoEvento tc inner join tc.evento e inner join e.deParaTipoEventoDirf de  left join de.convenioPlanoSaude cps  left join cps.pessoa pcps  left join pcps.complemento pcs inner join de.tipoEventoDirf te where  extract(year from a.dataPagamento) = :anoBase and  m.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  m.aberturaPeriodo.tipoCalculo.tipoFolha != 2  and  te.identificador != 1  and  m.colaborador.pessoa.complemento.cnpj = :cpf  group by  pcps.nome, pcs.cnpj, te.descricao, te.codigo ,  m.colaborador.numeroRegistro , m.colaborador.pessoa.nome, m.colaborador.dataAdmissao ,  m.colaborador.dataDemissao, i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento, i.valor, m.colaborador.pessoa.complemento.cnpj,  extract(month from m.aberturaPeriodo.dataPagamento)  order by m.colaborador.pessoa.complemento.cnpj";
        List aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setString("cpf", cpf).setInteger("anoBase", anoBase.intValue()).setParameter("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Double provento = 0.0;
        Double desconto = 0.0;
        boolean achou = false;
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        for (Object e : aux) {
            HashMap hashAux = (HashMap)e;
            String cpfAux = (String)hashAux.get("CPF_COLABORADOR");
            String siglaAux = (String)hashAux.get("SIGLA");
            for (Object e2 : retorno) {
                HashMap hashRetorno = (HashMap)e2;
                String cpfRetorno = (String)hashRetorno.get("CPF_COLABORADOR");
                String siglaRetorno = (String)hashRetorno.get("SIGLA");
                if (!siglaAux.equals(siglaRetorno)) continue;
                Short tipoEvento = (Short)hashAux.get("TIPO_EVENTO");
                if (tipoEvento.equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                    provento = (Double)hashAux.get("VALOR_EVENTO");
                    valorAnt = (Double)hashRetorno.get("VALOR_TOTAL");
                    hashRetorno.put("VALOR_TOTAL", valorAnt + provento);
                } else {
                    desconto = (Double)hashAux.get("VALOR_EVENTO");
                    valorAnt = (Double)hashRetorno.get("VALOR_TOTAL");
                    hashRetorno.put("VALOR_TOTAL", valorAnt - desconto);
                }
                achou = true;
            }
            if (!achou) {
                HashMap hashRetorno = new HashMap();
                hashRetorno.put("SIGLA", hashAux.get("SIGLA"));
                hashRetorno.put("DESCRICAO_DE_PARA", hashAux.get("DESCRICAO_DE_PARA"));
                hashRetorno.put("VALOR_TOTAL", 0.0);
                hashRetorno.put("PROVENTO", 0.0);
                hashRetorno.put("DESCONTO", 0.0);
                hashRetorno.put("F_NOME_CONVENIO", (String)hashAux.get("F_NOME_CONVENIO"));
                hashRetorno.put("F_CNPJ_CONVENIO", (String)hashAux.get("F_CNPJ_CONVENIO"));
                Short s = (Short)hashAux.get("TIPO_EVENTO");
                if (s.equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                    provento = (Double)hashAux.get("VALOR_EVENTO");
                    valorAnt = (Double)hashRetorno.get("VALOR_TOTAL");
                    hashRetorno.put("VALOR_TOTAL", valorAnt + provento);
                } else {
                    desconto = (Double)hashAux.get("VALOR_EVENTO");
                    valorAnt = (Double)hashRetorno.get("VALOR_TOTAL");
                    hashRetorno.put("VALOR_TOTAL", valorAnt - desconto);
                }
                retorno.add(hashRetorno);
            }
            achou = false;
        }
        for (Object e : retorno) {
            HashMap h = (HashMap)e;
            h.put("VALOR_TOTAL", Math.abs((Double)h.get("VALOR_TOTAL")));
        }
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dados", retorno);
        return retorno;
    }
}

