/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.locacaobens.contratolocacao;

import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GrupoContrLocacao;
import com.touchcomp.basementor.model.vo.Nodo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.dao.impl.DAOContratoLocacaoCore;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.locacaobens.contratolocacao.UtilListagemContratoLocacao;
import mentorcore.service.impl.locacaobens.contratolocacao.UtilRelatorioControleBensTeste;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceContratoLocacao
extends CoreService {
    public static final String FIND_CONTRATO_LOCACAO_BY_ATIVO = "getContratoLocacaoByAtivo";
    public static final String GET_OUTRO_CONTRATO_COM_ATIVO = "getOutroContratoComAtivo";
    public static final String GET_CONTRATO_ABERTO_ATIVO = "getContratoAbertoAtivo";
    public static final String FIND_CONTRATOS_POR_PERIODO = "findContratosPorPeriodo";
    public static final String GERAR_RELATORIO_CONTROLE_BENS_PARA_LOCACAO = "gerarRelatorioControleBensParaLocacao";
    public static final String GERAR_LISTAGEM_CONTRATO_LOCACAO = "gerarListagemContratoLocacao";
    public static String PRINT_FATURAMENTO_CONTRATO = "printFaturamentoContrato";

    public List<ContratoLocacao> getContratoLocacaoByAtivo(CoreRequestContext context) {
        Long idAtivo = (Long)context.getAttribute("identificador");
        return CoreDAOFactory.getInstance().getDAOContratoLocacaoCore().getContratoLocacaoByAtivo(idAtivo);
    }

    public ContratoLocacao getOutroContratoComAtivo(CoreRequestContext request) throws ExceptionService {
        Equipamento ativo = (Equipamento)request.getAttribute("ativo");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Long idContratoLocacao = (Long)request.getAttribute("idContratoLocacao");
        CoreDAOFactory.getInstance().getDAOContratoLocacaoCore();
        return DAOContratoLocacaoCore.getOutroContratoComAtivo(ativo, dataInicial, dataFinal, idContratoLocacao);
    }

    public ContratoLocacao getContratoAbertoAtivo(CoreRequestContext request) {
        Equipamento ativo = (Equipamento)request.getAttribute("ativo");
        Long idContrato = (Long)request.getAttribute("contrato");
        return CoreDAOFactory.getInstance().getDAOContratoLocacaoCore().getContratoAbertoAtivo(ativo, idContrato);
    }

    public List<ContratoLocacao> findContratosPorPeriodo(CoreRequestContext request) throws ExceptionService {
        Date periodo = (Date)request.getAttribute("periodo");
        Date dataApuracao = (Date)request.getAttribute("dataApuracao");
        GrupoContrLocacao grupoContrLocacao = (GrupoContrLocacao)request.getAttribute("grupoContrLocacao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        CoreDAOFactory.getInstance().getDAOContratoLocacaoCore();
        return DAOContratoLocacaoCore.findContratosPorPeriodo(dataApuracao, grupoContrLocacao, empresa);
    }

    public JasperPrint gerarRelatorioControleBensParaLocacao(CoreRequestContext request) throws ExceptionService {
        Short filtrarInicioVigencia = (Short)request.getAttribute("FILTRAR_INICIO_VIGENCIA");
        Date inicioVigenciaDataInicial = (Date)request.getAttribute("INICIO_VIGENCIA_DATA_INICIAL");
        Date inicioVigenciaDataFinal = (Date)request.getAttribute("INICIO_VIGENCIA_DATA_FINAL");
        Short filtrarFimVigencia = (Short)request.getAttribute("FILTRAR_FIM_VIGENCIA");
        Date fimVigenciaDataInicial = (Date)request.getAttribute("FINAL_VIGENCIA_DATA_INICIAL");
        Date fimVigenciaDataFinal = (Date)request.getAttribute("FINAL_VIGENCIA_DATA_FINAL");
        Short filtrarCliente = (Short)request.getAttribute("FILTRAR_CLIENTE");
        Long clienteInicial = (Long)request.getAttribute("CLIENTE_INICIAL");
        Long clienteFinal = (Long)request.getAttribute("CLIENTE_FINAL");
        Short filtrarTomador = (Short)request.getAttribute("FILTRAR_TOMADOR");
        Long tomadorInicial = (Long)request.getAttribute("TOMADOR_INICIAL");
        Long tomadorFinal = (Long)request.getAttribute("TOMADOR_FINAL");
        Short filtrarAtivo = (Short)request.getAttribute("FILTRAR_ATIVO");
        Long ativoInicial = (Long)request.getAttribute("ATIVO_INICIAL");
        Long ativoFinal = (Long)request.getAttribute("ATIVO_FINAL");
        Empresa empresa = (Empresa)request.getAttribute("EMPRESA");
        Short status = (Short)request.getAttribute("STATUS");
        String fecho = (String)request.getAttribute("FECHO");
        HashMap params = (HashMap)request.getAttribute("params");
        Nodo nodo = (Nodo)request.getAttribute("nodo");
        UtilRelatorioControleBensTeste utilRelatorioControleBensTeste = new UtilRelatorioControleBensTeste();
        return utilRelatorioControleBensTeste.gerarRelatorioControleBensLocacao(filtrarAtivo, ativoInicial, ativoFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarInicioVigencia, inicioVigenciaDataInicial, inicioVigenciaDataFinal, filtrarFimVigencia, fimVigenciaDataInicial, fimVigenciaDataFinal, filtrarTomador, tomadorInicial, tomadorFinal, nodo, params, empresa, fecho, status);
    }

    public JasperPrint gerarListagemContratoLocacao(CoreRequestContext request) throws ExceptionService {
        Short filtrarDataInicial = (Short)request.getAttribute("FILTRAR_DATA_INICIAL");
        Date dataInicialInicial = (Date)request.getAttribute("DATA_INICIAL_INICIAL");
        Date dataInicialFinal = (Date)request.getAttribute("DATA_INICIAL_FINAL");
        Short filtrarDataFinal = (Short)request.getAttribute("FILTRAR_DATA_FINAL");
        Date dataFinalInicial = (Date)request.getAttribute("DATA_FINAL_INICIAL");
        Date dataFinalFinal = (Date)request.getAttribute("DATA_FINAL_FINAL");
        Short filtrarCliente = (Short)request.getAttribute("FILTRAR_CLIENTE");
        Long clienteInicial = (Long)request.getAttribute("CLIENTE_INICIAL");
        Long clienteFinal = (Long)request.getAttribute("CLIENTE_FINAL");
        Short filtrarTomador = (Short)request.getAttribute("FILTRAR_TOMADOR");
        Long tomadorInicial = (Long)request.getAttribute("TOMADOR_INICIAL");
        Long tomadorFinal = (Long)request.getAttribute("TOMADOR_FINAL");
        Short filtrarBem = (Short)request.getAttribute("FILTRAR_ATIVO");
        Long bemInicial = (Long)request.getAttribute("ATIVO_INICIAL");
        Long bemFinal = (Long)request.getAttribute("ATIVO_FINAL");
        Short filtrarRepresentante = (Short)request.getAttribute("FILTRAR_REPRESENTANTE");
        Long representanteInicial = (Long)request.getAttribute("REPRESENTANTE_INICIAL");
        Long representanteFinal = (Long)request.getAttribute("REPRESENTANTE_FINAL");
        Short status = (Short)request.getAttribute("STATUS");
        String fecho = (String)request.getAttribute("FECHO");
        Short filtrarAberto = (Short)request.getAttribute("FILTRAR_ABERTO");
        Short filtrarFechado = (Short)request.getAttribute("FILTRAR_FECHADO");
        Short filtrarEmpresa = (Short)request.getAttribute("P_FILTRAR_EMPRESA");
        Long empresaIncial = (Long)request.getAttribute("P_ID_EMPRESA_INICIAL");
        Long empresaFinal = (Long)request.getAttribute("P_ID_EMPRESA_FINAL");
        HashMap params = (HashMap)request.getAttribute("params");
        Nodo nodo = (Nodo)request.getAttribute("nodo");
        return UtilListagemContratoLocacao.gerarListagemContratoLocacao(filtrarDataInicial, dataInicialInicial, dataInicialFinal, filtrarDataFinal, dataFinalInicial, dataFinalFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarBem, bemInicial, bemFinal, filtrarRepresentante, representanteInicial, representanteFinal, filtrarTomador, tomadorInicial, tomadorFinal, filtrarEmpresa, empresaIncial, empresaFinal, filtrarAberto, filtrarFechado, status, fecho, params, nodo);
    }

    public JasperPrint printFaturamentoContrato(CoreRequestContext request) throws ExceptionService {
        Short exibirNotaRps = (Short)request.getAttribute("exibirNotaRps");
        Short filtrarDataApuracao = (Short)request.getAttribute("filtrarDataApuracao");
        Date dataApuracaoInicial = (Date)request.getAttribute("dataApuracaoInicial");
        Date dataApuracaoFinal = (Date)request.getAttribute("dataApuracaoFinal");
        Short filtarDataEmissao = (Short)request.getAttribute("filtrarDataEmissao");
        Date dataEmissaoInicial = (Date)request.getAttribute("dataEmissaoInicial");
        Date dataEmissaoFinal = (Date)request.getAttribute("dataEmissaoFinal");
        Short filtrarCliente = (Short)request.getAttribute("filtrarCliente");
        Long clienteInicial = (Long)request.getAttribute("clienteInicial");
        Long clienteFinal = (Long)request.getAttribute("clienteFinal");
        Short filtrarTomador = (Short)request.getAttribute("filtrarTomador");
        Long tomadorInicial = (Long)request.getAttribute("tomadorInicial");
        Long tomadorFinal = (Long)request.getAttribute("tomadorFinal");
        Short filtrarContrato = (Short)request.getAttribute("filtrarContrato");
        Long contratoInicial = (Long)request.getAttribute("contratoInicial");
        Long contratoFinal = (Long)request.getAttribute("contratoFinal");
        Short mostrarAtivo = (Short)request.getAttribute("mostrarAtivo");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Nodo nodo = (Nodo)request.getAttribute("nodo");
        HashMap params = (HashMap)request.getAttribute("params");
        return UtilListagemContratoLocacao.gerarListagemFaturamentoContrto(exibirNotaRps, filtrarDataApuracao, dataApuracaoInicial, dataApuracaoFinal, filtarDataEmissao, dataEmissaoInicial, dataEmissaoFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarContrato, contratoInicial, contratoFinal, filtrarTomador, tomadorInicial, tomadorFinal, nodo, params, empresa, mostrarAtivo);
    }
}

