/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.locacaobens.contratolocacao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OrdemServico;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilRelatorioControleBensParaLocacao {
    private static Object MenuDispatcher;

    UtilRelatorioControleBensParaLocacao() {
    }

    static JasperPrint gerarRelatorioControleBensParaLocacao(Short filtrarDataVigencia, Date dataVigenciaInicial, Date dataVigenciaFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarBem, Long bemInicial, Long bemFinal, Empresa empresa, Short status, String fecho, HashMap params, Nodo nodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT b.identificador AS ID_BEM,             b.codigo        AS CODIGO_BEM,             b.descricao     AS NOME_BEM,             e.identificador               AS ATIVO FROM Bem b LEFT JOIN b.equipamento e WHERE (:filtrarBem <> 1 or b.identificador BETWEEN :bemInicial AND :bemFinal) ";
        Query q = s.createQuery(query);
        q.setShort("filtrarBem", filtrarBem.shortValue());
        q.setLong("bemInicial", bemInicial.longValue());
        q.setLong("bemFinal", bemFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List bens = q.list();
        List<HashMap> bensContrato = UtilRelatorioControleBensParaLocacao.getContratosLocacao(bens, filtrarDataVigencia, dataVigenciaInicial, dataVigenciaFinal, filtrarCliente, clienteInicial, clienteFinal, status);
        List<HashMap> result = UtilRelatorioControleBensParaLocacao.setStatusBem(bensContrato, empresa);
        result = UtilRelatorioControleBensParaLocacao.filtrarStatus(result, status);
        params.put("FILTRAR_DATA_VIGENCIA", filtrarDataVigencia);
        params.put("DATA_VIGENCIA_INICIAL", dataVigenciaInicial);
        params.put("DATA_VIGENCIA_FINAL", dataVigenciaFinal);
        params.put("FILTRAR_CLIENTE", filtrarCliente);
        params.put("CLIENTE_INICIAL", clienteInicial);
        params.put("CLIENTE_FINAL", clienteFinal);
        params.put("FILTRAR_BEM", filtrarBem);
        params.put("BEM_INICIAL", bemInicial);
        params.put("BEM_FINAL", bemFinal);
        params.put("STATUS", status);
        params.put("FECHO", fecho);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "locacao" + File.separator + "controlebensparalocacao" + File.separator + "RELATORIO_CONTROLE_BENS_PARA_LOCACAO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", result);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private static List<HashMap> getContratosLocacao(List<HashMap> bens, Short filtrarDataVigencia, Date dataVigenciaInicial, Date dataVigenciaFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short status) {
        for (HashMap h : bens) {
            String query = "SELECT cb.contratoLocacao.identificador       AS ID_CONTRATO,             cb.contratoLocacao.numeroContrato      AS NUM_CONTRATO,             cb.contratoLocacao.dataInicialVigencia AS DATA_INICIAL_VIGENCIA,             cb.contratoLocacao.dataFinalVigencia   AS DATA_FINAL_VIGENCIA,             f.dataHoraFechamento                   AS DATA_FECHAMENTO,             cb.contratoLocacao.preContrato         AS PRE_CONTRATO FROM ContratoLocacaoBem cb LEFT JOIN cb.contratoLocacao.fechamentoContratoLocacao f WHERE cb.bem.identificador = :idBem AND (:filtrarCliente      <> 1 OR cb.contratoLocacao.cliente.identificador BETWEEN :clienteInicial AND :clienteFinal) AND (:filtrarDataVigencia <> 1 OR (cb.contratoLocacao.dataInicialVigencia >= :dataVigenciaInicial                                    AND cb.contratoLocacao.dataFinalVigencia <= :dataVigenciaFinal) ) ";
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery(query);
            q.setShort("filtrarCliente", filtrarCliente.shortValue());
            q.setLong("clienteInicial", clienteInicial.longValue());
            q.setLong("clienteFinal", clienteFinal.longValue());
            q.setShort("filtrarDataVigencia", filtrarDataVigencia.shortValue());
            q.setDate("dataVigenciaInicial", dataVigenciaInicial);
            q.setDate("dataVigenciaFinal", dataVigenciaFinal);
            q.setLong("idBem", ((Long)h.get("ID_BEM")).longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List contratos = q.list();
            HashMap hashToAdd = UtilRelatorioControleBensParaLocacao.getContratoEmVigencia(h, contratos);
            if (hashToAdd == null) continue;
            h.putAll(hashToAdd);
        }
        return bens;
    }

    private static HashMap getContratoEmVigencia(HashMap hashBem, List<HashMap> contratos) {
        HashMap contratoVigente = null;
        for (HashMap h : contratos) {
            Date dataInicialVigencia = (Date)h.get("DATA_INICIAL_VIGENCIA");
            Date dataFinalVigencia = (Date)h.get("DATA_FINAL_VIGENCIA");
            Date dataFechamento = (Date)h.get("DATA_FECHAMENTO");
            Date dataAtual = new Date();
            if (dataFechamento == null) {
                if (!DateUtil.dateBetween(dataAtual, dataInicialVigencia, dataFinalVigencia).booleanValue()) continue;
                contratoVigente = h;
                continue;
            }
            if (!DateUtil.dateBetween(dataAtual, dataInicialVigencia, dataFechamento).booleanValue()) continue;
            contratoVigente = h;
        }
        if (contratoVigente != null) {
            contratoVigente.put("DIAS_RETORNO", DateUtil.diferenceDayBetweenDates(new Date(), (Date)contratoVigente.get("DATA_FINAL_VIGENCIA")));
        }
        return contratoVigente;
    }

    private static List<HashMap> setStatusBem(List<HashMap> bensContrato, Empresa empresa) throws ExceptionService {
        for (HashMap h : bensContrato) {
            HashMap hashToAdd;
            Long numeroContrato = (Long)h.get("NUM_CONTRATO");
            Short preContrato = (Short)h.get("PRE_CONTRATO");
            if (numeroContrato != null && preContrato == 0) {
                h.put("STATUS_CONTRATO", 1);
            } else if (numeroContrato != null && preContrato == 1) {
                h.put("STATUS_PRE_CONTRATO", 1);
            }
            if (numeroContrato == null) {
                h.put("STATUS_EMPRESA", 1);
            }
            if ((hashToAdd = UtilRelatorioControleBensParaLocacao.getDadosCasoManutencao(h, empresa)) == null) continue;
            h.putAll(hashToAdd);
        }
        return bensContrato;
    }

    private static HashMap getDadosCasoManutencao(HashMap h, Empresa empresa) throws ExceptionService {
        if (h.get("ATIVO") != null) {
            Object pendencias = "";
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("ativo", h.get("ATIVO"));
            request.setAttribute("isFechada", false);
            request.setAttribute("empresa", empresa);
            List ordensServico = (List)CoreServiceFactory.getServiceOrdemServico().execute(request, "findOrdemServicoPorAtivo");
            if (!ordensServico.isEmpty()) {
                int i = 1;
                for (OrdemServico ordemServico : ordensServico) {
                    pendencias = (String)pendencias + ordemServico.getCodigo();
                    if (i != ordensServico.size()) {
                        pendencias = (String)pendencias + ", ";
                    }
                    ++i;
                }
                h.put("STATUS_MANUTENCAO", 1);
                h.put("OS", pendencias);
                return h;
            }
        }
        return null;
    }

    private static List<HashMap> filtrarStatus(List<HashMap> list, Short status) {
        if (status.equals((short)3)) {
            return list;
        }
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (HashMap h : list) {
            Integer locado = (Integer)h.get("STATUS_CONTRATO");
            Integer reservado = (Integer)h.get("STATUS_PRE_CONTRATO");
            Integer naoLocado = (Integer)h.get("STATUS_EMPRESA");
            Integer manutencao = (Integer)h.get("STATUS_MANUTENCAO");
            if (!(status.equals((short)0) && locado != null && locado == 1 && !result.contains(h) || status.equals((short)1) && naoLocado != null && naoLocado == 1 && !result.contains(h) || status.equals((short)2) && reservado != null && reservado == 1 && !result.contains(h)) && (!status.equals((short)4) || manutencao == null || manutencao != 1 || result.contains(h))) continue;
            result.add(h);
        }
        return result;
    }
}

