/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.locacaobens.contratolocacao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilRelatorioControleBensTeste {
    private static Object MenuDispatcher;

    public JasperPrint gerarRelatorioControleBensLocacao(Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarInicioVigencia, Date inicioVigenciaDataInicial, Date inicioVigenciaDataFinal, Short filtrarFimVigencia, Date fimVigenciaDataInicial, Date fimVigenciaDataFinal, Short filtrarTomador, Long tomadorInicial, Long tomadorFinal, Nodo nodo, HashMap params, Empresa empresa, String fecho, Short status) throws ExceptionService {
        List data = new LinkedList<HashMap>();
        if (status == 3) {
            this.putTodosBens(filtrarAtivo, ativoInicial, ativoFinal, data);
        }
        if (status == 1) {
            this.putTodosBens(filtrarAtivo, ativoInicial, ativoFinal, data);
        }
        if (status == 0 || status == 3 || status == 1) {
            this.putBensLocados(filtrarAtivo, ativoInicial, ativoFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarTomador, tomadorInicial, tomadorFinal, filtrarInicioVigencia, inicioVigenciaDataInicial, inicioVigenciaDataFinal, filtrarFimVigencia, fimVigenciaDataInicial, fimVigenciaDataFinal, data, status);
        }
        if (status == 2 || status == 3 || status == 1) {
            this.putBensReservados(filtrarAtivo, ativoInicial, ativoFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarTomador, tomadorInicial, tomadorFinal, filtrarInicioVigencia, inicioVigenciaDataInicial, inicioVigenciaDataFinal, filtrarFimVigencia, fimVigenciaDataInicial, fimVigenciaDataFinal, data, status);
        }
        this.putBensManutencao(empresa, filtrarAtivo, ativoInicial, ativoFinal, status, data);
        params.put("FILTRAR_INICIO_VIGENCIA", filtrarInicioVigencia);
        params.put("INICIO_VIGENCIA_DATA_INICIAL", inicioVigenciaDataInicial);
        params.put("INICIO_VIGENCIA_DATA_FINAL", inicioVigenciaDataFinal);
        params.put("FILTRAR_FIM_VIGENCIA", filtrarFimVigencia);
        params.put("FIM_VIGENCIA_DATA_INICIAL", fimVigenciaDataInicial);
        params.put("FIM_VIGENCIA_DATA_FINAL", fimVigenciaDataFinal);
        params.put("FILTRAR_CLIENTE", filtrarCliente);
        params.put("CLIENTE_INICIAL", clienteInicial);
        params.put("CLIENTE_FINAL", clienteFinal);
        params.put("FILTRAR_TOMADOR", filtrarTomador);
        params.put("TOMADOR_INICIAL", tomadorInicial);
        params.put("TOMADOR_FINAL", tomadorFinal);
        params.put("FILTRAR_ATIVO", filtrarAtivo);
        params.put("ATIVO_INICIAL", ativoInicial);
        params.put("ATIVO_FINAL", ativoFinal);
        params.put("STATUS", status);
        params.put("FECHO", fecho);
        this.setStatusBem(data);
        if (status == 1) {
            data = this.setNaoLocados(data);
        }
        this.setDiasRetorno(data);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("isPaisagem", true).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "locacao" + File.separator + "controlebensparalocacao" + File.separator + "RELATORIO_CONTROLE_BENS_PARA_LOCACAO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("dados", data);
        relatorio.setAttribute("parametros", params);
        JasperPrint jasper = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasper;
    }

    private void putTodosBens(Short filtrarAtivo, Long idInicial, Long idFinal, List data) {
        Session session = CoreBdUtil.getInstance().getSession();
        String query = "SELECT ativo.identificador AS ID_ATIVO,      ativo.codigo AS CODIGO_ATIVO,      ativo.nome AS NOME_ATIVO FROM Equipamento ativo WHERE (:filtrarAtivo  <> 1 or ativo.identificador BETWEEN :idInicial AND :idFinal)";
        Query q = session.createQuery(query);
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("idInicial", idInicial.longValue());
        q.setLong("idFinal", idFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        data.addAll(q.list());
    }

    private void putBensLocados(Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarTomador, Long tomadorInicial, Long tomadorFinal, Short filtrarInicioVigencia, Date inicioVigenciaDataInicial, Date inicioVigenciaDataFinal, Short filtrarFimVigencia, Date fimVigenciaDataInicial, Date fimVigenciaDataFinal, List data, Short status) {
        Session session = CoreBdUtil.getInstance().getSession();
        String query = "SELECT a.identificador AS ID_ATIVO,      a.codigo as CODIGO_ATIVO,      a.nome AS NOME_ATIVO,      c.numeroContrato AS NUM_CONTRATO,      c.preContrato AS PRE_CONTRATO,      c.dataInicialVigencia AS DATA_INICIAL_VIGENCIA,      c.dataFinalVigencia   AS DATA_FINAL_VIGENCIA  FROM ContratoLocacaoBem cb      inner join cb.ativo a      inner join cb.itemContratoLocacao item      inner join item.contratoLocacao c      left join c.cliente cc      left join c.tomador tom      left join c.fechamentoContratoLocacao f  WHERE (:filtrarAtivo            <> 1 OR a.identificador BETWEEN :ativoInicial AND :ativoFinal)  AND   (:filtrarCliente        <> 1 OR cc.identificador BETWEEN :clienteInicial AND :clienteFinal)  AND   (:filtrarTomador        <> 1 OR tom.identificador BETWEEN :tomadorInicial AND :tomadorFinal)  AND   (:filtrarInicioVigencia <> 1 OR c.dataInicialVigencia BETWEEN :inicioVigenciaDataInicial AND :inicioVigenciaDataFinal)  AND   (:filtrarFimVigencia    <> 1 OR c.dataFinalVigencia BETWEEN :fimVigenciaDataInicial and :fimVigenciaDataFinal)  AND c.preContrato=0 AND f.identificador is null";
        Query q = session.createQuery(query);
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("ativoInicial", ativoInicial.longValue());
        q.setLong("ativoFinal", ativoFinal.longValue());
        q.setShort("filtrarCliente", filtrarCliente.shortValue());
        q.setLong("clienteInicial", clienteInicial.longValue());
        q.setLong("clienteFinal", clienteFinal.longValue());
        q.setShort("filtrarTomador", filtrarTomador.shortValue());
        q.setLong("tomadorInicial", tomadorInicial.longValue());
        q.setLong("tomadorFinal", tomadorFinal.longValue());
        q.setShort("filtrarInicioVigencia", filtrarInicioVigencia.shortValue());
        q.setDate("inicioVigenciaDataInicial", inicioVigenciaDataInicial);
        q.setDate("inicioVigenciaDataFinal", inicioVigenciaDataFinal);
        q.setShort("filtrarFimVigencia", filtrarFimVigencia.shortValue());
        q.setDate("fimVigenciaDataInicial", fimVigenciaDataInicial);
        q.setDate("fimVigenciaDataFinal", fimVigenciaDataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        if (status == 0) {
            data.addAll(ret);
        }
        this.mesclar(data, ret);
    }

    private void putBensReservados(Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarTomador, Long tomadorInicial, Long tomadorFinal, Short filtrarInicioVigencia, Date inicioVigenciaDataInicial, Date inicioVigenciaDataFinal, Short filtrarFimVigencia, Date fimVigenciaDataInicial, Date fimVigenciaDataFinal, List data, Short status) {
        Session session = CoreBdUtil.getInstance().getSession();
        String query = "SELECT a.identificador AS ID_ATIVO,       a.codigo as CODIGO_ATIVO,       a.nome AS NOME_ATIVO,       c.numeroContrato AS NUM_CONTRATO,       c.preContrato AS PRE_CONTRATO,       c.dataInicialVigencia AS DATA_INICIAL_VIGENCIA,       c.dataFinalVigencia   AS DATA_FINAL_VIGENCIA  FROM ContratoLocacaoBem cb       inner join cb.ativo a       inner join cb.itemContratoLocacao item       inner join item.contratoLocacao c       left join c.cliente cc       left join c.tomador tom  WHERE (:filtrarAtivo            <> 1 OR a.identificador BETWEEN :ativoInicial AND :ativoFinal)  AND   (:filtrarCliente           <> 1 OR cc.identificador BETWEEN :clienteInicial AND :clienteFinal)  AND   (:filtrarTomador           <> 1 OR tom.identificador BETWEEN :tomadorInicial AND :tomadorFinal)  AND   (:filtrarInicioVigencia <> 1 OR c.dataInicialVigencia BETWEEN :inicioVigenciaDataInicial AND :inicioVigenciaDataFinal)  AND   (:filtrarFimVigencia    <> 1 OR c.dataFinalVigencia BETWEEN :fimVigenciaDataInicial and :fimVigenciaDataFinal)  AND c.preContrato=1";
        Query q = session.createQuery(query);
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("ativoInicial", ativoInicial.longValue());
        q.setLong("ativoFinal", ativoFinal.longValue());
        q.setShort("filtrarCliente", filtrarCliente.shortValue());
        q.setLong("clienteInicial", clienteInicial.longValue());
        q.setLong("clienteFinal", clienteFinal.longValue());
        q.setShort("filtrarTomador", filtrarTomador.shortValue());
        q.setLong("tomadorInicial", tomadorInicial.longValue());
        q.setLong("tomadorFinal", tomadorFinal.longValue());
        q.setShort("filtrarInicioVigencia", filtrarInicioVigencia.shortValue());
        q.setDate("inicioVigenciaDataInicial", inicioVigenciaDataInicial);
        q.setDate("inicioVigenciaDataFinal", inicioVigenciaDataFinal);
        q.setShort("filtrarFimVigencia", filtrarFimVigencia.shortValue());
        q.setDate("fimVigenciaDataInicial", fimVigenciaDataInicial);
        q.setDate("fimVigenciaDataFinal", fimVigenciaDataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        if (status == 2 && ret != null) {
            data.addAll(ret);
        }
        this.mesclar(data, ret);
    }

    private void putBensManutencao(Empresa empresa, Short filtrarAtivo, Long idInicial, Long idFinal, Short status, List data) throws ExceptionService {
        if (status == 2 && data.isEmpty()) {
            return;
        }
        if (status == 0 && data.isEmpty()) {
            return;
        }
        Session session = CoreBdUtil.getInstance().getSession();
        String query = "SELECT a.identificador as ID_ATIVO,       a.codigo AS CODIGO_ATIVO,       a.nome AS NOME_ATIVO,       os.codigo AS OS      FROM OrdemServico os       inner join os.equipamento a      WHERE (:filtrarAtivo <> 1 OR a.identificador BETWEEN :idInicial AND :idFinal)      AND (os.empresa.identificador=:idEmpresa)      AND (os.status=0) ";
        Query q = session.createQuery(query);
        q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("idInicial", idInicial.longValue());
        q.setLong("idFinal", idFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List<HashMap> ret = q.list();
        ret = this.retirarDuplicacaoOs(ret);
        this.mesclar(data, ret);
    }

    private void mesclar(List<HashMap> data, List<HashMap> ret) {
        if (data == null || data.isEmpty()) {
            data.addAll(ret);
        } else {
            for (HashMap h1 : data) {
                Long idAtivo = (Long)h1.get("ID_ATIVO");
                for (HashMap h2 : ret) {
                    Long idAtivo2 = (Long)h2.get("ID_ATIVO");
                    if (!idAtivo.equals(idAtivo2)) continue;
                    h1.putAll(h2);
                }
            }
        }
    }

    private List<HashMap> retirarDuplicacaoOs(List<HashMap> ret) {
        ArrayList<HashMap> toReturn = new ArrayList<HashMap>();
        for (int i = 0; i < ret.size(); ++i) {
            Long idAtivo = (Long)ret.get(i).get("ID_ATIVO");
            Long maior = (Long)ret.get(i).get("OS");
            for (int j = 0; j < ret.size(); ++j) {
                Long idAtivo2 = (Long)ret.get(j).get("ID_ATIVO");
                Long os2 = (Long)ret.get(j).get("OS");
                if (idAtivo != idAtivo2 || maior == os2 || maior >= os2) continue;
                maior = os2;
            }
            if (this.jaExiste(toReturn, ret.get(i))) continue;
            ret.get(i).put("STATUS_MANUTENCAO", 1);
            ret.get(i).put("STATUS_DISPONIVEL", 0);
            ret.get(i).put("OS", maior);
            toReturn.add(ret.get(i));
        }
        return toReturn;
    }

    private boolean jaExiste(List<HashMap> toReturn, HashMap ret) {
        for (HashMap h : toReturn) {
            if (h.get("ID_ATIVO") != ret.get("ID_ATIVO")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setStatusBem(List<HashMap> data) {
        for (HashMap h : data) {
            Long numeroContrato = (Long)h.get("NUM_CONTRATO");
            Short preContrato = (Short)h.get("PRE_CONTRATO");
            boolean manutencao = (Integer)h.get("STATUS_MANUTENCAO") != null;
            if (numeroContrato != null && preContrato == 0) {
                h.put("STATUS_CONTRATO", 1);
                h.put("STATUS_DISPONIVEL", 0);
            }
            if (numeroContrato != null && preContrato == 1) {
                h.put("STATUS_PRE_CONTRATO", 1);
                h.put("STATUS_DISPONIVEL", 0);
            }
            if (numeroContrato != null || manutencao) continue;
            h.put("STATUS_DISPONIVEL", 1);
        }
    }

    private void setDiasRetorno(List<HashMap> data) {
        for (HashMap h : data) {
            Date dataInicialVigencia = (Date)h.get("DATA_INICIAL_VIGENCIA");
            Date dataFinalVigencia = (Date)h.get("DATA_FINAL_VIGENCIA");
            Date dataFechamento = (Date)h.get("DATA_FECHAMENTO");
            Date dataAtual = new Date();
            Long numContrato = (Long)h.get("NUM_CONTRATO");
            Short preContrato = (Short)h.get("PRE_CONTRATO");
            if (numContrato == null || preContrato != 0) continue;
            int diasRetorno = DateUtil.diferenceDayBetweenDates(new Date(), (Date)h.get("DATA_FINAL_VIGENCIA"));
            h.put("DIAS_RETORNO", diasRetorno);
        }
    }

    private List setNaoLocados(List<HashMap> data) {
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        for (HashMap h : data) {
            Integer naoLocado = (Integer)h.get("STATUS_DISPONIVEL");
            if (naoLocado == null) {
                naoLocado = 0;
            }
            if (naoLocado != 1) continue;
            ret.add(h);
        }
        return ret;
    }
}

