/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lotefabricacao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.lotefabricacao.UtilLoteFabricacao;

public class ServiceLoteFabricacao
extends CoreService {
    public static final String UPDATE_LOTE_FABRICACAO = "updateLoteFabricacao";
    public static final String FIND_MELHOR_LOTE_FABRICACAO = "findMelhorLoteFabricacao";
    public static final String FIND_FIRST_LOTE_FABRICACAO = "findFirstLoteFabricacao";

    public void updateLoteFabricacao(CoreRequestContext request) {
        Long idLoteFabricacao = (Long)request.getAttribute("idLoteFabricacao");
        String loteFabricacao = (String)request.getAttribute("loteFabricacao");
        Date dataFabricacao = (Date)request.getAttribute("dataFabricacao");
        Date dataValidade = (Date)request.getAttribute("dataValidade");
        CoreDAOFactory.getInstance().getDAOLoteFabricacao().updateLoteFabricacao(idLoteFabricacao, loteFabricacao, dataFabricacao, dataValidade);
    }

    public LoteFabricacao findMelhorLoteFabricacao(CoreRequestContext request) throws ExceptionService {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        try {
            return UtilLoteFabricacao.findMelhorLoteFabricacao(gradeCor.getProdutoGrade().getProduto(), gradeCor, empresa, data);
        }
        catch (ExceptionDatabase ex) {
            ex.printStackTrace();
            throw new ExceptionService(ex);
        }
    }

    public LoteFabricacao findFirstLoteFabricacao(CoreRequestContext request) throws ExceptionService {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        try {
            return UtilLoteFabricacao.findFirstLoteFabricacao(gradeCor.getProdutoGrade().getProduto(), gradeCor, empresa, data);
        }
        catch (ExceptionDatabase ex) {
            ex.printStackTrace();
            throw new ExceptionService(ex);
        }
    }
}

