/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.lotefabricacao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;

class UtilLoteFabricacao {
    private static final ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);

    UtilLoteFabricacao() {
    }

    static LoteFabricacao findMelhorLoteFabricacao(Produto produto, GradeCor gradeCor, Empresa empresa, Date data) throws ExceptionDatabase {
        if (produto != null && produto.getLoteUnico() != null && produto.getLoteUnico().equals((short)0)) {
            return UtilLoteFabricacao.findMelhorLoteFabricacao(gradeCor, empresa, data);
        }
        return UtilLoteFabricacao.findLoteFabricacaoUnico(produto);
    }

    static LoteFabricacao findFirstLoteFabricacao(Produto produto, GradeCor gradeCor, Empresa empresa, Date data) throws ExceptionDatabase {
        if (produto != null && produto.getLoteUnico() != null && produto.getLoteUnico().equals((short)0)) {
            return UtilLoteFabricacao.findFirstLoteFabricacao(gradeCor, empresa, data);
        }
        return UtilLoteFabricacao.findLoteFabricacaoUnico(produto);
    }

    private static LoteFabricacao findMelhorLoteFabricacao(GradeCor gradeCor, Empresa empresa, Date data) throws ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOLoteFabricacao().findMelhorLote(gradeCor, data, empresa);
    }

    private static LoteFabricacao findFirstLoteFabricacao(GradeCor gradeCor, Empresa empresa, Date data) throws ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOLoteFabricacao().findFirstLote(gradeCor, data, empresa);
    }

    private static LoteFabricacao findLoteFabricacaoUnico(Produto produto) {
        LoteFabricacao loteFabricacao = serviceLoteFabricacaoImpl.findOrCreateLoteUnico(produto);
        return loteFabricacao;
    }
}

