/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.manad;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GeracaoArquivoManad;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGeracaoArquivoManad {
    String separador = "|";
    Integer contK050 = 0;
    Integer contK150 = 0;
    Integer contK250 = 0;
    Integer contK300 = 0;
    Integer contTotalk = 0;

    private String getFinalLine() {
        return "\r\n";
    }

    public void gerarArquivoManad(GeracaoArquivoManad vo, File arquivo, EmpresaRh empresaRh) throws IOException, ExceptionService {
        this.createBloco0000(vo, arquivo);
        this.createBloco0001(vo, arquivo);
        this.createBloco0050(vo, arquivo);
        this.createBloco0100(vo, arquivo);
        this.createBloco0990(vo, arquivo);
        this.createBlocoI001(vo, arquivo);
        this.createBlocoI990(vo, arquivo);
        this.createBlocoK001(vo, arquivo);
        this.createBlocoK050(vo, arquivo);
        this.createBlocoK150(vo, arquivo);
        this.createBlocoK250(vo, arquivo);
        this.createBlocoK300(vo, arquivo, empresaRh);
        this.createBlocoK990(vo, arquivo);
        this.createBloco9001(vo, arquivo);
        this.createBloco99000(vo, arquivo);
        this.createBloco99001(vo, arquivo);
        this.createBloco99050(vo, arquivo);
        this.createBloco99100(vo, arquivo);
        this.createBloco99990(vo, arquivo);
        this.createBloco99I01(vo, arquivo);
        this.createBloco99I50(vo, arquivo);
        this.createBloco99I99(vo, arquivo);
        this.createBloco99K001(vo, arquivo);
        this.createBloco99K050(vo, arquivo);
        this.createBloco99K100(vo, arquivo);
        this.createBloco99K150(vo, arquivo);
        this.createBloco99K200(vo, arquivo);
        this.createBloco99K250(vo, arquivo);
        this.createBloco99K300(vo, arquivo);
        this.createBloco99K990(vo, arquivo);
        this.createBloco999900(vo, arquivo);
        this.createBloco990001(vo, arquivo);
        this.createBloco990090(vo, arquivo);
        this.createBloco990099(vo, arquivo);
        this.createBloco99(vo, arquivo);
        this.creteBlocoFinal(vo, arquivo);
    }

    private void createBloco0000(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco0(p, vo);
        p.flush();
        p.close();
    }

    private void createBloco0001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco1(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco0(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("0000");
        p.append(this.separador);
        p.append(ToolString.clearInvalidUTF8Char((String)vo.getEmpresa().getPessoa().getNome()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.separador);
        p.append(vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getInscEst()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbge()));
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.separador);
        p.append(vo.getIndicadorCentralizacao().getCodigo());
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getPeriodoInicial()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getPeriodoFinal()));
        p.append(this.separador);
        p.append("003");
        p.append(this.separador);
        p.append(vo.getFinalidadeArquivoManad().getCodigo());
        p.append(this.separador);
        p.append(vo.getIndicadorEntradaDados().getCodigo());
        p.append(this.getFinalLine());
    }

    private String getPeriodo6Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "";
    }

    private String getPeriodo4Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("MMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "";
    }

    private void writterBloco1(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("0001");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
    }

    private void createBloco0050(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco50(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco50(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("0050");
        p.append(this.separador);
        p.append(ToolString.clearInvalidUTF8Char((String)vo.getPessoaContabilidade().getNome()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getPessoaContabilidade().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getCpfContador()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getCrcContador()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getInicioPrestContabilidade()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getFimPrestContabilidade()));
        p.append(this.separador);
        p.append(ToolString.clearInvalidUTF8Char((String)vo.getPessoaContabilidade().getEndereco().getLogradouro()));
        p.append(this.separador);
        p.append(vo.getPessoaContabilidade().getEndereco().getNumero());
        p.append(this.separador);
        p.append(this.separador);
        p.append(vo.getPessoaContabilidade().getEndereco().getBairro());
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getPessoaContabilidade().getEndereco().getCep()));
        p.append(this.separador);
        p.append(vo.getPessoaContabilidade().getEndereco().getCidade().getUf().getSigla());
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.separador);
        p.append(vo.getPessoaContabilidade().getComplemento().getFone1());
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.getFinalLine());
    }

    private void createBloco0100(GeracaoArquivoManad vo, File arquivo) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco100(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco100(PrintWriter p, GeracaoArquivoManad vo) throws ExceptionService {
        if (vo.getPessoaInformatica().getComplemento().getFone1() == null || vo.getPessoaInformatica().getComplemento().getFone1().isEmpty()) {
            throw new ExceptionService("Informe o Telefone para a pessoa: " + vo.getPessoaInformatica().getNome());
        }
        p.append("0100");
        p.append(this.separador);
        p.append(ToolString.clearInvalidUTF8Char((String)vo.getPessoaInformatica().getNome()));
        p.append(this.separador);
        p.append("Desenvolvimento de Sistemas");
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getInicioPrestInformatica()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(vo.getFimPrestInformatica()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getPessoaInformatica().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getCpfTecnicoInformatica()));
        p.append(this.separador);
        p.append(vo.getPessoaInformatica().getComplemento().getFone1());
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.getFinalLine());
    }

    private void createBloco0990(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("0990");
        p.append(this.separador);
        p.append("5");
        p.append(this.getFinalLine());
    }

    private void createBlocoI001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBlocoI001(p, vo);
        p.flush();
        p.close();
    }

    private void writterBlocoI001(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("I001");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBlocoI990(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBlocoI990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBlocoI990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("I990");
        p.append(this.separador);
        p.append("2");
        p.append(this.getFinalLine());
    }

    private void createBlocoK001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBlocoK001(p, vo);
        p.flush();
        p.close();
    }

    private void writterBlocoK001(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("K001");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
        this.contTotalk = this.contTotalk + 1;
    }

    private void createBlocoK050(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        List colaboradores = this.getColaboradores(vo.getPeriodoInicial(), vo.getPeriodoFinal(), vo.getEmpresa());
        colaboradores = this.ordenarLista(colaboradores);
        for (Object object : colaboradores) {
            this.contK050 = this.contK050 + 1;
            this.contTotalk = this.contTotalk + 1;
            Colaborador colaborador = (Colaborador)object;
            this.writterBlocoK050(p, vo, colaborador);
        }
        p.flush();
        p.close();
    }

    private void writterBlocoK050(PrintWriter p, GeracaoArquivoManad vo, Colaborador colaborador) {
        p.append("K050");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append(colaborador.getNumeroRegistro());
        p.append(this.separador);
        p.append(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(ToolString.refina((String)colaborador.getNumeroPis()));
        p.append(this.separador);
        p.append(colaborador.getCategoriaTrabalhador().getCodigo());
        p.append(this.separador);
        p.append(colaborador.getPessoa().getNome());
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(colaborador.getPessoa().getComplemento().getDataNascimento()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(colaborador.getDataAdmissao()));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(colaborador.getDataDemissao()));
        p.append(this.separador);
        p.append(colaborador.getIndicadorVinculoTrabalhador().getCodigo());
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.separador);
        p.append(this.getFinalLine());
    }

    private List getColaboradores(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        String hql = " select distinct m.colaborador  from MovimentoFolha m  where    m.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal  and  m.empresa = :empresa  and  (m.colaborador.tipoColaborador.identificador = :empregado  or  m.colaborador.tipoColaborador.identificador = :socio ) ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setEntity("empresa", (Object)empresa).list();
    }

    private List ordenarLista(List colaboradores) {
        if (colaboradores != null) {
            Collections.sort(colaboradores, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    Colaborador item1 = (Colaborador)o1;
                    Colaborador item2 = (Colaborador)o2;
                    Integer vlr1 = new Integer(item1.getNumeroRegistro());
                    Integer vlr2 = new Integer(item2.getNumeroRegistro());
                    return vlr1.compareTo(vlr2);
                }
            });
            return colaboradores;
        }
        return null;
    }

    private void createBlocoK150(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco150(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco150(PrintWriter p, GeracaoArquivoManad vo) {
        List eventos = this.getEventosPorPeriodo(vo.getPeriodoInicial(), vo.getPeriodoFinal());
        for (Object object : eventos) {
            this.contK150 = this.contK150 + 1;
            this.contTotalk = this.contTotalk + 1;
            HashMap h = (HashMap)object;
            String evento = (String)h.get("EVENTO");
            Long codigo = (Long)h.get("CODIGO");
            p.append("K150");
            p.append(this.separador);
            p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
            p.append(this.separador);
            p.append("01012014");
            p.append(this.separador);
            p.append(codigo.toString());
            p.append(this.separador);
            p.append(evento);
            p.append(this.getFinalLine());
        }
        this.setarEventosImpostos(p, vo);
    }

    private List getEventosPorPeriodo(Date periodoInicial, Date periodoFinal) {
        String hql = " select  distinct item.eventoColaborador.tipoCalculoEvento.evento.descricao as EVENTO ,  item.eventoColaborador.tipoCalculoEvento.evento.codigo as CODIGO  from ItemMovimentoFolha item  where  (item.movimentoFolha.colaborador.tipoColaborador.identificador = :empregado  or  item.movimentoFolha.colaborador.tipoColaborador.identificador = :socio) and  item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal  and  (item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  or  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro )  order by item.eventoColaborador.tipoCalculoEvento.evento.codigo ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private void createBlocoK250(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        List dados = this.getDadosFolhaPagamento(vo);
        for (Object object : dados) {
            this.contK250 = this.contK250 + 1;
            this.contTotalk = this.contTotalk + 1;
            HashMap h = (HashMap)object;
            this.writterBloco250(p, vo, h);
        }
        p.flush();
        p.close();
    }

    private List getDadosFolhaPagamento(GeracaoArquivoManad vo) {
        String hql = " select  m.colaborador.numeroRegistro as COD_TRABALHADOR,  m.aberturaPeriodo.dataInicio as DT_COMP,  m.aberturaPeriodo.dataPagamento as DT_PAGAMENTO,  m.colaborador.funcao.cbo.codigo as COD_CBO,  m.colaborador.funcao.descricao as DESC_CARGO,  m.nrDepIrrf as QTD_DEP_IR ,  m.nrQuota as QUOTA,  m.identificador as ID_MOV_FOLHA,  m.colaborador.categoriaTrabalhador.codigo as CAT_TRAB,  m.aberturaPeriodo.tipoCalculo.tipoFolha as TIPO_FOLHA  from MovimentoFolha m  where  (m.colaborador.tipoColaborador.identificador = :empregado  or  m.colaborador.tipoColaborador.identificador = :socio) and  m.aberturaPeriodo.dataInicio  between :periodoInicial and :periodoFinal  and  m.empresa = :empresa  and  (m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  or  m.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro )  order by  m.aberturaPeriodo.tipoCalculo.tipoFolha,  m.aberturaPeriodo.dataInicio,   m.colaborador.numeroRegistro ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", vo.getPeriodoInicial()).setDate("periodoFinal", vo.getPeriodoFinal()).setEntity("empresa", (Object)vo.getEmpresa()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private void writterBloco250(PrintWriter p, GeracaoArquivoManad vo, HashMap h) {
        String numeroRegistro = (String)h.get("COD_TRABALHADOR");
        Date dataCompetencia = (Date)h.get("DT_COMP");
        Date dataPagamento = (Date)h.get("DT_PAGAMENTO");
        String cbo = (String)h.get("COD_CBO");
        String descCargo = (String)h.get("DESC_CARGO");
        Short depIrrf = (Short)h.get("QTD_DEP_IR");
        Short quota = (Short)h.get("QUOTA");
        Long idMov = (Long)h.get("ID_MOV_FOLHA");
        String codTrab = "00";
        Short tipoFolha = (Short)h.get("TIPO_FOLHA");
        p.append("K250");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(this.getTipoFolha(tipoFolha));
        p.append(this.separador);
        p.append(this.separador);
        p.append(numeroRegistro);
        p.append(this.separador);
        p.append(this.getPeriodo4Digitos(dataCompetencia));
        p.append(this.separador);
        p.append(this.getPeriodo6Digitos(dataPagamento));
        p.append(this.separador);
        p.append(ToolString.refina((String)cbo));
        p.append(this.separador);
        p.append(codTrab);
        p.append(this.separador);
        p.append(ToolString.clearInvalidUTF8Char((String)descCargo));
        p.append(this.separador);
        p.append(depIrrf.toString());
        p.append(this.separador);
        p.append(quota.toString());
        p.append(this.separador);
        Double bcIrrf = this.getBaseIrrf(idMov);
        p.append(this.formatarValor(bcIrrf));
        p.append(this.separador);
        Double baseInss = this.getBaseInss(idMov);
        p.append(this.formatarValor(baseInss));
        p.append(this.getFinalLine());
    }

    private Double getBaseInss(Long idMov) {
        String hql = " select  coalesce(mov.bcInssSalario + mov.bcInssFerias +mov.bcInss13Sal,0)  from MovimentoFolha mov  where  mov.identificador = :idMov ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idMov", idMov.longValue()).uniqueResult();
    }

    private String formatarValor(Double valorDeclarado) {
        Object numero = "";
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)valorDeclarado, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Double getBaseIrrf(Long idMov) {
        String hql = " select  item.valor as VALOR ,  item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO  from ItemMovimentoFolha item  where  item.movimentoFolha.identificador = :idMov  and item.eventoColaborador.tipoCalculoEvento.incidenciaIrrf = :sim ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("idMov", idMov.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Double bcIrrf = 0.0;
        for (Object object : ret) {
            HashMap hash = (HashMap)object;
            Double valor = (Double)hash.get("VALOR");
            Short tipoEvento = (Short)hash.get("TIPO_EVENTO");
            if (tipoEvento.equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                bcIrrf = bcIrrf + valor;
                continue;
            }
            bcIrrf = bcIrrf - valor;
        }
        return ContatoFormatUtil.arrredondarNumero((Double)bcIrrf, (int)2);
    }

    private void createBlocoK300(GeracaoArquivoManad vo, File arquivo, EmpresaRh empresaRh) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        List dados = this.getDadosBlocoK300(vo);
        List dadosImpostos = this.getDadosBlocoK300Impostos(vo);
        this.incluirImpostosFolha(dados, dadosImpostos);
        dados = this.ordenarListaHash(dados);
        for (Object object : dados) {
            this.contK300 = this.contK300 + 1;
            this.contTotalk = this.contTotalk + 1;
            HashMap hash = (HashMap)object;
            this.writterBloco300(p, vo, hash, empresaRh);
        }
        p.flush();
        p.close();
    }

    private List getDadosBlocoK300Impostos(GeracaoArquivoManad vo) {
        String hql = " select  coalesce(movimentoFolha.vrInssSalario,0) as INSS_SALARIO ,  coalesce(movimentoFolha.vrInssFerias,0) as INSS_FERIAS,  coalesce(movimentoFolha.vrInss13Sal,0) as INSS_DEC,  coalesce(movimentoFolha.vrIrrfSalario,0) as IRRF_SALARIO,  coalesce(movimentoFolha.vrIrrfFerias,0) as IRRF_FERIAS,  coalesce(movimentoFolha.vrIrrf13Sal,0) as IRRF_DEC ,  movimentoFolha.colaborador.numeroRegistro as NR_REGISTRO, movimentoFolha.aberturaPeriodo.dataInicio as DATA_COMPETENTECIA,  movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha as TIPO_FOLHA_ABERTURA  from MovimentoFolha movimentoFolha  where  (movimentoFolha.colaborador.tipoColaborador.identificador = :empregado  or  movimentoFolha.colaborador.tipoColaborador.identificador = :socio) and  movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal  and  ( movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  or  movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro )  and  movimentoFolha.aberturaPeriodo.empresa = :empresa  order by  movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha ,  movimentoFolha.aberturaPeriodo.dataInicio,  movimentoFolha.colaborador.numeroRegistro ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", vo.getPeriodoInicial()).setDate("periodoFinal", vo.getPeriodoFinal()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setEntity("empresa", (Object)vo.getEmpresa()).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private List getDadosBlocoK300(GeracaoArquivoManad vo) {
        String hql = " select  item.movimentoFolha.colaborador.numeroRegistro as NR_REGISTRO, item.movimentoFolha.aberturaPeriodo.dataInicio as DATA_COMPETENTECIA,  item.eventoColaborador.tipoCalculoEvento.evento.codigo as RUBRICA, item.valor as VALOR, item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO, item.eventoColaborador.tipoCalculoEvento.incidenciaIrrf as INCIDENCIA_IRRF,  item.eventoColaborador.tipoCalculoEvento.incidenciaInss as INCIDENCIA_INSS,  item.eventoColaborador.tipoCalculoEvento.tipoCalculo.tipoFolha as TIPO_FOLHA,  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha as TIPO_FOLHA_ABERTURA  from ItemMovimentoFolha item  where  (item.movimentoFolha.colaborador.tipoColaborador.identificador = :empregado  or  item.movimentoFolha.colaborador.tipoColaborador.identificador = :socio) and  item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal  and  ( item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  or  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro  )  and  item.movimentoFolha.aberturaPeriodo.empresa = :empresa  and  item.valor > 0  order by  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha ,  item.movimentoFolha.aberturaPeriodo.dataInicio,  item.movimentoFolha.colaborador.numeroRegistro ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", vo.getPeriodoInicial()).setDate("periodoFinal", vo.getPeriodoFinal()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setEntity("empresa", (Object)vo.getEmpresa()).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    private void writterBloco300(PrintWriter p, GeracaoArquivoManad vo, HashMap hash, EmpresaRh empresaRh) {
        String nrRegistro = (String)hash.get("NR_REGISTRO");
        Date dataCompetencia = (Date)hash.get("DATA_COMPETENTECIA");
        String rubrica = new String(hash.get("RUBRICA").toString());
        Double valor = (Double)hash.get("VALOR");
        Short tipoEvento = (Short)hash.get("TIPO_EVENTO");
        Short incidenciaIrrf = (Short)hash.get("INCIDENCIA_IRRF");
        Short incidenciaInss = (Short)hash.get("INCIDENCIA_INSS");
        Short tipoFolha = (Short)hash.get("TIPO_FOLHA");
        Short tipoFolhaAbertura = (Short)hash.get("TIPO_FOLHA_ABERTURA");
        p.append("K300");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append(this.getTipoFolha(tipoFolhaAbertura));
        p.append(this.separador);
        p.append(this.separador);
        p.append(nrRegistro);
        p.append(this.separador);
        p.append(this.getPeriodo4Digitos(dataCompetencia));
        p.append(this.separador);
        p.append(rubrica.toString());
        p.append(this.separador);
        p.append(this.formatarValor(valor));
        p.append(this.separador);
        p.append(tipoEvento == EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue() ? "P" : "D");
        p.append(this.separador);
        String irrf = incidenciaIrrf == 1 && (tipoFolhaAbertura == EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue() || tipoFolhaAbertura == EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue()) ? "1" : (incidenciaIrrf == 1 && tipoFolhaAbertura == EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue() ? "2" : (incidenciaIrrf == 0 ? "3" : "9"));
        p.append(irrf);
        p.append(this.separador);
        p.append(this.setIncidenciaInss(incidenciaInss, rubrica, empresaRh, tipoFolhaAbertura));
        p.append(this.getFinalLine());
    }

    private String setIncidenciaInss(Short incidenciaInss, String rubrica, EmpresaRh empresaRh, Short tipoFolha) {
        if (empresaRh.getTipoCalculoSalarioFamilia() != null && empresaRh.getTipoCalculoSalarioFamilia().getEvento().getCodigo().toString() == rubrica) {
            return "4";
        }
        if (empresaRh.getTipoCalculoMaternidade() != null && empresaRh.getTipoCalculoMaternidade().getEvento().getCodigo().toString() == rubrica) {
            return "5";
        }
        String inss = incidenciaInss == 1 && (tipoFolha == EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue() || tipoFolha == EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue()) ? "1" : (incidenciaInss == 1 && tipoFolha == EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue() ? "2" : (incidenciaInss == 0 ? "8" : "9"));
        return inss;
    }

    private void createBlocoK990(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBlocoK990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBlocoK990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("K990");
        p.append(this.separador);
        Integer totalK990 = this.contTotalk + 1;
        p.append(totalK990.toString());
        p.append(this.getFinalLine());
    }

    private void createBloco9001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco9001(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco9001(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9001");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
    }

    private void createBloco99000(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99000(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99000(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("0000");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99001(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99001(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("0001");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99050(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99050(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99050(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("0050");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99100(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99100(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99100(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("0100");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99990(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("0990");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99I01(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99I01(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99I01(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("I001");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99I50(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99I50(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99I50(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("I050");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
    }

    private void createBloco99I99(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99I99(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99I99(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("I990");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99K001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99k001(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99k001(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K001");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99K050(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99k050(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99k050(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K050");
        p.append(this.separador);
        p.append(this.contK050.toString());
        p.append(this.getFinalLine());
    }

    private void createBloco99K100(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K100(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K100(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K100");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
    }

    private void createBloco99K150(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K150(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K150(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K150");
        p.append(this.separador);
        p.append(this.contK150.toString());
        p.append(this.getFinalLine());
    }

    private void createBloco99K200(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K200(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K200(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K200");
        p.append(this.separador);
        p.append("0");
        p.append(this.getFinalLine());
    }

    private void createBloco99K250(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K250(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K250(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K250");
        p.append(this.separador);
        p.append(this.contK250.toString());
        p.append(this.getFinalLine());
    }

    private void createBloco99K300(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K300(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K300(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K300");
        p.append(this.separador);
        p.append(this.contK300.toString());
        p.append(this.getFinalLine());
    }

    private void createBloco99K990(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99K990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99K990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("K990");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco999900(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco999900(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco999900(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("9900");
        p.append(this.separador);
        p.append("20");
        p.append(this.getFinalLine());
    }

    private void createBloco990001(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco999901(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco999901(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("9001");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco990090(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco999990(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco999990(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("9990");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco990099(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco999999(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco999999(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9900");
        p.append(this.separador);
        p.append("9999");
        p.append(this.separador);
        p.append("1");
        p.append(this.getFinalLine());
    }

    private void createBloco99(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBloco99(p, vo);
        p.flush();
        p.close();
    }

    private void writterBloco99(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9990");
        p.append(this.separador);
        p.append("23");
        p.append(this.getFinalLine());
    }

    private void creteBlocoFinal(GeracaoArquivoManad vo, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        this.writterBlocoFinal(p, vo);
        p.flush();
        p.close();
    }

    private void writterBlocoFinal(PrintWriter p, GeracaoArquivoManad vo) {
        p.append("9999");
        p.append(this.separador);
        Integer t = this.contTotalk + 1 + 7 + 23;
        p.append(t.toString());
        p.append(this.getFinalLine());
    }

    private String getTipoFolha(Short tipoFolha) {
        if (tipoFolha.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            return "1";
        }
        if (tipoFolha.equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
            return "2";
        }
        return "6";
    }

    private void setarEventosImpostos(PrintWriter p, GeracaoArquivoManad vo) {
        this.contK150 = this.contK150 + 1;
        this.contTotalk = this.contTotalk + 1;
        p.append("K150");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append("INSSSALARIO");
        p.append(this.separador);
        p.append("INSS SALARIO");
        p.append(this.getFinalLine());
        this.contK150 = this.contK150 + 1;
        this.contTotalk = this.contTotalk + 1;
        p.append("K150");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append("INSSDECIMOTERCEIRO");
        p.append(this.separador);
        p.append("INSS DECIMO TERCEIRO");
        p.append(this.getFinalLine());
        this.contK150 = this.contK150 + 1;
        this.contTotalk = this.contTotalk + 1;
        p.append("K150");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append("IRRFSALARIO");
        p.append(this.separador);
        p.append("IRRF SALARIO");
        p.append(this.getFinalLine());
        this.contK150 = this.contK150 + 1;
        this.contTotalk = this.contTotalk + 1;
        p.append("K150");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append("IRRFFERIAS");
        p.append(this.separador);
        p.append("IRRF FERIAS");
        p.append(this.getFinalLine());
        this.contK150 = this.contK150 + 1;
        this.contTotalk = this.contTotalk + 1;
        p.append("K150");
        p.append(this.separador);
        p.append(ToolString.refina((String)vo.getEmpresa().getPessoa().getComplemento().getCnpj()));
        p.append(this.separador);
        p.append("01012014");
        p.append(this.separador);
        p.append("IRRFDECIMOTERCEIRO");
        p.append(this.separador);
        p.append("IRRF DECIMO TERCEIRO");
        p.append(this.getFinalLine());
    }

    private void incluirImpostosFolha(List dados, List dadosImpostos) {
        for (Object object : dadosImpostos) {
            HashMap h = (HashMap)object;
            String nrRegistro = (String)h.get("NR_REGISTRO");
            Date dataCompetencia = (Date)h.get("DATA_COMPETENTECIA");
            System.err.println(dataCompetencia.toString());
            Short tipoEvento = EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue();
            Short incidenciaIrrf = 0;
            Short incidenciaInss = 0;
            Short tipoFolhaAbertura = (Short)h.get("TIPO_FOLHA_ABERTURA");
            Double vrInssSalario = (Double)h.get("INSS_SALARIO");
            Double vrInssFerias = (Double)h.get("INSS_FERIAS");
            Double vrInssDec = (Double)h.get("INSS_DEC");
            Double vrIrrfSalario = (Double)h.get("IRRF_SALARIO");
            Double vrIrrfFerias = (Double)h.get("IRRF_FERIAS");
            Double vrIrrfDec = (Double)h.get("IRRF_DEC");
            HashMap<String, Object> hashAux = null;
            Double valor = ContatoFormatUtil.arrredondarNumero((Double)(vrInssSalario + vrInssFerias), (int)2);
            if (valor > 0.0) {
                hashAux = new HashMap<String, Object>();
                hashAux.put("NR_REGISTRO", nrRegistro);
                hashAux.put("DATA_COMPETENTECIA", dataCompetencia);
                hashAux.put("TIPO_EVENTO", tipoEvento);
                hashAux.put("INCIDENCIA_IRRF", incidenciaIrrf);
                hashAux.put("INCIDENCIA_INSS", incidenciaInss);
                hashAux.put("TIPO_FOLHA", tipoFolhaAbertura);
                hashAux.put("TIPO_FOLHA_ABERTURA", tipoFolhaAbertura);
                hashAux.put("VALOR", valor);
                hashAux.put("RUBRICA", "INSSSALARIO");
                dados.add(hashAux);
            }
            if ((valor = ContatoFormatUtil.arrredondarNumero((Double)vrInssDec, (int)2)) > 0.0) {
                hashAux = new HashMap();
                hashAux.put("NR_REGISTRO", nrRegistro);
                hashAux.put("DATA_COMPETENTECIA", dataCompetencia);
                hashAux.put("TIPO_EVENTO", tipoEvento);
                hashAux.put("INCIDENCIA_IRRF", incidenciaIrrf);
                hashAux.put("INCIDENCIA_INSS", incidenciaInss);
                hashAux.put("TIPO_FOLHA", tipoFolhaAbertura);
                hashAux.put("TIPO_FOLHA_ABERTURA", tipoFolhaAbertura);
                hashAux.put("VALOR", valor);
                hashAux.put("RUBRICA", "INSSDECIMOTERCEIRO");
                dados.add(hashAux);
            }
            if ((valor = ContatoFormatUtil.arrredondarNumero((Double)vrIrrfSalario, (int)2)) > 0.0) {
                hashAux = new HashMap();
                hashAux.put("NR_REGISTRO", nrRegistro);
                hashAux.put("DATA_COMPETENTECIA", dataCompetencia);
                hashAux.put("TIPO_EVENTO", tipoEvento);
                hashAux.put("INCIDENCIA_IRRF", incidenciaIrrf);
                hashAux.put("INCIDENCIA_INSS", incidenciaInss);
                hashAux.put("TIPO_FOLHA", tipoFolhaAbertura);
                hashAux.put("TIPO_FOLHA_ABERTURA", tipoFolhaAbertura);
                hashAux.put("VALOR", valor);
                hashAux.put("RUBRICA", "IRRFSALARIO");
                dados.add(hashAux);
            }
            if ((valor = ContatoFormatUtil.arrredondarNumero((Double)vrIrrfFerias, (int)2)) > 0.0) {
                hashAux = new HashMap();
                hashAux.put("NR_REGISTRO", nrRegistro);
                hashAux.put("DATA_COMPETENTECIA", dataCompetencia);
                hashAux.put("TIPO_EVENTO", tipoEvento);
                hashAux.put("INCIDENCIA_IRRF", incidenciaIrrf);
                hashAux.put("INCIDENCIA_INSS", incidenciaInss);
                hashAux.put("TIPO_FOLHA", tipoFolhaAbertura);
                hashAux.put("TIPO_FOLHA_ABERTURA", tipoFolhaAbertura);
                hashAux.put("VALOR", valor);
                hashAux.put("RUBRICA", "IRRFFERIAS");
                dados.add(hashAux);
            }
            if (!((valor = ContatoFormatUtil.arrredondarNumero((Double)vrIrrfDec, (int)2)) > 0.0)) continue;
            hashAux = new HashMap();
            hashAux.put("NR_REGISTRO", nrRegistro);
            hashAux.put("DATA_COMPETENTECIA", dataCompetencia);
            hashAux.put("TIPO_EVENTO", tipoEvento);
            hashAux.put("INCIDENCIA_IRRF", incidenciaIrrf);
            hashAux.put("INCIDENCIA_INSS", incidenciaInss);
            hashAux.put("TIPO_FOLHA", tipoFolhaAbertura);
            hashAux.put("TIPO_FOLHA_ABERTURA", tipoFolhaAbertura);
            hashAux.put("VALOR", valor);
            hashAux.put("RUBRICA", "IRRFDECIMOTERCEIRO");
            dados.add(hashAux);
        }
    }

    private List ordenarListaHash(List dados) {
        if (dados != null) {
            Collections.sort(dados, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap item1 = (HashMap)o1;
                    HashMap item2 = (HashMap)o2;
                    Integer vlr1 = new Integer((String)item1.get("NR_REGISTRO"));
                    Integer vlr2 = new Integer((String)item2.get("NR_REGISTRO"));
                    return vlr1.compareTo(vlr2);
                }
            });
            return dados;
        }
        return null;
    }
}

