/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.manifestocteeletronico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoEncerramentoManifestoCte;
import com.touchcomp.basementor.model.vo.LoteEventoManifestoCte;
import com.touchcomp.basementor.model.vo.LoteFaturamentoManifestoCte;
import com.touchcomp.basementor.model.vo.ManifestoCteCte;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.ManifestoCteSeguro;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.TipoCTE;
import com.touchcomp.basementor.model.vo.TipoOperacaoCte;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceManifestoCteEletronico
extends CoreService {
    public static final String PESQUISAR_CTE_NAO_MANIFESTO_CTE = "pesquisarCteNaoManifestoCte";
    public static final String SALVAR_MANIFESTO_CTE_ELETRONICO = "salvarManifestoCteEletronico";
    public static final String SALVAR_MANIFESTO_CTE = "salvarManifestoCte";
    public static final String SALVAR_ENCERRAMENTO_MANIFESTO_CTE_ELETRONICO = "salvarEncerramentoManifestoCteEletronico";
    public static final String PESQUISAR_MANIFESTO_CTE_AUT_NAO_ENVIADO = "pesquisarManifestoCteAutNaoEnviado";
    public static final String PESQUISAR_MANIFESTO_CTE_PARA_ENCERRAR = "pesquisarManifestoCteParaEncerrar";
    public static final String PESQUISAR_EXISTE_ENCERRAMENTO_MANIFESTO_CTE = "pesquisarExisteEncerramentoManifestoCte";
    public static final String PESQUISAR_MANIFESTO_CTE = "pesquisarManifestoCte";
    public static final String PESQUISAR_MANIFESTO_NOTA_PROPRIA = "pesquisarManifestoNotaPropria";
    public static final String PESQUISAR_MANIFESTO_CLIENTE_TOMADOR_SERVICO = "pesquisarManifestoClienteTomadorServico";

    public List<Cte> pesquisarCteNaoManifestoCte(CoreRequestContext request) {
        TipoCTE tipoCte = (TipoCTE)request.getAttribute("TIPO_CTE");
        TipoOperacaoCte tipoOperacaoCte = (TipoOperacaoCte)request.getAttribute("TIPO_OPERACAO_CTE");
        Date dataEmissaoInicial = (Date)request.getAttribute("DATA_EMISSAO_INICIAL");
        Date dataEmissaoFinal = (Date)request.getAttribute("DATA_EMISSAO_FINAL");
        Empresa empresa = (Empresa)request.getAttribute("EMPRESA");
        List listTipoOperacao = (List)request.getAttribute("LIST_TIPO_OPERACAO");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarCteNaoManifestoCte(tipoCte, tipoOperacaoCte, dataEmissaoInicial, dataEmissaoFinal, empresa, listTipoOperacao);
    }

    public List<LoteFaturamentoManifestoCte> salvarManifestoCteEletronico(CoreRequestContext request) throws ExceptionService {
        List listaLoteFaturamento = (List)request.getAttribute("LISTA_LOTE");
        listaLoteFaturamento = (List)CoreService.saveOrUpdateCollection(listaLoteFaturamento);
        CoreBdUtil.getInstance().getSession().flush();
        for (LoteFaturamentoManifestoCte l : listaLoteFaturamento) {
            for (ManifestoCteEletronico m : l.getManifestoCte()) {
                for (ManifestoCteSeguro seguro : m.getManifestoCteSeguro()) {
                    if (!ToolMethods.isEquals((Object)seguro.getConcatenarNumeroCteAverb(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
                    seguro.setNumeroAverbacao(seguro.getNumeroAverbacao() + ((ManifestoCteCte)m.getCte().get(0)).getCte().getNumero());
                }
            }
        }
        return listaLoteFaturamento;
    }

    public Object salvarManifestoCte(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        ManifestoCteEletronico manifestoCteEletronico = (ManifestoCteEletronico)request.getAttribute("manifestoCteEletronico");
        manifestoCteEletronico = (ManifestoCteEletronico)CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().update(manifestoCteEletronico);
        CoreBdUtil.getInstance().getSession().flush();
        for (ManifestoCteSeguro seguro : manifestoCteEletronico.getManifestoCteSeguro()) {
            if (!ToolMethods.isEquals((Object)seguro.getConcatenarNumeroCteAverb(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
            seguro.setNumeroAverbacao(seguro.getNumeroAverbacao() + ((ManifestoCteCte)manifestoCteEletronico.getCte().get(0)).getCte().getNumero());
        }
        return manifestoCteEletronico;
    }

    public List<LoteEventoManifestoCte> salvarEncerramentoManifestoCteEletronico(CoreRequestContext request) throws ExceptionService {
        List listaLoteEvento = (List)request.getAttribute("LISTA_LOTE_EVENTO");
        for (LoteEventoManifestoCte l : listaLoteEvento) {
            if (l.getEventoEncerramento().getIdentificador() != null && l.getEventoEncerramento().getIdentificador() != 0L) continue;
            l.setEventoEncerramento((EventoEncerramentoManifestoCte)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOEventoEncerramentoManifestoCte(), l.getEventoEncerramento()));
        }
        return (List)CoreService.saveOrUpdateCollection(listaLoteEvento);
    }

    public List<LoteFaturamentoManifestoCte> pesquisarManifestoCteAutNaoEnviado(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("EMPRESA");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarManifestoCteAutNaoEnviado(empresa);
    }

    public List<ManifestoCteEletronico> pesquisarManifestoCteParaEncerrar(CoreRequestContext request) {
        List listTipoOperacao = (List)request.getAttribute("LIST_TIPO_OPERACAO");
        Date dataEmissaoInicial = (Date)request.getAttribute("DATA_EMISSAO_INICIAL");
        Date dataEmissaoFinal = (Date)request.getAttribute("DATA_EMISSAO_FINAL");
        Empresa empresa = (Empresa)request.getAttribute("EMPRESA");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarManifestoCteParaEncerrar(listTipoOperacao, dataEmissaoInicial, dataEmissaoFinal, empresa);
    }

    public EventoEncerramentoManifestoCte pesquisarExisteEncerramentoManifestoCte(CoreRequestContext request) {
        ManifestoCteEletronico manifestoCte = (ManifestoCteEletronico)request.getAttribute("MANIFESTO_CTE");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarExisteEncerramentoManifestoCte(manifestoCte);
    }

    public List<ManifestoCteEletronico> pesquisarManifestoCte(CoreRequestContext request) {
        Cte cte = (Cte)request.getAttribute("CTE");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarManifestoCte(cte);
    }

    public List<ManifestoCteEletronico> pesquisarManifestoNotaPropria(CoreRequestContext request) {
        NotaFiscalPropria notaPropria = (NotaFiscalPropria)request.getAttribute("NOTA_PROPRIA");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarManifestoNotaPropria(notaPropria);
    }

    public List<ManifestoCteEletronico> pesquisarManifestoClienteTomadorServico(CoreRequestContext request) {
        UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)request.getAttribute("UNIDADE_FAT_CLIENTE");
        return CoreDAOFactory.getInstance().getDAOManifestoCteEletronicoCore().pesquisarManifestoClienteTomadorServico(unidadeFatCliente);
    }
}

