/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.mentorplus.analisecomprasmensalordemcompra;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilAnaliseComprasMensalOrdemCompra {
    public JasperPrint gerarListagemAnaliseComprasMensalOrdemCompra(Date dataInicial, Date dataFinal, Long idEmpresaInicial, Long idEmpresaFinal, Empresa empresaLogada, Nodo nodo, CoreRequestContext request) throws ExceptionService {
        ArrayList lista = new ArrayList();
        ArrayList<Double> valoresAtuais = new ArrayList<Double>();
        ArrayList<Double> valoresMesAnteriores = new ArrayList<Double>();
        ArrayList<Double> valoresAnosAnterior = new ArrayList<Double>();
        int mes = DateUtil.monthFromDate(dataInicial);
        int ano = DateUtil.yearFromDate(dataFinal);
        int dias = DateUtil.getLastDayOnMonth(ano, mes);
        Double totalMesAtual = 0.0;
        Double totalMesAnterior = 0.0;
        Double totalAnoAnterior = 0.0;
        for (int dia = 1; dia <= dias; ++dia) {
            Date data = DateUtil.intToDate(ano, mes, dia);
            Double valorDia = this.getValorDiaAtual(data, idEmpresaInicial, idEmpresaFinal);
            totalMesAtual = totalMesAtual + valorDia;
            data = mes == 1 ? DateUtil.intToDate(ano - 1, 12, dia) : DateUtil.intToDate(ano, mes - 1, dia);
            Double valorMesAnterior = this.getValorMesAnterior(data, idEmpresaInicial, idEmpresaFinal);
            totalMesAnterior = totalMesAnterior + valorMesAnterior;
            data = DateUtil.intToDate(ano - 1, mes, dia);
            Double valorAnoAnterior = this.getValorAnoAnterior(data, idEmpresaInicial, idEmpresaFinal);
            totalAnoAnterior = totalAnoAnterior + valorAnoAnterior;
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("valorAtual", valorDia);
            h.put("valorMesAnterior", valorMesAnterior);
            h.put("valorAnoAnterior", valorAnoAnterior);
            h.put("dia", dia);
            if (valorDia > 0.0) {
                valoresAtuais.add(valorDia);
            }
            if (valorMesAnterior > 0.0) {
                valoresMesAnteriores.add(valorMesAnterior);
            }
            if (valorAnoAnterior > 0.0) {
                valoresAnosAnterior.add(valorAnoAnterior);
            }
            lista.add(h);
        }
        List dadosGrafico = this.gerarDadosGrafico(valoresAtuais, valoresMesAnteriores, valoresAnosAnterior);
        Map parametros = request.toHashMap();
        parametros.put("EMPRESA_LOGADA", empresaLogada);
        parametros.put("NOME_EMPRESA", empresaLogada.getPessoa().getNome());
        parametros.put("CNPJ_NOME", empresaLogada.getPessoa().getComplemento().getCnpj());
        parametros.put("INSCRICAO_ESTADUAL_NOME", empresaLogada.getPessoa().getComplemento().getInscEst());
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("EMPRESA_INICIAL", idEmpresaInicial);
        parametros.put("EMPRESA_FINAL", idEmpresaFinal);
        parametros.put("VR_TOTAL_MES_ATUAL", totalMesAtual);
        parametros.put("VR_TOTAL_MES_ANTERIOR", totalMesAnterior);
        parametros.put("VR_TOTAL_ANO_ANTERIOR", totalAnoAnterior);
        parametros.put("DADOS_GRAFICO", dadosGrafico);
        Object path = CoreUtilityFactory.getUtilityJasperReports().getPathReports();
        path = (String)path + File.separator + "mentorplus" + File.separator + "listagens" + File.separator + "analisecompramensalordemcompra" + File.separator + "BEANS_LISTAGEM_ANALISE_COMPRAS_MENSAL_ORDEM_COMPRA.jasper";
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", lista);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private Double getValorDiaAtual(Date dataMesAtual, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorOrdemCompra(dataMesAtual, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorMesAnterior(Date dataMesAnterior, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorOrdemCompra(dataMesAnterior, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorAnoAnterior(Date dataAnoAnterior, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorOrdemCompra(dataAnoAnterior, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorOrdemCompra(Date data, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.valorTotal)  from OrdemCompra i  where      i.dataEmissao = :data and i.empresa.identificador between :idEmpInicial and :idEmpFinal";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setLong("idEmpInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpFinal", idEmpresaFinal.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private List gerarDadosGrafico(List valoresAtuais, List valoresMesAnteriores, List valoresAnosAnterior) {
        int countAtual = valoresAtuais.size();
        int countMes = valoresMesAnteriores.size();
        int countAno = valoresAnosAnterior.size();
        int count = 0;
        count = countAtual > countMes ? countAtual : countMes;
        if (count < countAno) {
            count = countAno;
        }
        ArrayList lista = new ArrayList();
        for (int i = 0; i < count; ++i) {
            Double valorAtual = 0.0;
            Double valorMesAnterior = 0.0;
            Double valorAnoAnterior = 0.0;
            if (i < countAtual) {
                valorAtual = (Double)valoresAtuais.get(i);
            }
            if (i < countMes) {
                valorMesAnterior = (Double)valoresMesAnteriores.get(i);
            }
            if (i < countAno) {
                valorAnoAnterior = (Double)valoresAnosAnterior.get(i);
            }
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("valorAtualUtil", valorAtual);
            h.put("valorMesAnteriorUtil", valorMesAnterior);
            h.put("valorAnoAnteriorUtil", valorAnoAnterior);
            h.put("diaUtil", i + 1);
            lista.add(h);
        }
        return lista;
    }
}

