/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.mentorplus.analiseestoque;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;

public class UtilAnaliseEstoque {
    public JasperPrint gerarListagemAnaliseEstoque(CoreRequestContext r) throws ExceptionService {
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Double nivelA = (Double)r.getAttribute("NIVEL_A");
        Double nivelB = (Double)r.getAttribute("NIVEL_B");
        Empresa empresa = (Empresa)r.getAttribute("EMPRESA_LOGADA");
        Short tipoEstoque = (Short)r.getAttribute("TIPO_ESTOQUE");
        Short filtraEspecie = (Short)r.getAttribute("FILTRAR_ESPECIE");
        Long especieInicial = (Long)r.getAttribute("ID_ESPECIE_INICIAL");
        Long especieFinal = (Long)r.getAttribute("ID_ESPECIE_FINAL");
        if (filtraEspecie == null || filtraEspecie == 0) {
            especieFinal = null;
            especieInicial = null;
        }
        Short filtraSubEspecie = (Short)r.getAttribute("FILTRAR_SUBESPECIE");
        Long subEspecieInicial = (Long)r.getAttribute("ID_SUB_ESPECIE_INICIAL");
        Long subEspecieFinal = (Long)r.getAttribute("ID_SUB_ESPECIE_FINAL");
        if (filtraSubEspecie == null || filtraSubEspecie == 0) {
            subEspecieFinal = null;
            subEspecieInicial = null;
        }
        Short filtraFabricante = (Short)r.getAttribute("FILTRAR_FABRICANTE");
        Long fabricanteInicial = (Long)r.getAttribute("ID_FABRICANTE_INICIAL");
        Long fabricanteFinal = (Long)r.getAttribute("ID_FABRICANTE_FINAL");
        if (filtraFabricante == null || filtraFabricante == 0) {
            fabricanteFinal = null;
            fabricanteInicial = null;
        }
        Short filtrarCentroEstoque = (Short)r.getAttribute("P_FILTRAR_CENTRO_ESTOQUE");
        Long centroEstoqueInicial = (Long)r.getAttribute("F_CENTRO_ESTOQUE_INICIAL");
        Long centroEstoqueFinal = (Long)r.getAttribute("F_CENTRO_ESTOQUE_FINAL");
        if (filtrarCentroEstoque == null || filtrarCentroEstoque.equals((short)0)) {
            centroEstoqueFinal = null;
            centroEstoqueInicial = null;
        }
        Short tipoRel = (Short)r.getAttribute("TIPO_REL");
        Short tipoCentroEstPropTerc = (Short)r.getAttribute("tipoCentroEstoque");
        Nodo nodo = (Nodo)r.getAttribute("NODO");
        HashMap<String, String> parametros = new HashMap<String, String>(r.toHashMap());
        parametros.put("NOME_EMPRESA", empresa.getPessoa().getNome());
        parametros.put("CNPJ_NOME", empresa.getPessoa().getComplemento().getCnpj());
        parametros.put("INSCRICAO_ESTADUAL_NOME", empresa.getPessoa().getComplemento().getInscEst());
        List dados = this.getDadosEstoqueRelatorio(dataInicial, empresa, tipoEstoque, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, fabricanteInicial, fabricanteFinal, tipoCentroEstPropTerc, centroEstoqueInicial, centroEstoqueFinal);
        dados = this.classificarOrdenar(dados, nivelA, nivelB, parametros, tipoRel);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        Object path = CoreUtilityFactory.getUtilityJasperReports().getPathReports();
        path = (String)path + File.separator + "mentorplus" + File.separator + "listagens" + File.separator + "analiseestoque" + File.separator + "BEANS_LISTAGEM_ANALISE_ESTOQUE.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List getDadosEstoqueRelatorio(Date dataInicial, Empresa empresa, Short tipoEstoque, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long fabricanteInicial, Long fabricanteFinal, Short tipoCentroEstPropTerc, Long centroEstoqueInicial, Long centroEstoqueFinal) {
        List aux = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoValorMaior0ListagemAnaliseEstoque(null, null, dataInicial, empresa.getIdentificador(), tipoEstoque, null, null, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, fabricanteInicial, fabricanteFinal, tipoCentroEstPropTerc, centroEstoqueInicial, centroEstoqueFinal);
        return aux;
    }

    private List classificarOrdenar(List<SaldoEstoqueGeral> dados, Double nivelA, Double nivelB, HashMap params, Short tipoRel) {
        double valorTotal = this.getValorTotal(dados);
        dados = this.processarDeAcordoTipoRel(dados, tipoRel);
        dados = this.transformarCalcPercentual(dados, valorTotal);
        this.ordenarValor(dados);
        LinkedList aux = new LinkedList(dados);
        this.classicarNivel(aux, nivelA, "A", params);
        this.classicarNivel(aux, nivelB, "B", params);
        this.classicarNivel(aux, 100.0, "C", params);
        return dados;
    }

    private void ordenarValor(List aux) {
        Collections.sort(aux, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                return ((Double)h2.get("PERCENTUAL")).compareTo((Double)h1.get("PERCENTUAL"));
            }
        });
    }

    private double getValorTotal(List dados) {
        double valorTotal = 0.0;
        for (Object o : dados) {
            HashMap h = (HashMap)o;
            valorTotal += ((Number)h.get("SALDO_VALOR")).doubleValue();
        }
        return valorTotal;
    }

    private List transformarCalcPercentual(List dados, double valorTotal) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (Object ob : dados) {
            HashMap h = (HashMap)ob;
            h.put("PERCENTUAL", (Double)h.get("VALOR") / valorTotal * 100.0);
            aux.add(h);
        }
        return aux;
    }

    private void classicarNivel(List arrayList, Double indice, String nivel, HashMap param) {
        if (arrayList.isEmpty()) {
            return;
        }
        double percAcumulado = 0.0;
        double valorAcumulado = 0.0;
        int cont = 0;
        do {
            HashMap h = (HashMap)arrayList.get(0);
            Double perc = (Double)h.get("PERCENTUAL");
            Double valor = (Double)h.get("VALOR");
            percAcumulado += perc.doubleValue();
            valorAcumulado += valor.doubleValue();
            arrayList.remove(0);
            h.put("NIVEL", nivel);
            ++cont;
        } while (!(percAcumulado >= indice) && !arrayList.isEmpty());
        param.put("PERC_" + nivel, percAcumulado);
        param.put("VALOR_" + nivel, valorAcumulado);
        param.put("CONTADOR_" + nivel, cont);
    }

    private List<SaldoEstoqueGeral> processarDeAcordoTipoRel(List<SaldoEstoqueGeral> dados, Short tipoRel) {
        ArrayList<SaldoEstoqueGeral> toRet = new ArrayList<SaldoEstoqueGeral>();
        if (tipoRel == 0) {
            for (SaldoEstoqueGeral ob : dados) {
                HashMap h1 = (HashMap)ob;
                Integer idEsp1 = (Integer)h1.get("ID_ESPECIE");
                boolean achou = false;
                for (Object e : toRet) {
                    HashMap h2 = (HashMap)e;
                    Integer idEsp2 = (Integer)h2.get("IDENTIFICADOR");
                    if ((long)idEsp1.intValue() != idEsp2.longValue()) continue;
                    h2.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue() + (Double)h2.get("VALOR"));
                    h2.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue() + (Double)h2.get("QUANTIDADE"));
                    achou = true;
                    break;
                }
                if (achou) continue;
                HashMap hNew = new HashMap();
                hNew.put("IDENTIFICADOR", h1.get("ID_ESPECIE"));
                hNew.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue());
                hNew.put("NOME", h1.get("ESPECIE"));
                hNew.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue());
                toRet.add((SaldoEstoqueGeral)hNew);
            }
        } else if (tipoRel == 2) {
            for (SaldoEstoqueGeral ob : dados) {
                HashMap h1 = (HashMap)ob;
                Integer idEsp1 = (Integer)h1.get("ID_FABRICANTE");
                boolean achou = false;
                for (Object e : toRet) {
                    HashMap h2 = (HashMap)e;
                    Integer idEsp2 = (Integer)h2.get("IDENTIFICADOR");
                    if ((long)idEsp1.intValue() != idEsp2.longValue()) continue;
                    h2.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue() + (Double)h2.get("VALOR"));
                    h2.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue() + (Double)h2.get("QUANTIDADE"));
                    achou = true;
                    break;
                }
                if (achou) continue;
                HashMap hNew = new HashMap();
                hNew.put("IDENTIFICADOR", h1.get("ID_FABRICANTE"));
                hNew.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue());
                hNew.put("NOME", h1.get("FABRICANTE"));
                hNew.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue());
                toRet.add((SaldoEstoqueGeral)hNew);
            }
        } else if (tipoRel == 3) {
            for (SaldoEstoqueGeral ob : dados) {
                HashMap h1 = (HashMap)ob;
                Integer idEsp1 = (Integer)h1.get("ID_SUB_ESPECIE");
                boolean achou = false;
                for (Object e : toRet) {
                    HashMap h2 = (HashMap)e;
                    Integer idEsp2 = (Integer)h2.get("IDENTIFICADOR");
                    if ((long)idEsp1.intValue() != idEsp2.longValue()) continue;
                    h2.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue() + (Double)h2.get("VALOR"));
                    h2.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue() + (Double)h2.get("QUANTIDADE"));
                    achou = true;
                    break;
                }
                if (achou) continue;
                HashMap hNew = new HashMap();
                hNew.put("IDENTIFICADOR", h1.get("ID_SUB_ESPECIE"));
                hNew.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue());
                hNew.put("NOME", h1.get("NOME_ESPECIE"));
                hNew.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue());
                toRet.add((SaldoEstoqueGeral)hNew);
            }
        } else {
            for (SaldoEstoqueGeral ob : dados) {
                HashMap h1 = (HashMap)ob;
                HashMap h = new HashMap();
                h.put("IDENTIFICADOR", h1.get("ID_PRODUTO"));
                h.put("CODIGO_AUXILIAR", h1.get("CODIGO_AUXILIAR"));
                h.put("QUANTIDADE", ((Number)h1.get("SALDO_QTD")).doubleValue());
                h.put("NOME", h1.get("NOME_PRODUTO"));
                h.put("VALOR", ((Number)h1.get("SALDO_VALOR")).doubleValue());
                toRet.add((SaldoEstoqueGeral)h);
            }
        }
        return toRet;
    }
}

