/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.mentorplus.analisevendasclienterep;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilAnaliseVendasClienteRep {
    public JasperPrint gerarListagemAnaliseVendas(CoreRequestContext r) throws ExceptionService {
        Short filtrarData = (Short)r.getAttribute("FILTRAR_DATA");
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Date datafinal = (Date)r.getAttribute("DATA_FINAL");
        Double nivelA = (Double)r.getAttribute("NIVEL_A");
        Double nivelB = (Double)r.getAttribute("NIVEL_B");
        Short filtrarEmpresa = (Short)r.getAttribute("FILTRAR_EMPRESA");
        Long empresaInicial = (Long)r.getAttribute("ID_EMPRESA_INICIAL");
        Long empresaFinal = (Long)r.getAttribute("ID_EMPRESA_FINAL");
        Short filtrarCliente = (Short)r.getAttribute("FILTRAR_CLIENTE");
        Long clienteInicial = (Long)r.getAttribute("ID_CLIENTE_INICIAL");
        Long clienteFinal = (Long)r.getAttribute("ID_CLIENTE_FINAL");
        Short filtrarRamoAtividade = (Short)r.getAttribute("FILTRAR_RAMO_ATIVIDADE");
        Long ramoAtividadeInicial = (Long)r.getAttribute("ID_RAMO_ATIVIDADE_INICIAL");
        Long ramoAtividadeFinal = (Long)r.getAttribute("ID_RAMO_ATIVIDADE_FINAL");
        Short filtrarRegiao = (Short)r.getAttribute("FILTRAR_REGIAO");
        Long regiaoInicial = (Long)r.getAttribute("ID_REGIAO_INICIAL");
        Long regiaoFinal = (Long)r.getAttribute("ID_REGIAO_FINAL");
        Short filtrarRepresentante = (Short)r.getAttribute("FILTRAR_REPRESENTANTE");
        Long representanteInicial = (Long)r.getAttribute("ID_REPRESENTANTE_INICIAL");
        Long representanteFinal = (Long)r.getAttribute("ID_REPRESENTANTE_FINAL");
        Short tipoRel = (Short)r.getAttribute("TIPO_REL");
        Short filtrarClassificacao = (Short)r.getAttribute("FILTRAR_CLASSIFICACAO");
        Long classificacaoInicial = (Long)r.getAttribute("ID_CLASSIFICACAO_INICIAL");
        Long classificacaoFinal = (Long)r.getAttribute("ID_CLASSIFICACAO_FINAL");
        Empresa empresa = (Empresa)r.getAttribute("EMPRESA_LOGADA");
        Nodo nodo = (Nodo)r.getAttribute("NODO");
        HashMap<String, String> parametros = new HashMap<String, String>(r.toHashMap());
        parametros.put("NOME_EMPRESA", empresa.getPessoa().getNome());
        parametros.put("CNPJ_NOME", empresa.getPessoa().getComplemento().getCnpj());
        parametros.put("INSCRICAO_ESTADUAL_NOME", empresa.getPessoa().getComplemento().getInscEst());
        List dados = this.getDadosVendas(filtrarData, dataInicial, datafinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRamoAtividade, ramoAtividadeInicial, ramoAtividadeFinal, filtrarRegiao, regiaoInicial, regiaoFinal, filtrarClassificacao, classificacaoInicial, classificacaoFinal, filtrarRepresentante, representanteInicial, representanteFinal, tipoRel);
        dados = this.classificarOrdenar(dados, nivelA, nivelB, parametros);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        Object path = CoreUtilityFactory.getUtilityJasperReports().getPathReports();
        path = (String)path + "mentorplus" + File.separator + "listagens" + File.separator + "analisevendasclienterep" + File.separator + "BEANS_LISTAGEM_ANALISE_VENDAS_CLIENTE_REP.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List classificarOrdenar(List<HashMap> dados, Double nivelA, Double nivelB, HashMap params) {
        double valorTotal = this.getValorTotal(dados);
        dados = this.transformarCalcPercentual(dados, valorTotal);
        this.ordenarValor(dados);
        LinkedList aux = new LinkedList(dados);
        this.classicarNivel(aux, nivelA, "A", params);
        this.classicarNivel(aux, nivelB, "B", params);
        this.classicarNivel(aux, 100.0, "C", params);
        return dados;
    }

    private void ordenarValor(List aux) {
        Collections.sort(aux, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                return ((Double)h2.get("PERCENTUAL")).compareTo((Double)h1.get("PERCENTUAL"));
            }
        });
    }

    private double getValorTotal(List<HashMap> dados) {
        double valorTotal = 0.0;
        Iterator<HashMap> iterator = dados.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap h = o = iterator.next();
            valorTotal += ((Double)h.get("VALOR_TOTAL")).doubleValue();
        }
        return valorTotal;
    }

    private List transformarCalcPercentual(List<HashMap> dados, double valorTotal) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        Iterator<HashMap> iterator = dados.iterator();
        while (iterator.hasNext()) {
            HashMap s;
            HashMap h = s = iterator.next();
            h.put("PERCENTUAL", (Double)h.get("VALOR_TOTAL") / valorTotal * 100.0);
            aux.add(h);
        }
        return aux;
    }

    private void classicarNivel(List arrayList, Double indice, String nivel, HashMap param) {
        if (arrayList.isEmpty()) {
            return;
        }
        double percAcumulado = 0.0;
        double valorAcumulado = 0.0;
        int cont = 0;
        do {
            HashMap h = (HashMap)arrayList.get(0);
            Double perc = (Double)h.get("PERCENTUAL");
            Double valor = (Double)h.get("VALOR_TOTAL");
            percAcumulado += perc.doubleValue();
            valorAcumulado += valor.doubleValue();
            arrayList.remove(0);
            h.put("NIVEL", nivel);
            ++cont;
        } while (!(percAcumulado >= indice) && !arrayList.isEmpty());
        param.put("PERC_" + nivel, percAcumulado);
        param.put("VALOR_" + nivel, valorAcumulado);
        param.put("CONTADOR_" + nivel, cont);
    }

    private List getNotas(Short filtrarData, Date dataInicial, Date datafinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRamoAtividade, Long ramoAtividadeInicial, Long ramoAtividadeFinal, Short filtrarRegiao, Long regiaoInicial, Long regiaoFinal, Short filtrarClassificacao, Long classificacaoInicial, Long classificacaoFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short tipoRel) {
        String query = this.getQueryNotas(tipoRel);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        if (tipoRel == 1) {
            q.setParameter("autorizado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        }
        q.setShort("sim", (short)1);
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setParameter("empresaInicial", (Object)empresaInicial);
        q.setParameter("empresaFinal", (Object)empresaFinal);
        q.setShort("filtrarData", filtrarData.shortValue());
        q.setParameter("dataInicial", (Object)dataInicial);
        q.setParameter("dataFinal", (Object)datafinal);
        q.setShort("filtrarCliente", filtrarCliente.shortValue());
        q.setParameter("clienteInicial", (Object)clienteInicial);
        q.setParameter("clienteFinal", (Object)clienteFinal);
        q.setShort("filtrarRamoAtividade", filtrarRamoAtividade.shortValue());
        q.setParameter("ramoAtividadeInicial", (Object)ramoAtividadeInicial);
        q.setParameter("ramoAtividadeFinal", (Object)ramoAtividadeFinal);
        q.setShort("filtrarRegiao", filtrarRegiao.shortValue());
        q.setParameter("regiaoInicial", (Object)regiaoInicial);
        q.setParameter("regiaoFinal", (Object)regiaoFinal);
        q.setShort("filtrarRepresentante", filtrarRepresentante.shortValue());
        q.setParameter("representanteInicial", (Object)representanteInicial);
        q.setParameter("representanteFinal", (Object)representanteFinal);
        q.setShort("filtrarClassificacao", filtrarClassificacao.shortValue());
        q.setParameter("classificacaoInicial", (Object)classificacaoInicial);
        q.setParameter("classificacaoFinal", (Object)classificacaoFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getDadosVendas(Short filtrarData, Date dataInicial, Date datafinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarCliente, Long clienteInicial, Long clienteFinal, Short filtrarRamoAtividade, Long ramoAtividadeInicial, Long ramoAtividadeFinal, Short filtrarRegiao, Long regiaoInicial, Long regiaoFinal, Short filtrarClassificacao, Long classificacaoInicial, Long classificacaoFinal, Short filtrarRepresentante, Long representanteInicial, Long representanteFinal, Short tipoRel) {
        List notasTemp = this.getNotas(filtrarData, dataInicial, datafinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarCliente, clienteInicial, clienteFinal, filtrarRamoAtividade, ramoAtividadeInicial, ramoAtividadeFinal, filtrarRegiao, regiaoInicial, regiaoFinal, filtrarClassificacao, classificacaoInicial, classificacaoFinal, filtrarRepresentante, representanteInicial, representanteFinal, tipoRel);
        List notas = this.agruparNotas(notasTemp);
        ArrayList to = new ArrayList();
        this.mergeList(notas, to);
        return to;
    }

    private void mergeList(List notas, List to) {
        for (int i = 0; i < notas.size(); ++i) {
            HashMap h1 = (HashMap)notas.get(i);
            Long id1 = (Long)h1.get("IDENTIFICADOR");
            boolean achou = false;
            for (int j = 0; j < to.size(); ++j) {
                HashMap h2 = (HashMap)to.get(j);
                Long id2 = (Long)h2.get("IDENTIFICADOR");
                if (id1.longValue() != id2.longValue()) continue;
                Double valor1 = (Double)h1.get("VALOR_TOTAL");
                Double valor2 = (Double)h2.get("VALOR_TOTAL");
                h1.put("VALOR_TOTAL", valor1 + valor2);
                to.remove(j);
                achou = true;
            }
            if (achou) continue;
            to.add(h1);
        }
    }

    private String getQueryNotas(Short tipoRel) {
        if (tipoRel == 0) {
            return "SELECT rep.identificador                                                 AS IDENTIFICADOR, pes.nome                                                              AS NOME, cl.cnpj                                                               AS CNPJ, i.quantidadeTotal                                                     AS QUANT_TOTAL, i.valorUnitario                                                       AS VALOR_UNIT, i.valorDesconto                                                       AS VALOR_DESC FROM ItemPedido i  inner join i.pedido n inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.faturamento f inner join n.representante rep inner join rep.pessoa pes inner join pes.complemento cl  left join f.ramoAtividade r left join c.classificacaoClientes cla left join c.regiao re WHERE  n.situacaoPedido.cancelarTitulos <>:sim and (:filtrarEmpresa                      <> 1 OR emp.identificador  BETWEEN :empresaInicial       AND :empresaFinal) AND (:filtrarData                            <> 1 OR n.dataEmissao      BETWEEN :dataInicial          AND :dataFinal) AND (:filtrarCliente                         <> 1 OR c.identificador    BETWEEN :clienteInicial       AND :clienteFinal) AND (:filtrarRamoAtividade                   <> 1 OR r.identificador   BETWEEN :ramoAtividadeInicial AND :ramoAtividadeFinal) AND (:filtrarRegiao                          <> 1 OR re.identificador    BETWEEN :regiaoInicial        AND :regiaoFinal) AND (:filtrarRepresentante                   <> 1 OR rep.identificador  BETWEEN :representanteInicial AND :representanteFinal) AND (:filtrarClassificacao                   <> 1 OR cla.identificador  BETWEEN :classificacaoInicial AND :classificacaoFinal) ";
        }
        return "SELECT c.identificador                                                   AS IDENTIFICADOR, pes.nome                                                              AS NOME, cl.cnpj                                                               AS CNPJ, i.quantidadeTotal                                                     AS QUANT_TOTAL, i.valorUnitario                                                       AS VALOR_UNIT, i.valorDesconto                                                       AS VALOR_DESC FROM ItemNotaFiscalPropria i  inner join i.itemNotaLivroFiscal il inner join il.cfop cf inner join i.notaFiscalPropria n inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.faturamento f inner join f.representante rep inner join c.pessoa pes inner join pes.complemento cl  left join f.ramoAtividade r left join c.classificacaoClientes cla left join c.regiao re WHERE ( n.status              IN(:autorizado)) AND  cf.cfopReceitaVenda           = :sim AND (:filtrarEmpresa                         <> 1 OR emp.identificador  BETWEEN :empresaInicial       AND :empresaFinal) AND (:filtrarData                            <> 1 OR n.dataEmissaoNota  BETWEEN :dataInicial          AND :dataFinal) AND (:filtrarCliente                         <> 1 OR c.identificador    BETWEEN :clienteInicial       AND :clienteFinal) AND (:filtrarRamoAtividade                   <> 1 OR r.identificador   BETWEEN :ramoAtividadeInicial AND :ramoAtividadeFinal) AND (:filtrarRegiao                          <> 1 OR re.identificador    BETWEEN :regiaoInicial        AND :regiaoFinal) AND (:filtrarRepresentante                   <> 1 OR rep.identificador  BETWEEN :representanteInicial AND :representanteFinal) AND (:filtrarClassificacao                   <> 1 OR cla.identificador  BETWEEN :classificacaoInicial AND :classificacaoFinal) ";
    }

    private List agruparNotas(List notasTemp) {
        ArrayList notas = new ArrayList();
        for (Object o : notasTemp) {
            HashMap h = (HashMap)o;
            HashMap<String, Object> n = new HashMap<String, Object>();
            n.put("IDENTIFICADOR", (Long)h.get("IDENTIFICADOR"));
            n.put("NOME", (String)h.get("NOME"));
            n.put("CNPJ", (String)h.get("CNPJ"));
            Double valorTotal = 0.0;
            Double quantTotal = 0.0;
            for (Object o2 : notasTemp) {
                HashMap h2 = (HashMap)o2;
                Double quantidade = (Double)h2.get("QUANT_TOTAL");
                Double valorUnit = (Double)h2.get("VALOR_UNIT");
                Double desconto = (Double)h2.get("VALOR_DESC");
                if (!((Long)h.get("IDENTIFICADOR")).equals((Long)h2.get("IDENTIFICADOR"))) continue;
                valorTotal = valorTotal + (quantidade * valorUnit - desconto);
                quantTotal = quantTotal + quantidade;
            }
            n.put("VALOR_TOTAL", valorTotal);
            n.put("QUANTIDADE_TOTAL", quantTotal);
            if (notas.contains(n)) continue;
            notas.add(n);
        }
        return notas;
    }
}

