/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.mentorplus.analisevendasmensal;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilAnaliseVendasMensal {
    public JasperPrint gerarListagemAnaliseVendasMensal(Date dataInicial, Date dataFinal, Long idEmpresaInicial, Long idEmpresaFinal, Empresa empresaLogada, Nodo nodo, CoreRequestContext request) throws ExceptionService {
        ArrayList lista = new ArrayList();
        int mes = DateUtil.monthFromDate(dataInicial);
        int ano = DateUtil.yearFromDate(dataFinal);
        int dias = DateUtil.getLastDayOnMonth(ano, mes);
        Double totalMesAtual = 0.0;
        Double totalMesAnterior = 0.0;
        Double totalAnoAnterior = 0.0;
        for (int dia = 1; dia <= dias; ++dia) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            Date data = DateUtil.intToDate(ano, mes, dia);
            Double valorDia = this.getValorDiaAtual(data, idEmpresaInicial, idEmpresaFinal);
            totalMesAtual = totalMesAtual + valorDia;
            h.put("diaTextoAtual", DateUtil.diaDaSemanaTexto(data));
            data = mes == 1 ? DateUtil.intToDate(ano - 1, 12, dia) : DateUtil.intToDate(ano, mes - 1, dia);
            Double valorMesAnterior = this.getValorMesAnterior(data, idEmpresaInicial, idEmpresaFinal);
            totalMesAnterior = totalMesAnterior + valorMesAnterior;
            h.put("diaTextoMes", DateUtil.diaDaSemanaTexto(data));
            data = DateUtil.intToDate(ano - 1, mes, dia);
            h.put("diaTextoAno", DateUtil.diaDaSemanaTexto(data));
            Double valorAnoAnterior = this.getValorAnoAnterior(data, idEmpresaInicial, idEmpresaFinal);
            totalAnoAnterior = totalAnoAnterior + valorAnoAnterior;
            h.put("valorAtual", valorDia);
            h.put("valorMesAnterior", valorMesAnterior);
            h.put("valorAnoAnterior", valorAnoAnterior);
            h.put("dia", dia);
            lista.add(h);
        }
        Map parametros = request.toHashMap();
        parametros.put("NOME_EMPRESA", empresaLogada.getPessoa().getNome());
        parametros.put("CNPJ_NOME", empresaLogada.getPessoa().getComplemento().getCnpj());
        parametros.put("INSCRICAO_ESTADUAL_NOME", empresaLogada.getPessoa().getComplemento().getInscEst());
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("EMPRESA_INICIAL", idEmpresaInicial);
        parametros.put("EMPRESA_FINAL", idEmpresaFinal);
        parametros.put("VR_TOTAL_MES_ATUAL", totalMesAtual);
        parametros.put("VR_TOTAL_MES_ANTERIOR", totalMesAnterior);
        parametros.put("VR_TOTAL_ANO_ANTERIOR", totalAnoAnterior);
        Object path = CoreUtilityFactory.getUtilityJasperReports().getPathReports();
        path = (String)path + File.separator + "mentorplus" + File.separator + "listagens" + File.separator + "analisevendamensal" + File.separator + "BEANS_LISTAGEM_ANALISE_VENDAS_MENSAL.jasper";
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", lista);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private Double getValorDiaAtual(Date dataMesAtual, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorNotasFiscais(dataMesAtual, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorCuponsFiscais(dataMesAtual, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorConhecimentos(dataMesAtual, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorNfce(dataMesAtual, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorMesAnterior(Date dataMesAnterior, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorNotasFiscais(dataMesAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorCuponsFiscais(dataMesAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorConhecimentos(dataMesAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorNfce(dataMesAnterior, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorAnoAnterior(Date dataAnoAnterior, Long idEmpresaInicial, Long idEmpresaFinal) {
        Double valor = this.getValorNotasFiscais(dataAnoAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorCuponsFiscais(dataAnoAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorConhecimentos(dataAnoAnterior, idEmpresaInicial, idEmpresaFinal);
        valor = valor + this.getValorNfce(dataAnoAnterior, idEmpresaInicial, idEmpresaFinal);
        return valor;
    }

    private Double getValorNotasFiscais(Date data, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.itemNotaLivroFiscal.valorTotal)  from ItemNotaFiscalPropria i  where   i.itemNotaLivroFiscal.cfop.cfopReceitaVenda = :cfopReceitaVenda and   i.notaFiscalPropria.dataEmissaoNota = :data and (   i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc1       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc2       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc3       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc4       or i.notaFiscalPropria.situacaoDocumento.codigo = :codSitDoc5) and i.notaFiscalPropria.empresa.identificador between :idEmpInicial and :idEmpFinal and i.modeloFiscal.compoeFluxoVenda = :compoeFluxoVenda";
        Query q = s.createQuery(hql);
        q.setShort("cfopReceitaVenda", (short)1);
        q.setDate("data", data);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setLong("idEmpInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpFinal", idEmpresaFinal.longValue());
        q.setShort("compoeFluxoVenda", (short)1);
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private Double getValorCuponsFiscais(Date data, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(cf.valorTotal)  from CupomFiscal cf  inner join cf.cupom c inner join c.empresa e where   c.dataMovimentacao = :data and cf.cancelado = :naoCancelado and e.identificador between :idEmpInicial and :idEmpFinal";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setShort("naoCancelado", (short)0);
        q.setLong("idEmpInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpFinal", idEmpresaFinal.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private Double getValorConhecimentos(Date data, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select sum(i.cteVlrImpostos.vrReceber)  from Cte i  where  i.dataEmissao = :data and (   i.situacaoDocumento.codigo = :codSitDoc1       or i.situacaoDocumento.codigo = :codSitDoc2       or i.situacaoDocumento.codigo = :codSitDoc3       or i.situacaoDocumento.codigo = :codSitDoc4       or i.situacaoDocumento.codigo = :codSitDoc5) and i.empresa.identificador between :idEmpInicial and :idEmpFinal";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setLong("idEmpInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpFinal", idEmpresaFinal.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private Double getValorNfce(Date data, Long idEmpresaInicial, Long idEmpresaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT SUM(n.totalizadores.valorTotalNFe) FROM NFCe n WHERE n.dataEmissao = :data AND   n.empresa.identificador BETWEEN :idEmpInicial AND :idEmpFinal AND  (n.situacaoDocumento.codigo = :codSitDoc1 OR    n.situacaoDocumento.codigo = :codSitDoc2 OR    n.situacaoDocumento.codigo = :codSitDoc3 OR    n.situacaoDocumento.codigo = :codSitDoc4 OR    n.situacaoDocumento.codigo = :codSitDoc5)";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setLong("idEmpInicial", idEmpresaInicial.longValue());
        q.setLong("idEmpFinal", idEmpresaFinal.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private List gerarDadosGrafico(List valoresAtuais, List valoresMesAnteriores, List valoresAnosAnterior) {
        int countAtual = valoresAtuais.size();
        int countMes = valoresMesAnteriores.size();
        int countAno = valoresAnosAnterior.size();
        int count = 0;
        count = countAtual > countMes ? countAtual : countMes;
        if (count < countAno) {
            count = countAno;
        }
        ArrayList lista = new ArrayList();
        for (int i = 0; i < count; ++i) {
            Double valorAtual = 0.0;
            Double valorMesAnterior = 0.0;
            Double valorAnoAnterior = 0.0;
            if (i < countAtual) {
                valorAtual = (Double)valoresAtuais.get(i);
            }
            if (i < countMes) {
                valorMesAnterior = (Double)valoresMesAnteriores.get(i);
            }
            if (i < countAno) {
                valorAnoAnterior = (Double)valoresAnosAnterior.get(i);
            }
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("valorAtualUtil", valorAtual);
            h.put("valorMesAnteriorUtil", valorMesAnterior);
            h.put("valorAnoAnteriorUtil", valorAnoAnterior);
            h.put("diaUtil", i + 1);
            lista.add(h);
        }
        return lista;
    }
}

