/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.mentorplus.analisevendasprodutoesp;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilAnaliseVendasProdutoEsp {
    public JasperPrint gerarListagemAnaliseVendas(CoreRequestContext r) throws ExceptionService {
        Short filtrarData = (Short)r.getAttribute("FILTRAR_DATA");
        Date dataInicial = (Date)r.getAttribute("DATA_INICIAL");
        Date datafinal = (Date)r.getAttribute("DATA_FINAL");
        Double nivelA = (Double)r.getAttribute("NIVEL_A");
        Double nivelB = (Double)r.getAttribute("NIVEL_B");
        Short filtrarEspecie = (Short)r.getAttribute("FILTRAR_ESPECIE");
        Long especieInicial = (Long)r.getAttribute("ID_ESPECIE_INICIAL");
        Long especieFinal = (Long)r.getAttribute("ID_ESPECIE_FINAL");
        Short filtrarProduto = (Short)r.getAttribute("FILTRAR_PRODUTO");
        Long produtoInicial = (Long)r.getAttribute("ID_PRODUTO_INICIAL");
        Long produtoFinal = (Long)r.getAttribute("ID_PRODUTO_FINAL");
        Short filtrarSubEspecie = (Short)r.getAttribute("FILTRAR_SUB_ESPECIE");
        Long subEspecieInicial = (Long)r.getAttribute("ID_SUB_ESPECIE_INICIAL");
        Long subEspecieFinal = (Long)r.getAttribute("ID_SUB_ESPECIE_FINAL");
        Short filtrarFabricante = (Short)r.getAttribute("FILTRAR_FABRICANTE");
        Long fabricanteInicial = (Long)r.getAttribute("ID_FABRICANTE_INICIAL");
        Long fabricanteFinal = (Long)r.getAttribute("ID_FABRICANTE_FINAL");
        Short filtrarEmpresa = (Short)r.getAttribute("FILTRAR_EMPRESA");
        Long empresaInicial = (Long)r.getAttribute("ID_EMPRESA_INICIAL");
        Long empresaFinal = (Long)r.getAttribute("ID_EMPRESA_FINAL");
        Short tipoRel = (Short)r.getAttribute("TIPO_REL");
        Empresa empresa = (Empresa)r.getAttribute("EMPRESA_LOGADA");
        Nodo nodo = (Nodo)r.getAttribute("NODO");
        HashMap<String, String> parametros = new HashMap<String, String>(r.toHashMap());
        parametros.put("NOME_EMPRESA", empresa.getPessoa().getNome());
        parametros.put("CNPJ_NOME", empresa.getPessoa().getComplemento().getCnpj());
        parametros.put("INSCRICAO_ESTADUAL_NOME", empresa.getPessoa().getComplemento().getInscEst());
        List dados = this.getDadosVendas(filtrarData, dataInicial, datafinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarEspecie, especieInicial, especieFinal, filtrarSubEspecie, subEspecieInicial, subEspecieFinal, filtrarFabricante, fabricanteInicial, fabricanteFinal, tipoRel);
        dados = this.classificarOrdenar(dados, nivelA, nivelB, parametros);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        Object path = CoreUtilityFactory.getUtilityJasperReports().getPathReports();
        path = (String)path + "mentorplus" + File.separator + "listagens" + File.separator + "analisevendasprodutoesp" + File.separator + "BEANS_LISTAGEM_ANALISE_VENDAS_PRODUTO_ESP.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }

    private List classificarOrdenar(List<HashMap> dados, Double nivelA, Double nivelB, HashMap params) {
        double valorTotal = this.getValorTotal(dados);
        dados = this.transformarCalcPercentual(dados, valorTotal);
        this.ordenarValor(dados);
        LinkedList aux = new LinkedList(dados);
        this.classicarNivel(aux, nivelA, "A", params);
        this.classicarNivel(aux, nivelB, "B", params);
        this.classicarNivel(aux, 100.0, "C", params);
        return dados;
    }

    private void ordenarValor(List aux) {
        Collections.sort(aux, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap h1 = (HashMap)o1;
                HashMap h2 = (HashMap)o2;
                return ((Double)h2.get("PERCENTUAL")).compareTo((Double)h1.get("PERCENTUAL"));
            }
        });
    }

    private double getValorTotal(List<HashMap> dados) {
        double valorTotal = 0.0;
        Iterator<HashMap> iterator = dados.iterator();
        while (iterator.hasNext()) {
            HashMap o;
            HashMap h = o = iterator.next();
            valorTotal += ((Double)h.get("VALOR_TOTAL")).doubleValue();
        }
        return valorTotal;
    }

    private List transformarCalcPercentual(List<HashMap> dados, double valorTotal) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        Iterator<HashMap> iterator = dados.iterator();
        while (iterator.hasNext()) {
            HashMap s;
            HashMap h = s = iterator.next();
            h.put("PERCENTUAL", (Double)h.get("VALOR_TOTAL") / valorTotal * 100.0);
            aux.add(h);
        }
        return aux;
    }

    private void classicarNivel(List arrayList, Double indice, String nivel, HashMap param) {
        if (arrayList.isEmpty()) {
            return;
        }
        double percAcumulado = 0.0;
        double valorAcumulado = 0.0;
        int cont = 0;
        do {
            HashMap h = (HashMap)arrayList.get(0);
            Double perc = (Double)h.get("PERCENTUAL");
            Double valor = (Double)h.get("VALOR_TOTAL");
            percAcumulado += perc.doubleValue();
            valorAcumulado += valor.doubleValue();
            arrayList.remove(0);
            h.put("NIVEL", nivel);
            ++cont;
        } while (!(percAcumulado >= indice) && !arrayList.isEmpty());
        param.put("PERC_" + nivel, percAcumulado);
        param.put("VALOR_" + nivel, valorAcumulado);
        param.put("CONTADOR_" + nivel, cont);
    }

    private List getNotas(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtrarFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short tipoRel) {
        String query = this.getQueryNotas(tipoRel);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setShort("sim", (short)1);
        q.setParameter("autorizado", (Object)EnumConstNFeStatus.getStatusAutorizadaShort());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        if (filtrarEmpresa == 1) {
            q.setLong("empresaInicial", empresaInicial.longValue());
            q.setLong("empresaFinal", empresaFinal.longValue());
        } else {
            q.setLong("empresaInicial", 0L);
            q.setLong("empresaFinal", 0L);
        }
        q.setShort("filtrarData", filtrarData.shortValue());
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        } else {
            q.setDate("dataInicial", new Date());
            q.setDate("dataFinal", new Date());
        }
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        if (filtrarProduto == 1) {
            q.setLong("produtoInicial", produtoInicial.longValue());
            q.setLong("produtoFinal", produtoFinal.longValue());
        } else {
            q.setLong("produtoInicial", 0L);
            q.setLong("produtoFinal", 0L);
        }
        q.setShort("filtrarEspecie", filtrarEspecie.shortValue());
        if (filtrarEspecie == 1) {
            q.setLong("especieInicial", especieInicial.longValue());
            q.setLong("especieFinal", especieFinal.longValue());
        } else {
            q.setLong("especieInicial", 0L);
            q.setLong("especieFinal", 0L);
        }
        q.setShort("filtrarSubEspecie", filtrarSubEspecie.shortValue());
        if (filtrarSubEspecie == 1) {
            q.setLong("subEspecieInicial", subEspecieInicial.longValue());
            q.setLong("subEspecieFinal", subEspecieFinal.longValue());
        } else {
            q.setLong("subEspecieInicial", 0L);
            q.setLong("subEspecieFinal", 0L);
        }
        q.setShort("filtrarFabricante", filtrarFabricante.shortValue());
        if (filtrarFabricante == 1) {
            q.setLong("fabricanteInicial", fabricanteInicial.longValue());
            q.setLong("fabricanteFinal", fabricanteFinal.longValue());
        } else {
            q.setLong("fabricanteInicial", 0L);
            q.setLong("fabricanteFinal", 0L);
        }
        q.setString("codigo1", "06");
        q.setString("codigo2", "07");
        q.setString("codigo3", "08");
        q.setString("codigo4", "00");
        q.setString("codigo5", "01");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getDadosVendas(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarProduto, Long produtoInicial, Long produtoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarEspecie, Long especieInicial, Long especieFinal, Short filtrarSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtrarFabricante, Long fabricanteInicial, Long fabricanteFinal, Short tipoRel) {
        List notas = this.getNotas(filtrarData, dataInicial, dataFinal, filtrarProduto, produtoInicial, produtoFinal, filtrarEspecie, especieInicial, especieFinal, filtrarSubEspecie, subEspecieInicial, subEspecieFinal, filtrarFabricante, fabricanteInicial, fabricanteFinal, filtrarEmpresa, empresaInicial, empresaFinal, tipoRel);
        ArrayList to = new ArrayList();
        this.mergeList(notas, to);
        return to;
    }

    private void mergeList(List notas, List to) {
        for (int i = 0; i < notas.size(); ++i) {
            HashMap h1 = (HashMap)notas.get(i);
            Long id1 = (Long)h1.get("IDENTIFICADOR");
            boolean achou = false;
            for (int j = 0; j < to.size(); ++j) {
                HashMap h2 = (HashMap)to.get(j);
                Long id2 = (Long)h2.get("IDENTIFICADOR");
                if (id1.longValue() != id2.longValue()) continue;
                Double valor1 = (Double)h1.get("VALOR_TOTAL");
                Double valor2 = (Double)h2.get("VALOR_TOTAL");
                h1.put("VALOR_TOTAL", valor1 + valor2);
                to.remove(j);
                achou = true;
            }
            if (achou) continue;
            to.add(h1);
        }
    }

    private String getQueryNotas(Short tipoRel) {
        if (tipoRel == 0) {
            return "SELECT esp.identificador                                             AS IDENTIFICADOR,  esp.nome                                                             AS NOME,  SUM((i.quantidadeTotal * i.valorUnitario) - i.valorDesconto)         AS VALOR_TOTAL,  SUM(i.quantidadeTotal)                                               AS QUANTIDADE_TOTAL  FROM ItemNotaFiscalPropria i  inner join i.itemNotaLivroFiscal il inner join il.cfop cf inner join i.produto p inner join p.unidadeMedida un inner join p.especie esp inner join p.subEspecie s inner join p.fabricante f inner join i.modeloFiscal m inner join i.notaFiscalPropria n inner join p.ncm nc inner join n.naturezaOperacao nn inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.complemento cl WHERE ( n.status              = :autorizado) and (n.situacaoDocumento.codigo =:codigo1 or  n.situacaoDocumento.codigo =:codigo2 or n.situacaoDocumento.codigo =:codigo3 or n.situacaoDocumento.codigo =:codigo4 or n.situacaoDocumento.codigo =:codigo5 )AND (:filtrarEmpresa                         <> 1 OR emp.identificador    BETWEEN :empresaInicial       AND :empresaFinal) AND cf.cfopReceitaVenda           = :sim AND (:filtrarData                            <> 1 OR n.dataEmissaoNota BETWEEN :dataInicial       AND :dataFinal) AND (:filtrarProduto                         <> 1 OR p.identificador             BETWEEN :produtoInicial    AND :produtoFinal) AND (:filtrarEspecie                         <> 1 OR esp.identificador     BETWEEN :especieInicial    AND :especieFinal) AND (:filtrarSubEspecie                      <> 1 OR s.identificador  BETWEEN :subEspecieInicial AND :subEspecieFinal) AND (:filtrarFabricante                      <> 1 OR f.identificador  BETWEEN :fabricanteInicial AND :fabricanteFinal) GROUP BY esp.identificador, esp.nome";
        }
        if (tipoRel == 3) {
            return "SELECT s.identificador                                                   AS IDENTIFICADOR,  s.nome                                                               AS NOME,  SUM((i.quantidadeTotal * i.valorUnitario) - i.valorDesconto)         AS VALOR_TOTAL,  SUM(i.quantidadeTotal)                                               AS QUANTIDADE_TOTAL  FROM ItemNotaFiscalPropria i  inner join i.itemNotaLivroFiscal il inner join il.cfop cf inner join i.produto p inner join p.unidadeMedida un inner join p.especie esp inner join p.subEspecie s inner join p.fabricante f inner join i.modeloFiscal m inner join i.notaFiscalPropria n inner join p.ncm nc inner join n.naturezaOperacao nn inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.complemento cl WHERE ( n.status              IN(:autorizado)) and (n.situacaoDocumento.codigo =:codigo1 or  n.situacaoDocumento.codigo =:codigo2 or n.situacaoDocumento.codigo =:codigo3 or n.situacaoDocumento.codigo =:codigo4 or n.situacaoDocumento.codigo =:codigo5 )AND (:filtrarEmpresa                         <> 1 OR emp.identificador    BETWEEN :empresaInicial       AND :empresaFinal) AND cf.cfopReceitaVenda           = :sim AND (:filtrarData                            <> 1 OR n.dataEmissaoNota BETWEEN :dataInicial       AND :dataFinal) AND (:filtrarProduto                         <> 1 OR p.identificador             BETWEEN :produtoInicial    AND :produtoFinal) AND (:filtrarEspecie                         <> 1 OR esp.identificador     BETWEEN :especieInicial    AND :especieFinal) AND (:filtrarSubEspecie                      <> 1 OR s.identificador  BETWEEN :subEspecieInicial AND :subEspecieFinal) AND (:filtrarFabricante                      <> 1 OR f.identificador  BETWEEN :fabricanteInicial AND :fabricanteFinal) GROUP BY s.identificador, s.nome";
        }
        if (tipoRel == 2) {
            return "SELECT f.identificador                                                   AS IDENTIFICADOR,  f.nome                                                               AS NOME,  SUM((i.quantidadeTotal * i.valorUnitario) - i.valorDesconto)         AS VALOR_TOTAL,  SUM(i.quantidadeTotal)                                               AS QUANTIDADE_TOTAL  FROM ItemNotaFiscalPropria i  inner join i.itemNotaLivroFiscal il inner join il.cfop cf inner join i.produto p inner join p.unidadeMedida un inner join p.especie esp inner join p.subEspecie s inner join p.fabricante f inner join i.modeloFiscal m inner join i.notaFiscalPropria n inner join p.ncm nc inner join n.naturezaOperacao nn inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.complemento cl WHERE ( n.status              = :autorizado) and (n.situacaoDocumento.codigo =:codigo1 or  n.situacaoDocumento.codigo =:codigo2 or n.situacaoDocumento.codigo =:codigo3 or n.situacaoDocumento.codigo =:codigo4 or n.situacaoDocumento.codigo =:codigo5 )AND (:filtrarEmpresa                         <> 1 OR emp.identificador    BETWEEN :empresaInicial       AND :empresaFinal) AND cf.cfopReceitaVenda           = :sim AND (:filtrarData                            <> 1 OR n.dataEmissaoNota    BETWEEN :dataInicial       AND :dataFinal) AND (:filtrarProduto                         <> 1 OR p.identificador      BETWEEN :produtoInicial    AND :produtoFinal) AND (:filtrarEspecie                         <> 1 OR esp.identificador    BETWEEN :especieInicial    AND :especieFinal) AND (:filtrarSubEspecie                      <> 1 OR s.identificador      BETWEEN :subEspecieInicial AND :subEspecieFinal) AND (:filtrarFabricante                      <> 1 OR f.identificador      BETWEEN :fabricanteInicial AND :fabricanteFinal) GROUP BY f.identificador, f.nome";
        }
        return "SELECT p.identificador                                                   AS IDENTIFICADOR, p.codigoAuxiliar                                                      AS COD_AUX, p.nome                                                                AS NOME, un.sigla                                                              AS UNIDADE_MEDIDA, SUM((i.quantidadeTotal * i.valorUnitario) - i.valorDesconto)          AS VALOR_TOTAL, SUM(i.quantidadeTotal)                                                AS QUANTIDADE_TOTAL FROM ItemNotaFiscalPropria i  inner join i.itemNotaLivroFiscal il inner join il.cfop cf inner join i.produto p inner join p.unidadeMedida un inner join p.especie esp inner join p.subEspecie s inner join p.fabricante f inner join i.modeloFiscal m inner join i.notaFiscalPropria n inner join p.ncm nc inner join n.naturezaOperacao nn inner join n.empresa emp inner join n.unidadeFatCliente u inner join u.cliente c inner join c.pessoa pes inner join pes.complemento cl WHERE ( n.status              = :autorizado) and (n.situacaoDocumento.codigo =:codigo1 or  n.situacaoDocumento.codigo =:codigo2 or n.situacaoDocumento.codigo =:codigo3 or n.situacaoDocumento.codigo =:codigo4 or n.situacaoDocumento.codigo =:codigo5 )AND (:filtrarEmpresa                         <> 1 OR emp.identificador    BETWEEN :empresaInicial       AND :empresaFinal) AND cf.cfopReceitaVenda           = :sim AND (:filtrarData                            <> 1 OR n.dataEmissaoNota    BETWEEN :dataInicial       AND :dataFinal) AND (:filtrarProduto                         <> 1 OR p.identificador      BETWEEN :produtoInicial    AND :produtoFinal) AND (:filtrarEspecie                         <> 1 OR esp.identificador    BETWEEN :especieInicial    AND :especieFinal) AND (:filtrarSubEspecie                      <> 1 OR s.identificador      BETWEEN :subEspecieInicial AND :subEspecieFinal) AND (:filtrarFabricante                      <> 1 OR f.identificador      BETWEEN :fabricanteInicial AND :fabricanteFinal) GROUP BY p.identificador, p.codigoAuxiliar, p.nome, un.sigla ";
    }
}

