/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.movimentobancario;

import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.util.CoreReportUtil;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityMovimentoBancario {
    private static BigDecimal saldoTotal = new BigDecimal(0);
    private static TLogger logger = TLogger.get(UtilityMovimentoBancario.class);

    public static JasperPrint gerarExtratoMovimentoBancario(String contasValores, String descricaoContasValores, Date dataInicial, Date dataFinal, Date dataAnterior, Empresa empresa, Short exibirLinhaTracejada, Integer imprimirCheques, Short imprimirInativas, Short exibirObservacao, Short aglutinarContas, Short dadosImpressos, Short tipoImpressao, String fecho, Short agruparBordero, String ordenacaoMovimentos) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT DISTINCT M.ID_CONTA_VALOR FROM MOVIMENTO_BANCARIO    M WHERE M.ID_CONTA_VALOR     IN (" + contasValores + ") ORDER BY 1 ASC";
        NativeQuery q = s.createSQLQuery(query);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List result = q.list();
        if (aglutinarContas == 0) {
            if (tipoImpressao == 1) {
                UtilityMovimentoBancario.getMovimentoContasNaoAgrupadasCompensacao(dataAnterior, dataInicial, dataFinal, imprimirInativas, result, exibirObservacao, agruparBordero, ordenacaoMovimentos);
            } else {
                UtilityMovimentoBancario.getMovimentoContasNaoAgrupadasEmissao(dataAnterior, dataInicial, dataFinal, imprimirInativas, result, exibirObservacao, agruparBordero, ordenacaoMovimentos);
            }
        } else if (tipoImpressao == 1) {
            UtilityMovimentoBancario.getMovimentoContasAgrupadasCompensacao(contasValores, dataInicial, dataFinal, dataAnterior, imprimirInativas, result, agruparBordero, ordenacaoMovimentos);
        } else {
            UtilityMovimentoBancario.getMovimentoContasAgrupadasEmissao(contasValores, dataInicial, dataFinal, dataAnterior, imprimirInativas, result, agruparBordero, ordenacaoMovimentos);
        }
        if (imprimirCheques == 1) {
            HashMap<String, List> h = new HashMap<String, List>();
            h.put("LIST_CHEQUE_TRANSITO", UtilityMovimentoBancario.getImprimirChequesTransito(contasValores, dataFinal));
            result.add(h);
        }
        HashMap parametros = UtilityMovimentoBancario.buildParametros(contasValores, descricaoContasValores, dataInicial, dataFinal, dataAnterior, empresa, exibirLinhaTracejada, imprimirCheques, imprimirInativas, exibirObservacao, aglutinarContas, dadosImpressos, tipoImpressao, fecho);
        return UtilityMovimentoBancario.buildReport(tipoImpressao, empresa, parametros, result);
    }

    private static JasperPrint buildReport(Short tipoImpressao, Empresa empresa, HashMap parametros, List dados) throws ExceptionService {
        String path = "";
        path = tipoImpressao == 1 ? UtilityMovimentoBancario.getReport("LISTAGEM_EXTRATO_BANCARIO_COMPENSACAO.jasper", empresa) : UtilityMovimentoBancario.getReport("LISTAGEM_EXTRATO_BANCARIO_EMISSAO.jasper", empresa);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", parametros).setAttribute("nodo", null), "setarParametrosRelatorio");
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
    }

    private static HashMap buildParametros(String contasValores, String descricaoContasValores, Date dataInicial, Date dataFinal, Date dataAnterior, Empresa empresa, Short exibirLinhaTracejada, Integer imprimirCheques, Short imprimirInativas, Short exibirObservacao, Short aglutinarContas, Short dadosImpressos, Short tipoImpressao, String fecho) {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("CONTAS_VALORES", contasValores);
        parametros.put("DESCRICAO_CONTAS_VALORES", descricaoContasValores);
        parametros.put("DATA_INICIAL", dataInicial);
        parametros.put("DATA_FINAL", dataFinal);
        parametros.put("DATA_ANTERIOR", dataAnterior);
        parametros.put("ID_EMPRESA", empresa.getIdentificador().intValue());
        parametros.put("IMPRIME_CHEQUES", imprimirCheques);
        parametros.put("IMPRIME_INATIVAS", imprimirInativas);
        parametros.put("EXIBIR_OBSERVACAO", exibirObservacao);
        parametros.put("AGLUTINAR_CONTAS", aglutinarContas);
        parametros.put("DADOS_IMPRESSOS", dadosImpressos);
        parametros.put("EXIBIR_LINHA_TRACEJADA", exibirLinhaTracejada);
        parametros.put("SALDO", saldoTotal);
        parametros.put("FECHO", fecho);
        parametros.putAll(CoreReportUtil.instance(empresa).getDefaultParams(null));
        return parametros;
    }

    public static String getReport(String nomeRelatorio, Empresa empresa) {
        CoreReportUtil.instance(empresa);
        return CoreReportUtil.getPathReports() + File.separator + "financas" + File.separator + "gestaotesouraria" + File.separator + "listagens" + File.separator + "listagemextratofinanceiro" + File.separator + nomeRelatorio;
    }

    private static void getMovimentoContasNaoAgrupadasCompensacao(Date dataAnterior, Date dataInicial, Date dataFinal, Short imprimirInativas, List result, Short exibirObservacao, Short agruparBordero, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (Object o : result) {
            HashMap h = (HashMap)o;
            Integer idConta = (Integer)h.get("ID_CONTA_VALOR");
            String query = "SELECT DISTINCT M.ID_CONTA_VALOR,     P.NOME,     s.VALOR_SALDO,     s.DATA_SALDO,     c.NR_CONTA,     c.DV_CONTA,     A.NR_AGENCIA,     C.DESCRICAO FROM MOVIMENTO_BANCARIO    M INNER JOIN CONTA_VALORES   C ON (C.ID_CONTA_VALOR   = M.ID_CONTA_VALOR) INNER JOIN AGENCIA_VALORES A ON  C.ID_AGENCIA_VALOR = A.ID_AGENCIA_VALOR INNER JOIN SALDO_BANCO_COMPENSACAO(:idConta, :dataAnterior, :dataAnterior)                            S on S.ID_CONTA_VLR = C.ID_CONTA_VALOR INNER JOIN PESSOA          P ON (P.ID_PESSOA        = A.ID_PESSOA) WHERE M.ID_CONTA_VALOR     = :idConta AND (:imprimirInativas <> 0 OR c.ativo = :sim)";
            NativeQuery q = s.createSQLQuery(query);
            q.setDate("dataAnterior", dataAnterior);
            q.setShort("imprimirInativas", imprimirInativas.shortValue());
            q.setShort("sim", (short)1);
            q.setInteger("idConta", idConta.intValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aux = q.list();
            if (aux == null || aux.isEmpty()) continue;
            for (Object ob : aux) {
                HashMap h1 = (HashMap)ob;
                Integer idContaValor = (Integer)h1.get("ID_CONTA_VALOR");
                if (ToolMethods.isEquals((Object)agruparBordero, (Object)1)) {
                    h1.put("LIST_MOVIMENTOS", UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBordero(idContaValor, dataInicial, dataFinal, exibirObservacao, ordenacaoMovimentos));
                    continue;
                }
                h1.put("LIST_MOVIMENTOS", UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoCompensacao(idContaValor, dataInicial, dataFinal, exibirObservacao, ordenacaoMovimentos));
            }
            h.put("LIST_VALOR_SALDO", aux);
        }
    }

    private static void getMovimentoContasAgrupadasCompensacao(String contasValores, Date dataInicial, Date dataFinal, Date dataAnterior, Short imprimirInativas, List result, Short agruparBordero, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        saldoTotal = new BigDecimal(0);
        for (Object o : result) {
            HashMap h = (HashMap)o;
            Integer idConta = (Integer)h.get("ID_CONTA_VALOR");
            String query = "SELECT DISTINCT     s.VALOR_SALDO FROM MOVIMENTO_BANCARIO    M INNER JOIN CONTA_VALORES   C ON (C.ID_CONTA_VALOR   = M.ID_CONTA_VALOR) INNER JOIN AGENCIA_VALORES A ON  C.ID_AGENCIA_VALOR = A.ID_AGENCIA_VALOR INNER JOIN SALDO_BANCO_COMPENSACAO(:idConta, :dataAnterior, :dataAnterior)                            S on S.ID_CONTA_VLR = C.ID_CONTA_VALOR INNER JOIN PESSOA          P ON (P.ID_PESSOA        = A.ID_PESSOA) WHERE M.ID_CONTA_VALOR     = :idConta AND (:imprimirInativas <> 0 OR c.ativo = :sim)";
            NativeQuery q = s.createSQLQuery(query);
            q.setShort("sim", (short)1);
            q.setShort("imprimirInativas", imprimirInativas.shortValue());
            q.setDate("dataAnterior", dataAnterior);
            q.setInteger("idConta", idConta.intValue());
            BigDecimal valorSaldo = q.uniqueResult() != null ? (BigDecimal)q.uniqueResult() : new BigDecimal(0);
            saldoTotal = saldoTotal.add(valorSaldo);
        }
        if (ToolMethods.isEquals((Object)agruparBordero, (Object)1)) {
            result.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBordero(contasValores, dataInicial, dataFinal, ordenacaoMovimentos));
        } else {
            result.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoCompensacao(contasValores, dataInicial, dataFinal, ordenacaoMovimentos));
        }
    }

    private static List getMovimentoCreditoDebitoAgrupadoCompensacao(String contaValores, Date dataInicial, Date dataFinal, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT m.id_movimento_bancario,     M.data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal and   m.id_conta_valor         IN (" + contaValores + ") order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = query + " M.data_COMPENSACAO asc";
                    break;
                }
                case "2": {
                    query = query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = query + " M.historico";
                    break;
                }
                case "4": {
                    query = query + " M.valor";
                    break;
                }
                case "5": {
                    query = query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = query + ",";
        }
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static List getMovimentoCreditoDebitoAgrupadoEmissao(String contaValores, Date dataInicial, Date dataFinal, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT m.id_movimento_bancario,     M.DATA_LANCAMENTO as data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal and   m.id_conta_valor         IN (" + contaValores + ") order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = query + " M.DATA_LANCAMENTO asc";
                    break;
                }
                case "2": {
                    query = query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = query + " M.historico";
                    break;
                }
                case "4": {
                    query = query + " M.valor";
                    break;
                }
                case "5": {
                    query = query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = query + ",";
        }
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoCompensacao(Integer idConta, Date dataInicial, Date dataFinal, Short exibirObservacao, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT m.id_movimento_bancario,     M.data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal and   m.id_conta_valor         = :idContaValor order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = (String)query + " M.data_COMPENSACAO asc";
                    break;
                }
                case "2": {
                    query = (String)query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = (String)query + " M.historico";
                    break;
                }
                case "4": {
                    query = (String)query + " M.valor";
                    break;
                }
                case "5": {
                    query = (String)query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = (String)query + ",";
        }
        NativeQuery q = s.createSQLQuery((String)query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idConta.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        if (aux != null && !aux.isEmpty() && exibirObservacao == 1) {
            for (Object o : aux) {
                HashMap h = (HashMap)o;
                Integer idMovimento = (Integer)h.get("ID_MOVIMENTO_BANCARIO");
                h.put("LIST_OBSERVACAO_TITULO", UtilityMovimentoBancario.getExibirObservacaoTitulosNaoAgrupado(idMovimento));
            }
        }
        return aux;
    }

    private static List getExibirObservacaoTitulosNaoAgrupado(Integer idMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT t.id_titulo AS ID_TITULO, t.observacao AS OBSERVACAO FROM baixa_titulo b inner join grupo_de_baixa_formas gbf on (gbf.id_grupo_de_baixa_formas = b.id_grupo_baixa_formas) INNER JOIN grupo_de_baixa g ON g.id_grupo_de_baixa = gbf.id_grupo_de_baixa INNER JOIN movimento_bancario m ON m.id_grupo_baixa_formas = gbf.id_grupo_de_baixa_formas INNER JOIN titulo t ON t.id_titulo = b.id_titulo WHERE m.id_movimento_bancario = :idMovimento";
        NativeQuery q = s.createSQLQuery(query);
        q.setInteger("idMovimento", idMovimento.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static List getImprimirChequesTransito(String contasValores, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT C.ID_CONTA_VALOR,     P.NOME,     C.NUMERO,     C.DATA_EMISSAO,     C.FAVORECIDO,     C.VALOR,     CV.DESCRICAO      FROM CHEQUE               C JOIN CONTA_VALORES            CV ON CV.ID_CONTA_VALOR   = C.ID_CONTA_VALOR JOIN AGENCIA_VALORES          AV ON AV.ID_AGENCIA_VALOR = CV.ID_AGENCIA_VALOR JOIN PESSOA                    P ON P.ID_PESSOA         = AV.ID_PESSOA LEFT JOIN COMPENSACAO_CHEQUES CC ON CC.ID_CHEQUE        = C.ID_CHEQUE WHERE C.ID_CONTA_VALOR IN (" + contasValores + ") AND C.DATA_EMISSAO  <= :dataFinal AND (CC.DATA_COMPENSACAO IS NULL OR CC.DATA_COMPENSACAO > :dataFinal) AND (C.DATA_EMISSAO  <= :dataFinal)";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static void getMovimentoContasNaoAgrupadasEmissao(Date dataAnterior, Date dataInicial, Date dataFinal, Short imprimirInativas, List result, Short exibirObservacao, Short agruparBordero, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (Object o : result) {
            HashMap h = (HashMap)o;
            Integer idConta = (Integer)h.get("ID_CONTA_VALOR");
            String query = "SELECT DISTINCT M.ID_CONTA_VALOR,     P.NOME,     s.VALOR_SALDO,     s.DATA_SALDO,     c.NR_CONTA,     c.DV_CONTA,     A.NR_AGENCIA,     C.DESCRICAO FROM MOVIMENTO_BANCARIO    M INNER JOIN CONTA_VALORES   C ON (C.ID_CONTA_VALOR   = M.ID_CONTA_VALOR) INNER JOIN AGENCIA_VALORES A ON  C.ID_AGENCIA_VALOR = A.ID_AGENCIA_VALOR INNER JOIN SALDO_BANCO_EMISSAO(:idConta, :dataAnterior, :dataAnterior)                            S on S.ID_CONTA_VLR = C.ID_CONTA_VALOR INNER JOIN PESSOA          P ON (P.ID_PESSOA        = A.ID_PESSOA) WHERE M.ID_CONTA_VALOR     = :idConta AND (:imprimirInativas <> 0 OR c.ativo = :sim)";
            NativeQuery q = s.createSQLQuery(query);
            q.setDate("dataAnterior", dataAnterior);
            q.setShort("imprimirInativas", imprimirInativas.shortValue());
            q.setShort("sim", (short)1);
            q.setInteger("idConta", idConta.intValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aux = q.list();
            if (aux == null || aux.isEmpty()) continue;
            for (Object ob : aux) {
                HashMap h1 = (HashMap)ob;
                Integer idContaValor = (Integer)h1.get("ID_CONTA_VALOR");
                if (ToolMethods.isEquals((Object)agruparBordero, (Object)1)) {
                    h1.put("LIST_MOVIMENTOS", UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBordero(idContaValor, dataInicial, dataFinal, exibirObservacao, ordenacaoMovimentos));
                    continue;
                }
                h1.put("LIST_MOVIMENTOS", UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoEmissao(idContaValor, dataInicial, dataFinal, exibirObservacao, ordenacaoMovimentos));
            }
            h.put("LIST_VALOR_SALDO", aux);
        }
    }

    private static void getMovimentoContasAgrupadasEmissao(String contasValores, Date dataInicial, Date dataFinal, Date dataAnterior, Short imprimirInativas, List result, Short agruparBordero, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        saldoTotal = new BigDecimal(0);
        for (Object o : result) {
            HashMap h = (HashMap)o;
            Integer idConta = (Integer)h.get("ID_CONTA_VALOR");
            String query = "SELECT DISTINCT     s.VALOR_SALDO FROM MOVIMENTO_BANCARIO    M INNER JOIN CONTA_VALORES   C ON (C.ID_CONTA_VALOR   = M.ID_CONTA_VALOR) INNER JOIN AGENCIA_VALORES A ON  C.ID_AGENCIA_VALOR = A.ID_AGENCIA_VALOR INNER JOIN SALDO_BANCO_EMISSAO(:idConta, :dataAnterior, :dataAnterior)                            S on S.ID_CONTA_VLR = C.ID_CONTA_VALOR INNER JOIN PESSOA          P ON (P.ID_PESSOA        = A.ID_PESSOA) WHERE M.ID_CONTA_VALOR     = :idConta AND (:imprimirInativas <> 0 OR c.ativo = :sim)";
            NativeQuery q = s.createSQLQuery(query);
            q.setShort("sim", (short)1);
            q.setShort("imprimirInativas", imprimirInativas.shortValue());
            q.setDate("dataAnterior", dataAnterior);
            q.setInteger("idConta", idConta.intValue());
            BigDecimal valorSaldo = q.uniqueResult() != null ? (BigDecimal)q.uniqueResult() : new BigDecimal(0);
            saldoTotal = saldoTotal.add(valorSaldo);
        }
        if (ToolMethods.isEquals((Object)agruparBordero, (Object)1)) {
            result.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBordero(contasValores, dataInicial, dataFinal, ordenacaoMovimentos));
        } else {
            result.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoEmissao(contasValores, dataInicial, dataFinal, ordenacaoMovimentos));
        }
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoEmissao(Integer idContaValor, Date dataInicial, Date dataFinal, Short exibirObservacao, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT m.id_movimento_bancario,     M.DATA_LANCAMENTO as data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal and   m.id_conta_valor         = :idContaValor order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = (String)query + " M.DATA_LANCAMENTO asc";
                    break;
                }
                case "2": {
                    query = (String)query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = (String)query + " M.historico";
                    break;
                }
                case "4": {
                    query = (String)query + " M.valor";
                    break;
                }
                case "5": {
                    query = (String)query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = (String)query + ",";
        }
        NativeQuery q = s.createSQLQuery((String)query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        if (aux != null && !aux.isEmpty() && exibirObservacao == 1) {
            for (Object o : aux) {
                HashMap h = (HashMap)o;
                Integer idMovimento = (Integer)h.get("ID_MOVIMENTO_BANCARIO");
                h.put("LIST_OBSERVACAO_TITULO", UtilityMovimentoBancario.getExibirObservacaoTitulosNaoAgrupado(idMovimento));
            }
        }
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBordero(Integer idContaValor, Date dataInicial, Date dataFinal, Short exibirObservacao, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT m.id_movimento_bancario,     M.DATA_LANCAMENTO as data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  and not exists (select * from BORDERO_CH_TERC_CHEQUES b where  b.id_mov_banc_credito = m.id_movimento_bancario                    or b.id_mov_banc_debito = m.id_movimento_bancario) order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = (String)query + " M.DATA_LANCAMENTO asc";
                    break;
                }
                case "2": {
                    query = (String)query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = (String)query + " M.historico";
                    break;
                }
                case "4": {
                    query = (String)query + " M.valor";
                    break;
                }
                case "5": {
                    query = (String)query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = (String)query + ",";
        }
        NativeQuery q = s.createSQLQuery((String)query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        if (aux != null && !aux.isEmpty() && exibirObservacao == 1) {
            for (Object o : aux) {
                HashMap h = (HashMap)o;
                Integer idMovimento = (Integer)h.get("ID_MOVIMENTO_BANCARIO");
                h.put("LIST_OBSERVACAO_TITULO", UtilityMovimentoBancario.getExibirObservacaoTitulosNaoAgrupado(idMovimento));
            }
        }
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBorderoCredito(idContaValor, dataInicial, dataFinal));
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBorderoDebito(idContaValor, dataInicial, dataFinal));
        aux = UtilityMovimentoBancario.ordenarLista(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBorderoCredito(Integer idContaValor, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_LANCAMENTO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_credito WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  group by m.data_lancamento, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_LANCAMENTO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoEmissaoAgrupaBorderoDebito(Integer idContaValor, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_LANCAMENTO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_debito WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  group by m.data_lancamento, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_LANCAMENTO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBordero(Integer idContaValor, Date dataInicial, Date dataFinal, Short exibirObservacao, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT m.id_movimento_bancario,     M.DATA_COMPENSACAO as data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico FROM movimento_bancario M WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  and not exists (select * from BORDERO_CH_TERC_CHEQUES b where  b.id_mov_banc_credito = m.id_movimento_bancario                    or b.id_mov_banc_debito = m.id_movimento_bancario) order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = (String)query + " M.data_COMPENSACAO asc";
                    break;
                }
                case "2": {
                    query = (String)query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = (String)query + " M.historico";
                    break;
                }
                case "4": {
                    query = (String)query + " M.valor";
                    break;
                }
                case "5": {
                    query = (String)query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = (String)query + ",";
        }
        NativeQuery q = s.createSQLQuery((String)query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        if (aux != null && !aux.isEmpty() && exibirObservacao == 1) {
            for (Object o : aux) {
                HashMap h = (HashMap)o;
                Integer idMovimento = (Integer)h.get("ID_MOVIMENTO_BANCARIO");
                h.put("LIST_OBSERVACAO_TITULO", UtilityMovimentoBancario.getExibirObservacaoTitulosNaoAgrupado(idMovimento));
            }
        }
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBorderoCredito(idContaValor, dataInicial, dataFinal));
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBorderoDebito(idContaValor, dataInicial, dataFinal));
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBorderoCredito(Integer idContaValor, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_COMPENSACAO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_credito WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  group by m.DATA_COMPENSACAO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_COMPENSACAO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoNaoAgrupadoCompensacaoAgrupaBorderoDebito(Integer idContaValor, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_COMPENSACAO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_debito WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         = :idContaValor  group by m.DATA_COMPENSACAO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_COMPENSACAO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("idContaValor", idContaValor.intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBordero(String contaValores, Date dataInicial, Date dataFinal, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT m.id_movimento_bancario,     M.data_COMPENSACAO,     M.valor,     M.deb_cred,     M.historico  FROM movimento_bancario M  WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  and not exists (select * from BORDERO_CH_TERC_CHEQUES b where  b.id_mov_banc_credito = m.id_movimento_bancario                    or b.id_mov_banc_debito = m.id_movimento_bancario)order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = query + " M.data_COMPENSACAO asc";
                    break;
                }
                case "2": {
                    query = query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = query + " M.historico";
                    break;
                }
                case "4": {
                    query = query + " M.valor";
                    break;
                }
                case "5": {
                    query = query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = query + ",";
        }
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBorderoCredito(contaValores, dataInicial, dataFinal));
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBorderoDebito(contaValores, dataInicial, dataFinal));
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBorderoCredito(String contaValores, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_COMPENSACAO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_credito WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  group by m.DATA_COMPENSACAO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_COMPENSACAO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoCompensacaoAgrupaBorderoDebito(String contaValores, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_COMPENSACAO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_debito WHERE M.DATA_COMPENSACAO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  group by m.DATA_COMPENSACAO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_COMPENSACAO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBordero(String contaValores, Date dataInicial, Date dataFinal, String ordenacaoMovimentos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT m.id_movimento_bancario,     M.DATA_LANCAMENTO,     M.valor,     M.deb_cred,     M.historico  FROM movimento_bancario M  WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  and not exists (select * from BORDERO_CH_TERC_CHEQUES b where  b.id_mov_banc_credito = m.id_movimento_bancario                    or b.id_mov_banc_debito = m.id_movimento_bancario)order by ";
        String[] partes = ToolString.splitString((String)ordenacaoMovimentos, (char[])new char[]{','});
        int i = 0;
        String[] stringArray = partes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String parte;
            switch (parte = stringArray[j]) {
                case "1": {
                    query = query + " M.DATA_LANCAMENTO asc";
                    break;
                }
                case "2": {
                    query = query + " M.deb_cred desc";
                    break;
                }
                case "3": {
                    query = query + " M.historico";
                    break;
                }
                case "4": {
                    query = query + " M.valor";
                    break;
                }
                case "5": {
                    query = query + " M.id_movimento_bancario";
                }
            }
            if (++i == partes.length) continue;
            query = query + ",";
        }
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBorderoCredito(contaValores, dataInicial, dataFinal));
        aux.addAll(UtilityMovimentoBancario.getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBorderoDebito(contaValores, dataInicial, dataFinal));
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBorderoCredito(String contaValores, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_LANCAMENTO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_credito WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  group by m.DATA_LANCAMENTO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_LANCAMENTO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List getMovimentoCreditoDebitoAgrupadoEmissaoAgrupaBorderoDebito(String contaValores, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT M.DATA_LANCAMENTO as data_COMPENSACAO, sum(M.valor) as valor, M.deb_cred, b.id_bordero_ch_terc FROM BORDERO_CH_TERC_CHEQUES b inner join movimento_bancario m on m.id_movimento_bancario = b.id_mov_banc_debito WHERE M.DATA_LANCAMENTO BETWEEN :dataInicial AND :dataFinal  and   m.id_conta_valor         IN (" + contaValores + ")  group by m.DATA_LANCAMENTO, m.deb_cred, b.id_bordero_ch_terc order by M.DATA_LANCAMENTO asc, M.deb_cred desc";
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List aux = q.list();
        UtilityMovimentoBancario.setInfoBordero(aux);
        return aux;
    }

    private static List ordenarLista(List<HashMap> lancamentos) {
        if (lancamentos != null) {
            Collections.sort(lancamentos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    HashMap item1 = (HashMap)o1;
                    HashMap item2 = (HashMap)o2;
                    Date data1 = (Date)item1.get("DATA_COMPENSACAO");
                    Date data2 = (Date)item2.get("DATA_COMPENSACAO");
                    return data1.compareTo(data2);
                }
            });
            return lancamentos;
        }
        return new ArrayList();
    }

    private static void setInfoBordero(List aux) {
        for (Object ob : aux) {
            HashMap hash = (HashMap)ob;
            Integer idBordero = (Integer)hash.get("ID_BORDERO_CH_TERC");
            BorderoChequesTerceiros b = UtilityMovimentoBancario.getBorderoChequeFromIdentificador(idBordero.longValue());
            hash.put("ID_MOVIMENTO_BANCARIO", idBordero);
            StringBuilder sb = new StringBuilder();
            sb.append("Bordero Cheque Terc: ");
            sb.append(idBordero);
            if (b != null) {
                sb.append(". Cart. Origem: ");
                sb.append(b.getCarteiraOrigem().getNome());
                sb.append(". Cart. Destino: ");
                sb.append(b.getCarteiraCobranca().getNome());
            }
            hash.put("HISTORICO", sb.toString());
        }
    }

    private static BorderoChequesTerceiros getBorderoChequeFromIdentificador(long idBordero) {
        try {
            return (BorderoChequesTerceiros)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOBorderoChequesTerceiros(), idBordero);
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }
}

