/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.movimentocolaboradorcc;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.MovimentoColaboradorCentroCusto;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.movimentocolaboradorcc.UtilMovimentoColaboradorCentroCusto;
import mentorcore.tools.DateUtil;

public class ServiceMovimentoColaboradorCentroCusto
extends CoreService {
    public static final String SALVAR_MOVIMENTO_COLABORADOR_CC = "salvarMovimentoColaboradorCC";
    public static final String FIND_MOVIMENTOS_COLABORADOR = "findMovimentosPorColaborador";

    public Object salvarMovimentoColaboradorCC(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        MovimentoColaboradorCentroCusto vo = (MovimentoColaboradorCentroCusto)request.getAttribute("vo");
        Integer existenciaMovSuperior = new UtilMovimentoColaboradorCentroCusto().verificarMovimentoDataMaior(vo);
        if (existenciaMovSuperior.equals(1)) {
            throw new ExceptionService("Existem movimentos com data Inicial superior a informada.");
        }
        MovimentoColaboradorCentroCusto movAnterior = new UtilMovimentoColaboradorCentroCusto().buscarMovAnterior(vo);
        if (movAnterior != null) {
            movAnterior.setDataFinal(DateUtil.nextDays(vo.getDataInicio(), -1));
            vo.setMovimentoAnterior(movAnterior);
        }
        return CoreDAOFactory.getInstance().getDAOMovimentoColaboradorCentroCusto().saveOrUpdate(vo);
    }

    public List findMovimentosPorColaborador(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataInicio = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return new UtilMovimentoColaboradorCentroCusto().findMovimentosPorColaborador(colaborador, dataInicio, dataFinal);
    }
}

