/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.movimentocolaboradorcc;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.MovimentoColaboradorCentroCusto;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;

public class UtilMovimentoColaboradorCentroCusto {
    public Integer verificarMovimentoDataMaior(MovimentoColaboradorCentroCusto vo) {
        Date dataInicio = vo.getDataInicio();
        Colaborador colaborador = vo.getColaborador();
        String hql = " select count(mov.identificador)  from MovimentoColaboradorCentroCusto mov  where  mov.dataInicio >= :dataInicio  and  mov.colaborador = :colaborador ";
        Long retValor = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", dataInicio).setEntity("colaborador", (Object)colaborador).uniqueResult();
        if (retValor != null && retValor > 0L) {
            return 1;
        }
        return 0;
    }

    public MovimentoColaboradorCentroCusto buscarMovAnterior(MovimentoColaboradorCentroCusto mov) throws ExceptionService {
        String hql = " select max(mov.identificador)   from MovimentoColaboradorCentroCusto mov  where  mov.colaborador = :colaborador   and  mov.dataInicio < :dataInicio  and  mov.dataFinal is null ";
        Long idMovAnterior = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", mov.getDataInicio()).setEntity("colaborador", (Object)mov.getColaborador()).uniqueResult();
        if (idMovAnterior != null) {
            return (MovimentoColaboradorCentroCusto)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOMovimentoColaboradorCentroCusto(), "identificador", idMovAnterior, 0);
        }
        return null;
    }

    public List findMovimentosPorColaborador(Colaborador colaborador, Date dataInicio, Date dataFinal) {
        String hql = " select distinct mov  from MovimentoColaboradorCentroCusto mov  where  mov.dataInicio between :dataInicio and :dataFinal  and  mov.colaborador = :colaborador ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).list();
    }
}

