/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.movimentopneu;

import com.touchcomp.basementor.model.vo.MovimentoPneu;
import com.touchcomp.basementor.model.vo.Pneu;
import com.touchcomp.basementor.model.vo.PosicaoTipoVeiculo;
import com.touchcomp.basementor.model.vo.Veiculo;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceMovimentoPneu
extends CoreService {
    public static final String GET_ULTIMO_MOVIMENTO = "getUltimoMovimento";
    public static final String IS_VALID_COLOCACAO_VEICULO_POSICAO = "isValidColocacaoVeiculoPosicao";
    public static final String GET_MOVIMENTO_ANTERIOR = "getMovimentoAnterior";
    public static final String GET_MOVIMENTOS_POR_PNEU = "getMovimentosPorPneu";
    public static final String GET_MOVIMENTOS_PNEU_POR_VEICULO = "getMovimentosPneuPorVeiculo";
    public static final String GET_TOTAL_ODOMETRO_RODADO_POR_PNEU = "getTotalOdometroRodadoPorPneu";

    public MovimentoPneu getUltimoMovimento(CoreRequestContext request) {
        Pneu pneu = (Pneu)request.getAttribute("pneu");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getUltimoMovimento(pneu);
    }

    public MovimentoPneu isValidColocacaoVeiculoPosicao(CoreRequestContext request) {
        Veiculo veiculo = (Veiculo)request.getAttribute("veiculo");
        PosicaoTipoVeiculo posicaoTipoVeiculo = (PosicaoTipoVeiculo)request.getAttribute("posicaoTipoVeiculo");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getUltimoMovimentoPorVeiculo(veiculo, posicaoTipoVeiculo);
    }

    public MovimentoPneu getMovimentoAnterior(CoreRequestContext request) {
        Long idMovimento = (Long)request.getAttribute("idMovimento");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getMovimentoAterior(idMovimento);
    }

    public Object getMovimentosPorPneu(CoreRequestContext request) {
        Pneu vo = (Pneu)request.getAttribute("pneu");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getMovimentosPorPneu(vo);
    }

    public List getMovimentosPneuPorVeiculo(CoreRequestContext request) {
        Veiculo veiculo = (Veiculo)request.getAttribute("veiculo");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getUltimoMovimentoPneuVeiculo(veiculo);
    }

    public Double getTotalOdometroRodadoPorPneu(CoreRequestContext request) {
        Pneu pneu = (Pneu)request.getAttribute("pneu");
        return CoreDAOFactory.getInstance().getDAOMovimentoPneu().getTotalOdometroRodadoPorPneu(pneu);
    }
}

