/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.necessidadecompra;

import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.ItemPlanejProdSobEncPrevConsProd;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.PlanejProdSobEncPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoProdSobEnc;
import java.util.Date;
import java.util.List;

class AuxGerarNecCompraPlanejamentoProdSobEnc {
    void gerarNecessidades(List<PlanejamentoProdSobEnc> planej, OpcoesCompraSuprimentos op) {
        for (PlanejamentoProdSobEnc planejamentoProdSobEnc : planej) {
            this.gerarNecessidade(planejamentoProdSobEnc, op);
        }
    }

    private void gerarNecessidade(PlanejamentoProdSobEnc planejamentoProdSobEnc, OpcoesCompraSuprimentos op) {
        GrupoNecCompra gr = planejamentoProdSobEnc.getGrupoNecCompra();
        if (gr == null) {
            gr = new GrupoNecCompra();
            gr.setDataCadastro(new Date());
            gr.setEmpresa(planejamentoProdSobEnc.getEmpresa());
            gr.setObservacao(planejamentoProdSobEnc.getObservacao());
            gr.setUsuarioSolicitante(planejamentoProdSobEnc.getUsuarioLibCompras());
            gr.setCentroCusto(planejamentoProdSobEnc.getCentroCustoCompras());
            gr.setTipoNecessidade(Short.valueOf((short)0));
            planejamentoProdSobEnc.setGrupoNecCompra(gr);
        } else {
            gr.getNecessidadesCompra().clear();
        }
        for (PlanejProdSobEncPrevConsProd pp : planejamentoProdSobEnc.getPrevisaoConsProdutos()) {
            if (!(pp.getQtdCompra() > 0.0) || pp.getEnviarParaCompras() != 1) continue;
            NecessidadeCompra n = new NecessidadeCompra();
            if (op != null) {
                n.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if (pp.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped() != null) {
                n.setNaturezaOperacao(pp.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
            }
            n.setCentroCusto(gr.getCentroCusto());
            n.setDataCadastro(gr.getDataCadastro());
            n.setDataNecessidade(planejamentoProdSobEnc.getDataLiberacaoCompras());
            n.setDesativarNecessidade(Short.valueOf((short)0));
            n.setEmpresa(gr.getEmpresa());
            n.setEstoque(pp.getQtdeSaldo());
            n.setEstoqueMaximo(pp.getQtdeMax());
            n.setEstoqueMinimo(pp.getQtdeMin());
            n.setEstoqueRessuprimento(pp.getQtdeRessuprimento());
            n.setGradeCor(pp.getGradeCor());
            n.setGrupoNecCompra(gr);
            n.setObservacao(planejamentoProdSobEnc.getObservacao());
            n.setQuantidadeAdicional(Double.valueOf(0.0));
            n.setQuantidadeComprada(Double.valueOf(0.0));
            n.setQuantidadeNecessidade(pp.getQtdCompra());
            n.setQuantidadeNecessidadeGerada(pp.getQtdCompra());
            n.setTipoGeracao(Short.valueOf((short)1));
            n.setTipoNecessidade(gr.getTipoNecessidade());
            n.setUsuarioSolicitante(gr.getUsuarioSolicitante());
            this.criarItemNecessidadeCompraPlanej(n, pp);
            gr.getNecessidadesCompra().add(n);
        }
    }

    private void criarItemNecessidadeCompraPlanej(NecessidadeCompra n, PlanejProdSobEncPrevConsProd pp) {
        for (ItemPlanejProdSobEncPrevConsProd i : pp.getItemPlanejProdSobEncPrevConsProd()) {
            ItemNecCompraDetalhes item = new ItemNecCompraDetalhes();
            item.setQuantidade(i.getQuantidade());
            item.setQtdReferencia(i.getQtdReferencia());
            item.setComprimento(i.getComprimento());
            item.setAltura(i.getAltura());
            item.setLargura(i.getLargura());
            item.setVolume(i.getVolume());
            item.setNecessidadeCompra(n);
            n.getItemNecCompraDetalhes().add(item);
        }
    }
}

