/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.necessidadecompra;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.necessidadecompra.AuxGerarNecCompraPlanejamentoProdLinProd;
import mentorcore.service.impl.necessidadecompra.AuxGerarNecCompraPlanejamentoProdSobEnc;
import mentorcore.service.impl.necessidadecompra.UtilNecessidadeCompraGrAnalEstoque;
import mentorcore.service.impl.necessidadecompra.UtilNecessidadeCompraPedAlmox;
import mentorcore.service.impl.necessidadecompra.UtilNecessidadeCompraProduto;

public class ServiceNecessidadeCompra
extends CoreService {
    public static final String FIND_NECESSIDADES_COMPRA_ABERTAS = "findNecessidadesCompraAbertas";
    public static final String FIND_NECESSIDADES_COMPRA_ABERTAS_LIBERADAS = "findNecessidadesCompraAbertasLiberadas";
    public static final String FIND_NECESSIDADES_COMPRA_ATEND_PED_ALMOX_ABERTAS = "findNecessidadesCompraAtendPedAlmoxAbertas";
    public static final String GENERATE_NECESSIDADES_RESSUPRIMENTO = "generateNecessidadeRessuprimento";
    public static final String GENERATE_NECESSIDADES_RESSUPRIMENTO_PRODUTO = "generateNecessidadeRessuprimentoProduto";
    public static final String FIND_SALDO_COMPRA_ABERTO_GRADE_COR = "findSaldoCompraAbertoGradeCor";
    public static final String PESQUISAR_NECESSIDADES_COMPRA_NAO_LIBERADAS = "pesquisarNecCompraNaoLiberadas";
    public static final String PESQUISA_PLANEJAMENTOS_PROD_LIN_PROD_PARA_GERAR_NEC_COMPRA = "pesqPlanejProdLinProdParaGerarNecCompra";
    public static final String PESQUISA_PLANEJAMENTOS_PROD_SOB_ENC_PARA_GERAR_NEC_COMPRA = "pesqPlanejProdSobEncParaGerarNecCompra";
    public static final String GERA_NEC_COMPRA_PLANEJAMENTO_PROD_LIN_PROD = "geraNecCompraPlanejamentoProdLinProd";
    public static final String GERA_NEC_COMPRA_PLANEJAMENTO_PROD_SOB_ENC = "geraNecCompraPlanejamentoProdSobEnc";
    public static final String PESQUISAR_ULTIMOS_EMAIL_SOLICITANTE_GRUPO = "pesquisarUltimosEmailSolicitanteGrupo";
    public static final String PESQUISAR_ULTIMOS_EMAIL_SOLICITANTE_NECESSIDADE = "pesquisarUltimosEmailSolicitanteNecessidade";

    public List findNecessidadesCompraAbertas(CoreRequestContext request) throws ExceptionService {
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = (OpcoesCompraSuprimentos)request.getAttribute("opcoesComprasSup");
        Short filtrarNaturezaOperacao = (Short)request.getAttribute("filtrarNaturezaOperacao");
        NaturezaOperacao naturezaOperacao = (NaturezaOperacao)request.getAttribute("naturezaOperacao");
        Short filtrarCentroCusto = (Short)request.getAttribute("filtrarCentroCusto");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCusto");
        Short filtrarUsuarioSolicitante = (Short)request.getAttribute("filtrarUsuarioSolicitante");
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        Short filtrarProduto = (Short)request.getAttribute("filtrarProduto");
        Produto produto = (Produto)request.getAttribute("produto");
        List<HashMap> necessidades = CoreDAOFactory.getInstance().getDAONecessidadeCompra().findNecessidadesCompraAbertas(usuario, empresa, opcoesCompraSuprimentos, filtrarNaturezaOperacao, naturezaOperacao, filtrarCentroCusto, centroCusto, filtrarUsuarioSolicitante, usuarioSolicitante, filtrarProduto, produto);
        return necessidades;
    }

    public List findNecessidadesCompraAbertasLiberadas(CoreRequestContext request) throws ExceptionService {
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = (OpcoesCompraSuprimentos)request.getAttribute("opcoesComprasSup");
        Short filtrarNaturezaOperacao = (Short)request.getAttribute("filtrarNaturezaOperacao");
        NaturezaOperacao naturezaOperacao = (NaturezaOperacao)request.getAttribute("naturezaOperacao");
        Short filtrarCentroCusto = (Short)request.getAttribute("filtrarCentroCusto");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCusto");
        Short filtrarUsuarioSolicitante = (Short)request.getAttribute("filtrarUsuarioSolicitante");
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        Short filtrarProduto = (Short)request.getAttribute("filtrarProduto");
        Produto produto = (Produto)request.getAttribute("produto");
        List<HashMap> necessidades = CoreDAOFactory.getInstance().getDAONecessidadeCompra().findNecessidadesCompraAbertasLiberadas(usuario, empresa, opcoesCompraSuprimentos, filtrarNaturezaOperacao, naturezaOperacao, filtrarCentroCusto, centroCusto, filtrarUsuarioSolicitante, usuarioSolicitante, filtrarProduto, produto);
        return necessidades;
    }

    public List<NecessidadeCompra> findNecessidadesCompraAtendPedAlmoxAbertas(CoreRequestContext request) throws ExceptionService {
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCustoCompra");
        Date dataIn = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Short gerarNecCompraSepPedAlmox = (Short)request.getAttribute("gerarNecCompraSepPedAlmox");
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        return new UtilNecessidadeCompraPedAlmox().generateNecessidadeRessuprimento(dataIn, dataFinal, usuario, centroCusto, empresa, gerarNecCompraSepPedAlmox, op);
    }

    public List<NecessidadeCompra> generateNecessidadeRessuprimento(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Date dataRessuprimento = (Date)request.getAttribute("dataRessuprimento");
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        CentroCusto centroCustoCompra = (CentroCusto)request.getAttribute("centroCustoCompra");
        Fabricante fabricante = (Fabricante)request.getAttribute("fabricante");
        Especie especie = (Especie)request.getAttribute("especie");
        SubEspecie subEspecie = (SubEspecie)request.getAttribute("subEspecie");
        GrupoProdutos grupoProdutos = (GrupoProdutos)request.getAttribute("grupoProdutos");
        ClassificacaoAnaliseEstoque classificacao = (ClassificacaoAnaliseEstoque)request.getAttribute("classificacao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Integer tipoProduto = (Integer)request.getAttribute("tipoProduto");
        OpcoesCompraSuprimentos opcoesCompra = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        return UtilNecessidadeCompraGrAnalEstoque.generateNecessidadeRessuprimento(dataRessuprimento, usuarioSolicitante, centroCustoCompra, fabricante, especie, subEspecie, grupoProdutos, classificacao, empresa, tipoProduto, opcoesCompra);
    }

    public List<NecessidadeCompra> generateNecessidadeRessuprimentoProduto(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Date dataRessuprimento = (Date)request.getAttribute("dataRessuprimento");
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        CentroCusto centroCustoCompra = (CentroCusto)request.getAttribute("centroCustoCompra");
        Fabricante fabricante = (Fabricante)request.getAttribute("fabricante");
        Especie especie = (Especie)request.getAttribute("especie");
        GrupoProdutos grupoProdutos = (GrupoProdutos)request.getAttribute("grupoProdutos");
        SubEspecie subEspecie = (SubEspecie)request.getAttribute("subEspecie");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Integer tipoProduto = (Integer)request.getAttribute("tipoProduto");
        Short produtosSemMovimentacao = (Short)request.getAttribute("produtosSemMovimentacao");
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        return UtilNecessidadeCompraProduto.generateNecessidadeRessuprimento(dataRessuprimento, usuarioSolicitante, centroCustoCompra, fabricante, especie, subEspecie, grupoProdutos, empresa, tipoProduto, produtosSemMovimentacao, op);
    }

    public Double findSaldoCompraAbertoGradeCor(CoreRequestContext request) throws ExceptionService {
        GradeCor gradeCor = (GradeCor)request.getAttribute("gradeCor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().findSaldoCompraAbertoGradeCor(gradeCor, empresa);
    }

    public List<NecessidadeCompra> pesquisarNecCompraNaoLiberadas(CoreRequestContext request) throws ExceptionService {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short filtrarGrupoNecessidadeCompra = (Short)request.getAttribute("filtrarGrupoNecessidadeCompra");
        GrupoNecCompra grupoNecessidadeCompra = (GrupoNecCompra)request.getAttribute("grupoNecessidadeCompra");
        Short filtrarUsuarioSolicitante = (Short)request.getAttribute("filtrarUsuarioSolicitante");
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        Short filtrarCentroCusto = (Short)request.getAttribute("filtrarCentroCusto");
        CentroCusto centroCusto = (CentroCusto)request.getAttribute("centroCusto");
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().pesquisarNecCompraNaoLiberadas(dataInicial, dataFinal, empresa, filtrarGrupoNecessidadeCompra, grupoNecessidadeCompra, filtrarUsuarioSolicitante, usuarioSolicitante, filtrarCentroCusto, centroCusto);
    }

    public List<PlanejamentoProdLinhaProd> pesqPlanejProdLinProdParaGerarNecCompra(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().pesqPlanejProdLinProdParaGerarNecCompra();
    }

    public List<PlanejamentoProdLinhaProd> pesqPlanejProdSobEncParaGerarNecCompra(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().pesqPlanejProdLinProdParaGerarNecCompraSobEnc();
    }

    public void geraNecCompraPlanejamentoProdLinProd(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        List planej = (List)request.getAttribute("planejamentos");
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        new AuxGerarNecCompraPlanejamentoProdLinProd().gerarNecessidades(planej, op);
    }

    public void geraNecCompraPlanejamentoProdSobEnc(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        List planej = (List)request.getAttribute("planejamentos");
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)request.getAttribute("opcoesCompraSuprimentos");
        new AuxGerarNecCompraPlanejamentoProdSobEnc().gerarNecessidades(planej, op);
    }

    public List<HashMap> pesquisarUltimosEmailSolicitanteGrupo(CoreRequestContext request) throws ExceptionService {
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().pesquisarUltimosEmailSolicitanteGrupo(usuarioSolicitante);
    }

    public List<HashMap> pesquisarUltimosEmailSolicitanteNecessidade(CoreRequestContext request) throws ExceptionService {
        Usuario usuarioSolicitante = (Usuario)request.getAttribute("usuarioSolicitante");
        return CoreDAOFactory.getInstance().getDAONecessidadeCompra().pesquisarUltimosEmailSolicitanteNecessidade(usuarioSolicitante);
    }
}

