/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.necessidadecompra;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.impl.tipoitemsped.ServiceTipoItemSpedImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ContatoFormatUtil;

class UtilNecessidadeCompraGrAnalEstoque {
    UtilNecessidadeCompraGrAnalEstoque() {
    }

    static List<NecessidadeCompra> generateNecessidadeRessuprimento(Date dataRessuprimento, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, ClassificacaoAnaliseEstoque classificacao, Empresa empresa, Integer tipoProduto, OpcoesCompraSuprimentos op) throws ExceptionService, ExceptionDatabase {
        ArrayList<HashMap> produtosNecessidades = new ArrayList<HashMap>();
        produtosNecessidades.addAll(CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findProdutosRessuprimentoEstoque(dataRessuprimento, fabricante, especie, subEspecie, grupoProdutos, classificacao, empresa, tipoProduto, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue()));
        return UtilNecessidadeCompraGrAnalEstoque.buildNecessidadesCompra(produtosNecessidades, usuarioSolicitante, centroCustoCompra, empresa, op);
    }

    private static Double findSaldoCompraAbertoGradeCor(GradeCor gc, Empresa empresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("gradeCor", gc);
        request.setAttribute("empresa", empresa);
        return (Double)CoreServiceFactory.getServiceNecessidadeCompra().execute(request, "findSaldoCompraAbertoGradeCor");
    }

    private static List<NecessidadeCompra> buildNecessidadesCompra(List<HashMap> produtosNecessidades, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Empresa emp, OpcoesCompraSuprimentos op) throws ExceptionService, ExceptionDatabase {
        ServiceTipoItemSpedImpl serviceTipoItemSped = (ServiceTipoItemSpedImpl)ConfApplicationContext.getBean(ServiceTipoItemSpedImpl.class);
        HashMap<Long, TipoItemSped> map = new HashMap<Long, TipoItemSped>();
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (HashMap saldoEstProprio : produtosNecessidades) {
            TipoItemSped tipoItemSped;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            Integer idGradeCor = (Integer)saldoEstProprio.get("ID_GRADE_COR");
            Number qtd = (Number)saldoEstProprio.get("SALDO_QTD");
            Number qtdMax = (Number)saldoEstProprio.get("ESTOQUE_MAXIMO");
            Number qtdRes = (Number)saldoEstProprio.get("ESTOQUE_RESSUPRIMENTO");
            Number qtdMin = (Number)saldoEstProprio.get("ESTOQUE_MINIMO");
            Number idItemSped = (Number)saldoEstProprio.get("ID_ITEM_SPED");
            Integer lead = (Integer)saldoEstProprio.get("LEAD_TIME");
            GradeCor gradeCor = (GradeCor)CoreDAOFactory.getInstance().getDAOGradeCor().findByPrimaryKey(idGradeCor.longValue());
            if (op != null) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if ((tipoItemSped = (TipoItemSped)map.get(idItemSped)) == null && idItemSped != null) {
                map.put(idItemSped.longValue(), (TipoItemSped)serviceTipoItemSped.get((Serializable)Long.valueOf(idItemSped.longValue())));
            }
            if (idItemSped != null && map.get(idItemSped.longValue()) != null) {
                necessidadeCompra.setNaturezaOperacao(((TipoItemSped)map.get(idItemSped.longValue())).getNaturezaOperacaoNecCompra());
            }
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setQuantidadeComprada(UtilNecessidadeCompraGrAnalEstoque.findSaldoCompraAbertoGradeCor(gradeCor, emp));
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setDataNecessidade(UtilNecessidadeCompraGrAnalEstoque.calculateDataNecessidade(necessidadeCompra.getDataCadastro(), lead));
            necessidadeCompra.setEmpresa(emp);
            necessidadeCompra.setGradeCor(gradeCor);
            necessidadeCompra.setQuantidadeNecessidadeGerada(ContatoFormatUtil.arrredondarNumero(qtdMax.doubleValue() - (qtd == null ? 0.0 : qtd.doubleValue()) - necessidadeCompra.getQuantidadeComprada(), 4));
            necessidadeCompra.setTipoGeracao(Short.valueOf((short)1));
            necessidadeCompra.setTipoNecessidade(Short.valueOf((short)0));
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setEstoqueMaximo(Double.valueOf(qtdMax.doubleValue()));
            necessidadeCompra.setQuantidadeComprada(necessidadeCompra.getQuantidadeComprada());
            necessidadeCompra.setEstoqueMinimo(Double.valueOf(qtdMin.doubleValue()));
            necessidadeCompra.setEstoqueRessuprimento(Double.valueOf(qtdRes.doubleValue()));
            necessidadeCompra.setEstoque(Double.valueOf(qtd.doubleValue()));
            necessidadeCompra.setQuantidadeNecessidade(necessidadeCompra.getQuantidadeNecessidadeGerada());
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }

    private static Date calculateDataNecessidade(Date dataBase, Integer dias) throws ExceptionService {
        return dataBase;
    }
}

