/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.necessidadecompra;

import com.touchcomp.basementor.model.vo.AtendPedAlmoxItemGradeNecComp;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmoxItemGrade;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;

class UtilNecessidadeCompraPedAlmox {
    UtilNecessidadeCompraPedAlmox() {
    }

    public List<NecessidadeCompra> generateNecessidadeRessuprimento(Date dataInicial, Date dataFinal, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Empresa empresa, Short gerarNecCompraSepPedAlmox, OpcoesCompraSuprimentos op) throws ExceptionService {
        List produtosNecessidades = CoreDAOFactory.getInstance().getDAOPedidoAlmoxarifado().findAtendimentosCompra(dataInicial, dataFinal, empresa);
        List hashGradesProdutos = this.calcularHash(produtosNecessidades, gerarNecCompraSepPedAlmox);
        return this.buildNecessidadesCompra(hashGradesProdutos, usuarioSolicitante, centroCustoCompra, empresa, op);
    }

    private List<NecessidadeCompra> buildNecessidadesCompra(List produtosNecessidades, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Empresa emp, OpcoesCompraSuprimentos op) throws ExceptionService {
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (Object ob : produtosNecessidades) {
            HashMap h = (HashMap)ob;
            GradeCor gc = (GradeCor)h.get("gradeCor");
            NaturezaOperacao naturezaOperacao = (NaturezaOperacao)h.get("naturezaOperacao");
            String observacao = (String)h.get("OBSERVACAO");
            String observacaoNecessidadeCompra = (String)h.get("OBSERVACAO_NECESSIDADE_COMPRA");
            Short tipoNecessidade = (Short)h.get("TIPO_NECESSIDADE");
            List grades = (List)h.get("lista");
            Double qtdTotal = 0.0;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            ArrayList<AtendPedAlmoxItemGradeNecComp> gr = new ArrayList<AtendPedAlmoxItemGradeNecComp>();
            Date dataMin = null;
            for (AtendPedidoAlmoxItemGrade g : grades) {
                qtdTotal = qtdTotal + g.getQuantidadeCotar();
                AtendPedAlmoxItemGradeNecComp aux = new AtendPedAlmoxItemGradeNecComp();
                aux.setNecessidadeCompra(necessidadeCompra);
                aux.setAtendPedidoAlmoxItemGrade(g);
                gr.add(aux);
                if (dataMin == null || g.getDataNecessidade() != null && dataMin != null && dataMin.after(g.getDataNecessidade())) {
                    dataMin = g.getDataNecessidade();
                }
                if (g.getCentroCusto() == null) continue;
                centroCustoCompra = g.getCentroCusto();
            }
            if (op != null) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            necessidadeCompra.setNaturezaOperacao(naturezaOperacao);
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setEmpresa(emp);
            necessidadeCompra.setGradeCor(gc);
            necessidadeCompra.setDataNecessidade(dataMin);
            necessidadeCompra.setQuantidadeNecessidadeGerada(qtdTotal);
            necessidadeCompra.setQuantidadeNecessidade(qtdTotal);
            necessidadeCompra.setObservacao(observacao);
            if (observacaoNecessidadeCompra != null && observacaoNecessidadeCompra.length() > 0) {
                necessidadeCompra.setObservacao(necessidadeCompra.getObservacao() + " " + observacaoNecessidadeCompra);
            }
            necessidadeCompra.setTipoGeracao(Short.valueOf((short)1));
            necessidadeCompra.setTipoNecessidade(Short.valueOf((short)0));
            if (tipoNecessidade != null) {
                necessidadeCompra.setTipoNecessidade(tipoNecessidade);
            }
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setAtendPedAlmoxNecCompra(gr);
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }

    private List calcularHash(List produtosNecessidades, Short gerarNecCompraSepPedAlmox) {
        ArrayList<HashMap> hash = new ArrayList<HashMap>();
        for (Object o : produtosNecessidades) {
            ArrayList<AtendPedidoAlmoxItemGrade> aux;
            AtendPedidoAlmoxItemGrade a = (AtendPedidoAlmoxItemGrade)o;
            HashMap h = null;
            if (gerarNecCompraSepPedAlmox.equals((short)0)) {
                for (HashMap m : hash) {
                    GradeCor gr = (GradeCor)m.get("gradeCor");
                    NaturezaOperacao naturezaOperacao = (NaturezaOperacao)m.get("naturezaOperacao");
                    if (!gr.equals((Object)a.getGradeItemPedAlmox().getGradeCor()) || !Objects.equals(naturezaOperacao, a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao())) continue;
                    String observacao = String.valueOf(m.get("OBSERVACAO")) + " - " + a.getGradeItemPedAlmox().getItemPedidoAlmoxarifado().getObservacao();
                    m.put("OBSERVACAO", observacao.trim());
                    h = m;
                    break;
                }
            }
            if (h == null) {
                h = new HashMap();
                aux = new ArrayList<AtendPedidoAlmoxItemGrade>();
                h.put("gradeCor", a.getGradeItemPedAlmox().getGradeCor());
                if (a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao() != null) {
                    h.put("naturezaOperacao", a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao());
                } else {
                    h.put("naturezaOperacao", a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
                }
                h.put("lista", aux);
                h.put("OBSERVACAO", a.getGradeItemPedAlmox().getItemPedidoAlmoxarifado().getObservacao());
                h.put("OBSERVACAO_NECESSIDADE_COMPRA", a.getObservacao());
                h.put("TIPO_NECESSIDADE", a.getTipoNecessidade());
                hash.add(h);
            }
            aux = (ArrayList<AtendPedidoAlmoxItemGrade>)h.get("lista");
            aux.add(a);
        }
        return hash;
    }
}

