/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.necessidadecompra;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.impl.tipoitemsped.ServiceTipoItemSpedImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ContatoFormatUtil;

class UtilNecessidadeCompraProduto {
    UtilNecessidadeCompraProduto() {
    }

    static List<NecessidadeCompra> generateNecessidadeRessuprimento(Date dataRessuprimento, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, Empresa empresa, Integer tipoProduto, Short produtosSemMovimentacao, OpcoesCompraSuprimentos op) throws ExceptionService, ExceptionDatabase {
        ArrayList<HashMap> produtosNecessidades = new ArrayList<HashMap>();
        produtosNecessidades.addAll(CoreDAOFactory.getInstance().getDAOSaldoEstProprio().getSaldoProdutoNecessidadeCompraProduto(dataRessuprimento, null, null, especie != null ? especie.getIdentificador() : null, especie != null ? especie.getIdentificador() : null, subEspecie != null ? subEspecie.getIdentificador() : null, subEspecie != null ? subEspecie.getIdentificador() : null, null, null, fabricante != null ? fabricante.getIdentificador() : null, fabricante != null ? fabricante.getIdentificador() : null, 0L, 999999999L, grupoProdutos != null ? grupoProdutos.getIdentificador() : null, tipoProduto, tipoProduto, (short)3, empresa.getIdentificador(), produtosSemMovimentacao, 2, 1, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue()));
        return UtilNecessidadeCompraProduto.buildNecessidadesCompra(produtosNecessidades, usuarioSolicitante, centroCustoCompra, empresa, op);
    }

    private static Double findSaldoCompraAbertoGradeCor(GradeCor gc, Empresa empresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("gradeCor", gc);
        request.setAttribute("empresa", empresa);
        return (Double)CoreServiceFactory.getServiceNecessidadeCompra().execute(request, "findSaldoCompraAbertoGradeCor");
    }

    private static List<NecessidadeCompra> buildNecessidadesCompra(List<HashMap> produtosNecessidades, Usuario usuarioSolicitante, CentroCusto centroCustoCompra, Empresa emp, OpcoesCompraSuprimentos op) throws ExceptionService, ExceptionDatabase {
        ServiceTipoItemSpedImpl serviceTipoItemSped = (ServiceTipoItemSpedImpl)ConfApplicationContext.getBean(ServiceTipoItemSpedImpl.class);
        HashMap<Long, TipoItemSped> map = new HashMap<Long, TipoItemSped>();
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (HashMap saldoEstProprio : produtosNecessidades) {
            TipoItemSped tipoItemSped;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            Integer idGradeCor = (Integer)saldoEstProprio.get("ID_GRADE_COR");
            Number qtd = (Number)saldoEstProprio.get("SALDO_QTD");
            Number qtdMax = (Number)saldoEstProprio.get("QTD_MAX");
            Number qtdRes = (Number)saldoEstProprio.get("PONTO_RESSUPRIMENTO");
            Number idItemSped = (Number)saldoEstProprio.get("ID_ITEM_SPED");
            Number qtdMin = (Number)saldoEstProprio.get("QTD_MIN");
            GradeCor gradeCor = (GradeCor)CoreDAOFactory.getInstance().getDAOGradeCor().findByPrimaryKey(idGradeCor.longValue());
            if (op != null) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if ((tipoItemSped = (TipoItemSped)map.get(idItemSped)) == null && idItemSped != null) {
                map.put(idItemSped.longValue(), (TipoItemSped)serviceTipoItemSped.get((Serializable)Long.valueOf(idItemSped.longValue())));
            }
            if (idItemSped != null && map.get(idItemSped.longValue()) != null) {
                necessidadeCompra.setNaturezaOperacao(((TipoItemSped)map.get(idItemSped.longValue())).getNaturezaOperacaoNecCompra());
            }
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setQuantidadeComprada(UtilNecessidadeCompraProduto.findSaldoCompraAbertoGradeCor(gradeCor, emp));
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setDataNecessidade(UtilNecessidadeCompraProduto.calculateDataNecessidade(necessidadeCompra.getDataCadastro(), 0));
            necessidadeCompra.setEmpresa(emp);
            necessidadeCompra.setGradeCor(gradeCor);
            necessidadeCompra.setQuantidadeNecessidadeGerada(ContatoFormatUtil.arrredondarNumero(qtdRes.doubleValue() - qtd.doubleValue() - necessidadeCompra.getQuantidadeComprada(), 4));
            necessidadeCompra.setTipoGeracao(Short.valueOf((short)1));
            necessidadeCompra.setTipoNecessidade(Short.valueOf((short)0));
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setEstoqueMaximo(Double.valueOf(qtdMax.doubleValue()));
            necessidadeCompra.setEstoqueMinimo(Double.valueOf(qtdMin.doubleValue()));
            necessidadeCompra.setEstoqueRessuprimento(Double.valueOf(qtdRes.doubleValue()));
            necessidadeCompra.setEstoque(Double.valueOf(qtd.doubleValue()));
            necessidadeCompra.setQuantidadeNecessidade(necessidadeCompra.getQuantidadeNecessidadeGerada());
            if (!(necessidadeCompra.getQuantidadeNecessidadeGerada() > 0.0)) continue;
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }

    private static Date calculateDataNecessidade(Date dataBase, Integer dias) throws ExceptionService {
        return dataBase;
    }
}

