/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfce;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.model.vo.BandeiraTEF;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.TipoBandeiraTEF;
import com.touchcomp.basementor.model.vo.TipoBandeiraTEFEmpresa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilApuracaoTitulosCartaoDebCred {
    TLogger logger = TLogger.get(this.getClass());

    UtilApuracaoTitulosCartaoDebCred() {
    }

    public List<Titulo> gerarTitulosCartaoDebitoCredito(NFCeOpcoes opcoesNFCe, Date dataApuracao, Empresa empresa, OpcoesContabeis opcoesContabeis, OpcoesGerenciais opcoesGerenciais, EmpresaContabilidade empresaContabilidade, OpcoesFinanceiras opcoesFinanceiras, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionService, ExceptionDatabase {
        List pagamentos = this.getPagamentosCartao(dataApuracao, empresa, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        for (Object o : pagamentos) {
            TipoBandeiraTEF tipoBandeira;
            HashMap h = (HashMap)o;
            CondicoesPagamento condicoesPagamento = (CondicoesPagamento)h.get("CONDICOES_PAGAMENTO");
            Short numeroParcelas = (Short)h.get("NUMERO_PARCELAS");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Double valor = (Double)h.get("VALOR");
            String tipo = (String)h.get("TIPO");
            Short permitirTEF = (Short)h.get("PERMITIR_TEF");
            MeioPagamento meioPagamento = (MeioPagamento)h.get("MEIO_PAGAMENTO");
            BandeiraTEF bandeiraTEF = (BandeiraTEF)h.get("BANDEIRA_TEF");
            if (opcoesNFCe.getGerarTitulosDebitoCredito() == null || opcoesNFCe.getGerarTitulosDebitoCredito() != 1) continue;
            if (this.getPagamentoDebitoAlimentacaoRefeicaoCombustivel(meioPagamento) && permitirTEF.equals((short)0)) {
                if (ToolMethods.isEquals((Object)condicoesPagamento.getExibirBandeiraCartao(), (Object)1)) {
                    tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, empresa);
                    this.gerarTitulosCartaoDebitoTEF(condicoesPagamento, dataEmissao, empresa, valor, titulos, tipoBandeira, meioPagamento, opcoesFinanceiras);
                    continue;
                }
                this.gerarTitulosCartaoDebito(condicoesPagamento, dataEmissao, empresa, valor, titulos, meioPagamento, opcoesFinanceiras);
                continue;
            }
            if (this.getPagamentoDebitoAlimentacaoRefeicaoCombustivel(meioPagamento) && permitirTEF.equals((short)1)) {
                tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, empresa);
                this.gerarTitulosCartaoDebitoTEF(condicoesPagamento, dataEmissao, empresa, valor, titulos, tipoBandeira, meioPagamento, opcoesFinanceiras);
                continue;
            }
            if (this.getPagamentoCredito(meioPagamento) && permitirTEF.equals((short)0)) {
                if (ToolMethods.isEquals((Object)condicoesPagamento.getExibirBandeiraCartao(), (Object)1)) {
                    tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, empresa);
                    this.gerarTitulosCartaoCreditoTEF(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, titulos, tipoBandeira, meioPagamento, opcoesFinanceiras);
                    continue;
                }
                this.gerarTitulosCartaoCredito(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, titulos, meioPagamento, opcoesFinanceiras);
                continue;
            }
            if (!this.getPagamentoCredito(meioPagamento) || !permitirTEF.equals((short)1)) continue;
            tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, empresa);
            this.gerarTitulosCartaoCreditoTEF(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, titulos, tipoBandeira, meioPagamento, opcoesFinanceiras);
        }
        return titulos;
    }

    private List getPagamentosCartao(Date dataApuracao, Empresa empresa, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        List pagamentos = this.getPagamentosNFCeCartao(dataApuracao, empresa, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        pagamentos = this.getPagamentosNFeCartao(dataApuracao, empresa, pagamentos, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        return pagamentos;
    }

    private List getPagamentosNFCeCartao(Date dataApuracao, Empresa empresa, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        Boolean achou = false;
        Object hql = "select sum(p.valorLiquido)        AS VALOR, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, p.numeroParcelas                    AS NUMERO_PARCELAS, nfce.dataEmissao                    AS DATA_EMISSAO, p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from NFCePagamento p  inner join p.nfce nfce  inner join nfce.nfCeControleCaixa cf left  join p.bandeiraTEF b where nfce.empresa = :empresa  and nfce.dataEmissao = :dataEmissao and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and p.status = :ativo  and cf.realizado = :sim and (";
        if (TMethods.isEquals((Object)filtrarDebito, (Object)1)) {
            hql = (String)hql + "p.tipoPagamentoNFe.codigo = :debito";
            achou = true;
        }
        if (TMethods.isEquals((Object)filtrarCredito, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :credito";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo = :credito";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarAlimentacao, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :alimentacao";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo = :alimentacao";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarRefeicao, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :refeicao";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo = :refeicao";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarCombustivel, (Object)1)) {
            hql = achou != false ? (String)hql + " or p.tipoPagamentoNFe.codigo = :combustivel" : (String)hql + " p.tipoPagamentoNFe.codigo = :combustivel";
        }
        hql = (String)hql + ")";
        hql = (String)hql + " group by  p.numeroParcelas,  p.condicoesPagamento.identificador, nfce.dataEmissao,  p.tipoPagamentoNFe.codigo,  p.meioPagamento.identificador ,  p.permitirTEF, b.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataEmissao", dataApuracao);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setShort("ativo", (short)1);
        q.setShort("sim", (short)1);
        if (TMethods.isEquals((Object)filtrarDebito, (Object)1)) {
            q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarCredito, (Object)1)) {
            q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarAlimentacao, (Object)1)) {
            q.setString("alimentacao", EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarRefeicao, (Object)1)) {
            q.setString("refeicao", EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarCombustivel, (Object)1)) {
            q.setString("combustivel", EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
        }
        return lista;
    }

    private List getPagamentosNFeCartao(Date dataApuracao, Empresa empresa, List<HashMap> pagamentos, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        Boolean achou = false;
        Object hql = "select sum(p.valor)               AS VALOR, p.numeroParcelas                    AS NUMERO_PARCELAS, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, nfce.dataEmissaoNota                AS DATA_EMISSAO, p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from InfPagamentoNfPropria p  inner join p.notaFiscalPropria nfce  inner join nfce.naturezaOperacao nat  inner join nfce.nfceControleCaixa cf left  join p.bandeiraTEF b where nfce.empresa = :empresa  and nfce.dataEmissaoNota = :dataEmissao and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (nat.contabilizarPorIntegracao is null or nat.contabilizarPorIntegracao  = :nao ) and cf.realizado = :sim and (";
        if (TMethods.isEquals((Object)filtrarDebito, (Object)1)) {
            hql = (String)hql + "p.tipoPagamentoNFe.codigo = :debito";
            achou = true;
        }
        if (TMethods.isEquals((Object)filtrarCredito, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :credito";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo <> :credito";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarAlimentacao, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :alimentacao";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo <> :alimentacao";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarRefeicao, (Object)1)) {
            if (achou.booleanValue()) {
                hql = (String)hql + " or p.tipoPagamentoNFe.codigo = :refeicao";
            } else {
                hql = (String)hql + " p.tipoPagamentoNFe.codigo <> :refeicao";
                achou = true;
            }
        }
        if (TMethods.isEquals((Object)filtrarCombustivel, (Object)1)) {
            hql = achou != false ? (String)hql + " or p.tipoPagamentoNFe.codigo = :combustivel" : (String)hql + " p.tipoPagamentoNFe.codigo <> :combustivel";
        }
        hql = (String)hql + ") group by  p.numeroParcelas, p.condicoesPagamento.identificador,  nfce.dataEmissaoNota,  p.tipoPagamentoNFe.codigo,  p.meioPagamento.identificador ,  p.permitirTEF, b.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("nao", (short)0);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataEmissao", dataApuracao);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setShort("sim", (short)1);
        if (TMethods.isEquals((Object)filtrarDebito, (Object)1)) {
            q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarCredito, (Object)1)) {
            q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarAlimentacao, (Object)1)) {
            q.setString("alimentacao", EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarRefeicao, (Object)1)) {
            q.setString("refeicao", EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo());
        }
        if (TMethods.isEquals((Object)filtrarCombustivel, (Object)1)) {
            q.setString("combustivel", EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            Short numeroParcelas = (Short)h.get("NUMERO_PARCELAS");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            String codigo = (String)h.get("TIPO");
            Long idMeioPagamento = (Long)h.get("ID_MEIO_PAGAMENTO");
            Short permitirTEF = (Short)h.get("PERMITIR_TEF");
            Double valor = (Double)h.get("VALOR");
            Long idCondicoesPagamento = (Long)h.get("ID_CONDICOES_PAGAMENTO");
            Long idBandeiraTEF = (Long)h.get("ID_BANDEIRA_TEF");
            achou = false;
            for (HashMap pag : pagamentos) {
                Short numeroParcelasPag = (Short)pag.get("NUMERO_PARCELAS");
                Date dataEmissaoPag = (Date)pag.get("DATA_EMISSAO");
                String codigoPag = (String)pag.get("TIPO");
                Long idMeioPagamentoPag = (Long)pag.get("ID_MEIO_PAGAMENTO");
                Short permitirTEFPag = (Short)pag.get("PERMITIR_TEF");
                Double valorPag = (Double)pag.get("VALOR");
                Long idCondicoesPagamentoPag = (Long)pag.get("ID_CONDICOES_PAGAMENTO");
                Long idBandeiraTEFPag = (Long)pag.get("ID_BANDEIRA_TEF");
                if (!numeroParcelas.equals(numeroParcelasPag) || !dataEmissao.equals(ToolDate.dataSemHora((Date)dataEmissaoPag)) || !codigo.equals(codigoPag) || !idMeioPagamento.equals(idMeioPagamentoPag) || !idCondicoesPagamento.equals(idCondicoesPagamentoPag) || !permitirTEF.equals(permitirTEFPag) || (idBandeiraTEF != null || idBandeiraTEFPag != null) && (idBandeiraTEF == null || idBandeiraTEFPag == null || !idBandeiraTEF.equals(idBandeiraTEFPag))) continue;
                pag.put("VALOR", valor + valorPag);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
            pagamentos.add(h);
        }
        return pagamentos;
    }

    private TipoBandeiraTEF getPessoaFromBandeiraTEF(BandeiraTEF bandeiraTEF, Short numeroParcelas, Empresa empresa) throws ExceptionService {
        String query = "from TipoBandeiraTEF t  where t.bandeiraTEF = :bandeiraTEF";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setEntity("bandeiraTEF", (Object)bandeiraTEF);
        List tipoBandeira = q.list();
        if (tipoBandeira != null && tipoBandeira.size() == 1) {
            TipoBandeiraTEF t = (TipoBandeiraTEF)tipoBandeira.get(0);
            for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                if (!emp.getEmpresa().equals((Object)empresa)) continue;
                return t;
            }
            throw new ExceptionService("Nenhuma empresa encontrada para transa\u00e7oes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
        }
        if (tipoBandeira != null && tipoBandeira.size() > 1) {
            for (TipoBandeiraTEF t : tipoBandeira) {
                Short creditoParcelado = t.getCreditoParcelado();
                if (creditoParcelado.equals((short)1) && numeroParcelas > 1) {
                    for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                        if (!emp.getEmpresa().equals((Object)empresa)) continue;
                        return t;
                    }
                    continue;
                }
                if (!creditoParcelado.equals((short)0) || numeroParcelas != 1) continue;
                for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                    if (!emp.getEmpresa().equals((Object)empresa)) continue;
                    return t;
                }
            }
            for (TipoBandeiraTEF tipoBandeiraTEF : tipoBandeira) {
                for (TipoBandeiraTEFEmpresa emp : tipoBandeiraTEF.getEmpresas()) {
                    if (!emp.getEmpresa().equals((Object)empresa)) continue;
                    return tipoBandeiraTEF;
                }
            }
            if (tipoBandeira.size() > 1) {
                throw new ExceptionService("Nenhuma empresa encontrada para transa\u00e7oes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
            }
        } else {
            throw new ExceptionService("Nenhuma pessoa encontrada para transa\u00e7oes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
        }
        throw new ExceptionService("Nenhuma pessoa encontrada para transa\u00e7oes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
    }

    private void gerarTitulosCartaoDebitoTEF(CondicoesPagamento cp, Date dataEmissao, Empresa empresa, Double valor, List<Titulo> titulos, TipoBandeiraTEF tipoBandeira, MeioPagamento meioPagamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        Titulo titulo = new Titulo();
        titulo.setEmpresa(empresa);
        titulo.setDataCadastro(new Date());
        titulo.setProvisao(Short.valueOf((short)1));
        titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
        titulo.setPagRec(Short.valueOf((short)1));
        titulo.setPessoa(tipoBandeira.getPessoa());
        titulo.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
        if (tipoBandeira.getPessoa().getPessoaDadosFinanceiros() != null) {
            titulo.setCartCobrancaDestino(tipoBandeira.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
        }
        titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec(), opcoesFinanceiras));
        titulo.setDataEmissao(dataEmissao);
        titulo.setDataCompetencia(dataEmissao);
        titulo.setDataEntradaSaida(dataEmissao);
        titulo.setPlanoConta(tipoBandeira.getPlanoConta());
        titulo.setObservacao("TEF/Cartao Debito: " + cp.getNome() + ". Pessoa: " + tipoBandeira.getPessoa().getNome() + ". Data Emiss\u00e3o: " + ToolDate.dateToStr((Date)dataEmissao));
        titulo.setValor(valor);
        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (tipoBandeira.getTaxaCartao() / 100.0)), (int)2));
        titulo.setDataVencimento(this.getDataVencimentoTituloDebitoTEF(dataEmissao, tipoBandeira.getDiasDeslocamento(), tipoBandeira.getExcluiSabado(), tipoBandeira.getExcluiDomingo(), tipoBandeira.getExcluiFeriado(), empresa));
        titulo.setDataVencimentoBase(titulo.getDataVencimento());
        titulo.setNumParcTituloEstnota(Short.valueOf((short)1));
        titulo.setNumeroParcelas(Short.valueOf((short)1));
        titulo.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
        titulo.setMeioPagamento(meioPagamento);
        this.setarPercJurosMultaDesconto(titulo, opcoesFinanceiras);
        titulos.add(titulo);
    }

    private Date getDataVencimentoTituloDebitoTEF(Date dataEmissao, Integer diasDeslocamento, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa) {
        Date data = DateUtil.nextDays(dataEmissao, diasDeslocamento);
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals((short)1) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getDataVencimentoTituloDebito(Date dataEmissao, Integer diasDeslocamento, Empresa empresa) {
        Date data = DateUtil.nextDays(dataEmissao, diasDeslocamento);
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Boolean existeFeriado(Date data, Empresa empresa) {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("periodoFinal", data);
            request.setAttribute("periodoInicial", data);
            request.setAttribute("idEmpresa", empresa.getIdentificador());
            List feriados = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
            if (feriados != null && !feriados.isEmpty()) {
                return true;
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getMessage());
        }
        return false;
    }

    private void gerarTitulosCartaoCreditoTEF(CondicoesPagamento cp, Short numeroParcelas, Date dataEmissao, Empresa empresa, Double valor, List<Titulo> titulos, TipoBandeiraTEF tipoBandeira, MeioPagamento meioPagamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        if (numeroParcelas > 0) {
            Double vlrTotalAcu = 0.0;
            Double vrDesp = 0.0;
            vrDesp = tipoBandeira.getDeducaoTaxa() == 0 ? Double.valueOf(valor * (tipoBandeira.getTaxaCartao() / 100.0)) : Double.valueOf(valor * (tipoBandeira.getTaxaCartao() / 100.0) / (double)numeroParcelas.shortValue());
            Double valorTitulo = valor / (double)numeroParcelas.shortValue();
            for (int i = 1; i <= numeroParcelas.intValue(); ++i) {
                Titulo titulo = new Titulo();
                titulo.setEmpresa(empresa);
                titulo.setDataCadastro(new Date());
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
                titulo.setPessoa(tipoBandeira.getPessoa());
                titulo.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
                if (tipoBandeira.getPessoa().getPessoaDadosFinanceiros() != null) {
                    titulo.setCartCobrancaDestino(tipoBandeira.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                titulo.setPagRec(Short.valueOf((short)1));
                titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec(), opcoesFinanceiras));
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(dataEmissao);
                titulo.setDataEntradaSaida(dataEmissao);
                titulo.setPlanoConta(tipoBandeira.getPlanoConta());
                titulo.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
                titulo.setDataVencimento(this.getDataVencimentoTituloCreditoTEF(dataEmissao, tipoBandeira.getDataFixa(), tipoBandeira.getDiaFixo(), tipoBandeira.getDiaVariavel(), tipoBandeira.getExcluiSabado(), tipoBandeira.getExcluiDomingo(), tipoBandeira.getExcluiFeriado(), empresa, i));
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                if (tipoBandeira.getDeducaoTaxa() == 0) {
                    if (i == 1) {
                        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2));
                    }
                } else {
                    titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2, (int)1));
                }
                if (i == numeroParcelas) {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor - vlrTotalAcu), (int)2, (int)5));
                } else {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2, (int)1));
                }
                vlrTotalAcu = vlrTotalAcu + titulo.getValor();
                titulo.setNumParcTituloEstnota(Short.valueOf((short)i));
                titulo.setNumeroParcelas(numeroParcelas);
                titulo.setObservacao("TEF/Cartao Credito: " + cp.getNome() + ". Parcela:" + titulo.getNumParcTituloEstnota() + "/" + numeroParcelas.toString() + ". Pessoa: " + tipoBandeira.getPessoa().getNome() + ". Data Emissao: " + ToolDate.dateToStr((Date)dataEmissao));
                this.setarPercJurosMultaDesconto(titulo, opcoesFinanceiras);
                titulo.setMeioPagamento(meioPagamento);
                titulos.add(titulo);
            }
        }
    }

    private Date getDataVencimentoTituloCredito(Date dataEmissao, Short dataFixa, Integer diaFixo, Integer diaVariavel, Short excluirDiasNaoUteis, Empresa empresa, int parcela) {
        Date data = null;
        if (dataFixa.equals((short)1)) {
            Integer diaFixoVencimento = diaFixo;
            Integer diaEmissao = DateUtil.dayFromDate(dataEmissao);
            Integer mesEmissao = DateUtil.monthFromDate(dataEmissao);
            Integer anoEmissao = DateUtil.yearFromDate(dataEmissao);
            if (diaEmissao < diaFixoVencimento) {
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            } else {
                if ((mesEmissao = Integer.valueOf(mesEmissao + parcela)) > 12) {
                    mesEmissao = mesEmissao - 12;
                    anoEmissao = anoEmissao + 1;
                }
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            }
        } else {
            data = DateUtil.nextDays(dataEmissao, diaVariavel * parcela);
        }
        Integer diaSemana = DateUtil.diaDaSemana(data);
        if (diaSemana.equals(7) && excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals((short)1) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluirDiasNaoUteis.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluirDiasNaoUteis.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getDataVencimentoTituloCreditoTEF(Date dataEmissao, Short dataFixa, Integer diaFixo, Integer diaVariavel, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa, int parcela) {
        Date data = null;
        if (dataFixa.equals((short)1)) {
            Integer diaFixoVencimento = diaFixo;
            Integer diaEmissao = DateUtil.dayFromDate(dataEmissao);
            Integer mesEmissao = DateUtil.monthFromDate(dataEmissao);
            Integer anoEmissao = DateUtil.yearFromDate(dataEmissao);
            if (diaEmissao < diaFixoVencimento) {
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            } else {
                if ((mesEmissao = Integer.valueOf(mesEmissao + parcela)) > 12) {
                    mesEmissao = mesEmissao - 12;
                    anoEmissao = anoEmissao + 1;
                }
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            }
        } else {
            data = DateUtil.nextDays(dataEmissao, diaVariavel * parcela);
        }
        Integer diaSemana = DateUtil.diaDaSemana(data);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals((short)1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals((short)1) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals((short)1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getFormateDate(Integer diaFixoVencimento, Integer mesEmissao, Integer anoEmissao) {
        return DateUtil.intToDate(anoEmissao, mesEmissao, diaFixoVencimento);
    }

    private CarteiraCobranca getCarteiraCobranca(Empresa empresa, Short pagRec, OpcoesFinanceiras op) throws ExceptionService {
        return ((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(pagRec.shortValue());
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    private void gerarTitulosCartaoDebito(CondicoesPagamento cp, Date dataEmissao, Empresa empresa, Double valor, List<Titulo> titulos, MeioPagamento meioPagamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        Titulo titulo = new Titulo();
        titulo.setEmpresa(empresa);
        titulo.setDataCadastro(new Date());
        titulo.setProvisao(Short.valueOf((short)1));
        titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
        titulo.setPagRec(Short.valueOf((short)1));
        titulo.setPessoa(meioPagamento.getCredenciadoraCreditoDebito());
        titulo.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
        if (meioPagamento.getCredenciadoraCreditoDebito() != null && meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros() != null) {
            titulo.setCartCobrancaDestino(meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros().getCarteiraCobranca());
        }
        titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec(), opcoesFinanceiras));
        titulo.setDataEmissao(dataEmissao);
        titulo.setDataCompetencia(dataEmissao);
        titulo.setDataEntradaSaida(dataEmissao);
        titulo.setPlanoConta(meioPagamento.getPlanoContaCredenciadoraCreditoDebito());
        titulo.setObservacao("TEF/Cartao Debito: " + cp.getNome() + ". Pessoa: " + (meioPagamento.getCredenciadoraCreditoDebito() != null ? meioPagamento.getCredenciadoraCreditoDebito().getNome() : "N\u00e3o informada no meio de pagamento.") + ". Data Emissao: " + ToolDate.dateToStr((Date)dataEmissao));
        titulo.setValor(valor);
        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (cp.getTaxaCartao() / 100.0)), (int)2));
        titulo.setDataVencimento(this.getDataVencimentoTituloDebito(dataEmissao, cp.getDiasDeslocamento(), empresa));
        titulo.setDataVencimentoBase(titulo.getDataVencimento());
        titulo.setNumParcTituloEstnota(Short.valueOf((short)1));
        titulo.setNumeroParcelas(Short.valueOf((short)1));
        titulo.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
        this.setarPercJurosMultaDesconto(titulo, opcoesFinanceiras);
        titulo.setMeioPagamento(meioPagamento);
        titulos.add(titulo);
    }

    private void gerarTitulosCartaoCredito(CondicoesPagamento cp, Short numeroParcelas, Date dataEmissao, Empresa empresa, Double valor, List<Titulo> titulos, MeioPagamento meioPagamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        if (numeroParcelas > 0) {
            Double vlrTotalAcu = 0.0;
            Double vrDesp = 0.0;
            vrDesp = cp.getDeducaoTaxa() == 0 ? Double.valueOf(valor * (cp.getTaxaCartao() / 100.0)) : Double.valueOf(valor * (cp.getTaxaCartao() / 100.0) / (double)numeroParcelas.shortValue());
            Double valorTitulo = valor / (double)numeroParcelas.shortValue();
            for (int i = 1; i <= numeroParcelas.intValue(); ++i) {
                Titulo titulo = new Titulo();
                titulo.setEmpresa(empresa);
                titulo.setDataCadastro(new Date());
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
                titulo.setPagRec(Short.valueOf((short)1));
                titulo.setPessoa(meioPagamento.getCredenciadoraCreditoDebito());
                titulo.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
                if (meioPagamento.getCredenciadoraCreditoDebito() != null && meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros() != null) {
                    titulo.setCartCobrancaDestino(meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                titulo.setPlanoConta(meioPagamento.getPlanoContaCredenciadoraCreditoDebito());
                titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec(), opcoesFinanceiras));
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(dataEmissao);
                titulo.setDataEntradaSaida(dataEmissao);
                titulo.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
                titulo.setDataVencimento(this.getDataVencimentoTituloCredito(dataEmissao, cp.getDataFixa(), cp.getDiaFixo(), cp.getDiaVariavel(), cp.getExcluirDiasNaoUteis(), empresa, i));
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                if (cp.getDeducaoTaxa() == 0) {
                    if (i == 1) {
                        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2));
                    }
                } else {
                    titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2, (int)1));
                }
                if (i == numeroParcelas) {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor - vlrTotalAcu), (int)2, (int)5));
                } else {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2, (int)1));
                }
                vlrTotalAcu = vlrTotalAcu + titulo.getValor();
                titulo.setNumParcTituloEstnota(Short.valueOf((short)i));
                titulo.setNumeroParcelas(numeroParcelas);
                titulo.setObservacao("TEF/Cartao Credito: " + cp.getNome() + ". Parcela:" + titulo.getNumParcTituloEstnota() + "/" + numeroParcelas.toString() + ". Meio de Pagamento: " + String.valueOf(meioPagamento) + " Data Emissao: " + ToolDate.dateToStr((Date)dataEmissao));
                this.setarPercJurosMultaDesconto(titulo, opcoesFinanceiras);
                titulo.setMeioPagamento(meioPagamento);
                titulos.add(titulo);
            }
        }
    }

    private boolean getPagamentoDebitoAlimentacaoRefeicaoCombustivel(MeioPagamento meioPagamento) {
        return meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
    }

    private boolean getPagamentoCredito(MeioPagamento meioPagamento) {
        return meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
    }
}

