/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfce;

import com.touchcomp.basementor.constants.ConstantsTipoPreAbastecimento;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.model.vo.BandeiraTEF;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.NFCeCaixa;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoBandeiraTEF;
import com.touchcomp.basementor.model.vo.TipoBandeiraTEFEmpresa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TransferenciaContaValor;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.borderochequesterceiros.ServiceBorderoChequesTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorservice.service.impl.planocontagerencial.ServicePlanoContaGerencialImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoFormatUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.movimentofinanceiro.UtilityMovimentoFinanceiro;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilNFCeControleCaixa {
    TLogger logger = TLogger.get(this.getClass());

    UtilNFCeControleCaixa() {
    }

    public List findNFCeAutorizadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.identificador                         as ID_NFCE, nfcePag.valorLiquido                                as VALOR,  nfcePag.valorTroco                                  as VALOR_TROCO,  nfcePag.meioPagamento.descricao                     as FORMA_PAGAMENTO, nfce.numero                                         as NR_COO, nfce.totalizadores.valorTotalNFe                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissao                                    as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfcePag.tipoPagamentoNFe.codigo                     as TIPO_PAGAMENTO , nfce.status                                         as STATUS,  nfcePag.permitirTEF                                 as PERMITIR_TEF,  band.descricao                                      as BANDEIRA_CARTAO  from NFCe nfce  inner join  nfce.pagamentos nfcePag  inner join nfcePag.nfce nfce  left join nfcePag.bandeiraTEF band  where nfce.nfCeControleCaixa = :nfceControleCaixa  and (nfce.status = :autorizada  or nfce.status = :autorizadaForaPrazo)  and nfcePag.status = :ativo order by nfce.numero";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findNFeAutorizadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfePag.valor                               as VALOR,  nfePag.valorTroco                                   as VALOR_TROCO,  nfePag.meioPagamento.descricao                      as FORMA_PAGAMENTO, nfe.numeroNota                                      as NR_COO, nfe.valoresNfPropria.valorTotal                     as VALOR_TOTAL_BRUTO,  nfe.dataEmissaoNota                                 as DATA_EMISSAO,  nfe.status                                          as CANCELADO,  nfePag.tipoPagamentoNFe.codigo                      as TIPO_PAGAMENTO , nfe.status                                          as STATUS, nfePag.permitirTEF                                  as PERMITIR_TEF,  band.descricao                                      as BANDEIRA_CARTAO  from NotaFiscalPropria nfe  inner join  nfe.infPagamentoNfPropria nfePag  left join nfePag.bandeiraTEF band  where nfe.nfceControleCaixa = :nfceControleCaixa  and (nfe.status = :autorizada  or nfe.status = :autorizadaForaPrazo) order by nfe.numeroNota";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    public List findNFCeCanceladasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.identificador                         as ID_NFCE, nfce.numero                                         as NR_COO, nfce.totalizadores.valorTotalNFe                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissao                                    as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfce.status                                         as STATUS  from NFCe nfce  where nfce.nfCeControleCaixa = :nfceControleCaixa  and (nfce.status = :cancelada or nfce.status = :canceladaForaPrazo  or nfce.status = :denegada or nfce.status = :denegadaSefaz) order by nfce.numero";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("FORMA_PAGAMENTO", "Cancelado");
        }
        return lista;
    }

    public List findNFeCanceladasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.numeroNota                            as NR_COO, nfce.valoresNfPropria.valorTotal                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissaoNota                                as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfce.status                                         as STATUS  from NotaFiscalPropria nfce  where nfce.nfceControleCaixa = :nfceControleCaixa  and (nfce.status = :cancelada or nfce.status = :canceladaForaPrazo  or nfce.status = :denegada or nfce.status = :denegadaSefaz) order by nfce.numeroNota";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("FORMA_PAGAMENTO", "Cancelado");
        }
        return lista;
    }

    public List findNFCeRejeitadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.identificador                         as ID_NFCE, nfcePag.valor                                       as VALOR,  nfcePag.valorTroco                                  as VALOR_TROCO,  nfcePag.meioPagamento.descricao                     as FORMA_PAGAMENTO, nfce.numero                                         as NR_COO, nfce.totalizadores.valorTotalNFe                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissao                                    as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfcePag.tipoPagamentoNFe.codigo                     as TIPO_PAGAMENTO , nfce.status                                         as STATUS,  nfcePag.permitirTEF                                 as PERMITIR_TEF,  band.descricao                                      as BANDEIRA_CARTAO  from NFCe nfce  inner join  nfce.pagamentos nfcePag  inner join nfcePag.nfce nfce  left join nfcePag.bandeiraTEF band  where nfce.nfCeControleCaixa = :nfceControleCaixa  and nfce.status <> :autorizada  and nfce.status <> :autorizadaForaPrazo  and nfce.status <> :cancelada  and nfce.status <> :canceladaForaPrazo  and nfce.status <> :denegada  and nfce.status <> :denegadaSefaz  and nfce.status <> :inutilizada  order by nfce.numero";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findNFeRejeitadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfcePag.valor                              as VALOR,  nfcePag.valorTroco                                  as VALOR_TROCO,  nfcePag.meioPagamento.descricao                     as FORMA_PAGAMENTO, nfce.numeroNota                                     as NR_COO, nfce.valoresNfPropria.valorTotal                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissaoNota                                as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfcePag.tipoPagamentoNFe.codigo                     as TIPO_PAGAMENTO , nfce.status                                         as STATUS, nfcePag.permitirTEF                                 as PERMITIR_TEF,  band.descricao                                      as BANDEIRA_CARTAO  from NotaFiscalPropria nfce  inner join  nfce.infPagamentoNfPropria nfcePag  left join nfcePag.bandeiraTEF band  where nfce.nfceControleCaixa = :nfceControleCaixa  and nfce.status <> :autorizada  and nfce.status <> :autorizadaForaPrazo  and nfce.status <> :cancelada  and nfce.status <> :canceladaForaPrazo  and nfce.status <> :denegada  and nfce.status <> :denegadaSefaz  order by nfce.numeroNota";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
        q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    public List findNFCeInutilizadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        ArrayList lista = new ArrayList();
        lista.addAll(this.findInutilizacoesNFCeComNFCEByControleCaixa(nfceControleCaixa));
        lista.addAll(this.findInutilizacoesNFCeSemNFCEByControleCaixa(nfceControleCaixa));
        return lista;
    }

    public List findInutilizacoesNFCeComNFCEByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.identificador                         as ID_NFCE, nfce.numero                                         as NR_COO, nfce.totalizadores.valorTotalNFe                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissao                                    as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfce.status                                         as STATUS  from NFCe nfce  where nfce.nfCeControleCaixa = :nfceControleCaixa  and (nfce.inutilizacaoNFe.status = :inutilizada) order by nfce.numero";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("FORMA_PAGAMENTO", "Inutilizada");
        }
        return lista;
    }

    public List findInutilizacoesNFCeSemNFCEByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select i.identificador                         as ID_NFCE, cast(i.numeroInicial as long)                    as NR_COO, i.periodo                                        as DATA_EMISSAO  from InutilizacaoNumeracaoNFe i  where i.nfceControleCaixa = :nfceControleCaixa  and i.nfce is null and i.modeloDocFiscal.codigo = :modelo65 and (i.status = :inutilizada) order by i.numeroInicial";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("modelo65", EnumConstantsModeloDocFiscal.NFCE_65.getCodigo());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("VALOR_TOTAL_BRUTO", 0.0);
            h.put("FORMA_PAGAMENTO", "Inutilizada");
            h.put("STATUS", EnumConstNFeStatus.INUTILIZADA.getValue());
            h.put("CANCELADO", EnumConstNFeStatus.INUTILIZADA.getValue());
        }
        return lista;
    }

    public List findNFeInutilizadasByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        ArrayList lista = new ArrayList();
        lista.addAll(this.findInutilizacoesNFCeComNFEByControleCaixa(nfceControleCaixa));
        lista.addAll(this.findInutilizacoesNFeSemNFCEByControleCaixa(nfceControleCaixa));
        return lista;
    }

    public List findInutilizacoesNFCeComNFEByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select nfce.numeroNota                            as NR_COO, nfce.valoresNfPropria.valorTotal                    as VALOR_TOTAL_BRUTO,  nfce.dataEmissaoNota                                as DATA_EMISSAO,  nfce.status                                         as CANCELADO,  nfce.status                                         as STATUS  from NotaFiscalPropria nfce  where nfce.nfceControleCaixa = :nfceControleCaixa  and (nfce.inutilizacaoNFe.status = :inutilizada) order by nfce.numeroNota";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("FORMA_PAGAMENTO", "Inutilizada");
        }
        return lista;
    }

    public List findInutilizacoesNFeSemNFCEByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String hql = "select i.identificador                         as ID_NFCE, cast(i.numeroInicial as long)                    as NR_COO, i.periodo                                        as DATA_EMISSAO  from InutilizacaoNumeracaoNFe i  where i.nfceControleCaixa = :nfceControleCaixa  and i.nfce is null and i.modeloDocFiscal.codigo = :modelo65 and (i.status = :inutilizada) order by i.numeroInicial";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("modelo65", EnumConstantsModeloDocFiscal.NFE_55.getCodigo());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            h.put("VALOR", 0.0);
            h.put("VALOR_TROCO", 0.0);
            h.put("VALOR_TOTAL_BRUTO", 0.0);
            h.put("FORMA_PAGAMENTO", "Inutilizada");
            h.put("STATUS", EnumConstNFeStatus.INUTILIZADA.getValue());
            h.put("CANCELADO", EnumConstNFeStatus.INUTILIZADA.getValue());
        }
        return lista;
    }

    public List findSangriasSuprimentosByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        String sql = "select distinct nMov.data_Movimento AS DATA_MOVIMENTO,  nMov.tipo_Movimento          AS TIPO_MOVIMENTO,  nMov.valor                   AS VALOR,  nMov.id_nfce_movimento_caixa AS ID_MOVIMENTO_CAIXA, nMov.observacao              AS OBSERVACAO  from NFCe_Movimento_Caixa nMov  inner join nfce_controle_caixa cc on cc.id_nfce_controle_caixa = nMov.id_controle_caixa  where cc.id_nfce_controle_caixa = :idControleCaixa ";
        NativeQuery q = CoreBdUtil.getInstance().getSession().createSQLQuery(sql);
        q.setLong("idControleCaixa", nfceControleCaixa.getIdentificador().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findPreAbastecimentoByControleCaixa(NFCeControleCaixa nfceControleCaixa, Date dataInicial, Date dataFinal, Short tipo) {
        Object hql = "";
        boolean filtrarData = false;
        if (dataInicial != null && dataFinal != null) {
            filtrarData = true;
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.TODOS)) {
            hql = " from NFCePreAbastecimento p ";
            if (filtrarData) {
                hql = (String)hql + " where p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.SEM_NOTAS)) {
            hql = " from NFCePreAbastecimento p where not exists (select i.identificador from NFCeItem i where i.preAbastecimento.identificador = p.identificador)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_NAO_ENVIADAS)) {
            hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfce.status <> :autorizada                     and i.nfce.status <> :autorizadaForaPrazo                     and i.nfce.status <> :cancelada                     and i.nfce.status <> :canceladaForaPrazo                     and i.nfce.status <> :denegada                     and i.nfce.status <> :denegadaSefaz)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
            q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
            q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
            q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
            q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
            q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_INUTILIZADAS)) {
            hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfce.inutilizacaoNFe.status = :inutilizada)";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_CANCELADAS)) {
            hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador and (i.nfce.status = :cancelada or i.nfce.status = :canceladaForaPrazo  or i.nfce.status = :denegada or i.nfce.status = :denegadaSefaz))";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
            q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
            q.setInteger("denegada", EnumConstNFeStatus.DENEGADA.getValue().intValue());
            q.setInteger("denegadaSefaz", EnumConstNFeStatus.REJ_NFE_DENEGADA_SEFAZ.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.NOTAS_ENVIADAS)) {
            hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeItem i                      where i.preAbastecimento.identificador = p.identificador                     and (i.nfce.status = :autorizada  or i.nfce.status = :autorizadaForaPrazo))";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
            q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
            return q.list();
        }
        if (tipo.equals(ConstantsTipoPreAbastecimento.AFERICAO)) {
            hql = " from NFCePreAbastecimento p where exists (select i.identificador                      from NFCeAfericaoPreAbastecimento i                      where i.preAbastecimento.identificador = p.identificador                     and i.nfCeControleCaixa.identificador = :idControleCaixa )";
            if (filtrarData) {
                hql = (String)hql + " and p.dataAbastecimento between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            if (filtrarData) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setLong("idControleCaixa", nfceControleCaixa.getIdentificador().longValue());
            return q.list();
        }
        return new ArrayList();
    }

    public HashMap gerarTitulosCartaoDebitoCreditoAndMovimentoFinanceiroDinheiro(NFCeControleCaixa nfceControleCaixa, NFCeOpcoes opcoesNFCe, Double valorDiferencaCaixa, Double valorRemanescenteCaixa, Double valorSuprimento, Double valorSangria, Double valorDiferencaDinheiro, Double valorDinheiroInformado, OpcoesContabeis opcoesContabeis, OpcoesGerenciais opcoesGerenciais, Double valorTolerancia, Boolean somenteRecalculaDinheiro, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionService, ExceptionDatabase {
        HashMap<String, Object> movimentos = new HashMap<String, Object>();
        List pagamentos = this.getPagamentos(nfceControleCaixa, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        Boolean existePIX = false;
        for (Object o : pagamentos) {
            HashMap h = (HashMap)o;
            CondicoesPagamento condicoesPagamento = (CondicoesPagamento)h.get("CONDICOES_PAGAMENTO");
            Short numeroParcelas = (Short)h.get("NUMERO_PARCELAS");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Empresa empresa = (Empresa)h.get("EMPRESA");
            Double valor = (Double)h.get("VALOR");
            String tipo = (String)h.get("TIPO");
            Short permitirTEF = (Short)h.get("PERMITIR_TEF");
            MeioPagamento meioPagamento = (MeioPagamento)h.get("MEIO_PAGAMENTO");
            BandeiraTEF bandeiraTEF = (BandeiraTEF)h.get("BANDEIRA_TEF");
            if (somenteRecalculaDinheiro == null || !somenteRecalculaDinheiro.booleanValue()) {
                if (opcoesNFCe.getGerarTitulosDebitoCredito() != null && opcoesNFCe.getGerarTitulosDebitoCredito().shortValue() == EnumConstantsMentorSimNao.SIM.getValue() && (opcoesNFCe.getGerarTituloDebCreditoApuracao() == null || opcoesNFCe.getGerarTituloDebCreditoApuracao().shortValue() == EnumConstantsMentorSimNao.NAO.getValue())) {
                    if (this.getPagamentoDebitoAlimentacaoRefeicaoCombustivel(meioPagamento) && permitirTEF.equals(EnumConstantsMentorSimNao.NAO.getValue())) {
                        if (ToolMethods.isEquals((Object)condicoesPagamento.getExibirBandeiraCartao(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                            tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, nfceControleCaixa.getNfceCaixa().getEmpresa());
                            this.gerarTitulosCartaoDebitoTEF(condicoesPagamento, dataEmissao, empresa, valor, nfceControleCaixa, titulos, tipoBandeira, meioPagamento, opcoesGerenciais);
                        } else {
                            this.gerarTitulosCartaoDebito(condicoesPagamento, dataEmissao, empresa, valor, nfceControleCaixa, titulos, meioPagamento, opcoesGerenciais);
                        }
                    } else if (this.getPagamentoDebitoAlimentacaoRefeicaoCombustivel(meioPagamento) && permitirTEF.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                        tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, nfceControleCaixa.getNfceCaixa().getEmpresa());
                        this.gerarTitulosCartaoDebitoTEF(condicoesPagamento, dataEmissao, empresa, valor, nfceControleCaixa, titulos, tipoBandeira, meioPagamento, opcoesGerenciais);
                    } else if (this.getPagamentoCredito(meioPagamento) && permitirTEF.equals(EnumConstantsMentorSimNao.NAO.getValue())) {
                        if (ToolMethods.isEquals((Object)condicoesPagamento.getExibirBandeiraCartao(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                            tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, nfceControleCaixa.getNfceCaixa().getEmpresa());
                            this.gerarTitulosCartaoCreditoTEF(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, nfceControleCaixa, titulos, tipoBandeira, meioPagamento, opcoesGerenciais);
                        } else {
                            this.gerarTitulosCartaoCredito(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, nfceControleCaixa, titulos, meioPagamento, opcoesGerenciais);
                        }
                    } else if (this.getPagamentoCredito(meioPagamento) && permitirTEF.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                        tipoBandeira = this.getPessoaFromBandeiraTEF(bandeiraTEF, numeroParcelas, nfceControleCaixa.getNfceCaixa().getEmpresa());
                        this.gerarTitulosCartaoCreditoTEF(condicoesPagamento, numeroParcelas, dataEmissao, empresa, valor, nfceControleCaixa, titulos, tipoBandeira, meioPagamento, opcoesGerenciais);
                    }
                }
                if (opcoesNFCe.getGerarMovBancarioCheque().shortValue() == EnumConstantsMentorSimNao.SIM.getValue() && meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) {
                    StringBuilder warning = this.isValidAddChequeByCriacaoBordero(nfceControleCaixa);
                    if (ToolMethods.isStringBuilderWithData((StringBuilder)warning)) {
                        movimentos.put("WARNING", warning.toString());
                    } else {
                        movimentos.put("MOVIMENTO_BANCARIO_CHEQUE", this.gerarMovimentoBancanrioCheques(dataEmissao, empresa, valor, nfceControleCaixa));
                        movimentos.put("BORDERO_CHEQUE_TERCEIROS", this.gerarBorderoChequesTerceiros(this.gerarMovimentoBancanrioCheques(nfceControleCaixa), empresa, nfceControleCaixa, opcoesContabeis));
                    }
                }
            }
            if (ToolMethods.isEquals((Object)opcoesNFCe.getGerarMovBancarioDinheiro(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo())) {
                this.gerarMovimentoBancanrioDinheiro(dataEmissao, empresa, valor, nfceControleCaixa, movimentos, valorRemanescenteCaixa, valorDiferencaDinheiro, condicoesPagamento);
            }
            if (ToolMethods.isEquals((Object)opcoesNFCe.getGerarMovimentoBancarioPix(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)meioPagamento.getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.PIX.getCodigo())) {
                existePIX = true;
                if (ToolMethods.isEquals((Object)opcoesNFCe.getAgruparMovimentoPix(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                    this.gerarMovimentoBancarioPixAgrupado(dataEmissao, empresa, valor, condicoesPagamento, nfceControleCaixa, movimentos);
                }
            }
            if (!meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo()) && !meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.PIX.getCodigo()) && !meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CHEQUE.getCodigo())) continue;
            this.gerarLancGerenciaisDinheiroPixCheque(valor, opcoesGerenciais, condicoesPagamento, meioPagamento, nfceControleCaixa);
        }
        if (existePIX.booleanValue() && ToolMethods.isEquals((Object)opcoesNFCe.getGerarMovimentoBancarioPix(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)opcoesNFCe.getAgruparMovimentoPix(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            this.getPagamentosAndMovimentosPixNaoAgrupados(nfceControleCaixa, movimentos);
        }
        movimentos.put("TITULOS", titulos);
        movimentos.put("MOVIMENTO_BANCARIO_DIFERENCA_CAIXA", this.getMovimentoBancarioDiferencaCaixa(nfceControleCaixa, opcoesNFCe, valorDiferencaDinheiro, valorTolerancia));
        movimentos.put("TRANSFERENCIA_CONTA_VALOR", this.gerarTransferenciaContaValor(nfceControleCaixa, opcoesNFCe, valorDinheiroInformado, opcoesContabeis));
        movimentos.put("LANC_GERENCIAIS", nfceControleCaixa.getLancamentosGerenciais());
        return movimentos;
    }

    private List getPagamentos(NFCeControleCaixa nfceControleCaixa, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        List pagamentos = this.getPagamentosNFCe(nfceControleCaixa, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        pagamentos = this.getPagamentosNFe(nfceControleCaixa, pagamentos, filtrarDebito, filtrarCredito, filtrarAlimentacao, filtrarRefeicao, filtrarCombustivel);
        return pagamentos;
    }

    private List getPagamentosNFCe(NFCeControleCaixa nfceControleCaixa, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        String hql = "select sum(p.valorLiquido)        AS VALOR, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, p.numeroParcelas                    AS NUMERO_PARCELAS, nfce.dataEmissao                    AS DATA_EMISSAO, nfce.empresa.identificador          AS ID_EMPRESA,  p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from NFCePagamento p  inner join p.nfce nfce  inner join nfce.nfCeControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo = :debito        or p.tipoPagamentoNFe.codigo = :credito       or p.tipoPagamentoNFe.codigo = :alimentacao       or p.tipoPagamentoNFe.codigo = :refeicao       or p.tipoPagamentoNFe.codigo = :combustivel       or p.tipoPagamentoNFe.codigo = :dinheiro      or p.tipoPagamentoNFe.codigo = :pix      or p.tipoPagamentoNFe.codigo = :cheque) and p.status = :ativo  group by  p.numeroParcelas,  p.condicoesPagamento.identificador, nfce.dataEmissao,  nfce.empresa.identificador,  p.tipoPagamentoNFe.codigo,  p.meioPagamento.identificador ,  p.permitirTEF, b.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        q.setString("alimentacao", EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo());
        q.setString("refeicao", EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo());
        q.setString("combustivel", EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
        q.setString("dinheiro", EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo());
        q.setString("cheque", EnumConstNFeTipoPagNFe.CHEQUE.getCodigo());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setShort("ativo", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            Empresa empresa = (Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey((Long)h.get("ID_EMPRESA"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
        }
        return lista;
    }

    private List getPagamentosNFe(NFCeControleCaixa nfceControleCaixa, List<HashMap> pagamentos, Short filtrarDebito, Short filtrarCredito, Short filtrarAlimentacao, Short filtrarRefeicao, Short filtrarCombustivel) throws ExceptionDatabase {
        String hql = "select sum(p.valor)               AS VALOR, p.numeroParcelas                    AS NUMERO_PARCELAS, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, nfce.dataEmissaoNota                AS DATA_EMISSAO, nfce.empresa.identificador          AS ID_EMPRESA,  p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from InfPagamentoNfPropria p  inner join p.notaFiscalPropria nfce  inner join nfce.naturezaOperacao nat  inner join nfce.nfceControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo = :debito        or p.tipoPagamentoNFe.codigo = :credito       or p.tipoPagamentoNFe.codigo = :alimentacao       or p.tipoPagamentoNFe.codigo = :refeicao       or p.tipoPagamentoNFe.codigo = :combustivel       or p.tipoPagamentoNFe.codigo = :dinheiro      or p.tipoPagamentoNFe.codigo = :pix      or p.tipoPagamentoNFe.codigo = :cheque)  group by  p.numeroParcelas, p.condicoesPagamento.identificador,  nfce.dataEmissaoNota,  nfce.empresa.identificador,  p.tipoPagamentoNFe.codigo,  p.meioPagamento.identificador ,  p.permitirTEF, b.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        q.setString("alimentacao", EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo());
        q.setString("refeicao", EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo());
        q.setString("combustivel", EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
        q.setString("dinheiro", EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo());
        q.setString("cheque", EnumConstNFeTipoPagNFe.CHEQUE.getCodigo());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            Short numeroParcelas = (Short)h.get("NUMERO_PARCELAS");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Long idEmpresa = (Long)h.get("ID_EMPRESA");
            String codigo = (String)h.get("TIPO");
            Long idMeioPagamento = (Long)h.get("ID_MEIO_PAGAMENTO");
            Short permitirTEF = (Short)h.get("PERMITIR_TEF");
            Double valor = (Double)h.get("VALOR");
            Long idCondicoesPagamento = (Long)h.get("ID_CONDICOES_PAGAMENTO");
            Long idBandeiraTEF = (Long)h.get("ID_BANDEIRA_TEF");
            Boolean achou = false;
            for (HashMap pag : pagamentos) {
                Short numeroParcelasPag = (Short)pag.get("NUMERO_PARCELAS");
                Date dataEmissaoPag = (Date)pag.get("DATA_EMISSAO");
                Long idEmpresaPag = (Long)pag.get("ID_EMPRESA");
                String codigoPag = (String)pag.get("TIPO");
                Long idMeioPagamentoPag = (Long)pag.get("ID_MEIO_PAGAMENTO");
                Short permitirTEFPag = (Short)pag.get("PERMITIR_TEF");
                Double valorPag = (Double)pag.get("VALOR");
                Long idCondicoesPagamentoPag = (Long)pag.get("ID_CONDICOES_PAGAMENTO");
                Long idBandeiraTEFPag = (Long)pag.get("ID_BANDEIRA_TEF");
                if (!numeroParcelas.equals(numeroParcelasPag) || !dataEmissao.equals(ToolDate.dataSemHora((Date)dataEmissaoPag)) || !idEmpresa.equals(idEmpresaPag) || !codigo.equals(codigoPag) || !idMeioPagamento.equals(idMeioPagamentoPag) || !idCondicoesPagamento.equals(idCondicoesPagamentoPag) || !permitirTEF.equals(permitirTEFPag) || (idBandeiraTEF != null || idBandeiraTEFPag != null) && (idBandeiraTEF == null || idBandeiraTEFPag == null || !idBandeiraTEF.equals(idBandeiraTEFPag))) continue;
                pag.put("VALOR", valor + valorPag);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            Empresa empresa = (Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey((Long)h.get("ID_EMPRESA"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
            pagamentos.add(h);
        }
        return pagamentos;
    }

    private CarteiraCobranca getCarteiraCobranca(Empresa empresa, Short pagRec) throws ExceptionService {
        return ((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(this.getOpcoesFinanceiras(empresa)).getCarteiraCobranca(pagRec.shortValue());
    }

    private void gerarTitulosCartaoDebito(CondicoesPagamento cp, Date dataEmissao, Empresa empresa, Double valor, NFCeControleCaixa nfceControleCaixa, List<Titulo> titulos, MeioPagamento meioPagamento, OpcoesGerenciais op) throws ExceptionService, ExceptionDatabase {
        Titulo titulo = new Titulo();
        titulo.setEmpresa(empresa);
        titulo.setDataCadastro(new Date());
        titulo.setProvisao(Short.valueOf((short)1));
        titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
        titulo.setPagRec(Short.valueOf((short)1));
        titulo.setPessoa(meioPagamento.getCredenciadoraCreditoDebito());
        titulo.setClassificacaoPessoa(this.getOpcoesFinanceiras(empresa).getClassificacaoClientes());
        if (meioPagamento.getCredenciadoraCreditoDebito() != null && meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros() != null) {
            titulo.setCartCobrancaDestino(meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros().getCarteiraCobranca());
        }
        titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec()));
        titulo.setDataEmissao(dataEmissao);
        titulo.setDataCompetencia(dataEmissao);
        titulo.setDataEntradaSaida(dataEmissao);
        titulo.setPlanoConta(meioPagamento.getPlanoContaCredenciadoraCreditoDebito());
        titulo.setObservacao("Controle Caixa " + nfceControleCaixa.getIdentificador() + ".  Debito: " + cp.getNome() + ". Pessoa: " + (meioPagamento.getCredenciadoraCreditoDebito() != null ? meioPagamento.getCredenciadoraCreditoDebito().getNome() : "N\u00ef\u00bf\u00bdo informada no meio de pagamento."));
        titulo.setValor(valor);
        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (cp.getTaxaCartao() / 100.0)), (int)2));
        titulo.setDataVencimento(this.getDataVencimentoTituloDebito(dataEmissao, cp.getDiasDeslocamento(), empresa));
        titulo.setDataVencimentoBase(titulo.getDataVencimento());
        titulo.setNfCeControleCaixa(nfceControleCaixa);
        titulo.setNumParcTituloEstnota(Short.valueOf((short)1));
        titulo.setTipoDoc(this.getOpcoesFinanceiras(empresa).getTipoDocFinanceiro());
        this.setarPercJurosMultaDesconto(titulo, this.getOpcoesFinanceiras(empresa));
        titulo.setMeioPagamento(meioPagamento);
        this.gerarLancGerenciaisDebitoCredito(titulo, op, cp, meioPagamento, nfceControleCaixa);
        titulos.add(titulo);
    }

    private OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) throws ExceptionService {
        return (OpcoesFinanceiras)this.loadUniqueEntity(CoreDAOFactory.getInstance().getOpcoesFinanceirasDAO(), empresa);
    }

    private Object loadUniqueEntity(CoreBaseDAO entityDAO, Empresa empresa) throws ExceptionService {
        return CoreService.simpleFindByCriteriaUniqueResult(entityDAO, "empresa", empresa, 0);
    }

    private void gerarTitulosCartaoCredito(CondicoesPagamento cp, Short numeroParcelas, Date dataEmissao, Empresa empresa, Double valor, NFCeControleCaixa nfceControleCaixa, List<Titulo> titulos, MeioPagamento meioPagamento, OpcoesGerenciais op) throws ExceptionService, ExceptionDatabase {
        if (numeroParcelas > 0) {
            Double vlrTotalAcu = 0.0;
            Double vrDesp = 0.0;
            vrDesp = cp.getDeducaoTaxa() == 0 ? Double.valueOf(valor * (cp.getTaxaCartao() / 100.0)) : Double.valueOf(valor * (cp.getTaxaCartao() / 100.0) / (double)numeroParcelas.shortValue());
            Double valorTitulo = valor / (double)numeroParcelas.shortValue();
            for (int i = 1; i <= numeroParcelas.intValue(); ++i) {
                Titulo titulo = new Titulo();
                titulo.setEmpresa(empresa);
                titulo.setDataCadastro(new Date());
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
                titulo.setPagRec(Short.valueOf((short)1));
                titulo.setPessoa(meioPagamento.getCredenciadoraCreditoDebito());
                titulo.setClassificacaoPessoa(this.getOpcoesFinanceiras(empresa).getClassificacaoClientes());
                if (meioPagamento.getCredenciadoraCreditoDebito() != null && meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros() != null) {
                    titulo.setCartCobrancaDestino(meioPagamento.getCredenciadoraCreditoDebito().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                titulo.setPlanoConta(meioPagamento.getPlanoContaCredenciadoraCreditoDebito());
                titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec()));
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(dataEmissao);
                titulo.setDataEntradaSaida(dataEmissao);
                titulo.setTipoDoc(this.getOpcoesFinanceiras(empresa).getTipoDocFinanceiro());
                titulo.setDataVencimento(this.getDataVencimentoTituloCredito(dataEmissao, cp.getDataFixa(), cp.getDiaFixo(), cp.getDiaVariavel(), cp.getExcluirDiasNaoUteis(), empresa, i));
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                titulo.setNfCeControleCaixa(nfceControleCaixa);
                if (cp.getDeducaoTaxa() == 0) {
                    if (i == 1) {
                        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2));
                    }
                } else {
                    titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2, (int)1));
                }
                if (i == numeroParcelas) {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor - vlrTotalAcu), (int)2, (int)5));
                } else {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2, (int)1));
                }
                vlrTotalAcu = vlrTotalAcu + titulo.getValor();
                titulo.setNumParcTituloEstnota(Short.valueOf((short)i));
                titulo.setObservacao("Controle Caixa: " + nfceControleCaixa.getIdentificador() + ". Credito: " + cp.getNome() + ". Parcela:" + titulo.getNumParcTituloEstnota() + "/" + numeroParcelas.toString() + ". Meio de Pagamento: " + String.valueOf(meioPagamento));
                this.setarPercJurosMultaDesconto(titulo, this.getOpcoesFinanceiras(empresa));
                titulo.setMeioPagamento(meioPagamento);
                this.gerarLancGerenciaisDebitoCredito(titulo, op, cp, meioPagamento, nfceControleCaixa);
                titulos.add(titulo);
            }
        }
    }

    private void gerarMovimentoBancanrioDinheiro(Date dataEmissao, Empresa empresa, Double valor, NFCeControleCaixa nfceControleCaixa, HashMap movimentos, Double valorRemanescenteCaixa, Double valorDiferencaDinheiro, CondicoesPagamento condPagamento) {
        MovimentoBancario m = null;
        if (movimentos.get("MOVIMENTO_BANCARIO") != null) {
            m = (MovimentoBancario)movimentos.get("MOVIMENTO_BANCARIO");
            m.setValor(Double.valueOf(m.getValor() + valor));
        } else {
            m = new MovimentoBancario();
            m.setDataCadastro(new Date());
            m.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)dataEmissao));
            m.setDataCompensacao(this.getDataMovimentoEmFimDeSemanaOrFeriado(condPagamento, ContatoDateUtil.toTimestamp((Date)dataEmissao), empresa));
            m.setEmpresa(empresa);
            m.setDebCred(Short.valueOf((short)1));
            m.setContaValor(nfceControleCaixa.getNfceCaixa().getContaValorCaixa());
            m.setHistorico("Movimento Financeiro gerado pelo Controle de Caixa Fiscal: " + nfceControleCaixa.getIdentificador() + " com venda em dinheiro do dia " + DateUtil.dateToStr(dataEmissao));
            m.setValor(Double.valueOf(valor - valorRemanescenteCaixa));
            m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            nfceControleCaixa.setMovimentoBancario(m);
            movimentos.put("MOVIMENTO_BANCARIO", m);
        }
    }

    private List<ChequeTerceiros> gerarMovimentoBancanrioCheques(NFCeControleCaixa nfceControleCaixa) {
        return this.getChequesByControleCaixa(nfceControleCaixa);
    }

    private TipoBandeiraTEF getPessoaFromBandeiraTEF(BandeiraTEF bandeiraTEF, Short numeroParcelas, Empresa empresa) throws ExceptionService {
        if (bandeiraTEF == null) {
            throw new ExceptionService(MessagesBaseMentor.getErrorMsg((String)"E.ERP.1790.001", (Object[])new Object[0]));
        }
        String query = "from TipoBandeiraTEF t  where t.bandeiraTEF = :bandeiraTEF";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setEntity("bandeiraTEF", (Object)bandeiraTEF);
        List tipoBandeira = q.list();
        if (tipoBandeira != null && tipoBandeira.size() == 1) {
            TipoBandeiraTEF t = (TipoBandeiraTEF)tipoBandeira.get(0);
            for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                if (!emp.getEmpresa().equals((Object)empresa)) continue;
                return t;
            }
            throw new ExceptionService("Nenhuma empresa encontrada para transacoes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
        }
        if (tipoBandeira != null && tipoBandeira.size() > 1) {
            for (TipoBandeiraTEF t : tipoBandeira) {
                Short creditoParcelado = t.getCreditoParcelado();
                if (creditoParcelado.equals(EnumConstantsMentorSimNao.SIM.getValue()) && numeroParcelas > 1) {
                    for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                        if (!emp.getEmpresa().equals((Object)empresa)) continue;
                        return t;
                    }
                    continue;
                }
                if (!creditoParcelado.equals(EnumConstantsMentorSimNao.NAO.getValue()) || numeroParcelas != 1) continue;
                for (TipoBandeiraTEFEmpresa emp : t.getEmpresas()) {
                    if (!emp.getEmpresa().equals((Object)empresa)) continue;
                    return t;
                }
            }
            for (TipoBandeiraTEF tipoBandeiraTEF : tipoBandeira) {
                for (TipoBandeiraTEFEmpresa emp : tipoBandeiraTEF.getEmpresas()) {
                    if (!emp.getEmpresa().equals((Object)empresa)) continue;
                    return tipoBandeiraTEF;
                }
            }
            if (tipoBandeira.size() > 1) {
                throw new ExceptionService("Nenhuma empresa encontrada para transacoes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
            }
        } else {
            throw new ExceptionService("Nenhuma pessoa encontrada para transacoes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
        }
        throw new ExceptionService("Nenhuma pessoa encontrada para transacoes TEF para a bandeira TEF" + bandeiraTEF.getCodigo() + " - " + bandeiraTEF.getDescricao() + ".  Verifique seu cadastro de Tipos de Pagamento NFE ");
    }

    private MovimentoBancario gerarMovimentoBancanrioCheques(Date dataEmissao, Empresa empresa, Double valor, NFCeControleCaixa nfceControleCaixa) {
        MovimentoBancario m = new MovimentoBancario();
        m.setDataCadastro(new Date());
        m.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)dataEmissao));
        m.setDataCompensacao(dataEmissao);
        m.setEmpresa(empresa);
        m.setDebCred(Short.valueOf((short)1));
        m.setContaValor(nfceControleCaixa.getNfceCaixa().getContaValorCaixa());
        m.setHistorico("Movimento Financeiro gerado pelo Controle de Caixa Fiscal:" + nfceControleCaixa.getIdentificador() + " com venda com cheques do dia " + DateUtil.dateToStr(dataEmissao));
        m.setValor(valor);
        m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        nfceControleCaixa.setMovimentoBancario(m);
        return m;
    }

    private TransferenciaContaValor gerarTransferenciaContaValor(NFCeControleCaixa nfceControleCaixa, NFCeOpcoes opcoesNFCe, Double valorDinheiroInformado, OpcoesContabeis opCont) {
        if (opcoesNFCe.getGerarMovBancarioSangriaSuprimento() != null && opcoesNFCe.getGerarMovBancarioSangriaSuprimento().shortValue() == EnumConstantsMentorSimNao.SIM.getValue() && valorDinheiroInformado != 0.0) {
            TransferenciaContaValor vo = new TransferenciaContaValor();
            vo.setDataCadastro(new Date());
            vo.setContaOrigem(nfceControleCaixa.getNfceCaixa().getContaValorCaixa());
            vo.setContaDestino(nfceControleCaixa.getNfceCaixa().getContaValorRetaguarda());
            vo.setDataTransferencia(nfceControleCaixa.getDataAbertura());
            vo.setEmpresa(nfceControleCaixa.getNfceCaixa().getEmpresa());
            vo.setHistorico("Transferencia realizada pelo Controle do Caixa Fiscal NFCe (Valor Dinheiro Informado): " + nfceControleCaixa.getNfceCaixa().getDescricao() + " do dia " + DateUtil.dateToStr(vo.getDataTransferencia()));
            vo.setValor(valorDinheiroInformado);
            vo.setNaoContabilizarTransf(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            vo.setMovBanc(this.getMovimentosBancariosTransferencia(nfceControleCaixa, nfceControleCaixa.getNfceCaixa(), vo, vo.getValor()));
            return vo;
        }
        return null;
    }

    private List<MovimentoBancario> getMovimentosBancariosTransferencia(NFCeControleCaixa nfceControleCaixa, NFCeCaixa c, TransferenciaContaValor t, Double valor) {
        ArrayList<MovimentoBancario> movimentos = new ArrayList<MovimentoBancario>();
        movimentos.add(this.getMovimentoBancarioCredito(nfceControleCaixa, c, t, valor));
        movimentos.add(this.getMovimentoBancarioDebito(nfceControleCaixa, c, t, valor));
        return movimentos;
    }

    private MovimentoBancario getMovimentoBancarioCredito(NFCeControleCaixa nfceControleCaixa, NFCeCaixa c, TransferenciaContaValor t, Double valor) {
        MovimentoBancario m = new MovimentoBancario();
        m.setDataCadastro(new Date());
        m.setDataLancamento(nfceControleCaixa.getDataAbertura());
        m.setDataCompensacao(nfceControleCaixa.getDataAbertura());
        m.setEmpresa(c.getEmpresa());
        m.setDebCred(Short.valueOf((short)1));
        m.setContaValor(c.getContaValorRetaguarda());
        m.setHistorico("Movimento Financeiro gerado pela transferencia referente ao Controle do Caixa Fiscal NFCe (Valor Dinheiro Informado): " + nfceControleCaixa.getNfceCaixa().getDescricao() + " do dia " + DateUtil.dateToStr(nfceControleCaixa.getDataFechamento()));
        m.setValor(valor);
        m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        m.setTransferenciaValor(t);
        return m;
    }

    private MovimentoBancario getMovimentoBancarioDebito(NFCeControleCaixa nfceControleCaixa, NFCeCaixa c, TransferenciaContaValor t, Double valor) {
        MovimentoBancario m = new MovimentoBancario();
        m.setDataCadastro(new Date());
        m.setDataLancamento(nfceControleCaixa.getDataAbertura());
        m.setDataCompensacao(nfceControleCaixa.getDataAbertura());
        m.setEmpresa(c.getEmpresa());
        m.setDebCred(Short.valueOf((short)0));
        m.setContaValor(c.getContaValorCaixa());
        m.setHistorico("Movimento Financeiro gerado pela transferencia referente ao Controle do Caixa Fiscal NFCe (Valor Dinheiro Informado): " + nfceControleCaixa.getNfceCaixa().getDescricao() + " do dia " + DateUtil.dateToStr(nfceControleCaixa.getDataFechamento()));
        m.setValor(valor);
        m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        m.setTransferenciaValor(t);
        return m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getMovimentoBancarioDiferencaCaixa(NFCeControleCaixa nfceControleCaixa, NFCeOpcoes opcoesNFCe, Double valorDiferencaCaixa, Double valorTolerancia) throws ExceptionService {
        if (opcoesNFCe.getGerarMovBancarioDiferencaCaixa() == null || opcoesNFCe.getGerarMovBancarioDiferencaCaixa().shortValue() != EnumConstantsMentorSimNao.SIM.getValue() || valorDiferencaCaixa == 0.0) return null;
        MovimentoBancario m = new MovimentoBancario();
        m.setDataCadastro(new Date());
        m.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)nfceControleCaixa.getDataAbertura()));
        m.setDataCompensacao(nfceControleCaixa.getDataAbertura());
        m.setEmpresa(nfceControleCaixa.getNfceCaixa().getEmpresa());
        if (valorDiferencaCaixa < 0.0) {
            m.setDebCred(Short.valueOf((short)0));
            m.setValor(Double.valueOf(Math.abs(valorDiferencaCaixa)));
            if (nfceControleCaixa.getNfceCaixa().getModeloLancBancarioDevedor() == null) throw new ExceptionService("Primeiro cadastre o Modelo de Lancamento Bancario Devedor para o Caixa Fiscal NFCe!");
            m.setModeloLancamentoBancario(nfceControleCaixa.getNfceCaixa().getModeloLancBancarioDevedor());
        } else {
            m.setDebCred(Short.valueOf((short)1));
            m.setValor(Double.valueOf(Math.abs(valorDiferencaCaixa)));
            if (nfceControleCaixa.getNfceCaixa().getModeloLancBancarioCredor() == null) throw new ExceptionService("Primeiro cadastre o Modelo de Lancamento Bancario Credor para o Caixa Fiscal NFCe!");
            m.setModeloLancamentoBancario(nfceControleCaixa.getNfceCaixa().getModeloLancBancarioCredor());
        }
        m.setContaValor(nfceControleCaixa.getNfceCaixa().getContaValorCaixa());
        m.setHistorico("Movimento Financeiro gerado pela diferenca de caixa do controle de caixa fiscal NFCe nr " + nfceControleCaixa.getIdentificador() + " do dia " + DateUtil.dateToStr(nfceControleCaixa.getDataAbertura()));
        m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        ArrayList<ContraPartMovimentoBancario> contraPartidas = new ArrayList<ContraPartMovimentoBancario>();
        for (Object o : m.getModeloLancamentoBancario().getItemModeloLancBancario()) {
            ItemModeloLancBancario item = (ItemModeloLancBancario)o;
            ContraPartMovimentoBancario contraPartida = new ContraPartMovimentoBancario();
            contraPartida.setDebCred(item.getDebCred());
            contraPartida.setBuscaTitulos(item.getBuscarTitulo());
            contraPartida.setHistorico(item.getHistoricoPadrao().getDescricao());
            contraPartida.setHistoricoPadrao(item.getHistoricoPadrao());
            contraPartida.setPlanoConta(item.getPlanoConta());
            contraPartida.setPlanoContaGerencial(item.getPlanoContaGerencial());
            contraPartida.setContraPartidaGeradaModeloLancamentoBancario(item.getContraPartida());
            contraPartida.setValor(m.getValor());
            contraPartida.setLancamentoCtbGerencial(this.getLancamentoCtbGerencial(contraPartida.getDebCred(), contraPartida.getValor(), item.getPlanoContaGerencial(), contraPartida, m.getDataLancamento(), m.getEmpresa()));
            contraPartidas.add(contraPartida);
        }
        m.setContraPartMovimentoBancario(contraPartidas);
        m.getContraPartMovimentoBancario().forEach(i -> i.setMovimentoBancario(m));
        nfceControleCaixa.setMovimentoBancarioDiferenca(m);
        try {
            new UtilityMovimentoFinanceiro().validarToleranciaMovimentoFinanceiro(m, valorTolerancia);
            return m;
        }
        catch (Exception e) {
            throw new ExceptionService(e.getMessage());
        }
    }

    private LancamentoCtbGerencial getLancamentoCtbGerencial(short debCred, Double valor, PlanoContaGerencial pc, ContraPartMovimentoBancario c, Date data, Empresa empresa) {
        LancamentoCtbGerencial lancCtbGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(c.getIdentificador() != null ? this.findLancamentoCtbGerencialFromContraPartida(c.getIdentificador()) : null, new Date(), data, Short.valueOf(debCred), empresa, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), "Lanc. por Movimento Financeiro.", pc, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), null, valor, null);
        return lancCtbGerencial;
    }

    private LancamentoCtbGerencial findLancamentoCtbGerencialFromContraPartida(Long idContraPartida) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.lancamentoCtbGerencial from ContraPartMovimentoBancario c where c.identificador = :identificador");
        q.setLong("identificador", idContraPartida.longValue());
        q.setMaxResults(1);
        return (LancamentoCtbGerencial)q.uniqueResult();
    }

    private void gerarTitulosCartaoDebitoTEF(CondicoesPagamento cp, Date dataEmissao, Empresa empresa, Double valorTitulo, NFCeControleCaixa nfceControleCaixa, List<Titulo> titulos, TipoBandeiraTEF tipoBandeira, MeioPagamento meioPagamento, OpcoesGerenciais op) throws ExceptionService, ExceptionDatabase {
        Titulo titulo = new Titulo();
        titulo.setEmpresa(empresa);
        titulo.setDataCadastro(new Date());
        titulo.setProvisao(Short.valueOf((short)1));
        titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
        titulo.setPagRec(Short.valueOf((short)1));
        titulo.setPessoa(tipoBandeira.getPessoa());
        titulo.setClassificacaoPessoa(this.getOpcoesFinanceiras(empresa).getClassificacaoClientes());
        if (tipoBandeira.getPessoa().getPessoaDadosFinanceiros() != null) {
            titulo.setCartCobrancaDestino(tipoBandeira.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
        }
        titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec()));
        titulo.setDataEmissao(dataEmissao);
        titulo.setDataCompetencia(dataEmissao);
        titulo.setDataEntradaSaida(dataEmissao);
        titulo.setPlanoConta(tipoBandeira.getPlanoConta());
        titulo.setObservacao("Controle Caixa" + nfceControleCaixa.getIdentificador() + ". TEF Debito: " + cp.getNome() + ". Pessoa: " + tipoBandeira.getPessoa().getNome());
        titulo.setValor(valorTitulo);
        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (tipoBandeira.getTaxaCartao() / 100.0)), (int)2));
        titulo.setDataVencimento(this.getDataVencimentoTituloDebitoTEF(dataEmissao, tipoBandeira.getDiasDeslocamento(), tipoBandeira.getExcluiSabado(), tipoBandeira.getExcluiDomingo(), tipoBandeira.getExcluiFeriado(), empresa));
        titulo.setDataVencimentoBase(titulo.getDataVencimento());
        titulo.setNfCeControleCaixa(nfceControleCaixa);
        titulo.setNumParcTituloEstnota(Short.valueOf((short)1));
        titulo.setTipoDoc(this.getOpcoesFinanceiras(empresa).getTipoDocFinanceiro());
        titulo.setMeioPagamento(meioPagamento);
        this.setarPercJurosMultaDesconto(titulo, this.getOpcoesFinanceiras(empresa));
        this.gerarLancGerenciaisDebitoCredito(titulo, op, cp, meioPagamento, nfceControleCaixa);
        titulos.add(titulo);
    }

    private Date getDataVencimentoTituloDebitoTEF(Date dataEmissao, Integer diasDeslocamento, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa) {
        Date data = DateUtil.nextDays(dataEmissao, diasDeslocamento);
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals(EnumConstantsMentorSimNao.SIM.getValue()) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getDataVencimentoTituloDebito(Date dataEmissao, Integer diasDeslocamento, Empresa empresa) {
        Date data = DateUtil.nextDays(dataEmissao, diasDeslocamento);
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Boolean existeFeriado(Date data, Empresa empresa) {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("periodoFinal", data);
            request.setAttribute("periodoInicial", data);
            request.setAttribute("idEmpresa", empresa.getIdentificador());
            List feriados = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
            if (feriados != null && !feriados.isEmpty()) {
                return true;
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getMessage());
        }
        return false;
    }

    private void gerarTitulosCartaoCreditoTEF(CondicoesPagamento cp, Short numeroParcelas, Date dataEmissao, Empresa empresa, Double valor, NFCeControleCaixa nfceControleCaixa, List<Titulo> titulos, TipoBandeiraTEF tipoBandeira, MeioPagamento meioPagamento, OpcoesGerenciais op) throws ExceptionService, ExceptionDatabase {
        if (numeroParcelas > 0) {
            Double vlrTotalAcu = 0.0;
            Double vrDesp = 0.0;
            vrDesp = tipoBandeira.getDeducaoTaxa() == 0 ? Double.valueOf(valor * (tipoBandeira.getTaxaCartao() / 100.0)) : Double.valueOf(valor * (tipoBandeira.getTaxaCartao() / 100.0) / (double)numeroParcelas.shortValue());
            Double valorTitulo = valor / (double)numeroParcelas.shortValue();
            for (int i = 1; i <= numeroParcelas.intValue(); ++i) {
                Titulo titulo = new Titulo();
                titulo.setEmpresa(empresa);
                titulo.setDataCadastro(new Date());
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setNaoCompoeFluxo(Short.valueOf((short)0));
                titulo.setPessoa(tipoBandeira.getPessoa());
                titulo.setClassificacaoPessoa(this.getOpcoesFinanceiras(empresa).getClassificacaoClientes());
                if (tipoBandeira.getPessoa().getPessoaDadosFinanceiros() != null) {
                    titulo.setCartCobrancaDestino(tipoBandeira.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                titulo.setPagRec(Short.valueOf((short)1));
                titulo.setCarteiraCobranca(this.getCarteiraCobranca(empresa, titulo.getPagRec()));
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(dataEmissao);
                titulo.setDataEntradaSaida(dataEmissao);
                titulo.setPlanoConta(tipoBandeira.getPlanoConta());
                titulo.setTipoDoc(this.getOpcoesFinanceiras(empresa).getTipoDocFinanceiro());
                titulo.setDataVencimento(this.getDataVencimentoTituloCreditoTEF(dataEmissao, tipoBandeira.getDataFixa(), tipoBandeira.getDiaFixo(), tipoBandeira.getDiaVariavel(), tipoBandeira.getExcluiSabado(), tipoBandeira.getExcluiDomingo(), tipoBandeira.getExcluiFeriado(), empresa, i));
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                titulo.setNfCeControleCaixa(nfceControleCaixa);
                if (tipoBandeira.getDeducaoTaxa() == 0) {
                    if (i == 1) {
                        titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2));
                    }
                } else {
                    titulo.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)vrDesp, (int)2, (int)1));
                }
                if (i == numeroParcelas) {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor - vlrTotalAcu), (int)2, (int)5));
                } else {
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2, (int)1));
                }
                vlrTotalAcu = vlrTotalAcu + titulo.getValor();
                titulo.setNumParcTituloEstnota(Short.valueOf((short)i));
                titulo.setObservacao("Controle Caixa: " + nfceControleCaixa.getIdentificador() + ". TEF Credito: " + cp.getNome() + ". Parcela:ge" + titulo.getNumParcTituloEstnota() + "/" + numeroParcelas.toString() + ". Pessoa: " + tipoBandeira.getPessoa().getNome());
                this.setarPercJurosMultaDesconto(titulo, this.getOpcoesFinanceiras(empresa));
                titulo.setMeioPagamento(meioPagamento);
                this.gerarLancGerenciaisDebitoCredito(titulo, op, cp, meioPagamento, nfceControleCaixa);
                titulos.add(titulo);
            }
        }
    }

    private Date getDataVencimentoTituloCredito(Date dataEmissao, Short dataFixa, Integer diaFixo, Integer diaVariavel, Short excluirDiasNaoUteis, Empresa empresa, int parcela) {
        Date data = null;
        if (dataFixa.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            Integer diaFixoVencimento = diaFixo;
            Integer diaEmissao = DateUtil.dayFromDate(dataEmissao);
            Integer mesEmissao = DateUtil.monthFromDate(dataEmissao);
            Integer anoEmissao = DateUtil.yearFromDate(dataEmissao);
            if (diaEmissao < diaFixoVencimento) {
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            } else {
                if ((mesEmissao = Integer.valueOf(mesEmissao + parcela)) > 12) {
                    mesEmissao = mesEmissao - 12;
                    anoEmissao = anoEmissao + 1;
                }
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            }
        } else {
            data = DateUtil.nextDays(dataEmissao, diaVariavel * parcela);
        }
        Integer diaSemana = DateUtil.diaDaSemana(data);
        if (diaSemana.equals(7) && excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluirDiasNaoUteis != null && excluirDiasNaoUteis.equals(EnumConstantsMentorSimNao.SIM.getValue()) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluirDiasNaoUteis.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluirDiasNaoUteis.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getDataVencimentoTituloCreditoTEF(Date dataEmissao, Short dataFixa, Integer diaFixo, Integer diaVariavel, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa, int parcela) {
        Date data = null;
        if (dataFixa.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            Integer diaFixoVencimento = diaFixo;
            Integer diaEmissao = DateUtil.dayFromDate(dataEmissao);
            Integer mesEmissao = DateUtil.monthFromDate(dataEmissao);
            Integer anoEmissao = DateUtil.yearFromDate(dataEmissao);
            if (diaEmissao < diaFixoVencimento) {
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            } else {
                if ((mesEmissao = Integer.valueOf(mesEmissao + parcela)) > 12) {
                    mesEmissao = mesEmissao - 12;
                    anoEmissao = anoEmissao + 1;
                }
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            }
        } else {
            data = DateUtil.nextDays(dataEmissao, diaVariavel * parcela);
        }
        Integer diaSemana = DateUtil.diaDaSemana(data);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals(EnumConstantsMentorSimNao.SIM.getValue()) && this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getFormateDate(Integer diaFixoVencimento, Integer mesEmissao, Integer anoEmissao) {
        return DateUtil.intToDate(anoEmissao, mesEmissao, diaFixoVencimento);
    }

    private List<ChequeTerceiros> getChequesByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        ArrayList<ChequeTerceiros> cheques = new ArrayList();
        String hql = "select cheques.chequeTerceiros  from NFCe nfce  inner join  nfce.pagamentos nfcePag  inner join  nfcePag.chequeTerceiros cheques  where nfce.nfCeControleCaixa = :nfceControleCaixa  and (nfce.status = :autorizada  or nfce.status = :autorizadaForaPrazo)";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        cheques = q.list();
        if (cheques == null) {
            cheques = new ArrayList();
        }
        hql = "select cheques.chequeTerceiros  from NotaFiscalPropria nfe  inner join  nfe.infPagamentoNfPropria nfePag  inner join  nfePag.chequeTerceiros cheques  where nfe.nfceControleCaixa = :nfceControleCaixa  and (nfe.status = :autorizada  or nfe.status = :autorizadaForaPrazo)";
        Query q1 = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q1.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q1.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q1.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        List lista = q1.list();
        if (lista != null && !lista.isEmpty()) {
            cheques.addAll(lista);
        }
        return cheques;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    private MovimentoBancario getMovimentoCredito(NFCeControleCaixa nfceControleCaixa, BorderoChequeTerceirosMovBancario b, OpcoesContabeis opcoesContabeis) {
        CarteiraCobranca carteiraCobrancaDestino = nfceControleCaixa.getNfceCaixa().getCarteiraCobrancaDestino();
        if (carteiraCobrancaDestino != null) {
            MovimentoBancario movCred = new MovimentoBancario();
            movCred.setDataCadastro(new Date());
            movCred.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            movCred.setDataLancamento(nfceControleCaixa.getDataAbertura());
            movCred.setDebCred(Short.valueOf((short)1));
            movCred.setEmpresa(nfceControleCaixa.getNfceCaixa().getEmpresa());
            if (carteiraCobrancaDestino.getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("999")) {
                movCred.setDataCompensacao(new Date());
            }
            movCred.setHistorico("Border\u00ef\u00bf\u00bd Cheques credor sobre a carteira " + carteiraCobrancaDestino.getNome() + " em " + DateUtil.dateToStr(movCred.getDataLancamento()) + " sobre o cheque nr: " + b.getChequeTerceiros().getNumero());
            movCred.setContaValor(carteiraCobrancaDestino.getContaValor());
            movCred.setValor(b.getChequeTerceiros().getValor());
            b.setMovimentoBancarioCredito(movCred);
            ContraPartMovimentoBancario contCred = new ContraPartMovimentoBancario();
            contCred.setDebCred(Short.valueOf((short)0));
            contCred.setHistorico(movCred.getHistorico());
            contCred.setPlanoConta(movCred.getContaValor().getPlanoConta());
            contCred.setPlanoContaGerencial(opcoesContabeis.getPlanoChequeTerceirosGerencial());
            contCred.setValor(b.getChequeTerceiros().getValor());
            LancamentoCtbGerencial l = CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialMovimentoBancario(movCred, EnumLancamentoCTBGerencial.CREDITO.getValue(), contCred.getPlanoContaGerencial(), b.getChequeTerceiros().getValor());
            contCred.setLancamentoCtbGerencial(l);
            movCred.getContraPartMovimentoBancario().add(contCred);
            movCred.setChequeTerceiros(b.getChequeTerceiros());
            b.getChequeTerceiros().getMovimentosBancarios().add(movCred);
            return movCred;
        }
        return null;
    }

    private MovimentoBancario getMovimentoDebito(NFCeControleCaixa nfceControleCaixa, BorderoChequeTerceirosMovBancario b, OpcoesContabeis opcoesContabeis) {
        CarteiraCobranca carteiraCobrancaOrigem = nfceControleCaixa.getNfceCaixa().getCarteiraCobrancaOrigem();
        if (carteiraCobrancaOrigem != null) {
            MovimentoBancario movDeb = new MovimentoBancario();
            movDeb.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            movDeb.setDataCadastro(new Date());
            movDeb.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            movDeb.setDataLancamento(nfceControleCaixa.getDataAbertura());
            movDeb.setDataCompensacao(nfceControleCaixa.getDataAbertura());
            movDeb.setDebCred(Short.valueOf((short)0));
            movDeb.setEmpresa(nfceControleCaixa.getNfceCaixa().getEmpresa());
            movDeb.setHistorico("Bordero Cheques devedor sobre a carteira " + carteiraCobrancaOrigem.getNome() + " em " + DateUtil.dateToStr(movDeb.getDataLancamento()) + " sobre o cheque nr: " + b.getChequeTerceiros().getNumero());
            movDeb.setContaValor(carteiraCobrancaOrigem.getContaValor());
            movDeb.setValor(b.getChequeTerceiros().getValor());
            b.setMovimentoBancarioDebito(movDeb);
            ContraPartMovimentoBancario contDeb = new ContraPartMovimentoBancario();
            contDeb.setDebCred(Short.valueOf((short)1));
            contDeb.setPlanoConta(movDeb.getContaValor().getPlanoConta());
            contDeb.setHistorico(movDeb.getHistorico());
            contDeb.setPlanoContaGerencial(opcoesContabeis.getPlanoChequeTerceirosGerencial());
            contDeb.setValor(b.getChequeTerceiros().getValor());
            LancamentoCtbGerencial l = CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialMovimentoBancario(movDeb, EnumLancamentoCTBGerencial.DEBITO.getValue(), contDeb.getPlanoContaGerencial(), b.getChequeTerceiros().getValor());
            contDeb.setLancamentoCtbGerencial(l);
            movDeb.getContraPartMovimentoBancario().add(contDeb);
            movDeb.setChequeTerceiros(b.getChequeTerceiros());
            b.getChequeTerceiros().getMovimentosBancarios().add(movDeb);
            return movDeb;
        }
        return null;
    }

    private BorderoChequesTerceiros gerarBorderoChequesTerceiros(List<ChequeTerceiros> cheques, Empresa empresa, NFCeControleCaixa nFCeControleCaixa, OpcoesContabeis opcoesContabeis) throws ExceptionService {
        if (!ToolMethods.isWithData(cheques)) {
            return null;
        }
        StringBuilder erros = new StringBuilder();
        ArrayList<BorderoChequeTerceirosMovBancario> aux = new ArrayList<BorderoChequeTerceirosMovBancario>();
        for (ChequeTerceiros chequeTerceiros : cheques) {
            if (chequeTerceiros.getGrupoDeBaixaFormasPag() != null) {
                erros.append("Cheque foi utilizado em uma baixa. Remova o cheque da baixa para realizar o fechamento do caixa: " + String.valueOf(chequeTerceiros) + ", valor: " + ToolFormatter.formataNumero((Number)chequeTerceiros.getValor(), (int)2));
            }
            if (chequeTerceiros.getCompensacaoCheque() != null) {
                erros.append("Cheque foi compensado. Desfaca a compensacao para realizar o fechamento do caixa: " + String.valueOf(chequeTerceiros) + ", valor: " + ToolFormatter.formataNumero((Number)chequeTerceiros.getValor(), (int)2));
            }
            if (chequeTerceiros.getCarteiraCobranca() == null || ToolMethods.isEquals((Object)chequeTerceiros.getCarteiraCobranca(), (Object)nFCeControleCaixa.getNfceCaixa().getCarteiraCobrancaOrigem()) || ToolMethods.isEquals((Object)chequeTerceiros.getCarteiraCobranca(), (Object)nFCeControleCaixa.getNfceCaixa().getCarteiraCobrancaDestino())) continue;
            erros.append("Carteira do Cheque est\u00ef\u00bf\u00bd diferente da carteira do caixa. Provavelmente foi realizado um bordero antes de realizar o fechamento do caixa.\n Exclua o bordero para realizar o fechamento do caixa: " + String.valueOf(chequeTerceiros) + ", valor: " + ToolFormatter.formataNumero((Number)chequeTerceiros.getValor(), (int)2) + "\n");
        }
        if (erros.length() > 0) {
            throw new ExceptionService(erros.toString());
        }
        for (ChequeTerceiros chequeTerceiros : cheques) {
            if (chequeTerceiros.getGrupoDeBaixaFormasPag() != null || chequeTerceiros.getCompensacaoCheque() != null && chequeTerceiros.getCompensacaoCheque().getDataCompensacao() != null) continue;
            BorderoChequeTerceirosMovBancario bb = new BorderoChequeTerceirosMovBancario();
            bb.setChequeTerceiros(chequeTerceiros);
            bb.setMovimentoBancarioDebito(this.getMovimentoDebito(nFCeControleCaixa, bb, opcoesContabeis));
            bb.setMovimentoBancarioCredito(this.getMovimentoCredito(nFCeControleCaixa, bb, opcoesContabeis));
            aux.add(bb);
        }
        if (!aux.isEmpty()) {
            BorderoChequesTerceiros vo = new BorderoChequesTerceiros();
            vo.setEmpresa(empresa);
            vo.setDataBordero(nFCeControleCaixa.getDataFechamento());
            vo.setCarteiraCobranca(nFCeControleCaixa.getNfceCaixa().getCarteiraCobrancaDestino());
            vo.setDataCadastro(new Date());
            vo.setChequesTerceirosMovBancarios(aux);
            vo.setCarteiraOrigem(nFCeControleCaixa.getNfceCaixa().getCarteiraCobrancaOrigem());
            for (Object o : vo.getChequesTerceirosMovBancarios()) {
                BorderoChequeTerceirosMovBancario b = (BorderoChequeTerceirosMovBancario)o;
                b.setBorderoChequeTerceiros(vo);
            }
            this.atualizarCarteiraCobrancaCh(vo);
            ServiceBorderoChequesTerceirosImpl serviceBorderoChequesTerceirosImpl = (ServiceBorderoChequesTerceirosImpl)Context.get(ServiceBorderoChequesTerceirosImpl.class);
            serviceBorderoChequesTerceirosImpl.beforeSaveBordero(vo);
            return vo;
        }
        return null;
    }

    private void atualizarCarteiraCobrancaCh(BorderoChequesTerceiros vo) {
        for (Object o : vo.getChequesTerceirosMovBancarios()) {
            BorderoChequeTerceirosMovBancario b = (BorderoChequeTerceirosMovBancario)o;
            ChequeTerceiros ch = b.getChequeTerceiros();
            ch.setCarteiraCobranca(vo.getCarteiraCobranca());
        }
    }

    private StringBuilder isValidAddChequeByCriacaoBordero(NFCeControleCaixa controleCaixa) {
        StringBuilder warning = new StringBuilder();
        boolean possuiErro = false;
        if (controleCaixa.getNfceCaixa().getCarteiraCobrancaOrigem() == null) {
            warning.append("Primeiro, informe a carteira de cobranca de origem no cadastro do Caixa Fiscal NFCe! \n");
            possuiErro = true;
        }
        if (controleCaixa.getNfceCaixa().getCarteiraCobrancaDestino() == null) {
            warning.append("Primeiro, informe a carteira de cobranca de destino no cadastro do Caixa Fiscal NFCe! \n");
            possuiErro = true;
        }
        if (possuiErro) {
            return new StringBuilder().append("Para geracao do Bordero de Cheque de Terceiros: \n\n").append((CharSequence)warning);
        }
        return null;
    }

    private void gerarMovimentoBancarioPixAgrupado(Date dataEmissao, Empresa empresa, Double valor, CondicoesPagamento condPag, NFCeControleCaixa nfceControleCaixa, HashMap movimentos) {
        MovimentoBancario m = new MovimentoBancario();
        m.setDataCadastro(new Date());
        m.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)dataEmissao));
        m.setDataCompensacao(this.getDataMovimentoEmFimDeSemanaOrFeriado(condPag, ContatoDateUtil.toTimestamp((Date)dataEmissao), empresa));
        m.setEmpresa(empresa);
        m.setDebCred(Short.valueOf((short)1));
        m.setContaValor(condPag.getContaValorPix());
        m.setHistorico("Movimento Financeiro (PIX) gerado pelo Controle de Caixa Fiscal: " + nfceControleCaixa.getIdentificador() + " com venda em PIX do dia " + DateUtil.dateToStr(dataEmissao));
        m.setValor(valor);
        m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        if (movimentos.get("MOVIMENTO_BANCARIO_PIX") != null) {
            List lista = (List)movimentos.get("MOVIMENTO_BANCARIO_PIX");
            lista.add(m);
            movimentos.put("MOVIMENTO_BANCARIO_PIX", lista);
        } else {
            ArrayList<MovimentoBancario> lista = new ArrayList<MovimentoBancario>();
            lista.add(m);
            movimentos.put("MOVIMENTO_BANCARIO_PIX", lista);
        }
    }

    private void getPagamentosAndMovimentosPixNaoAgrupados(NFCeControleCaixa nfceControleCaixa, HashMap movimentos) throws ExceptionDatabase {
        List<HashMap> pagamentos = this.getPagamentosPixNaoAgrupados(nfceControleCaixa);
        this.gerarMovimentoBancarioPixNaoAgrupado(pagamentos, movimentos, nfceControleCaixa);
    }

    private List<HashMap> getPagamentosPixNaoAgrupados(NFCeControleCaixa nfceControleCaixa) throws ExceptionDatabase {
        ArrayList<HashMap> pagamentos = new ArrayList<HashMap>();
        pagamentos.addAll(this.getPagamentosNFCePixNaoAgrupados(nfceControleCaixa));
        pagamentos.addAll(this.getPagamentosNFePixNaoAgrupados(nfceControleCaixa));
        return pagamentos;
    }

    private List getPagamentosNFCePixNaoAgrupados(NFCeControleCaixa nfceControleCaixa) throws ExceptionDatabase {
        String hql = "select p.valorLiquido             AS VALOR, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, p.numeroParcelas                    AS NUMERO_PARCELAS, nfce.dataEmissao                    AS DATA_EMISSAO, nfce.empresa.identificador          AS ID_EMPRESA,  p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from NFCePagamento p  inner join p.nfce nfce  inner join nfce.nfCeControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and p.tipoPagamentoNFe.codigo = :pix and p.status = :ativo ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setShort("ativo", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            Empresa empresa = (Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey((Long)h.get("ID_EMPRESA"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
        }
        return lista;
    }

    private List getPagamentosNFePixNaoAgrupados(NFCeControleCaixa nfceControleCaixa) throws ExceptionDatabase {
        String hql = "select p.valor                    AS VALOR, p.numeroParcelas                    AS NUMERO_PARCELAS, p.condicoesPagamento.identificador  AS ID_CONDICOES_PAGAMENTO, nfce.dataEmissaoNota                AS DATA_EMISSAO, nfce.empresa.identificador          AS ID_EMPRESA,  p.tipoPagamentoNFe.codigo           AS TIPO,  p.meioPagamento.identificador       AS ID_MEIO_PAGAMENTO,  p.permitirTEF                       AS PERMITIR_TEF, b.identificador                     AS ID_BANDEIRA_TEF  from InfPagamentoNfPropria p  inner join p.notaFiscalPropria nfce  inner join nfce.naturezaOperacao nat  inner join nfce.nfceControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and p.tipoPagamentoNFe.codigo = :pix";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            CondicoesPagamento cp = (CondicoesPagamento)CoreDAOFactory.getInstance().getDAOCondicoesPagamento().findByPrimaryKey((Long)h.get("ID_CONDICOES_PAGAMENTO"));
            Empresa empresa = (Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey((Long)h.get("ID_EMPRESA"));
            MeioPagamento meioPagamento = (MeioPagamento)CoreDAOFactory.getInstance().getDAOMeioPagamento().findByPrimaryKey((Long)h.get("ID_MEIO_PAGAMENTO"));
            if (h.get("ID_BANDEIRA_TEF") != null) {
                h.put("BANDEIRA_TEF", CoreDAOFactory.getInstance().getDAOBandeiraTEF().findByPrimaryKey((Long)h.get("ID_BANDEIRA_TEF")));
            }
            h.put("EMPRESA", empresa);
            h.put("MEIO_PAGAMENTO", meioPagamento);
            h.put("CONDICOES_PAGAMENTO", cp);
        }
        return lista;
    }

    private void gerarMovimentoBancarioPixNaoAgrupado(List<HashMap> pagamentos, HashMap movimentos, NFCeControleCaixa nfceControleCaixa) {
        ArrayList<MovimentoBancario> lista = new ArrayList<MovimentoBancario>();
        for (HashMap h : pagamentos) {
            CondicoesPagamento condicoesPagamento = (CondicoesPagamento)h.get("CONDICOES_PAGAMENTO");
            Short numeroParcelas = (Short)h.get("NUMERO_PARCELAS");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Empresa empresa = (Empresa)h.get("EMPRESA");
            Double valor = (Double)h.get("VALOR");
            String tipo = (String)h.get("TIPO");
            Short permitirTEF = (Short)h.get("PERMITIR_TEF");
            MeioPagamento meioPagamento = (MeioPagamento)h.get("MEIO_PAGAMENTO");
            BandeiraTEF bandeiraTEF = (BandeiraTEF)h.get("BANDEIRA_TEF");
            MovimentoBancario m = new MovimentoBancario();
            m.setDataCadastro(new Date());
            m.setDataLancamento((Date)ContatoDateUtil.toTimestamp((Date)dataEmissao));
            m.setDataCompensacao(this.getDataMovimentoEmFimDeSemanaOrFeriado(condicoesPagamento, ContatoDateUtil.toTimestamp((Date)dataEmissao), empresa));
            m.setEmpresa(empresa);
            m.setDebCred(Short.valueOf((short)1));
            m.setContaValor(condicoesPagamento.getContaValorPix());
            m.setHistorico("Movimento Financeiro (PIX) gerado pelo Controle de Caixa Fiscal: " + nfceControleCaixa.getIdentificador() + " com venda em PIX do dia " + DateUtil.dateToStr(dataEmissao));
            m.setValor(valor);
            m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            lista.add(m);
            movimentos.put("MOVIMENTO_BANCARIO_PIX", lista);
        }
    }

    private List getDadosGerenciaisDebitoCredito(NFCeControleCaixa nfceControleCaixa, CondicoesPagamento condPag, MeioPagamento meioPag) throws ExceptionDatabase {
        List dadosGerenciais = this.getDadosGerenciaisNFCeDebitoCredito(nfceControleCaixa, condPag, meioPag);
        dadosGerenciais = this.getDadosGerenciaisNFeDebitoCredito(nfceControleCaixa, dadosGerenciais, condPag, meioPag);
        return dadosGerenciais;
    }

    private List getDadosGerenciaisNFCeDebitoCredito(NFCeControleCaixa nfceControleCaixa, CondicoesPagamento condicoesPagamento, MeioPagamento meioPagamento) throws ExceptionDatabase {
        String hql = "select sum(i.valorTotal)        AS VALOR, i.produto.planoContaGerencial.identificador as ID_PC_GERENCIAL from NFCePagamento p  inner join p.nfce nfce  inner join nfce.itens i  inner join nfce.nfCeControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo = :debito        or p.tipoPagamentoNFe.codigo = :credito ) and p.condicoesPagamento = :condPagamento and p.meioPagamento = :meioPagamento and p.status = :ativo  and i.status = :ativo group by  i.produto.planoContaGerencial.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        q.setShort("ativo", (short)1);
        q.setEntity("meioPagamento", (Object)meioPagamento);
        q.setEntity("condPagamento", (Object)condicoesPagamento);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ServicePlanoContaGerencialImpl service = (ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class);
        for (HashMap h : lista) {
            Long idPcGerencial = (Long)h.get("ID_PC_GERENCIAL");
            PlanoContaGerencial pc = (PlanoContaGerencial)service.get((Serializable)idPcGerencial);
            h.put("PC_GERENCIAL", pc);
        }
        return lista;
    }

    private List getDadosGerenciaisNFeDebitoCredito(NFCeControleCaixa nfceControleCaixa, List<HashMap> pagamentos, CondicoesPagamento condPag, MeioPagamento meioPag) throws ExceptionDatabase {
        String hql = "select sum(i.itemNotaLivroFiscal.valorTotal)               AS VALOR, i.produto.planoContaGerencial.identificador as ID_PC_GERENCIAL from InfPagamentoNfPropria p  inner join p.notaFiscalPropria nfce  inner join nfce.naturezaOperacao nat  inner join nfce.nfceControleCaixa cf inner join nfce.itensNotaPropria i  left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo = :debito        or p.tipoPagamentoNFe.codigo = :credito)  and p.condicoesPagamento = :condPagamento and p.meioPagamento = :meioPagamento  group by  i.produto.planoContaGerencial.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("debito", EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo());
        q.setString("credito", EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
        q.setEntity("condPagamento", (Object)condPag);
        q.setEntity("meioPagamento", (Object)meioPag);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            Double valor = (Double)h.get("VALOR");
            Long idPcGerencial = (Long)h.get("ID_PC_GERENCIAL");
            Boolean achou = false;
            for (HashMap pag : pagamentos) {
                Double valorPag = (Double)pag.get("VALOR");
                Long idPcGerencialPag = (Long)pag.get("ID_PC_GERENCIAL");
                if (!idPcGerencial.equals(idPcGerencialPag)) continue;
                pag.put("VALOR", valor + valorPag);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ServicePlanoContaGerencialImpl service = (ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class);
            PlanoContaGerencial pc = (PlanoContaGerencial)service.get((Serializable)idPcGerencial);
            h.put("PC_GERENCIAL", pc);
            pagamentos.add(h);
        }
        return pagamentos;
    }

    private void gerarLancGerenciaisDebitoCredito(Titulo titulo, OpcoesGerenciais op, CondicoesPagamento cp, MeioPagamento meioPagamento, NFCeControleCaixa nfceControleCaixa) throws ExceptionDatabase {
        if (ToolMethods.isEquals((Object)op.getGerarLancGerencialTituloNFCeControleCaixa(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            List dadosGerenciais = this.getDadosGerenciaisDebitoCredito(nfceControleCaixa, cp, meioPagamento);
            Double valorGerencialTotal = 0.0;
            for (HashMap h : dadosGerenciais) {
                valorGerencialTotal = valorGerencialTotal + (Double)h.get("VALOR");
            }
            for (HashMap h : dadosGerenciais) {
                PlanoContaGerencial pcGerencial = (PlanoContaGerencial)h.get("PC_GERENCIAL");
                Double valorGerencial = (double)((Double)h.get("VALOR"));
                Double percentual = ToolFormatter.arrredondarNumero((Double)(valorGerencial * 100.0 / valorGerencialTotal), (int)6);
                Double valorLancamento = ToolFormatter.arrredondarNumero((Double)(titulo.getValor() * (percentual / 100.0)), (int)2);
                CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencialNFCeControleCaixa((PlanoContaGerencial)pcGerencial, (Double)valorLancamento, (OpcoesGerenciais)op, (Titulo)titulo);
            }
        }
    }

    private Date getDataMovimentoEmFimDeSemanaOrFeriado(CondicoesPagamento condPag, Date dataEmissao, Empresa emp) {
        Date data = ContatoDateUtil.toTimestamp((Date)dataEmissao);
        if (!ToolMethods.isEquals((Object)condPag.getExcluirDiasNaoUteis(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            return data;
        }
        List feriado = ((ServiceFeriadoImpl)Context.get(ServiceFeriadoImpl.class)).findFeriadosNacionalPorPeriodo(data, data, emp.getIdentificador());
        while (ToolDate.isWeekend((Date)data).booleanValue() || !feriado.isEmpty()) {
            data = ToolDate.nextDays((Date)data, (int)1);
            feriado = ((ServiceFeriadoImpl)Context.get(ServiceFeriadoImpl.class)).findFeriadosNacionalPorPeriodo(data, data, emp.getIdentificador());
        }
        return data;
    }

    private void gerarLancGerenciaisDinheiroPixCheque(Double valor, OpcoesGerenciais op, CondicoesPagamento cp, MeioPagamento meioPagamento, NFCeControleCaixa nfceControleCaixa) throws ExceptionDatabase {
        if (ToolMethods.isEquals((Object)op.getGerarLancGerencialTituloNFCeControleCaixa(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            List dadosGerenciais = this.getDadosGerenciaisDinheiroPixCheque(nfceControleCaixa, cp, meioPagamento);
            Double valorGerencialTotal = 0.0;
            for (HashMap h : dadosGerenciais) {
                valorGerencialTotal = valorGerencialTotal + (Double)h.get("VALOR");
            }
            for (HashMap h : dadosGerenciais) {
                PlanoContaGerencial pcGerencial = (PlanoContaGerencial)h.get("PC_GERENCIAL");
                Double valorGerencial = (double)((Double)h.get("VALOR"));
                Double percentual = ToolFormatter.arrredondarNumero((Double)(valorGerencial * 100.0 / valorGerencialTotal), (int)6);
                Double valorLancamento = ToolFormatter.arrredondarNumero((Double)(valor * (percentual / 100.0)), (int)2);
                CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencialNFCeControleCaixaOutrosPagamentos((PlanoContaGerencial)pcGerencial, (Double)valorLancamento, (OpcoesGerenciais)op, (NFCeControleCaixa)nfceControleCaixa, (CondicoesPagamento)cp, (MeioPagamento)meioPagamento);
            }
        }
    }

    private List getDadosGerenciaisDinheiroPixCheque(NFCeControleCaixa nfceControleCaixa, CondicoesPagamento condPag, MeioPagamento meioPag) throws ExceptionDatabase {
        List dadosGerenciais = this.getDadosGerenciaisNFCeDinheiroPixCheque(nfceControleCaixa, condPag, meioPag);
        dadosGerenciais = this.getDadosGerenciaisNFeDinheiroPixCheque(nfceControleCaixa, dadosGerenciais, condPag, meioPag);
        return dadosGerenciais;
    }

    private List getDadosGerenciaisNFCeDinheiroPixCheque(NFCeControleCaixa nfceControleCaixa, CondicoesPagamento condicoesPagamento, MeioPagamento meioPagamento) throws ExceptionDatabase {
        String hql = "select sum(i.valorTotal)        AS VALOR, i.produto.planoContaGerencial.identificador as ID_PC_GERENCIAL from NFCePagamento p  inner join p.nfce nfce  inner join nfce.itens i  inner join nfce.nfCeControleCaixa cf left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo = :dinheiro        or p.tipoPagamentoNFe.codigo = :pix       or p.tipoPagamentoNFe.codigo = :cheque) and p.condicoesPagamento = :condPagamento and p.meioPagamento = :meioPagamento and p.status = :ativo  and i.status = :ativo group by  i.produto.planoContaGerencial.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("dinheiro", EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setString("cheque", EnumConstNFeTipoPagNFe.CHEQUE.getCodigo());
        q.setShort("ativo", (short)1);
        q.setEntity("meioPagamento", (Object)meioPagamento);
        q.setEntity("condPagamento", (Object)condicoesPagamento);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ServicePlanoContaGerencialImpl service = (ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class);
        for (HashMap h : lista) {
            Long idPcGerencial = (Long)h.get("ID_PC_GERENCIAL");
            PlanoContaGerencial pc = (PlanoContaGerencial)service.get((Serializable)idPcGerencial);
            h.put("PC_GERENCIAL", pc);
        }
        return lista;
    }

    private List getDadosGerenciaisNFeDinheiroPixCheque(NFCeControleCaixa nfceControleCaixa, List<HashMap> pagamentos, CondicoesPagamento condPag, MeioPagamento meioPag) throws ExceptionDatabase {
        String hql = "select sum(i.itemNotaLivroFiscal.valorTotal)               AS VALOR, i.produto.planoContaGerencial.identificador as ID_PC_GERENCIAL from InfPagamentoNfPropria p  inner join p.notaFiscalPropria nfce  inner join nfce.naturezaOperacao nat  inner join nfce.nfceControleCaixa cf inner join nfce.itensNotaPropria i  left  join p.bandeiraTEF b where cf = :nfceControleCaixa  and nfce.status  <> :cancelada  and nfce.status  <> :canceladaForaPrazo  and nfce.status  <> :inutilizada  and (   p.tipoPagamentoNFe.codigo  = :dinheiro        or p.tipoPagamentoNFe.codigo  = :pix        or p.tipoPagamentoNFe.codigo  = :cheque)  and p.condicoesPagamento = :condPagamento and p.meioPagamento = :meioPagamento  group by  i.produto.planoContaGerencial.identificador ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
        q.setInteger("cancelada", EnumConstNFeStatus.CANCELADA.getValue().intValue());
        q.setInteger("canceladaForaPrazo", EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue().intValue());
        q.setInteger("inutilizada", EnumConstNFeStatus.INUTILIZADA.getValue().intValue());
        q.setString("dinheiro", EnumConstNFeTipoPagNFe.DINHEIRO.getCodigo());
        q.setString("pix", EnumConstNFeTipoPagNFe.PIX.getCodigo());
        q.setString("cheque", EnumConstNFeTipoPagNFe.CHEQUE.getCodigo());
        q.setEntity("condPagamento", (Object)condPag);
        q.setEntity("meioPagamento", (Object)meioPag);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            Double valor = (Double)h.get("VALOR");
            Long idPcGerencial = (Long)h.get("ID_PC_GERENCIAL");
            Boolean achou = false;
            for (HashMap pag : pagamentos) {
                Double valorPag = (Double)pag.get("VALOR");
                Long idPcGerencialPag = (Long)pag.get("ID_PC_GERENCIAL");
                if (!idPcGerencial.equals(idPcGerencialPag)) continue;
                pag.put("VALOR", valor + valorPag);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ServicePlanoContaGerencialImpl service = (ServicePlanoContaGerencialImpl)ConfApplicationContext.getBean(ServicePlanoContaGerencialImpl.class);
            PlanoContaGerencial pc = (PlanoContaGerencial)service.get((Serializable)idPcGerencial);
            h.put("PC_GERENCIAL", pc);
            pagamentos.add(h);
        }
        return pagamentos;
    }

    private boolean getPagamentoDebitoAlimentacaoRefeicaoCombustivel(MeioPagamento meioPagamento) {
        return meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_DEBITO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_ALIMENTACAO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_REFEICAO.getCodigo()) || meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.VALE_COMBUSTIVEL.getCodigo());
    }

    private boolean getPagamentoCredito(MeioPagamento meioPagamento) {
        return meioPagamento.getTipoPagamentoNFe().getCodigo().equals(EnumConstNFeTipoPagNFe.CARTAO_CREDITO.getCodigo());
    }

    public List findPedidosByControleCaixa(NFCeControleCaixa nfceControleCaixa, NFCeOpcoes nfceOpcoes) {
        if (nfceOpcoes != null && nfceOpcoes.getSituacaoPedidosVendaConsignada() != null) {
            String hql = "select t.valor                                    as VALOR,  nfePag.meioPagamento.descricao                      as FORMA_PAGAMENTO, nfe.identificador                                   as NR_COO, nfe.valorTotal                                      as VALOR_TOTAL_BRUTO,  nfe.dataEmissao                                     as DATA_EMISSAO,  nfePag.tipoPagamentoNFe.codigo                      as TIPO_PAGAMENTO from Pedido nfe  inner join  nfe.infPagamentoPedido nfePag  inner join nfePag.titulos t   where nfe.nfceControleCaixa = :nfceControleCaixa  and (nfe.situacaoPedido = :situacaoConsignado) and t.provisao = :realizado order by nfe.identificador";
            Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
            q.setEntity("nfceControleCaixa", (Object)nfceControleCaixa);
            q.setEntity("situacaoConsignado", (Object)nfceOpcoes.getSituacaoPedidosVendaConsignada());
            q.setShort("realizado", (short)1);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            for (HashMap h : lista) {
                h.put("VALOR_TROCO", 0.0);
                h.put("CANCELADO", EnumConstNFeStatus.AUTORIZADA.getValue());
                h.put("STATUS", EnumConstNFeStatus.AUTORIZADA.getValue());
            }
            return lista;
        }
        return new ArrayList();
    }
}

