/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.nfe.NFeBuildText;
import mentorcore.utilities.impl.xmlstore.UtilXMLStore;

class AuxEmailEventoNFe_V400 {
    private static TLogger logger = TLogger.get(AuxEmailEventoNFe_V400.class);

    AuxEmailEventoNFe_V400() {
    }

    private static boolean sendEmailEventoNFe(EventoNFe ev, OpcoesRelacionamento op) throws ExceptionService {
        if (ev instanceof EvtNFeCancelamento) {
            EvtNFeCancelamento e = (EvtNFeCancelamento)ev;
            if (e.getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails() == null) {
                return false;
            }
            if (e.getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails().isEmpty()) {
                return false;
            }
            if (!NFeConstStatusEventoNFe.isEventoValido((Short)e.getStatus())) {
                return false;
            }
        } else if (ev instanceof EvtNFeCartaCorrecao) {
            EvtNFeCartaCorrecao e = (EvtNFeCartaCorrecao)ev;
            if (e.getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails() == null) {
                return false;
            }
            if (e.getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails().isEmpty()) {
                return false;
            }
            if (!NFeConstStatusEventoNFe.isEventoValido((Short)e.getStatus())) {
                return false;
            }
        }
        return true;
    }

    private static HashSet<String> getRecipientesEventoNFE(Pessoa p, Transportador transportador, OpcoesRelacionamento op) {
        HashSet<String> emails = new HashSet<String>();
        if (p.getComplemento().getEmails() != null) {
            for (EmailPessoa o : p.getComplemento().getEmails()) {
                if (o.getAtivo() == null || o.getAtivo() != 1 || o.getEnviarDadosNfe() == null || o.getEnviarDadosNfe() != 1 || o.getEmail() == null || o.getEmail().trim().length() <= 0) continue;
                emails.add(o.getEmail());
            }
        }
        String email = op.getEmailCopiaEventoNFe();
        if (op.getEnviarCopiaEventoNFe() != null && op.getEnviarCopiaEventoNFe() == 1 && email != null && email.trim().length() > 0) {
            emails.add(email);
        }
        if (transportador != null && op != null && op.getEnviarXMLNFeTransportadora() != null && op.getEnviarXMLNFeTransportadora() == 1 && transportador.getPessoa().getComplemento().getEmails() != null) {
            for (EmailPessoa o : transportador.getPessoa().getComplemento().getEmails()) {
                if (o.getAtivo() == null || o.getAtivo() != 1 || o.getEnviarDadosNfe() == null || o.getEnviarDadosNfe() != 1 || o.getEmail() == null || o.getEmail().trim().length() <= 0) continue;
                emails.add(o.getEmail());
            }
        }
        return emails;
    }

    private static File gerarXMLEventoNFe(EventoNFe e) throws ExceptionService {
        try {
            return UtilXMLStore.getNFeXMLEventoNFeFile(e);
        }
        catch (ExceptionFileManipulation ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar o xml de Cancelamento.");
        }
    }

    private static List getAnexosEventoNFe(EventoNFe e) throws IOException, ExceptionService {
        File f;
        ArrayList<File> anexos = new ArrayList<File>();
        if (e != null && NFeConstStatusEventoNFe.isStatusFinal((Short)e.getStatus()) && (f = AuxEmailEventoNFe_V400.gerarXMLEventoNFe(e)) != null) {
            anexos.add(f);
        }
        return anexos;
    }

    public static Email criarEmailEventoNFe(EventoNFe ev, OpcoesRelacionamento op, Usuario usuario) throws ExceptionService, IOException {
        Email email = null;
        if (ev instanceof EvtNFeManifestoDest || ev instanceof EvtNFeEpec) {
            return null;
        }
        if (op != null && op.getServidorEmailEventoNFe() != null && op.getModeloEmailEventoNFe() != null && AuxEmailEventoNFe_V400.sendEmailEventoNFe(ev, op)) {
            ServidorEmail servidor = op.getServidorEmailEventoNFe();
            email = new Email(true);
            email.setRemetente(servidor.getEmail());
            email.setAssunto(op.getModeloEmailEventoNFe().getTituloEmail());
            String texto = AuxEmailEventoNFe_V400.getTextoEmailEventoNFe(new String(op.getModeloEmailEventoNFe().getModelo()), ev);
            texto = texto.replace("\n", "<BR>");
            email.setCorpoMensagem(texto);
            email.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), servidor.getEmail(), servidor.getSenha(), servidor.getPortaEmail(), servidor.getNaoAutenticarEmail(), servidor.getLogin(), servidor.getServerProperties(), servidor.getGerarArquivoExtensaoEml(), servidor.getDebugServer()));
            email.addAnexos(AuxEmailEventoNFe_V400.getAnexosEventoNFe(ev));
            email.setZiparAnexos(servidor.getZiparEmails() != null && servidor.getZiparEmails() == 1);
            if (ev instanceof EvtNFeCancelamento) {
                email.setDestinatariosStr(AuxEmailEventoNFe_V400.getRecipientesEventoNFE(((EvtNFeCancelamento)ev).getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa(), ((EvtNFeCancelamento)ev).getNotaFiscalPropria().getDadosTransNfPropria().getTransportador(), op));
            } else if (ev instanceof EvtNFeCartaCorrecao) {
                email.setDestinatariosStr(AuxEmailEventoNFe_V400.getRecipientesEventoNFE(((EvtNFeCartaCorrecao)ev).getNotaFiscalPropria().getUnidadeFatCliente().getCliente().getPessoa(), ((EvtNFeCartaCorrecao)ev).getNotaFiscalPropria().getDadosTransNfPropria().getTransportador(), op));
            }
        }
        return email;
    }

    private static String getTextoEmailEventoNFe(String modelo, EventoNFe e) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = NFeBuildText.getInstance().getValueEmailEventoNFe(tk.getChave(), e);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    static void criarEnviarEmailEventoNFe(EventoNFe p, OpcoesRelacionamento op, Usuario usuario) throws ExceptionService, ExceptionService, IOException, Exception {
        Email e = AuxEmailEventoNFe_V400.criarEmailEventoNFe(p, op, usuario);
        if (e != null) {
            String assunto = AuxEmailEventoNFe_V400.getDadosLogEmail(p);
            ToolSendEmail.sendEmailWithException((Email)e);
        }
    }

    private static String getDadosLogEmail(EventoNFe eventoNFe) {
        StringBuilder sb = new StringBuilder();
        if (eventoNFe instanceof EvtNFeCancelamento) {
            sb.append("Id Evento Cancelamento NFe: ");
        } else if (eventoNFe instanceof EvtNFeCartaCorrecao) {
            sb.append("Id Evento Carta Correcao NFe: ");
        } else if (eventoNFe instanceof EvtNFeManifestoDest) {
            sb.append("Id Evento Manifesto: ");
        }
        sb.append(eventoNFe.getIdentificador());
        return sb.toString();
    }
}

