/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.email.builders.CompEmailBuilderNotaFiscalPropria;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ResultProcessGerBol;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.nfe.NFeBuildText;
import mentorcore.utilities.impl.xmlstore.UtilXMLStore;

public class AuxEmailNFe_V400 {
    private static final TLogger logger = TLogger.get(AuxEmailNFe_V400.class);

    public static Email criarEmail(NotaFiscalPropria n, Usuario usuario, Grupo grupoUsuarios, OpcoesRelacionamento op, OpcoesFinanceiras of) throws IOException, ExceptionGeracaoBoletos, ExceptionGeracaoTitulos {
        Email e = new Email();
        if (op != null && op.getServidorEmailFaturamento() != null && op.getModeloEmailFaturamento() != null) {
            try {
                if (AuxEmailNFe_V400.sendEmail(n, op)) {
                    String corpoMensagem;
                    String assunto;
                    if (ToolMethods.isNotNull((Object)op.getModeloEmailFaturamento().getObjectObsDinamica()).booleanValue() && (ToolMethods.isEquals((Object)op.getModeloEmailFaturamento().getObjectObsDinamica().getClasse(), Class.forName(NotaFiscalPropria.class.getName())) || ToolMethods.isEquals((Object)op.getModeloEmailFaturamento().getObjectObsDinamica().getClasse(), (Object)NotaFiscalPropria.class.getName()))) {
                        assunto = ((CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class)).build((Object)n, op.getModeloEmailFaturamento().getTituloEmail());
                        corpoMensagem = ((CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class)).build((Object)n, op.getModeloEmailFaturamento().getObjectObsDinamica().getObservacao());
                    } else {
                        assunto = op.getModeloEmailFaturamento().getTituloEmail();
                        corpoMensagem = AuxEmailNFe_V400.getTextoEmail(op.getModeloEmailFaturamento().getModelo(), n, usuario).replace("\n", "<BR>");
                    }
                    CompEmailBuilderNotaFiscalPropria comp = (CompEmailBuilderNotaFiscalPropria)ConfApplicationContext.getBean(CompEmailBuilderNotaFiscalPropria.class);
                    comp.criarEmailAutorizado(n, op.getServidorEmailFaturamento(), op.getModeloEmailFaturamento(), assunto, corpoMensagem, op, AuxEmailNFe_V400.getAnexos(n, of, usuario, grupoUsuarios));
                }
            }
            catch (ExceptionInvalidData | ExceptionEmail | ExceptionReflection | ClassNotFoundException | ExceptionService ex) {
                logger.error(ex.getMessage());
                return null;
            }
        }
        return e;
    }

    private static String getTextoEmail(String modelo, NotaFiscalPropria nota, Usuario usuario) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = NFeBuildText.getInstance().getValueEmail(tk.getChave(), nota, usuario);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    private static List getAnexos(NotaFiscalPropria nf, OpcoesFinanceiras of, Usuario usuario, Grupo grupoUsuarios) throws IOException, ExceptionService, ExceptionGeracaoBoletos, ExceptionGeracaoTitulos {
        ArrayList<File> anexos = new ArrayList<File>();
        if (nf != null && nf.getStatus() != null && EnumConstNFeStatus.isStatusAutorizada((Integer)nf.getStatus().intValue())) {
            File f;
            if (ToolMethods.isEquals((Object)of.getEnviarBoletoJuntoNFe(), (Object)1)) {
                ServiceBoletoTituloImpl serviceBoleto = (ServiceBoletoTituloImpl)Context.get(ServiceBoletoTituloImpl.class);
                ArrayList titulos = new ArrayList();
                for (InfPagamentoNfPropria i : nf.getInfPagamentoNfPropria()) {
                    if (!ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"15")) continue;
                    titulos.addAll(i.getTitulos());
                }
                ArrayList<Titulo> titulosAGerarBoleto = new ArrayList<Titulo>();
                for (Titulo titulo : titulos) {
                    CarteiraCobranca c = titulo.getCartCobrancaDestino();
                    if (ToolMethods.isNull((Object)c).booleanValue()) {
                        c = titulo.getCarteiraCobranca();
                    }
                    if (!ToolMethods.isEquals((Object)c.getEnviarBoletoJuntoNFe(), (Object)1)) continue;
                    titulosAGerarBoleto.add(titulo);
                }
                if (ToolMethods.isWithData(titulosAGerarBoleto)) {
                    for (Titulo titulo : titulosAGerarBoleto) {
                        ArrayList<Titulo> aux = new ArrayList<Titulo>();
                        aux.add(titulo);
                        ResultProcessGerBol resBoleto = CoreUtilityFactory.getUtilityBoleto().converterSalvarEGerarBoletoTitulo(aux, of, false, usuario, grupoUsuarios, nf.getEmpresa(), true);
                        List<DataOutputBI> arqBoletos = AuxEmailNFe_V400.gerarBoletoTitulo(resBoleto.getBoletos(), usuario, grupoUsuarios, nf.getEmpresa(), ((BoletoTitulo)resBoleto.getBoletos().get(0)).getTitulo().getConfiguracaoCnab().getTipoNumeroTitulo());
                        for (DataOutputBI d : arqBoletos) {
                            anexos.add(d.getFile());
                        }
                    }
                }
            }
            if ((f = UtilXMLStore.gerarDANFE(nf)) != null) {
                anexos.add(f);
            }
            if ((f = UtilXMLStore.gerarXML(nf)) != null) {
                anexos.add(f);
            }
        }
        return anexos;
    }

    private static List<DataOutputBI> gerarBoletoTitulo(List<BoletoTitulo> boletos, Usuario usuario, Grupo grupoUsuarios, Empresa empresa, Short tipoNumeroTitulo) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("boletos", boletos);
        r.setAttribute("usuario", usuario);
        r.setAttribute("grupoUsuarios", grupoUsuarios);
        r.setAttribute("empresa", empresa);
        r.setAttribute("tipoNumero", tipoNumeroTitulo);
        return (List)CoreServiceFactory.getServiceBoletoTitulo().execute(r, "gerarBoletoTitulo");
    }

    private static boolean sendEmail(NotaFiscalPropria p, OpcoesRelacionamento op) throws ExceptionService {
        Short aux;
        Boolean retValue = true;
        if (p.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails() == null) {
            retValue = false;
        }
        if (p.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails().isEmpty()) {
            retValue = false;
        }
        if (!retValue.booleanValue() && p.getDadosTransNfPropria() != null && p.getDadosTransNfPropria().getTransportador() != null && op != null && op.getEnviarXMLNFeTransportadora() != null && op.getEnviarXMLNFeTransportadora() == 1 && p.getDadosTransNfPropria().getTransportador().getPessoa().getComplemento().getEmails() != null && !p.getDadosTransNfPropria().getTransportador().getPessoa().getComplemento().getEmails().isEmpty()) {
            retValue = true;
        }
        if ((aux = p.getStatus()) == null || !EnumConstNFeStatus.isStatusAutorizada((Integer)aux.intValue())) {
            retValue = false;
        }
        return true;
    }

    private static HashSet<String> getRecipientes(Pessoa p) {
        HashSet<String> emails = new HashSet<String>();
        if (p.getComplemento().getEmails() != null) {
            for (EmailPessoa o : p.getComplemento().getEmails()) {
                if (o.getAtivo() == null || o.getAtivo() != 1 || o.getEnviarDadosNfe() == null || o.getEnviarDadosNfe() != 1) continue;
                emails.add(o.getEmail());
            }
        }
        return emails;
    }
}

