/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.nfesefaz.versao400;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperCancDenegaNotaPropria;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoNFe;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import javax.xml.bind.JAXBException;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.nfesefaz.versao400.AuxEmailEventoNFe_V400;
import mentorcore.service.impl.nfesefaz.versao400.AuxEmailNFe_V400;
import mentorcore.tools.DateUtil;
import mentorcore.util.ExceptionUtilities;
import mentorcore.utilities.impl.xmlstore.UtilXMLStore;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.versao400.model.TEvento;
import nfe.versao400.model.TProtNFe;
import nfe.versao400.model.TRetCancNFe;
import nfe.versao400.model.TRetEvento;
import utilities.MarshallerUtil;

class AuxProcessaDados_V400 {
    private static final TLogger logger = TLogger.get(AuxProcessaDados_V400.class);

    AuxProcessaDados_V400() {
    }

    public void atualizarConteudoAprovacao(TProtNFe t, NotaFiscalPropria nfe, Usuario usuario, Grupo grupoUsuarios, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws NFeException {
        try {
            nfe.setStatus(Short.valueOf(t.getInfProt().getCStat()));
            String motivo = t.getInfProt().getXMotivo();
            if (motivo != null && motivo.length() > 255) {
                motivo = motivo.substring(0, 255);
            }
            nfe.setMotivo(motivo);
            Short status = (short)Short.valueOf(t.getInfProt().getCStat());
            if (EnumConstNFeStatus.isStatusAutorizada((Integer)status.intValue())) {
                nfe.setLiberarImpDanfe(Short.valueOf((short)1));
                nfe.setNrProtocolo(t.getInfProt().getNProt());
                XMLNfePropria x = UtilXMLStore.findCreateXMLNfePropria(nfe);
                x.setIdNotaPropria(nfe.getIdentificador());
                x.setConteudoAprovacao(MarshallerUtil.mashall((Object)t));
                UtilXMLStore.saveOrUpdateXMLNotaPropria(x);
                this.atualizarSituacaoPedido(nfe, opcoesFaturamento.getSituacaoPedidosFat());
                this.sendEmail(nfe, usuario, grupoUsuarios, opcoesRelacionamento, of);
            } else if (EnumConstNFeStatus.isStatusDenegada((Integer)status.intValue())) {
                nfe.setLiberarImpDanfe(Short.valueOf((short)0));
                nfe.setNrProtocolo(t.getInfProt().getNProt());
                this.atualizaDadosNfeDenegada(nfe, status, motivo, opcoesFaturamento.getSituacaoPedidosInutExc());
            } else {
                nfe.setLiberarImpDanfe(Short.valueOf((short)0));
                nfe.setNrProtocolo(null);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new NFeException("Erro ao atualizar os dados da NFe.", (Throwable)ex);
        }
    }

    private void sendEmailAutorizacao(NotaFiscalPropria nfe, Usuario usuario, Grupo grupoUsuarios, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) throws ExceptionService, IOException, Exception {
        Email e = AuxEmailNFe_V400.criarEmail(nfe, usuario, grupoUsuarios, opcoesRelacionamento, of);
    }

    private void sendEmail(NotaFiscalPropria nfe, Usuario usuario, Grupo grupoUsuarios, OpcoesRelacionamento opcoesRelacionamento, OpcoesFinanceiras of) {
        try {
            if (nfe.getStatus() != null && EnumConstNFeStatus.isStatusAutorizada((Integer)nfe.getStatus().intValue())) {
                this.sendEmailAutorizacao(nfe, usuario, grupoUsuarios, opcoesRelacionamento, of);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    void atualizarDadosEventoNFe(TRetEvento t, EventoNFe p, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws ExceptionService, ExceptionDatabase, JAXBException, Exception {
        short s = new Short(t.getInfEvento().getCStat());
        if (s == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_VINC_NFE.getCodigo() || s == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_NAO_VINC_NFE.getCodigo() || s == 155) {
            ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
            XMLEventoNFe xml = service.getOrCreateXMLEventoNFe(p.getIdentificador());
            xml.setConteudoRecebido(MarshallerUtil.mashall((Object)t));
            service.saveOrUpdate((Object)xml);
            p.setNrProtocolo(t.getInfEvento().getNProt());
            p.setStatus(Short.valueOf(s));
            if (p instanceof EvtNFeCancelamento && (p.getStatus().shortValue() == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_VINC_NFE.getCodigo().shortValue() || p.getStatus() == 155)) {
                EvtNFeCancelamento ec = (EvtNFeCancelamento)p;
                ec.setNotaFiscalPropria(this.atualizaDadosNfeCancelada(ec.getNotaFiscalPropria(), t.getInfEvento().getCStat(), t.getInfEvento().getXMotivo(), opcoesFaturamento.getSituacaoPedidosCanc()));
                this.atualizarSituacaoPedido(ec.getNotaFiscalPropria(), opcoesFaturamento.getSituacaoPedidosCanc());
            } else if (p instanceof EvtNFeManifestoDest) {
                EvtNFeManifestoDest ec = (EvtNFeManifestoDest)p;
                this.atualizarNFeDestinada(ec);
            } else if (p instanceof EvtNFeEpec) {
                EvtNFeEpec ev = (EvtNFeEpec)p;
                NotaFiscalPropria nota = ev.getNotaFiscalPropria();
                nota.setEvtentoEpec(ev);
                nota.setLiberarImpDanfe(Short.valueOf((short)1));
                nota = (NotaFiscalPropria)CoreDAOFactory.getInstance().getDAONotaFiscalPropria().update(nota);
                ev.setNotaFiscalPropria(nota);
                ev.setDataHoraProt(this.getDataHoraRegistroEvento(t.getInfEvento().getDhRegEvento()));
                XMLNfePropria x = UtilXMLStore.findCreateXMLNfePropria(ev.getNotaFiscalPropria());
                x.setIdNotaPropria(ev.getNotaFiscalPropria().getIdentificador());
                x.setXmlDpec(MarshallerUtil.mashall((Object)t));
                UtilXMLStore.saveOrUpdateXMLNotaPropria(x);
            }
            this.sendEmailEvento(p, op, usuario);
        }
        p.setStatus(Short.valueOf(s));
        p.setMotivo(t.getInfEvento().getXMotivo());
    }

    void atualizarDadosEventoNFe(TEvento t, EventoNFe p) throws ExceptionService, ExceptionDatabase, JAXBException {
        ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
        XMLEventoNFe xml = service.getOrCreateXMLEventoNFe(p.getIdentificador());
        xml.setConteudoEnviado(MarshallerUtil.mashall((Object)t));
        service.saveOrUpdate((Object)xml);
    }

    private NotaFiscalPropria atualizaDadosNfeCancelada(NotaFiscalPropria nfe, String cStat, String xMotivo, SituacaoPedidos sitCanc) throws ExceptionDatabase, ExceptionService {
        nfe.setStatus(EnumConstNFeStatus.CANCELADA.getValueShort());
        nfe.setLiberarImpDanfe(Short.valueOf((short)0));
        nfe.setStatus(Short.valueOf(cStat));
        nfe.setMotivo(xMotivo);
        return new HelperCancDenegaNotaPropria().build(nfe).cancelarNotaFiscal(sitCanc);
    }

    public void trataExcecoesNFe(Throwable e) throws NFeException {
        logger.error(e.getClass(), e);
        String erroConexao = "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o servidor NFe. Verifique:\n\n1 - Sua conex\u00e3o com a internet;\n2 - Houve mudan\u00e7as na configura\u00e7\u00e3o/estrutura da rede/internet, tais como proxy, firewall\n3 - O servi\u00e7o da nfe est\u00e1 dispon\u00edvel (cheque disponibilidade no site da sefaz).\n4 - Reinicie seu computador e tente novamente. \nCaso n\u00e3o haja os problemas acima, aguarde 10 minutos e tente novamente. Se o problema persistir, refa\u00e7a os passos anteriores. Posteriormente entre em contato com o suporte.";
        if (ExceptionUtilities.findMessage(e, "timeout").booleanValue()) {
            throw new NFeException(erroConexao);
        }
        if (ExceptionUtilities.findMessage(e, "UnknownHostException").booleanValue()) {
            throw new NFeException(erroConexao);
        }
        if (ExceptionUtilities.findMessage(e, "handshake_failure").booleanValue()) {
            throw new NFeException(erroConexao);
        }
        if (ExceptionUtilities.findMessage(e, "AxisFault").booleanValue()) {
            throw new NFeException(erroConexao);
        }
        if (ExceptionUtilities.findMessage(e, "Forbidden").booleanValue()) {
            throw new NFeException("O seu certificado n\u00e3o oferece acesso ao servi\u00e7o da Sefaz. Ele pode estar vencido, ou o bit de ativa\u00e7\u00e3o ligado.  Caso seja o bit de ativa\u00e7\u00e3o, importe e exporte o certificado pelo internet explorer e adicione ao mentor novamente. ");
        }
        if (ExceptionUtilities.findMessage(e, "CKR_PIN_LOCKED").booleanValue()) {
            throw new NFeException("Seu certificado est\u00e1 bloqueado por tentativas incorretas atrav\u00e9s da senha informada. \n1 - Desbloqueie seu token atrav\u00e9s do aplicativo do mesmo2 - Confirme a senha cadastrada no Mentor");
        }
        if (ExceptionUtilities.findMessage(e, "PKCS11 not found").booleanValue()) {
            throw new NFeException("Seu certificado(Token/leitora) n\u00e3o est\u00e1 conectado ou configurado incorretamente. \n1 - Conecte seu certificado2 - Se estiver conectado: desconecte, feche o Mentor, conecte, e abra o Mentor novamente.3 - Verifique se houve instala\u00e7\u00e3o de novos drivers/programas e at\u00e9 outros certificados que possam entrar em conflito. Fa\u00e7a a restaura\u00e7\u00e3o do sistema ou desinstale todos os aplicativos relacionados e instale somente o do certificado.");
        }
        if (e instanceof NFeValidateException) {
            throw new NFeException("O registro enviado possui inconsist\u00eancias em sua estrutura:\n" + e.getMessage());
        }
        if (e instanceof MalformedURLException) {
            throw new NFeException("A URL de conex\u00e3o com o webservice da sefaz \u00e9 inv\u00e1lida:\n\n Entre em contato com suporte t\u00e9cnico." + e.getMessage());
        }
        if (e instanceof JAXBException) {
            throw new NFeException("A mensagem enviada ou recebida n\u00e3o est\u00e1 no padr\u00e3o esperado pelo sistema:\n\n Entre em contato com suporte t\u00e9cnico." + e.getMessage());
        }
        if (e instanceof ExceptionService || e instanceof ExceptionService) {
            throw new NFeException("Erro ao salvar atualizar os registros no seu banco de dados:\n1 - Verifique se sua rede est\u00e1 funcionando;2 - Verifique se o servidor est\u00e1 ligado;\n Entre em contato com suporte t\u00e9cnico." + e.getMessage());
        }
        throw new NFeException("Erro ainda n\u00e3o tratado. Entre em contato com o suporte tecnico: " + e.getMessage(), e);
    }

    private void sendEmailEvento(EventoNFe p, OpcoesRelacionamento op, Usuario usuario) {
        try {
            AuxEmailEventoNFe_V400.criarEnviarEmailEventoNFe(p, op, usuario);
        }
        catch (ExceptionService ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void atualizarNFeDestinada(EvtNFeManifestoDest ec) throws ExceptionService {
    }

    public void atualizarSituacaoPedido(NotaFiscalPropria nfe, SituacaoPedidos s) {
        if (nfe.getExpedicao() != null && nfe.getExpedicao().getPedido() != null) {
            nfe.getExpedicao().getPedido().setSituacaoPedido(s);
            CoreDAOFactory.getInstance().getDAOPedido().atualizarSituacaoPedido(nfe.getExpedicao().getPedido(), s);
        }
    }

    private void atualizaDadosNfeDenegada(NotaFiscalPropria nfe, Short status, String motivo, SituacaoPedidos s) {
        nfe.setStatus(status);
        nfe.setMotivo(motivo);
        new HelperCancDenegaNotaPropria().build(nfe).denegarNotaFiscal(s);
    }

    private String getDadosLogEmail(NotaFiscalPropria nfe) {
        StringBuilder sb = new StringBuilder();
        sb.append("Id Nota Propria: ");
        sb.append(nfe.getIdentificador());
        sb.append(", ");
        sb.append("Nr Nota: ");
        sb.append(nfe.getNumeroNota());
        sb.append(", ");
        sb.append("Serie: ");
        sb.append(nfe.getSerie());
        sb.append(", ");
        sb.append("Cliente: ");
        sb.append(nfe.getUnidadeFatCliente().getCliente().getPessoa().getNome());
        return sb.toString();
    }

    private Date getDataHoraRegistroEvento(String dhRegEvento) {
        String data = dhRegEvento.substring(0, 10);
        String hora = dhRegEvento.substring(11, 19);
        return DateUtil.strToDate(data + " " + hora, "yyyy-MM-dd HH:mm:ss");
    }

    void atualizarDadosCancelamentoNFeSemRetornoEvento(TRetCancNFe t, NotaFiscalPropria nf, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws ExceptionService, ExceptionDatabase, JAXBException, Exception {
        Integer status = new Integer(t.getInfCanc().getCStat());
        if (ToolMethods.isEquals((Object)EnumConstNFeStatus.CANCELADA.getValue(), (Object)status) || ToolMethods.isEquals((Object)EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue(), (Object)status)) {
            this.atualizaDadosNfeCancelada(nf, t.getInfCanc().getCStat(), t.getInfCanc().getXMotivo(), opcoesFaturamento.getSituacaoPedidosCanc());
            this.atualizarSituacaoPedido(nf, opcoesFaturamento.getSituacaoPedidosCanc());
        }
    }
}

